/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.stronghold;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3481;
import net.minecraft.class_3773;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import net.minecraft.class_6626;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.stronghold.StrongholdEntranceComponent;
import twilightforest.world.components.structures.stronghold.StrongholdPieces;
import twilightforest.world.components.structures.stronghold.StrongholdUpperAscenderComponent;
import twilightforest.world.components.structures.stronghold.StrongholdUpperCorridorComponent;
import twilightforest.world.components.structures.stronghold.StrongholdUpperLeftTurnComponent;
import twilightforest.world.components.structures.stronghold.StrongholdUpperRightTurnComponent;
import twilightforest.world.components.structures.stronghold.StrongholdUpperTIntersectionComponent;

public abstract class StructureTFStrongholdComponent
extends TFStructureComponentOld {
    public final List<class_2338> doors = new ArrayList<class_2338>();

    public StructureTFStrongholdComponent(class_3773 piece, class_2487 nbt) {
        super(piece, nbt);
        this.readOpeningsFromArray(nbt.method_10561("doorInts"));
    }

    public StructureTFStrongholdComponent(class_3773 type, int i, class_2350 facing, int x, int y, int z) {
        super(type, i, x, y, z);
        this.field_15315 = this.generateBoundingBox(facing, x, y, z);
        this.method_14926(facing);
    }

    private int[] getDoorsAsIntArray() {
        IntBuffer ibuffer = IntBuffer.allocate(this.doors.size() * 3);
        for (class_2338 door : this.doors) {
            ibuffer.put(door.method_10263());
            ibuffer.put(door.method_10264());
            ibuffer.put(door.method_10260());
        }
        return ibuffer.array();
    }

    @Override
    protected void method_14943(class_6625 ctx, class_2487 tagCompound) {
        super.method_14943(ctx, tagCompound);
        tagCompound.method_10539("doorInts", this.getDoorsAsIntArray());
    }

    private void readOpeningsFromArray(int[] intArray) {
        for (int i = 0; i < intArray.length; i += 3) {
            class_2338 door = new class_2338(intArray[i], intArray[i + 1], intArray[i + 2]);
            this.doors.add(door);
        }
    }

    public abstract class_3341 generateBoundingBox(class_2350 var1, int var2, int var3, int var4);

    public static class_3341 getComponentToAddBoundingBox(int x, int y, int z, int xOff, int yOff, int zOff, int xSize, int ySize, int zSize, class_2350 facing) {
        return switch (facing) {
            case class_2350.field_11039 -> new class_3341(x - zSize + 1 + zOff, y + yOff, z + xOff, x + zOff, y + ySize - 1 + yOff, z + xSize - 1 + xOff);
            case class_2350.field_11043 -> new class_3341(x - xSize + 1 - xOff, y + yOff, z - zSize + 1 + zOff, x - xOff, y + ySize - 1 + yOff, z + zOff);
            case class_2350.field_11034 -> new class_3341(x + zOff, y + yOff, z - xSize + 1 - xOff, x + zSize - 1 + zOff, y + ySize - 1 + yOff, z - xOff);
            default -> new class_3341(x + xOff, y + yOff, z + zOff, x + xSize - 1 + xOff, y + ySize - 1 + yOff, z + zSize - 1 + zOff);
        };
    }

    public void method_14918(class_3443 parent, class_6130 list, class_5819 rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
    }

    protected void addNewComponent(class_3443 entrance, class_6130 list, class_5819 random, class_2470 facing, int x, int y, int z) {
        int index = this.field_15316 + 1;
        class_2350 nFacing = this.getStructureRelativeRotation(facing);
        int nx = this.method_14928(x, z);
        int ny = this.method_14924(y);
        int nz = this.method_14941(x, z);
        if (index > 30 || this.isOutOfRange(entrance, nx, nz, 75)) {
            return;
        }
        StructureTFStrongholdComponent breakIn = (StructureTFStrongholdComponent)this.findBreakInComponent(list, nx, ny, nz);
        if (breakIn != null && breakIn.attemptToBreakIn(nx, ny, nz)) {
            this.addDoorwayTo(x, y, z, facing);
            return;
        }
        StrongholdPieces pieceList = ((StrongholdEntranceComponent)entrance).lowerPieces;
        StructureTFStrongholdComponent nextComponent = pieceList.getNextComponent(entrance, list, random, index, nFacing, nx, ny, nz);
        if (nextComponent != null) {
            list.method_35462((class_3443)nextComponent);
            nextComponent.method_14918(entrance, list, random);
            this.addDoorwayTo(x, y, z, facing);
        }
    }

    protected class_3443 findBreakInComponent(class_6130 list, int x, int y, int z) {
        class_2338 pos = new class_2338(x, y, z);
        if (list instanceof class_6626) {
            class_6626 start = (class_6626)list;
            for (class_3443 component : start.field_34944) {
                if (component.method_14935() == null || !component.method_14935().method_14662((class_2382)pos)) continue;
                return component;
            }
        }
        return null;
    }

    protected void addNewUpperComponent(class_3443 parent, class_6130 list, class_5819 random, class_2470 facing, int x, int y, int z) {
        StructureTFStrongholdComponent attempted;
        int index = this.field_15316 + 1;
        class_2350 nFacing = this.getStructureRelativeRotation(facing);
        int nx = this.method_14928(x, z);
        int ny = this.method_14924(y);
        int nz = this.method_14941(x, z);
        if (index > 100 || this.isOutOfRange(parent, nx, nz, 48)) {
            return;
        }
        switch (random.method_43048(5)) {
            case 1: {
                StructureTFStrongholdComponent structureTFStrongholdComponent = new StrongholdUpperLeftTurnComponent(index, nFacing, nx, ny, nz);
                break;
            }
            case 2: {
                StructureTFStrongholdComponent structureTFStrongholdComponent = new StrongholdUpperRightTurnComponent(index, nFacing, nx, ny, nz);
                break;
            }
            case 3: {
                StructureTFStrongholdComponent structureTFStrongholdComponent = new StrongholdUpperCorridorComponent(index, nFacing, nx, ny, nz);
                break;
            }
            case 4: {
                StructureTFStrongholdComponent structureTFStrongholdComponent = new StrongholdUpperAscenderComponent(index, nFacing, nx, ny, nz);
                break;
            }
            default: {
                StructureTFStrongholdComponent structureTFStrongholdComponent = attempted = new StrongholdUpperTIntersectionComponent(index, nFacing, nx, ny, nz);
            }
        }
        if (attempted != null && list.method_35461(attempted.method_14935()) == null) {
            list.method_35462((class_3443)attempted);
            attempted.method_14918(parent, list, random);
        }
    }

    private boolean isOutOfRange(class_3443 parent, int nx, int nz, int range) {
        return Math.abs(nx - parent.method_14935().method_35415()) > range || Math.abs(nz - parent.method_14935().method_35417()) > range;
    }

    protected void placeDoorwayAt(class_5281 world, int x, int y, int z, class_3341 sbb) {
        if (x == 0 || x == this.getXSize()) {
            this.method_14940(world, sbb, x, y, z - 2, x, y + 3, z + 2, this.deco.fenceState, class_2246.field_10124.method_9564(), false);
            this.method_14942(world, sbb, x, y, z - 1, x, y + 3, z + 1);
        } else {
            this.method_14940(world, sbb, x - 2, y, z, x + 2, y + 3, z, this.deco.fenceState, class_2246.field_10124.method_9564(), false);
            this.method_14942(world, sbb, x - 1, y, z, x + 1, y + 3, z);
        }
    }

    protected int getXSize() {
        return switch (this.method_14934()) {
            case class_2350.field_11039, class_2350.field_11034 -> this.field_15315.method_14663() - 1;
            default -> this.field_15315.method_35414() - 1;
        };
    }

    protected void placeSmallDoorwayAt(class_5281 world, int facing, int x, int y, int z, class_3341 sbb) {
        if (facing == 0 || facing == 2) {
            this.method_14940(world, sbb, x - 1, y, z, x + 1, y + 1, z, class_2246.field_10625.method_9564(), class_2246.field_10124.method_9564(), true);
        } else {
            this.method_14940(world, sbb, x, y, z - 1, x, y + 1, z + 1, class_2246.field_10625.method_9564(), class_2246.field_10124.method_9564(), true);
        }
        this.method_14942(world, sbb, x, y, z, x, y + 1, z);
    }

    public void placeCornerStatue(class_5281 world, int x, int y, int z, int facing, class_3341 sbb) {
        int ox = 1;
        int oz = 1;
        class_2350 smx = class_2350.field_11034;
        class_2350 smz = class_2350.field_11035;
        switch (facing) {
            case 0: {
                break;
            }
            case 1: {
                oz = -1;
                smz = class_2350.field_11035;
                break;
            }
            case 2: {
                ox = -1;
                smx = class_2350.field_11039;
                break;
            }
            case 3: {
                ox = -1;
                oz = -1;
                smx = class_2350.field_11039;
                smz = class_2350.field_11043;
            }
        }
        for (int sy = 0; sy < 5; ++sy) {
            this.method_14917(world, this.deco.pillarState, x, y + sy, z, sbb);
        }
        this.method_14917(world, class_2246.field_10620.method_9564(), x, y + 4, z + oz, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), x + ox, y + 4, z, sbb);
        this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smz, false), x, y + 3, z + oz, sbb);
        this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smx, false), x + ox, y + 3, z, sbb);
        this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smz, true), x, y + 2, z + oz, sbb);
        this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smx, true), x + ox, y + 2, z, sbb);
        this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smx, true), x + ox, y + 2, z + oz, sbb);
        this.method_14917(world, class_2246.field_10625.method_9564(), x + ox, y, z + oz, sbb);
        this.method_14917(world, class_2246.field_10625.method_9564(), x + ox, y + 1, z + oz, sbb);
        this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smz, false), x, y, z + oz, sbb);
        this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smx, false), x + ox, y, z, sbb);
    }

    public void placeWallStatue(class_5281 world, int x, int y, int z, class_2470 facing, class_3341 sbb) {
        int ox = 1;
        int oz = 1;
        for (int sy = 0; sy < 5; ++sy) {
            this.method_14917(world, this.deco.pillarState, x, y + sy, z, sbb);
        }
        if (facing == class_2470.field_11467 || facing == class_2470.field_11464) {
            if (facing == class_2470.field_11464) {
                ox = -ox;
                oz = -oz;
            }
            this.method_14917(world, class_2246.field_10620.method_9564(), x - ox, y + 4, z, sbb);
            this.method_14917(world, class_2246.field_10620.method_9564(), x + ox, y + 4, z, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11467).method_10503(class_2350.field_11039), false), x - ox, y + 3, z, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11464).method_10503(class_2350.field_11039), false), x + ox, y + 3, z, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11463).method_10503(class_2350.field_11039), false), x - ox, y + 3, z - oz, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11463).method_10503(class_2350.field_11039), false), x + ox, y + 3, z - oz, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11467).method_10503(class_2350.field_11039), true), x - ox, y + 2, z, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11464).method_10503(class_2350.field_11039), true), x + ox, y + 2, z, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11463).method_10503(class_2350.field_11039), true), x, y + 2, z - oz, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11463).method_10503(class_2350.field_11039), true), x - ox, y + 2, z - oz, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11463).method_10503(class_2350.field_11039), true), x + ox, y + 2, z - oz, sbb);
            this.method_14917(world, class_2246.field_10625.method_9564(), x, y, z - oz, sbb);
            this.method_14917(world, class_2246.field_10625.method_9564(), x, y + 1, z - oz, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11467).method_10503(class_2350.field_11039), false), x - ox, y, z, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11464).method_10503(class_2350.field_11039), false), x + ox, y, z, sbb);
        } else {
            if (facing == class_2470.field_11465) {
                oz = -oz;
                ox = -ox;
            }
            this.method_14917(world, class_2246.field_10620.method_9564(), x, y + 4, z - oz, sbb);
            this.method_14917(world, class_2246.field_10620.method_9564(), x, y + 4, z + oz, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11467).method_10503(class_2350.field_11039), false), x, y + 3, z - oz, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11464).method_10503(class_2350.field_11039), false), x, y + 3, z + oz, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11463).method_10503(class_2350.field_11039), false), x + ox, y + 3, z - oz, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11463).method_10503(class_2350.field_11039), false), x + ox, y + 3, z + oz, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11467).method_10503(class_2350.field_11039), true), x, y + 2, z - oz, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11464).method_10503(class_2350.field_11039), true), x, y + 2, z + oz, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11463).method_10503(class_2350.field_11039), true), x + oz, y + 2, z, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11463).method_10503(class_2350.field_11039), true), x + ox, y + 2, z - oz, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11463).method_10503(class_2350.field_11039), true), x + ox, y + 2, z + oz, sbb);
            this.method_14917(world, class_2246.field_10625.method_9564(), x + ox, y, z, sbb);
            this.method_14917(world, class_2246.field_10625.method_9564(), x + ox, y + 1, z, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11467).method_10503(class_2350.field_11039), false), x, y, z - ox, sbb);
            this.method_14917(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.method_10501(class_2470.field_11464).method_10503(class_2350.field_11039), false), x, y, z + ox, sbb);
        }
    }

    public boolean attemptToBreakIn(int wx, int wy, int wz) {
        if (!this.isValidBreakInPoint(wx, wy, wz)) {
            return false;
        }
        int dx = this.getRelativeX(wx, wz);
        int dy = this.getRelativeY(wy);
        int dz = this.getRelativeZ(wx, wz);
        this.addDoor(dx, dy, dz);
        return true;
    }

    public void addDoorwayTo(int dx, int dy, int dz, class_2470 facing) {
        switch (facing) {
            case field_11467: {
                this.addDoor(dx, dy, dz - 1);
                break;
            }
            case field_11463: {
                this.addDoor(dx + 1, dy, dz);
                break;
            }
            case field_11464: {
                this.addDoor(dx, dy, dz + 1);
                break;
            }
            case field_11465: {
                this.addDoor(dx - 1, dy, dz);
            }
        }
    }

    public void addDoor(int dx, int dy, int dz) {
        this.doors.add(new class_2338(dx, dy, dz));
    }

    protected boolean isValidBreakInPoint(int wx, int wy, int wz) {
        if (wy < this.field_15315.method_35416() || wy > this.field_15315.method_35419()) {
            return false;
        }
        if (wx == this.field_15315.method_35415() || wx == this.field_15315.method_35418()) {
            return wz > this.field_15315.method_35417() && wz < this.field_15315.method_35420();
        }
        if (wz == this.field_15315.method_35417() || wz == this.field_15315.method_35420()) {
            return wx > this.field_15315.method_35415() && wx < this.field_15315.method_35418();
        }
        return false;
    }

    protected int getRelativeX(int x, int z) {
        return switch (this.method_14934()) {
            case class_2350.field_11035 -> x - this.field_15315.method_35415();
            case class_2350.field_11043 -> this.field_15315.method_35418() - x;
            case class_2350.field_11039 -> z - this.field_15315.method_35417();
            case class_2350.field_11034 -> this.field_15315.method_35420() - z;
            default -> x;
        };
    }

    protected int getRelativeY(int y) {
        return y - this.field_15315.method_35416();
    }

    protected int getRelativeZ(int x, int z) {
        return switch (this.method_14934()) {
            case class_2350.field_11035 -> z - this.field_15315.method_35417();
            case class_2350.field_11043 -> this.field_15315.method_35420() - z;
            case class_2350.field_11039 -> this.field_15315.method_35418() - x;
            case class_2350.field_11034 -> x - this.field_15315.method_35415();
            default -> z;
        };
    }

    public void placeDoors(class_5281 world, class_3341 sbb) {
        if (this.doors != null) {
            for (class_2338 doorCoords : this.doors) {
                this.placeDoorwayAt(world, doorCoords.method_10263(), doorCoords.method_10264(), doorCoords.method_10260(), sbb);
            }
        }
    }

    protected void placeStrongholdWalls(class_5281 world, class_3341 sbb, int sx, int sy, int sz, int dx, int dy, int dz, class_5819 rand, class_3443.class_3444 randomBlocks) {
        for (int y = sy; y <= dy; ++y) {
            for (int x = sx; x <= dx; ++x) {
                for (int z = sz; z <= dz; ++z) {
                    boolean wall = y == sy || y == dy || x == sx || x == dx || z == sz || z == dz;
                    class_2248 blockID = this.method_14929((class_1922)world, x, y, z, sbb).method_26204();
                    if (blockID == class_2246.field_10124) {
                        if (!wall) continue;
                        this.method_14917(world, class_2246.field_10445.method_9564(), x, y, z, sbb);
                        continue;
                    }
                    if (y == sy || y == dy) {
                        class_3443.class_3444 strongBlocks = TFStructureComponentOld.getStrongholdStones();
                        strongBlocks.method_14948(rand, x, y, z, wall);
                        this.method_14917(world, strongBlocks.method_14947(), x, y, z, sbb);
                        continue;
                    }
                    if (wall && blockID == class_2246.field_10566) continue;
                    randomBlocks.method_14948(rand, x, y, z, wall);
                    this.method_14917(world, randomBlocks.method_14947(), x, y, z, sbb);
                }
            }
        }
    }

    protected void placeUpperStrongholdWalls(class_5281 world, class_3341 sbb, int sx, int sy, int sz, int dx, int dy, int dz, class_5819 rand, class_3443.class_3444 randomBlocks) {
        for (int y = sy; y <= dy; ++y) {
            for (int x = sx; x <= dx; ++x) {
                for (int z = sz; z <= dz; ++z) {
                    boolean wall = y == sy || y == dy || x == sx || x == dx || z == sz || z == dz;
                    class_2680 state = this.method_14929((class_1922)world, x, y, z, sbb);
                    if ((state.method_26215() || !state.method_26164(class_3481.field_25806) && !state.method_26164(class_3481.field_29822)) && (!state.method_26215() || rand.method_43048(3) != 0 || this.method_14929((class_1922)world, x, y - 1, z, sbb).method_26204() != class_2246.field_10056)) continue;
                    if (y == sy || y == dy) {
                        class_3443.class_3444 strongBlocks = TFStructureComponentOld.getStrongholdStones();
                        strongBlocks.method_14948(rand, x, y, z, wall);
                        this.method_14917(world, strongBlocks.method_14947(), x, y, z, sbb);
                        continue;
                    }
                    randomBlocks.method_14948(rand, x, y, z, wall);
                    this.method_14917(world, randomBlocks.method_14947(), x, y, z, sbb);
                }
            }
        }
    }

    public static interface Factory<T extends StructureTFStrongholdComponent> {
        public T newInstance(int var1, class_2350 var2, int var3, int var4, int var5);
    }
}

