/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtower;

import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2429;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFEntities;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.EntityUtil;
import twilightforest.util.RotationUtil;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.lichtower.TowerOutbuildingComponent;
import twilightforest.world.components.structures.lichtower.TowerWingComponent;

public class TowerMainComponent
extends TowerWingComponent {
    public TowerMainComponent(class_6625 ctx, class_2487 nbt) {
        super((class_3773)TFStructurePieceTypes.TFLTMai.get(), nbt);
    }

    public TowerMainComponent(class_5819 rand, int index, int x, int y, int z) {
        super((class_3773)TFStructurePieceTypes.TFLTMai.get(), index, x, y + 1, z, 15, 55 + rand.method_43048(32), class_2350.field_11035);
    }

    @Override
    public void method_14918(class_3443 parent, class_6130 list, class_5819 rand) {
        int childHeight;
        int[] dest;
        this.makeARoof(parent, list, rand);
        for (class_2470 rotation : RotationUtil.ROTATIONS) {
            dest = this.getValidOpening(rand, rotation);
            if (dest[1] < this.height / 2) {
                dest[1] = dest[1] + 20;
            }
            if (this.makeTowerWing(list, rand, 1, dest[0], dest[1], dest[2], 9, childHeight = Math.min(21 + rand.method_43048(10), this.height - dest[1] - 3), rotation)) continue;
            this.makeTowerWing(list, rand, 1, dest[0], dest[1], dest[2], 7, childHeight, rotation);
        }
        for (class_2470 rotation : RotationUtil.ROTATIONS) {
            dest = this.getValidOpening(rand, rotation);
            if (dest[1] < this.height / 2) {
                dest[1] = dest[1] + 10;
            }
            if (this.makeTowerWing(list, rand, 1, dest[0], dest[1], dest[2], 9, childHeight = Math.min(21 + rand.method_43048(10), this.height - dest[1] - 3), rotation)) continue;
            this.makeTowerWing(list, rand, 1, dest[0], dest[1], dest[2], 7, childHeight, rotation);
        }
        for (class_2470 rotation : RotationUtil.ROTATIONS) {
            dest = this.getValidOpening(rand, rotation);
            if (this.makeTowerWing(list, rand, 1, dest[0], dest[1], dest[2], 5, childHeight = Math.min(7 + rand.method_43048(6), this.height - dest[1] - 3), rotation)) continue;
            this.makeTowerWing(list, rand, 1, dest[0], dest[1], dest[2], 3, childHeight, rotation);
        }
        for (class_2470 rotation : RotationUtil.ROTATIONS) {
            dest = this.getOutbuildingOpening(rand, rotation);
            childHeight = 11 + rand.method_43048(10);
            int childSize = 7 + rand.method_43048(2) * 2;
            this.makeTowerOutbuilding(list, rand, 1, dest[0], dest[1], dest[2], childSize, childHeight, rotation);
        }
        for (int i = 0; i < 4; ++i) {
            for (class_2470 towerRotation : RotationUtil.ROTATIONS) {
                int[] dest2 = this.getValidOpening(rand, towerRotation);
                int childHeight2 = 6 + rand.method_43048(5);
                if (rand.method_43048(3) != 0 && this.makeTowerWing(list, rand, 1, dest2[0], dest2[1], dest2[2], 5, childHeight2, towerRotation)) continue;
                this.makeTowerWing(list, rand, 1, dest2[0], dest2[1], dest2[2], 3, childHeight2, towerRotation);
            }
        }
    }

    public int[] getOutbuildingOpening(class_5819 rand, class_2470 rotation) {
        int rx = 0;
        int ry = 1;
        int rz = 0;
        switch (rotation) {
            case field_11467: {
                rx = this.size - 1;
                rz = 6 + rand.method_43048(8);
                break;
            }
            case field_11463: {
                rx = 1 + rand.method_43048(11);
                rz = this.size - 1;
                break;
            }
            case field_11464: {
                rx = 0;
                rz = 1 + rand.method_43048(8);
                break;
            }
            case field_11465: {
                rx = 3 + rand.method_43048(11);
                rz = 0;
            }
        }
        return new int[]{rx, ry, rz};
    }

    public boolean makeTowerOutbuilding(class_6130 list, class_5819 rand, int index, int x, int y, int z, int wingSize, int wingHeight, class_2470 rotation) {
        class_2350 direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, wingSize, direction);
        TowerOutbuildingComponent outbuilding = new TowerOutbuildingComponent(index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        class_3443 intersect = list.method_35461(outbuilding.method_14935());
        if (intersect == null) {
            list.method_35462((class_3443)outbuilding);
            outbuilding.method_14918(this, list, rand);
            this.addOpening(x, y, z, rotation);
            return true;
        }
        return false;
    }

    @Override
    public void method_14931(class_5281 world, class_5138 manager, class_2794 generator, class_5819 rand, class_3341 sbb, class_1923 chunkPosIn, class_2338 blockPos) {
        this.method_14938(world, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, false, rand, TFStructureComponentOld.getStrongholdStones());
        this.method_14942(world, sbb, 1, 1, 1, this.size - 2, this.height - 2, this.size - 2);
        class_2680 defaultState = class_2246.field_10445.method_9564();
        for (int x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                this.method_14936(world, defaultState, x, -1, z, sbb);
            }
        }
        if (this.height - this.highestOpening > 15) {
            this.highestOpening = this.height - 15;
        }
        this.makeStairs(world, rand, sbb);
        this.makeOpenings(world, sbb);
        this.decorateStairFloor(world, generator, rand, sbb);
        this.makeStairwayCrossings(world, rand, sbb);
        this.makeLichRoom(world, rand, sbb);
        this.makeTowerPaintings(world, rand, sbb);
    }

    protected void makeStairwayCrossings(class_5281 world, class_5819 rand, class_3341 sbb) {
        int flights = this.highestOpening / 5 - 2;
        for (int i = 2 + rand.method_43048(2); i < flights; i += 1 + rand.method_43048(5)) {
            this.makeStairCrossing(world, rand, i, sbb);
        }
    }

    protected void makeStairCrossing(class_5281 world, class_5819 rand, int flight, class_3341 sbb) {
        int dz;
        int dx;
        class_2350 temp = this.method_14934();
        if (flight % 2 == 0) {
            this.method_14926(this.getStructureRelativeRotation(class_2470.field_11463));
        }
        int floorLevel = flight * 5;
        class_2680 crossingfloor = rand.method_43056() ? (class_2680)class_2246.field_10136.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682) : class_2246.field_10148.method_9564();
        for (dx = 6; dx <= 8; ++dx) {
            for (dz = 4; dz <= 10; ++dz) {
                this.method_14917(world, crossingfloor, dx, floorLevel, dz, sbb);
            }
        }
        ++floorLevel;
        dx = 6;
        for (dz = 3; dz <= 11; ++dz) {
            this.method_14917(world, class_2246.field_10620.method_9564(), dx, floorLevel, dz, sbb);
        }
        ++dx;
        for (dz = 3; dz <= 11; ++dz) {
            this.method_14917(world, AIR, dx, floorLevel, dz, sbb);
        }
        ++dx;
        for (dz = 3; dz <= 11; ++dz) {
            this.method_14917(world, class_2246.field_10620.method_9564(), dx, floorLevel, dz, sbb);
        }
        this.method_14917(world, crossingfloor, 6, floorLevel - 1, 11, sbb);
        this.method_14917(world, crossingfloor, 8, floorLevel - 1, 3, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), 5, floorLevel, 11, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), 9, floorLevel, 3, sbb);
        class_1299 mobID = switch (rand.method_43048(4)) {
            case 2 -> class_1299.field_6051;
            case 3 -> (class_1299)TFEntities.SWARM_SPIDER.get();
            default -> class_1299.field_6137;
        };
        this.setSpawner(world, 7, floorLevel + 2, 7, sbb, mobID);
        this.method_14917(world, class_2246.field_10620.method_9564(), 6, floorLevel + 1, 7, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), 8, floorLevel + 1, 7, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), 6, floorLevel + 2, 7, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), 8, floorLevel + 2, 7, sbb);
        this.method_14926(temp);
    }

    protected void makeLichRoom(class_5281 world, class_5819 rand, class_3341 sbb) {
        int floorLevel = 2 + this.highestOpening / 5 * 5;
        class_2470 i = this.highestOpening / 5 % 2 == 0 ? class_2470.field_11467 : class_2470.field_11463;
        this.makeLichFloor(world, floorLevel, i, sbb);
        this.decorateLichChandelier(world, floorLevel, sbb);
        this.decoratePaintings(world, rand, floorLevel, sbb);
        this.decorateTorches(world, rand, floorLevel, sbb);
        this.method_14917(world, ((class_2248)TFBlocks.LICH_BOSS_SPAWNER.get()).method_9564(), this.size / 2, floorLevel + 2, this.size / 2, sbb);
    }

    protected void makeTowerPaintings(class_5281 world, class_5819 rand, class_3341 sbb) {
        int howMany = 10;
        this.generatePaintingsOnWall(world, rand, howMany, 0, class_2350.field_11039, 48, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, class_2350.field_11039, 32, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, class_2350.field_11039, 0, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, class_2350.field_11034, 48, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, class_2350.field_11034, 32, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, class_2350.field_11034, 0, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, class_2350.field_11043, 48, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, class_2350.field_11043, 32, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, class_2350.field_11043, 0, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, class_2350.field_11035, 48, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, class_2350.field_11035, 32, sbb);
        this.generatePaintingsOnWall(world, rand, howMany, 0, class_2350.field_11035, 0, sbb);
    }

    protected void makeLichFloor(class_5281 world, int floorLevel, class_2470 rotation, class_3341 sbb) {
        class_2350 temp = this.method_14934();
        this.method_14926(this.getStructureRelativeRotation(rotation));
        class_2680 birchSlab = (class_2680)class_2246.field_10257.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679);
        class_2680 birchPlank = class_2246.field_10148.method_9564();
        for (int fx = 1; fx < 14; ++fx) {
            for (int fz = 1; fz < 14; ++fz) {
                if ((fx == 1 || fx == 2) && fz >= 6 && fz <= 12) {
                    if (fz != 6) continue;
                    this.method_14917(world, birchSlab, fx, floorLevel, fz, sbb);
                    continue;
                }
                if ((fx == 12 || fx == 13) && fz >= 3 && fz <= 8) {
                    if (fz != 8) continue;
                    this.method_14917(world, birchSlab, fx, floorLevel, fz, sbb);
                    continue;
                }
                if (fx >= 4 && fx <= 10 && fz >= 4 && fz <= 10) {
                    if (fx == 4 && fz == 4 || fx == 10 && fz == 10) {
                        this.method_14917(world, birchPlank, fx, floorLevel, fz, sbb);
                        continue;
                    }
                    this.method_14917(world, class_2246.field_10033.method_9564(), fx, floorLevel, fz, sbb);
                    continue;
                }
                if (!(fx != 2 && fx != 3 || fz != 2 && fz != 3)) {
                    this.method_14917(world, class_2246.field_10033.method_9564(), fx, floorLevel, fz, sbb);
                    continue;
                }
                if (!(fx != 11 && fx != 12 || fz != 11 && fz != 12)) {
                    this.method_14917(world, class_2246.field_10033.method_9564(), fx, floorLevel, fz, sbb);
                    continue;
                }
                this.method_14917(world, birchPlank, fx, floorLevel, fz, sbb);
            }
        }
        this.method_14917(world, AIR, 3, floorLevel + 1, 11, sbb);
        this.method_14917(world, AIR, 3, floorLevel + 1, 10, sbb);
        this.method_14917(world, AIR, 3, floorLevel + 2, 11, sbb);
        this.method_14917(world, AIR, 11, floorLevel + 1, 3, sbb);
        this.method_14917(world, AIR, 11, floorLevel + 1, 4, sbb);
        this.method_14917(world, AIR, 11, floorLevel + 2, 3, sbb);
        this.method_14926(temp);
    }

    protected void decorateLichChandelier(class_5281 world, int floorLevel, class_3341 sbb) {
        int cx = this.size / 2;
        int cy = floorLevel + 4;
        int cz = this.size / 2;
        this.method_14917(world, class_2246.field_10620.method_9564(), cx + 1, cy, cz, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), cx + 2, cy, cz, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), cx + 1, cy, cz + 1, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), cx, cy, cz + 1, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), cx, cy, cz + 2, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), cx - 1, cy, cz + 1, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), cx - 1, cy, cz, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), cx - 2, cy, cz, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), cx - 1, cy, cz - 1, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), cx, cy, cz - 1, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), cx, cy, cz - 2, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), cx + 1, cy, cz - 1, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), cx + 1, ++cy, cz, sbb);
        this.method_14917(world, class_2246.field_10336.method_9564(), cx + 2, cy, cz, sbb);
        this.method_14917(world, class_2246.field_10336.method_9564(), cx + 1, cy, cz + 1, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), cx, cy, cz + 1, sbb);
        this.method_14917(world, class_2246.field_10336.method_9564(), cx, cy, cz + 2, sbb);
        this.method_14917(world, class_2246.field_10336.method_9564(), cx - 1, cy, cz + 1, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), cx - 1, cy, cz, sbb);
        this.method_14917(world, class_2246.field_10336.method_9564(), cx - 2, cy, cz, sbb);
        this.method_14917(world, class_2246.field_10336.method_9564(), cx - 1, cy, cz - 1, sbb);
        this.method_14917(world, class_2246.field_10620.method_9564(), cx, cy, cz - 1, sbb);
        this.method_14917(world, class_2246.field_10336.method_9564(), cx, cy, cz - 2, sbb);
        this.method_14917(world, class_2246.field_10336.method_9564(), cx + 1, cy, cz - 1, sbb);
        this.method_14917(world, class_2246.field_10336.method_9564(), cx + 1, ++cy, cz, sbb);
        this.method_14917(world, class_2246.field_10336.method_9564(), cx, cy, cz + 1, sbb);
        this.method_14917(world, class_2246.field_10336.method_9564(), cx - 1, cy, cz, sbb);
        this.method_14917(world, class_2246.field_10336.method_9564(), cx, cy, cz - 1, sbb);
        for (int y = floorLevel + 5; y < this.height - 1; ++y) {
            this.method_14917(world, class_2246.field_10620.method_9564(), cx, y, cz, sbb);
        }
    }

    protected void decoratePaintings(class_5281 world, class_5819 rand, int floorLevel, class_3341 sbb) {
        int howMany = 25;
        for (class_2350 horizontal : class_2350.class_2353.field_11062) {
            this.generatePaintingsOnWall(world, rand, howMany, floorLevel, horizontal, 48, sbb);
            this.generatePaintingsOnWall(world, rand, howMany, floorLevel, horizontal, 32, sbb);
            this.generatePaintingsOnWall(world, rand, howMany, floorLevel, horizontal, 0, sbb);
        }
    }

    protected void decorateTorches(class_5281 world, class_5819 rand, int floorLevel, class_3341 sbb) {
        this.generateTorchesOnWall(world, rand, floorLevel, class_2350.field_11035, sbb);
        this.generateTorchesOnWall(world, rand, floorLevel, class_2350.field_11034, sbb);
        this.generateTorchesOnWall(world, rand, floorLevel, class_2350.field_11043, sbb);
        this.generateTorchesOnWall(world, rand, floorLevel, class_2350.field_11039, sbb);
    }

    protected void generateTorchesOnWall(class_5281 world, class_5819 rand, int floorLevel, class_2350 direction, class_3341 sbb) {
        for (int i = 0; i < 5; ++i) {
            class_2338 wCoords = this.getRandomWallSpot(rand, floorLevel, direction, sbb);
            if (wCoords == null) continue;
            class_2338.class_2339 tCoords = new class_2338.class_2339(wCoords.method_10263(), wCoords.method_10264(), wCoords.method_10260());
            class_2680 blockState = world.method_8320((class_2338)tCoords);
            class_2680 aboveBlockState = world.method_8320(tCoords.method_10084());
            if (!blockState.method_26215() || !aboveBlockState.method_26215() || !EntityUtil.getEntitiesInAABB(world, new class_238((class_2338)tCoords)).isEmpty()) continue;
            world.method_8652((class_2338)tCoords, (class_2680)class_2246.field_10620.method_9564().method_11657((class_2769)class_2429.field_11329.get(direction.method_10153()), (Comparable)Boolean.valueOf(true)), 2);
            world.method_8652(tCoords.method_10084(), class_2246.field_10336.method_9564(), 2);
        }
    }
}

