/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.layer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.LongFunction;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import twilightforest.init.custom.BiomeLayerTypes;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerFactory;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerType;
import twilightforest.world.components.layer.vanillalegacy.area.LazyArea;
import twilightforest.world.components.layer.vanillalegacy.context.Context;
import twilightforest.world.components.layer.vanillalegacy.context.LazyAreaContext;
import twilightforest.world.components.layer.vanillalegacy.traits.AreaTransformer0;

public class RandomBiomeLayer
implements AreaTransformer0 {
    private final int rareBiomeChance;
    private final List<class_5321<class_1959>> commonBiomes;
    private final List<class_5321<class_1959>> rareBiomes;

    public RandomBiomeLayer(int rareBiomeChance, List<class_5321<class_1959>> commonBiomes, List<class_5321<class_1959>> rareBiomes) {
        this.rareBiomeChance = rareBiomeChance;
        this.commonBiomes = commonBiomes;
        this.rareBiomes = rareBiomes;
    }

    @Override
    public class_5321<class_1959> applyPixel(Context context, int x, int z) {
        if (context.nextRandom(this.rareBiomeChance) == 0) {
            return this.rareBiomes.get(context.nextRandom(this.rareBiomes.size()));
        }
        return this.commonBiomes.get(context.nextRandom(this.commonBiomes.size()));
    }

    public static final class Factory
    implements BiomeLayerFactory {
        public static final Codec<Factory> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.LONG.fieldOf("salt").forGetter(Factory::salt), (App)Codec.INT.fieldOf("rare_biome_chance").forGetter(Factory::rareBiomeChance), (App)class_5321.method_39154((class_5321)class_7924.field_41236).listOf().fieldOf("common_biomes").forGetter(Factory::commonBiomes), (App)class_5321.method_39154((class_5321)class_7924.field_41236).listOf().fieldOf("rare_biomes").forGetter(Factory::rareBiomes)).apply((Applicative)inst, Factory::new));
        private final long salt;
        private final int rareBiomeChance;
        private final List<class_5321<class_1959>> commonBiomes;
        private final List<class_5321<class_1959>> rareBiomes;
        private final RandomBiomeLayer instance;

        public Factory(long salt, int rareBiomeChance, List<class_5321<class_1959>> commonBiomes, List<class_5321<class_1959>> rareBiomes) {
            this.salt = salt;
            this.rareBiomeChance = rareBiomeChance;
            this.commonBiomes = commonBiomes;
            this.rareBiomes = rareBiomes;
            this.instance = new RandomBiomeLayer(rareBiomeChance, commonBiomes, rareBiomes);
        }

        @Override
        public LazyArea build(LongFunction<LazyAreaContext> contextFactory) {
            return (LazyArea)this.instance.run(contextFactory.apply(this.salt));
        }

        @Override
        public BiomeLayerType getType() {
            return (BiomeLayerType)BiomeLayerTypes.RANDOM_BIOMES.get();
        }

        public long salt() {
            return this.salt;
        }

        public int rareBiomeChance() {
            return this.rareBiomeChance;
        }

        public List<class_5321<class_1959>> commonBiomes() {
            return this.commonBiomes;
        }

        public List<class_5321<class_1959>> rareBiomes() {
            return this.rareBiomes;
        }
    }
}

