/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.layer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.LongFunction;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import twilightforest.init.custom.BiomeLayerStack;
import twilightforest.init.custom.BiomeLayerTypes;
import twilightforest.world.components.layer.vanillalegacy.Area;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerFactory;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerType;
import twilightforest.world.components.layer.vanillalegacy.area.LazyArea;
import twilightforest.world.components.layer.vanillalegacy.context.Context;
import twilightforest.world.components.layer.vanillalegacy.context.LazyAreaContext;
import twilightforest.world.components.layer.vanillalegacy.traits.AreaTransformer2;
import twilightforest.world.components.layer.vanillalegacy.traits.DimensionOffset0Transformer;

public record FilteredBiomeLayer(class_5321<class_1959> biomeFirst) implements AreaTransformer2,
DimensionOffset0Transformer
{
    @Override
    public class_5321<class_1959> applyPixel(Context context, Area area1, Area area2, int x, int z) {
        class_5321<class_1959> riverInputs = area2.getBiome(this.getParentX(x), this.getParentY(z));
        if (riverInputs == this.biomeFirst) {
            return riverInputs;
        }
        return area1.getBiome(this.getParentX(x), this.getParentY(z));
    }

    public static final class Factory
    implements BiomeLayerFactory {
        public static final Codec<Factory> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.LONG.fieldOf("salt").forGetter(Factory::salt), (App)class_5321.method_39154((class_5321)class_7924.field_41236).fieldOf("keep_biome").forGetter(Factory::filterKeep), (App)BiomeLayerStack.HOLDER_CODEC.fieldOf("filtered_layer").forGetter(Factory::filteredLayer), (App)BiomeLayerStack.HOLDER_CODEC.fieldOf("fallback_layer").forGetter(Factory::fallbackLayer)).apply((Applicative)inst, Factory::new));
        private final long salt;
        private final class_5321<class_1959> filterKeep;
        private final class_6880<BiomeLayerFactory> filteredLayer;
        private final class_6880<BiomeLayerFactory> fallbackLayer;
        private final FilteredBiomeLayer filteredBiomeLayer;

        public Factory(long salt, class_5321<class_1959> filterKeep, class_6880<BiomeLayerFactory> filteredLayer, class_6880<BiomeLayerFactory> fallbackLayer) {
            this.salt = salt;
            this.filterKeep = filterKeep;
            this.filteredLayer = filteredLayer;
            this.fallbackLayer = fallbackLayer;
            this.filteredBiomeLayer = new FilteredBiomeLayer(this.filterKeep);
        }

        @Override
        public LazyArea build(LongFunction<LazyAreaContext> contextFactory) {
            return this.filteredBiomeLayer.run(contextFactory.apply(this.salt), ((BiomeLayerFactory)this.fallbackLayer.comp_349()).build(contextFactory), ((BiomeLayerFactory)this.filteredLayer.comp_349()).build(contextFactory));
        }

        @Override
        public BiomeLayerType getType() {
            return (BiomeLayerType)BiomeLayerTypes.FILTERED.get();
        }

        public long salt() {
            return this.salt;
        }

        public class_5321<class_1959> filterKeep() {
            return this.filterKeep;
        }

        public class_6880<BiomeLayerFactory> fallbackLayer() {
            return this.fallbackLayer;
        }

        public class_6880<BiomeLayerFactory> filteredLayer() {
            return this.filteredLayer;
        }
    }
}

