/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.layer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.LongFunction;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import twilightforest.init.custom.BiomeLayerStack;
import twilightforest.init.custom.BiomeLayerTypes;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerFactory;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerType;
import twilightforest.world.components.layer.vanillalegacy.area.LazyArea;
import twilightforest.world.components.layer.vanillalegacy.context.Context;
import twilightforest.world.components.layer.vanillalegacy.context.LazyAreaContext;
import twilightforest.world.components.layer.vanillalegacy.traits.CastleTransformer;

public record CompanionBiomesLayer(List<Pair<class_5321<class_1959>, class_5321<class_1959>>> biomeCompanions) implements CastleTransformer
{
    @Override
    public class_5321<class_1959> apply(Context context, class_5321<class_1959> up, class_5321<class_1959> right, class_5321<class_1959> down, class_5321<class_1959> left, class_5321<class_1959> center) {
        for (Pair<class_5321<class_1959>, class_5321<class_1959>> biomeCompanion : this.biomeCompanions) {
            if (!CompanionBiomesLayer.isKey((class_5321<class_1959>)((class_5321)biomeCompanion.getFirst()), center, left, right, up, down)) continue;
            return (class_5321)biomeCompanion.getSecond();
        }
        return center;
    }

    private static boolean isKey(class_5321<class_1959> biome, class_5321<class_1959> center, class_5321<class_1959> right, class_5321<class_1959> left, class_5321<class_1959> up, class_5321<class_1959> down) {
        return center != biome && (right == biome || left == biome || up == biome || down == biome);
    }

    public static final class Factory
    implements BiomeLayerFactory {
        public static final Codec<Factory> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.LONG.fieldOf("salt").forGetter(Factory::salt), (App)Codec.mapPair((MapCodec)class_5321.method_39154((class_5321)class_7924.field_41236).fieldOf("key"), (MapCodec)class_5321.method_39154((class_5321)class_7924.field_41236).fieldOf("companion")).codec().listOf().fieldOf("keys_to_companions").forGetter(Factory::biomeCompanions), (App)BiomeLayerStack.HOLDER_CODEC.fieldOf("parent").forGetter(Factory::parent)).apply((Applicative)inst, Factory::new));
        private final long salt;
        private final List<Pair<class_5321<class_1959>, class_5321<class_1959>>> biomeCompanions;
        private final class_6880<BiomeLayerFactory> parent;
        private final CompanionBiomesLayer instance;

        public Factory(long salt, List<Pair<class_5321<class_1959>, class_5321<class_1959>>> biomeCompanions, class_6880<BiomeLayerFactory> parent) {
            this.salt = salt;
            this.biomeCompanions = biomeCompanions;
            this.parent = parent;
            this.instance = new CompanionBiomesLayer(biomeCompanions);
        }

        @Override
        public LazyArea build(LongFunction<LazyAreaContext> contextFactory) {
            return this.instance.run(contextFactory.apply(this.salt), ((BiomeLayerFactory)this.parent.comp_349()).build(contextFactory));
        }

        @Override
        public BiomeLayerType getType() {
            return (BiomeLayerType)BiomeLayerTypes.COMPANION_BIOMES.get();
        }

        public long salt() {
            return this.salt;
        }

        public List<Pair<class_5321<class_1959>, class_5321<class_1959>>> biomeCompanions() {
            return this.biomeCompanions;
        }

        public class_6880<BiomeLayerFactory> parent() {
            return this.parent;
        }
    }
}

