/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import io.github.fabricators_of_create.porting_lib.common.util.IPlantable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import twilightforest.init.TFBlocks;
import twilightforest.util.FeatureLogic;
import twilightforest.util.FeaturePlacers;
import twilightforest.util.FeatureUtil;
import twilightforest.world.components.feature.config.TFTreeFeatureConfig;
import twilightforest.world.components.feature.trees.TFTreeFeature;

public class CanopyTreeFeature
extends TFTreeFeature<TFTreeFeatureConfig> {
    public CanopyTreeFeature(Codec<TFTreeFeatureConfig> config) {
        super(config);
    }

    @Override
    protected boolean generate(class_5281 world, class_5819 random, class_2338 pos, BiConsumer<class_2338, class_2680> trunkPlacer, BiConsumer<class_2338, class_2680> leavesPlacer, BiConsumer<class_2338, class_2680> decorationPlacer, TFTreeFeatureConfig config) {
        ArrayList leaves = Lists.newArrayList();
        int treeHeight = config.minHeight;
        if (random.method_43048(config.chanceAddFiveFirst) == 0) {
            treeHeight += random.method_43048(5);
            if (random.method_43048(config.chanceAddFiveSecond) == 0) {
                treeHeight += random.method_43048(5);
            }
        }
        if (world.method_31601(pos.method_10264() + treeHeight)) {
            return false;
        }
        class_2680 state = world.method_8320(pos.method_10074());
        if (!state.method_26204().canSustainPlant(state, (class_1922)world, pos.method_10074(), class_2350.field_11036, (IPlantable)TFBlocks.CANOPY_SAPLING.get())) {
            return false;
        }
        leaves.clear();
        this.buildBranch((class_1936)world, leaves, pos, trunkPlacer, 0, treeHeight, 0.0, 0.0, true, random, config);
        int numBranches = 3 + random.method_43048(2);
        float offset = random.method_43057();
        for (int b = 0; b < numBranches; ++b) {
            this.buildBranch((class_1936)world, leaves, pos, trunkPlacer, treeHeight - 10 + b, 9.0, 0.3 * (double)b + (double)offset, 0.2, false, random, config);
        }
        if (config.hasLeaves) {
            for (class_2338 leafPos : leaves) {
                this.makeLeafBlob((class_3746)world, leavesPlacer, random, leafPos, config);
            }
        }
        if (FeatureUtil.hasAirAround((class_1936)world, pos.method_10074())) {
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, random, pos.method_10074(), config.trunkProvider);
        } else {
            FeaturePlacers.placeIfValidRootPos((class_3746)world, decorationPlacer, random, pos.method_10074(), config.rootsProvider);
        }
        int numRoots = 3 + random.method_43048(2);
        offset = random.method_43057();
        for (int b = 0; b < numRoots; ++b) {
            FeaturePlacers.buildRoot((class_1936)world, decorationPlacer, random, pos, offset, b, config.rootsProvider);
        }
        return true;
    }

    private void makeLeafBlob(class_3746 world, BiConsumer<class_2338, class_2680> leafPlacer, class_5819 random, class_2338 leafPos, TFTreeFeatureConfig config) {
        FeaturePlacers.placeCircleOdd(world, leafPlacer, FeaturePlacers.VALID_TREE_POS, random, leafPos.method_10074(), 3.0f, config.leavesProvider);
        FeaturePlacers.placeCircleOdd(world, leafPlacer, FeaturePlacers.VALID_TREE_POS, random, leafPos, 4.0f, config.leavesProvider);
        FeaturePlacers.placeCircleOdd(world, leafPlacer, FeaturePlacers.VALID_TREE_POS, random, leafPos.method_10084(), 2.0f, config.leavesProvider);
    }

    void buildBranch(class_1936 world, List<class_2338> leaves, class_2338 pos, BiConsumer<class_2338, class_2680> trunkPlacer, int height, double length, double angle, double tilt, boolean trunk, class_5819 treeRNG, TFTreeFeatureConfig config) {
        class_2338 src = pos.method_10086(height);
        class_2338 dest = FeatureLogic.translate(src, length, angle, tilt);
        if (world.isAreaLoaded(dest, 5)) {
            if (trunk) {
                FeaturePlacers.drawBresenhamTree((class_3746)world, trunkPlacer, FeaturePlacers.VALID_TREE_POS, src, dest, config.trunkProvider, treeRNG);
            } else {
                FeaturePlacers.drawBresenhamBranch(world, trunkPlacer, treeRNG, src, dest, config.branchProvider);
            }
            if (trunk) {
                FeaturePlacers.addFirefly(world, pos, 3 + treeRNG.method_43048(7), treeRNG.method_43058());
            }
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, treeRNG, dest.method_10078(), config.branchProvider);
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, treeRNG, dest.method_10067(), config.branchProvider);
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, treeRNG, dest.method_10072(), config.branchProvider);
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, treeRNG, dest.method_10095(), config.branchProvider);
            leaves.add(dest);
        }
    }
}

