/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.chunkgenerators;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import net.minecraft.class_1311;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2810;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3233;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3485;
import net.minecraft.class_3532;
import net.minecraft.class_3754;
import net.minecraft.class_4076;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5284;
import net.minecraft.class_5309;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5483;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6012;
import net.minecraft.class_6544;
import net.minecraft.class_6748;
import net.minecraft.class_6780;
import net.minecraft.class_6874;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7059;
import net.minecraft.class_7138;
import net.minecraft.class_7869;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFLandmark;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.util.Vec2i;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorWrapper;
import twilightforest.world.components.chunkgenerators.ControlledSpawnsCache;
import twilightforest.world.components.chunkgenerators.warp.NoiseModifier;
import twilightforest.world.components.chunkgenerators.warp.NoiseSlider;
import twilightforest.world.components.chunkgenerators.warp.TFBlendedNoise;
import twilightforest.world.components.chunkgenerators.warp.TFNoiseInterpolator;
import twilightforest.world.components.chunkgenerators.warp.TFTerrainWarp;
import twilightforest.world.components.structures.TFStructureComponent;
import twilightforest.world.components.structures.placements.BiomeForcedLandmarkPlacement;
import twilightforest.world.components.structures.start.TFStructureStart;
import twilightforest.world.components.structures.type.HollowHillStructure;
import twilightforest.world.components.structures.util.ControlledSpawns;

public class ChunkGeneratorTwilight
extends ChunkGeneratorWrapper {
    public static final Codec<ChunkGeneratorTwilight> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2794.field_24746.fieldOf("wrapped_generator").forGetter(o -> o.delegate), (App)class_5284.field_24781.fieldOf("noise_generation_settings").forGetter(o -> o.noiseGeneratorSettings), (App)Codec.BOOL.fieldOf("generate_dark_forest_canopy").forGetter(o -> o.genDarkForestCanopy), (App)Codec.INT.optionalFieldOf("dark_forest_canopy_height").forGetter(o -> o.darkForestCanopyHeight), (App)Codec.unboundedMap((Codec)class_5321.method_39154((class_5321)class_7924.field_41236), (Codec)TFLandmark.CODEC.listOf().xmap(ImmutableSet::copyOf, ImmutableList::copyOf)).fieldOf("landmark_placement_allowed_biomes").forGetter(o -> o.biomeLandmarkOverrides)).apply((Applicative)instance, ChunkGeneratorTwilight::new));
    private final Map<class_5321<class_1959>, ImmutableSet<TFLandmark>> biomeLandmarkOverrides;
    private final class_6880<class_5284> noiseGeneratorSettings;
    private final boolean genDarkForestCanopy;
    private final Optional<Integer> darkForestCanopyHeight;
    private final class_2680 defaultBlock;
    private final class_2680 defaultFluid;
    private final Optional<class_6544.class_6552> surfaceNoiseGetter;
    private final Optional<TFTerrainWarp> warper;
    private static final class_2680[] EMPTY_COLUMN = new class_2680[0];

    public ChunkGeneratorTwilight(class_2794 delegate, class_6880<class_5284> noiseGenSettings, boolean genDarkForestCanopy, Optional<Integer> darkForestCanopyHeight, Map<class_5321<class_1959>, ImmutableSet<TFLandmark>> biomeLandmarkOverrides) {
        super(delegate);
        class_3754 noiseGen;
        this.biomeLandmarkOverrides = biomeLandmarkOverrides;
        this.noiseGeneratorSettings = noiseGenSettings;
        this.genDarkForestCanopy = genDarkForestCanopy;
        this.darkForestCanopyHeight = darkForestCanopyHeight;
        if (delegate instanceof class_3754 && (noiseGen = (class_3754)delegate).method_41541().method_40227()) {
            this.defaultBlock = ((class_5284)noiseGen.method_41541().comp_349()).comp_475();
            this.defaultFluid = ((class_5284)noiseGen.method_41541().comp_349()).comp_476();
            this.surfaceNoiseGetter = Optional.empty();
        } else {
            this.defaultBlock = class_2246.field_10340.method_9564();
            this.defaultFluid = class_2246.field_10382.method_9564();
            this.surfaceNoiseGetter = Optional.empty();
        }
        if (noiseGenSettings.method_40227()) {
            class_5309 settings = ((class_5284)noiseGenSettings.comp_349()).comp_474();
            class_1966 class_19662 = delegate.method_12098();
            if (class_19662 instanceof TFBiomeProvider) {
                TFBiomeProvider source = (TFBiomeProvider)class_19662;
                class_2919 random = new class_2919((class_5819)new class_5820(0L));
                TFBlendedNoise blendedNoise = new TFBlendedNoise((class_5819)random);
                NoiseModifier modifier = NoiseModifier.PASS;
                this.warper = Optional.of(new TFTerrainWarp(settings.method_39546(), settings.method_39545(), settings.comp_174() / settings.method_39545(), source, new NoiseSlider(-10.0, 3, 0), new NoiseSlider(15.0, 3, 0), settings, blendedNoise, modifier));
            } else {
                this.warper = Optional.empty();
            }
        } else {
            this.warper = Optional.empty();
        }
    }

    protected Codec<? extends class_2794> method_28506() {
        return CODEC;
    }

    @Override
    public int method_16397(int x, int z, class_2902.class_2903 heightMap, class_5539 level, class_7138 random) {
        if (this.warper.isEmpty()) {
            return super.method_16397(x, z, heightMap, level, random);
        }
        class_5309 settings = ((class_5284)this.noiseGeneratorSettings.comp_349()).comp_474();
        int minY = Math.max(settings.comp_173(), level.method_31607());
        int maxY = Math.min(settings.comp_173() + settings.comp_174(), level.method_31600());
        int minCell = Math.floorDiv(minY, settings.method_39545());
        int maxCell = Math.floorDiv(maxY - minY, settings.method_39545());
        return maxCell <= 0 ? level.method_31607() : this.iterateNoiseColumn(random, x, z, null, heightMap.method_16402(), minCell, maxCell).orElse(level.method_31607());
    }

    @Override
    public class_4966 method_26261(int x, int z, class_5539 level, class_7138 random) {
        if (this.warper.isEmpty()) {
            return super.method_26261(x, z, level, random);
        }
        class_5309 settings = ((class_5284)this.noiseGeneratorSettings.comp_349()).comp_474();
        int minY = Math.max(settings.comp_173(), level.method_31607());
        int maxY = Math.min(settings.comp_173() + settings.comp_174(), level.method_31600());
        int minCell = Math.floorDiv(minY, settings.method_39545());
        int maxCell = Math.floorDiv(maxY - minY, settings.method_39545());
        if (maxCell <= 0) {
            return new class_4966(minY, EMPTY_COLUMN);
        }
        class_2680[] ablockstate = new class_2680[maxCell * settings.method_39545()];
        this.iterateNoiseColumn(random, x, z, ablockstate, null, minCell, maxCell);
        return new class_4966(minY, ablockstate);
    }

    protected OptionalInt iterateNoiseColumn(class_7138 random, int x, int z, class_2680[] states, @Nullable Predicate<class_2680> predicate, int min, int max) {
        class_5309 settings = ((class_5284)this.noiseGeneratorSettings.comp_349()).comp_474();
        int cellWidth = settings.method_39546();
        int cellHeight = settings.method_39545();
        int xDiv = Math.floorDiv(x, cellWidth);
        int zDiv = Math.floorDiv(z, cellWidth);
        int xMod = Math.floorMod(x, cellWidth);
        int zMod = Math.floorMod(z, cellWidth);
        int xMin = xMod / cellWidth;
        int zMin = zMod / cellWidth;
        double[][] columns = new double[][]{this.makeAndFillNoiseColumn(random, xDiv, zDiv, min, max), this.makeAndFillNoiseColumn(random, xDiv, zDiv + 1, min, max), this.makeAndFillNoiseColumn(random, xDiv + 1, zDiv, min, max), this.makeAndFillNoiseColumn(random, xDiv + 1, zDiv + 1, min, max)};
        for (int cell = max - 1; cell >= 0; --cell) {
            double d00 = columns[0][cell];
            double d10 = columns[1][cell];
            double d20 = columns[2][cell];
            double d30 = columns[3][cell];
            double d01 = columns[0][cell + 1];
            double d11 = columns[1][cell + 1];
            double d21 = columns[2][cell + 1];
            double d31 = columns[3][cell + 1];
            for (int height = cellHeight - 1; height >= 0; --height) {
                double dcell = (double)height / (double)cellHeight;
                double lcell = class_3532.method_16438((double)dcell, (double)xMin, (double)zMin, (double)d00, (double)d01, (double)d20, (double)d21, (double)d10, (double)d11, (double)d30, (double)d31);
                int layer = cell * cellHeight + height;
                int maxlayer = layer + min * cellHeight;
                class_2680 state = this.generateBaseState(lcell, layer);
                if (states != null) {
                    states[layer] = state;
                }
                if (predicate == null || !predicate.test(state)) continue;
                return OptionalInt.of(maxlayer + 1);
            }
        }
        return OptionalInt.empty();
    }

    public CompletableFuture<class_2791> method_38275(Executor executor, class_7138 random, class_6748 blender, class_5138 manager, class_2791 chunkAccess) {
        return CompletableFuture.supplyAsync(class_156.method_37910((String)"init_biomes", () -> {
            chunkAccess.method_38257((class_6780)this.method_12098(), class_6544.method_40443());
            return chunkAccess;
        }), class_156.method_18349());
    }

    @Override
    public CompletableFuture<class_2791> method_12088(Executor executor, class_6748 blender, class_7138 random, class_5138 structureManager, class_2791 chunkAccess) {
        if (this.warper.isEmpty()) {
            return super.method_12088(executor, blender, random, structureManager, chunkAccess);
        }
        class_5309 settings = ((class_5284)this.noiseGeneratorSettings.comp_349()).comp_474();
        int cellHeight = settings.method_39545();
        int minY = Math.max(settings.comp_173(), chunkAccess.method_31607());
        int maxY = Math.min(settings.comp_173() + settings.comp_174(), chunkAccess.method_31600());
        int mincell = Math.floorDiv(minY, cellHeight);
        int maxcell = Math.floorDiv(maxY - minY, cellHeight);
        if (maxcell <= 0) {
            return CompletableFuture.completedFuture(chunkAccess);
        }
        int maxIndex = chunkAccess.method_31602(maxcell * cellHeight - 1 + minY);
        int minIndex = chunkAccess.method_31602(minY);
        HashSet sections = Sets.newHashSet();
        for (int index = maxIndex; index >= minIndex; --index) {
            class_2826 section = chunkAccess.method_38259(index);
            section.method_16676();
            sections.add(section);
        }
        return CompletableFuture.supplyAsync(() -> this.doFill(random, chunkAccess, mincell, maxcell), class_156.method_18349()).whenCompleteAsync((chunk, throwable) -> {
            for (class_2826 section : sections) {
                section.method_16677();
            }
        }, executor);
    }

    private class_2791 doFill(class_7138 random, class_2791 access, int min, int max) {
        class_5309 settings = ((class_5284)this.noiseGeneratorSettings.comp_349()).comp_474();
        int cellWidth = settings.method_39546();
        int cellHeight = settings.method_39545();
        int cellCountX = 16 / cellWidth;
        int cellCountZ = 16 / cellWidth;
        class_2902 oceanfloor = access.method_12032(class_2902.class_2903.field_13195);
        class_2902 surface = access.method_12032(class_2902.class_2903.field_13194);
        class_1923 chunkpos = access.method_12004();
        int minX = chunkpos.method_8326();
        int minZ = chunkpos.method_8328();
        TFNoiseInterpolator interpolator = new TFNoiseInterpolator(cellCountX, max, cellCountZ, chunkpos, min, (columns, x, z, min1, max1, max12) -> this.fillNoiseColumn(x, z, min1, max1, max12));
        ArrayList list = Lists.newArrayList((Object[])new TFNoiseInterpolator[]{interpolator});
        list.forEach(noiseint -> noiseint.initialiseFirstX(random));
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int cellX = 0; cellX < cellCountX; ++cellX) {
            int advX = cellX;
            list.forEach(noiseint -> noiseint.advanceX(random, advX));
            for (int cellZ = 0; cellZ < cellCountZ; ++cellZ) {
                int sections = access.method_32890() - 1;
                class_2826 section = access.method_38259(sections);
                for (int cellY = max - 1; cellY >= 0; --cellY) {
                    int advY = cellY;
                    int advZ = cellZ;
                    list.forEach(noiseint -> noiseint.selectYZ(advY, advZ));
                    for (int height = cellHeight - 1; height >= 0; --height) {
                        int minheight = (min + cellY) * cellHeight + height;
                        int mincellY = minheight & 0xF;
                        int minindexY = access.method_31602(minheight);
                        if (sections != minindexY) {
                            sections = minindexY;
                            section = access.method_38259(minindexY);
                        }
                        double heightdiv = (double)height / (double)cellHeight;
                        list.forEach(noiseint -> noiseint.updateY(heightdiv));
                        for (int widthX = 0; widthX < cellWidth; ++widthX) {
                            int minwidthX = minX + cellX * cellWidth + widthX;
                            int mincellX = minwidthX & 0xF;
                            double widthdivX = (double)widthX / (double)cellWidth;
                            list.forEach(noiseint -> noiseint.updateX(widthdivX));
                            for (int widthZ = 0; widthZ < cellWidth; ++widthZ) {
                                int minwidthZ = minZ + cellZ * cellWidth + widthZ;
                                int mincellZ = minwidthZ & 0xF;
                                double widthdivZ = (double)widthZ / (double)cellWidth;
                                double noiseval = interpolator.updateZ(widthdivZ);
                                class_2680 state = this.generateBaseState(noiseval, minheight);
                                if (state == class_2246.field_10124.method_9564()) continue;
                                section.method_12256(mincellX, mincellY, mincellZ, state, false);
                                oceanfloor.method_12597(mincellX, minheight, mincellZ, state);
                                surface.method_12597(mincellX, minheight, mincellZ, state);
                            }
                        }
                    }
                }
            }
            list.forEach(TFNoiseInterpolator::swapSlices);
        }
        return access;
    }

    private double[] makeAndFillNoiseColumn(class_7138 state, int x, int z, int min, int max) {
        double[] columns = new double[max + 1];
        this.fillNoiseColumn(columns, x, z, min, max);
        return columns;
    }

    private void fillNoiseColumn(double[] columns, int x, int z, int min, int max) {
        this.warper.get().fillNoiseColumn(columns, x, z, min, max);
    }

    private class_2680 generateBaseState(double noiseVal, double level) {
        class_2680 state = noiseVal > 0.0 ? this.defaultBlock : (level < (double)this.method_16398() ? this.defaultFluid : class_2246.field_10124.method_9564());
        return state;
    }

    @Override
    public void method_12110(class_3233 world, class_5138 manager, class_7138 random, class_2791 chunk) {
        this.deformTerrainForFeature(world, chunk);
        super.method_12110(world, manager, random, chunk);
        this.darkForestCanopyHeight.ifPresent(integer -> this.addDarkForestCanopy(world, chunk, (int)integer));
        this.addGlaciers(world, chunk);
    }

    private void addGlaciers(class_3233 primer, class_2791 chunk) {
        class_2680 glacierBase = class_2246.field_10255.method_9564();
        class_2680 glacierMain = class_2246.field_10225.method_9564();
        class_2680 glacierTop = class_2246.field_10295.method_9564();
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                class_2338 old;
                Optional biome = primer.method_23753(primer.method_33561().method_8323().method_10069(x, 0, z)).method_40230();
                if (biome.isEmpty() || !TFBiomes.GLACIER.method_29177().equals((Object)((class_5321)biome.get()).method_29177())) continue;
                int gBase = -1;
                for (int y = 127; y >= 0; --y) {
                    class_2338 old1 = primer.method_33561().method_8323().method_10069(x, 0, z);
                    class_2248 currentBlock = primer.method_8320(old1.method_33096(y)).method_26204();
                    if (currentBlock != class_2246.field_10340) continue;
                    gBase = y;
                    old = primer.method_33561().method_8323().method_10069(x, 0, z);
                    primer.method_8652(old.method_33096(y), glacierBase, 3);
                    break;
                }
                int gHeight = 32;
                int gTop = Math.min(gBase + gHeight, 127);
                for (int y = gBase; y < gTop; ++y) {
                    old = primer.method_33561().method_8323().method_10069(x, 0, z);
                    primer.method_8652(old.method_33096(y), glacierMain, 3);
                }
                class_2338 old2 = primer.method_33561().method_8323().method_10069(x, 0, z);
                primer.method_8652(old2.method_33096(gTop), glacierTop, 3);
            }
        }
    }

    public void method_40450(List<String> p_223175_, class_7138 p_223176_, class_2338 p_223177_) {
    }

    protected final void deformTerrainForFeature(class_3233 primer, class_2791 chunk) {
        Vec2i featureRelativePos = new Vec2i();
        TFLandmark nearFeature = LegacyLandmarkPlacements.getNearestLandmark(primer.method_33561().field_9181, primer.method_33561().field_9180, (class_5281)primer, featureRelativePos);
        if (!nearFeature.requiresTerraforming) {
            return;
        }
        int relativeFeatureX = featureRelativePos.x;
        int relativeFeatureZ = featureRelativePos.z;
        if (LegacyLandmarkPlacements.isTheseFeatures(nearFeature, TFLandmark.SMALL_HILL, TFLandmark.MEDIUM_HILL, TFLandmark.LARGE_HILL, TFLandmark.HYDRA_LAIR)) {
            int hdiam = (nearFeature.size * 2 + 1) * 16;
            for (int xInChunk = 0; xInChunk < 16; ++xInChunk) {
                for (int zInChunk = 0; zInChunk < 16; ++zInChunk) {
                    int featureDX = xInChunk - relativeFeatureX;
                    int featureDZ = zInChunk - relativeFeatureZ;
                    float dist = (int)class_3532.method_15355((float)(featureDX * featureDX + featureDZ * featureDZ));
                    float hheight = (int)(class_3532.method_15362((float)(dist / (float)hdiam * (float)Math.PI)) * ((float)hdiam / 3.0f));
                    this.raiseHills(primer, chunk, nearFeature.size, nearFeature == TFLandmark.HYDRA_LAIR, hdiam, xInChunk, zInChunk, featureDX, featureDZ, hheight);
                }
            }
        } else if (nearFeature == TFLandmark.HEDGE_MAZE || nearFeature == TFLandmark.NAGA_COURTYARD || nearFeature == TFLandmark.QUEST_GROVE) {
            for (int xInChunk = 0; xInChunk < 16; ++xInChunk) {
                for (int zInChunk = 0; zInChunk < 16; ++zInChunk) {
                    int featureDX = xInChunk - relativeFeatureX;
                    int featureDZ = zInChunk - relativeFeatureZ;
                    ChunkGeneratorTwilight.flattenTerrainForFeature(primer, nearFeature.size, xInChunk, zInChunk, featureDX, this.method_16398(), featureDZ);
                }
            }
        } else if (nearFeature == TFLandmark.YETI_CAVE) {
            for (int xInChunk = 0; xInChunk < 16; ++xInChunk) {
                for (int zInChunk = 0; zInChunk < 16; ++zInChunk) {
                    int featureDX = xInChunk - relativeFeatureX;
                    int featureDZ = zInChunk - relativeFeatureZ;
                    this.deformTerrainForYetiLair(primer, nearFeature.size, xInChunk, zInChunk, featureDX, featureDZ);
                }
            }
        } else if (nearFeature == TFLandmark.TROLL_CAVE) {
            ChunkGeneratorTwilight.deformTerrainForTrollCloud2(primer, chunk, relativeFeatureX, relativeFeatureZ, 166);
        }
    }

    private static void flattenTerrainForFeature(class_3233 primer, int size, int x, int z, int dx, int dy, int dz) {
        class_2338 old;
        class_2338 old1;
        class_2680 b;
        class_2338 old2;
        int y;
        float squishFactor = 0.0f;
        int mazeHeight = dy + 5;
        int FEATURE_BOUNDARY = (size * 2 + 1) * 8 - 8;
        if (dx <= -FEATURE_BOUNDARY) {
            squishFactor = (float)(-dx - FEATURE_BOUNDARY) / 8.0f;
        } else if (dx >= FEATURE_BOUNDARY) {
            squishFactor = (float)(dx - FEATURE_BOUNDARY) / 8.0f;
        }
        if (dz <= -FEATURE_BOUNDARY) {
            squishFactor = Math.max(squishFactor, (float)(-dz - FEATURE_BOUNDARY) / 8.0f);
        } else if (dz >= FEATURE_BOUNDARY) {
            squishFactor = Math.max(squishFactor, (float)(dz - FEATURE_BOUNDARY) / 8.0f);
        }
        if (squishFactor > 0.0f) {
            for (y = 0; y <= 127; ++y) {
                class_2338 old3 = primer.method_33561().method_8323().method_10069(x, 0, z);
                class_2248 currentTerrain = primer.method_8320(old3.method_33096(y)).method_26204();
                if (currentTerrain == class_2246.field_10340) continue;
                mazeHeight += (int)((float)(y - mazeHeight) * squishFactor);
                break;
            }
        }
        for (y = 0; y < mazeHeight; ++y) {
            old2 = primer.method_33561().method_8323().method_10069(x, 0, z);
            b = primer.method_8320(old2.method_33096(y));
            old1 = primer.method_33561().method_8323().method_10069(x, 0, z);
            if (primer.method_23753(old1.method_33096(y)).method_40225(TFBiomes.STREAM) || !b.method_26215() && !b.method_51176()) continue;
            old = primer.method_33561().method_8323().method_10069(x, 0, z);
            primer.method_8652(old.method_33096(y), class_2246.field_10340.method_9564(), 3);
        }
        for (y = mazeHeight; y <= 127; ++y) {
            old2 = primer.method_33561().method_8323().method_10069(x, 0, z);
            b = primer.method_8320(old2.method_33096(y));
            old1 = primer.method_33561().method_8323().method_10069(x, 0, z);
            if (primer.method_23753(old1.method_33096(y)).method_40225(TFBiomes.STREAM) || b.method_26215() || b.method_51176()) continue;
            old = primer.method_33561().method_8323().method_10069(x, 0, z);
            primer.method_8652(old.method_33096(y), class_2246.field_10124.method_9564(), 3);
        }
    }

    private static void deformTerrainForTrollCloud2(class_3233 primer, class_2791 chunkAccess, int hx, int hz, int cloudHeight) {
        for (int bx = 0; bx < 4; ++bx) {
            for (int bz = 0; bz < 4; ++bz) {
                int dx = bx * 4 - hx - 2;
                int dz = bz * 4 - hz - 2;
                int regionX = primer.method_33561().field_9181 + 8 >> 4;
                int regionZ = primer.method_33561().field_9180 + 8 >> 4;
                long seed = (long)regionX * 3129871L ^ (long)regionZ * 116129781L;
                seed = seed * seed * 42317861L + seed * 7L;
                int num0 = (int)(seed >> 12 & 3L);
                int num1 = (int)(seed >> 15 & 3L);
                int num2 = (int)(seed >> 18 & 3L);
                int num3 = (int)(seed >> 21 & 3L);
                int num4 = (int)(seed >> 9 & 3L);
                int num5 = (int)(seed >> 6 & 3L);
                int num6 = (int)(seed >> 3 & 3L);
                int num7 = (int)(seed & 3L);
                int dx2 = dx + num0 * 5 - num1 * 4;
                int dz2 = dz + num2 * 4 - num3 * 5;
                int dx3 = dx + num4 * 5 - num5 * 4;
                int dz3 = dz + num6 * 4 - num7 * 5;
                float dist0 = class_3532.method_15355((float)(dx * dx + dz * dz)) / 4.0f;
                float dist2 = class_3532.method_15355((float)(dx2 * dx2 + dz2 * dz2)) / 3.5f;
                float dist3 = class_3532.method_15355((float)(dx3 * dx3 + dz3 * dz3)) / 4.5f;
                double dist = Math.min(dist0, Math.min(dist2, dist3));
                float pr = primer.method_8409().method_43057();
                double cv = dist - 7.0 - (double)(pr * 3.0f);
                int y = cloudHeight;
                int depth = 4;
                if (pr < 0.1f) {
                    ++y;
                }
                if (pr > 0.6f) {
                    ++depth;
                }
                if (pr > 0.9f) {
                    ++depth;
                }
                for (int sx = 0; sx < 4; ++sx) {
                    for (int sz = 0; sz < 4; ++sz) {
                        int lx = bx * 4 + sx;
                        int lz = bz * 4 + sz;
                        class_2338.class_2339 movingPos = primer.method_33561().method_8323().method_25503().method_10100(lx, 0, lz);
                        int dY = primer.method_8624(class_2902.class_2903.field_13194, movingPos.method_10263(), movingPos.method_10260());
                        int oceanFloor = primer.method_8624(class_2902.class_2903.field_13195, movingPos.method_10263(), movingPos.method_10260());
                        if (dist < 7.0 || cv < (double)0.05f) {
                            primer.method_8652((class_2338)movingPos.method_33098(y), ((class_2248)TFBlocks.WISPY_CLOUD.get()).method_9564(), 3);
                            for (d = 1; d < depth; ++d) {
                                primer.method_8652((class_2338)movingPos.method_33098(y - d), ((class_2248)TFBlocks.FLUFFY_CLOUD.get()).method_9564(), 3);
                            }
                            primer.method_8652((class_2338)movingPos.method_33098(y - depth), ((class_2248)TFBlocks.WISPY_CLOUD.get()).method_9564(), 3);
                        } else if (dist < 8.0 || cv < 1.0) {
                            for (d = 1; d < depth; ++d) {
                                primer.method_8652((class_2338)movingPos.method_33098(y - d), ((class_2248)TFBlocks.FLUFFY_CLOUD.get()).method_9564(), 3);
                            }
                        }
                        ChunkGeneratorTwilight.forceHeightMapLevel(chunkAccess, class_2902.class_2903.field_13194, (class_2338)movingPos, dY);
                        ChunkGeneratorTwilight.forceHeightMapLevel(chunkAccess, class_2902.class_2903.field_13202, (class_2338)movingPos, dY);
                        ChunkGeneratorTwilight.forceHeightMapLevel(chunkAccess, class_2902.class_2903.field_13195, (class_2338)movingPos, oceanFloor);
                        ChunkGeneratorTwilight.forceHeightMapLevel(chunkAccess, class_2902.class_2903.field_13200, (class_2338)movingPos, oceanFloor);
                    }
                }
            }
        }
    }

    private void raiseHills(class_3233 world, class_2791 chunk, int size, boolean hydraHill, int hdiam, int xInChunk, int zInChunk, int featureDX, int featureDZ, float hillHeight) {
        class_2338.class_2339 movingPos = world.method_33561().method_8323().method_10069(xInChunk, 0, zInChunk).method_25503();
        int groundHeight = chunk.method_12005(class_2902.class_2903.field_13195, movingPos.method_10263(), movingPos.method_10260());
        float noiseRaw = this.surfaceNoiseGetter.map(ns -> Float.valueOf(0.0f)).orElse(Float.valueOf(0.0f)).floatValue();
        float totalHeightRaw = (float)groundHeight * 0.75f + (float)this.method_16398() * 0.25f + hillHeight + noiseRaw;
        int totalHeight = (int)((float)((int)totalHeightRaw >> 1) * 0.375f + totalHeightRaw * 0.625f);
        for (int y = groundHeight; y <= totalHeight; ++y) {
            world.method_8652((class_2338)movingPos.method_33098(y), this.defaultBlock, 3);
        }
        int hollow = Math.min((int)hillHeight - 4 - size, totalHeight - 3);
        if (hydraHill) {
            int mx = featureDX + 16;
            int mz = featureDZ + 16;
            int mdist = (int)class_3532.method_15355((float)(mx * mx + mz * mz));
            int mheight = (int)(class_3532.method_15362((float)((float)mdist / ((float)hdiam / 1.5f) * (float)Math.PI)) * ((float)hdiam / 1.5f));
            hollow = Math.max(mheight - 4, hollow);
        }
        int hollowFloor = hydraHill ? this.method_16398() : this.method_16398() - 5 - (hollow >> 3);
        for (int y = hollowFloor + 1; y < hollowFloor + hollow; ++y) {
            world.method_8652((class_2338)movingPos.method_33098(y), class_2246.field_10124.method_9564(), 3);
        }
    }

    private void deformTerrainForYetiLair(class_3233 primer, int size, int xInChunk, int zInChunk, int featureDX, int featureDZ) {
        int y;
        float squishFactor = 0.0f;
        int topHeight = this.method_16398() + 24;
        int outerBoundary = (size * 2 + 1) * 8 - 8;
        if (featureDX <= -outerBoundary) {
            squishFactor = (float)(-featureDX - outerBoundary) / 8.0f;
        } else if (featureDX >= outerBoundary) {
            squishFactor = (float)(featureDX - outerBoundary) / 8.0f;
        }
        if (featureDZ <= -outerBoundary) {
            squishFactor = Math.max(squishFactor, (float)(-featureDZ - outerBoundary) / 8.0f);
        } else if (featureDZ >= outerBoundary) {
            squishFactor = Math.max(squishFactor, (float)(featureDZ - outerBoundary) / 8.0f);
        }
        int caveBoundary = size * 2 * 8 - 8;
        int offset = Math.min(Math.abs(featureDX), Math.abs(featureDZ));
        int hollowCeiling = this.method_16398() + 40 - offset * 4;
        if (featureDX >= -caveBoundary && featureDZ >= -caveBoundary && featureDX <= caveBoundary && featureDZ <= caveBoundary) {
            hollowCeiling = this.method_16398() + 16;
        }
        hollowCeiling -= offset / 6;
        hollowCeiling = Math.min(hollowCeiling, this.method_16398() + 16);
        int hollowFloor = this.method_16398() - 4 + offset / 6;
        class_2338.class_2339 movingPos = primer.method_33561().method_8323().method_10069(xInChunk, 0, zInChunk).method_25503();
        if (squishFactor > 0.0f) {
            for (y = primer.method_31607(); y <= primer.method_31600(); ++y) {
                if (this.defaultBlock.equals(primer.method_8320((class_2338)movingPos.method_33098(y)))) continue;
                topHeight += (int)((float)(y - topHeight) * squishFactor);
                hollowFloor += (int)((float)(y - hollowFloor) * squishFactor);
                break;
            }
        }
        for (y = primer.method_31607(); y < topHeight; ++y) {
            class_2248 b = primer.method_8320((class_2338)movingPos.method_33098(y)).method_26204();
            if (b != class_2246.field_10124 && b != class_2246.field_10382) continue;
            primer.method_8652((class_2338)movingPos.method_33098(y), this.defaultBlock, 3);
        }
        for (y = hollowFloor + 1; y < hollowCeiling; ++y) {
            primer.method_8652((class_2338)movingPos.method_33098(y), class_2246.field_10124.method_9564(), 3);
        }
        if (hollowFloor < hollowCeiling && hollowFloor < this.method_16398() + 3) {
            primer.method_8652((class_2338)movingPos.method_33098(hollowFloor), class_2246.field_10225.method_9564(), 3);
        }
    }

    private void addDarkForestCanopy(class_3233 primer, class_2791 chunk, int height) {
        class_2338 blockpos = primer.method_33561().method_8323();
        int[] thicks = new int[25];
        boolean biomeFound = false;
        for (int dZ = 0; dZ < 5; ++dZ) {
            for (int dX = 0; dX < 5; ++dX) {
                for (int bx = -1; bx <= 1; ++bx) {
                    for (int bz = -1; bz <= 1; ++bz) {
                        class_2338 p = blockpos.method_10069(dX + bx << 2, 0, dZ + bz << 2);
                        class_1959 biome = (class_1959)this.field_12761.method_38109(p.method_10263() >> 2, 256, p.method_10260() >> 2, null).comp_349();
                        if (!TFBiomes.DARK_FOREST.method_29177().equals((Object)primer.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome)) && !TFBiomes.DARK_FOREST_CENTER.method_29177().equals((Object)primer.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome))) continue;
                        int n = dX + dZ * 5;
                        thicks[n] = thicks[n] + 1;
                        biomeFound = true;
                    }
                }
            }
        }
        if (!biomeFound) {
            return;
        }
        Vec2i nearCenter = new Vec2i();
        TFLandmark nearFeature = LegacyLandmarkPlacements.getNearestLandmark(primer.method_33561().field_9181, primer.method_33561().field_9180, (class_5281)primer, nearCenter);
        double d = 0.03125;
        for (int dZ = 0; dZ < 16; ++dZ) {
            for (int dX = 0; dX < 16; ++dX) {
                int hz;
                int rz;
                int hx;
                int rx;
                int dist;
                int qx = dX >> 2;
                int qz = dZ >> 2;
                float xweight = (float)(dX % 4) * 0.25f + 0.125f;
                float zweight = (float)(dZ % 4) * 0.25f + 0.125f;
                float thickness = (float)thicks[qx + qz * 5] * (1.0f - xweight) * (1.0f - zweight) + (float)thicks[qx + 1 + qz * 5] * xweight * (1.0f - zweight) + (float)thicks[qx + (qz + 1) * 5] * (1.0f - xweight) * zweight + (float)thicks[qx + 1 + (qz + 1) * 5] * xweight * zweight - 4.0f;
                if (nearFeature == TFLandmark.DARK_TOWER && (dist = (int)class_3532.method_15355((float)((rx = dX - (hx = nearCenter.x)) * rx + (rz = dZ - (hz = nearCenter.z)) * rz))) < 24) {
                    thickness -= (float)(24 - dist);
                }
                if (!(thickness > 1.0f)) continue;
                int dY = chunk.method_12005(class_2902.class_2903.field_13194, dX, dZ);
                int oceanFloor = chunk.method_12005(class_2902.class_2903.field_13195, dX, dZ);
                class_2338 pos = primer.method_33561().method_8323().method_10069(dX, dY, dZ);
                if (chunk.method_8320(pos).method_51176()) continue;
                int noise = 0;
                int treeBottom = pos.method_10264() + height - (int)(thickness * 0.5f);
                int treeTop = treeBottom + (int)(thickness * 1.5f);
                class_2680 darkLeaves = ((class_2248)TFBlocks.HARDENED_DARK_LEAVES.get()).method_9564();
                for (int y = treeBottom -= noise; y < treeTop; ++y) {
                    primer.method_8652(pos.method_33096(y), darkLeaves, 3);
                }
                ChunkGeneratorTwilight.forceHeightMapLevel(chunk, class_2902.class_2903.field_13194, pos, dY);
                ChunkGeneratorTwilight.forceHeightMapLevel(chunk, class_2902.class_2903.field_13202, pos, dY);
                ChunkGeneratorTwilight.forceHeightMapLevel(chunk, class_2902.class_2903.field_13195, pos, oceanFloor);
                ChunkGeneratorTwilight.forceHeightMapLevel(chunk, class_2902.class_2903.field_13200, pos, oceanFloor);
            }
        }
    }

    static void forceHeightMapLevel(class_2791 chunk, class_2902.class_2903 type, class_2338 pos, int dY) {
        chunk.method_12032(type).method_12602(pos.method_10263() & 0xF, pos.method_10260() & 0xF, dY + 1);
    }

    private static int getSpawnListIndexAt(class_3449 start, class_2338 pos) {
        int highestFoundIndex = -1;
        for (class_3443 component : start.method_14963()) {
            if (!component.method_14935().method_14662((class_2382)pos)) continue;
            if (component instanceof TFStructureComponent) {
                TFStructureComponent tfComponent = (TFStructureComponent)component;
                if (tfComponent.spawnListIndex <= highestFoundIndex) continue;
                highestFoundIndex = tfComponent.spawnListIndex;
                continue;
            }
            return 0;
        }
        return highestFoundIndex;
    }

    @Nullable
    public static List<class_5483.class_1964> gatherPotentialSpawns(@Nullable ChunkGeneratorTwilight key, class_5138 structureManager, class_1311 classification, class_2338 pos) {
        Object structures = structureManager.method_41036().method_30530(class_7924.field_41246);
        if (key != null) {
            List<class_3195> l = ControlledSpawnsCache.CONTROLLED_SPAWNS.get((Object)key);
            if (l == null) {
                ArrayList<class_3195> list = new ArrayList<class_3195>();
                Iterator iterator = structures.iterator();
                while (iterator.hasNext()) {
                    class_3195 structure = (class_3195)iterator.next();
                    if (!(structure instanceof ControlledSpawns)) continue;
                    list.add(structure);
                }
                ControlledSpawnsCache.CONTROLLED_SPAWNS.put(key, list);
                structures = list;
            } else {
                structures = l;
            }
        }
        Iterator iterator = structures.iterator();
        while (iterator.hasNext()) {
            HollowHillStructure hollowHill;
            TFStructureStart s;
            class_3195 structure = (class_3195)iterator.next();
            if (!(structure instanceof ControlledSpawns)) continue;
            ControlledSpawns landmark = (ControlledSpawns)structure;
            class_3449 start = structureManager.method_28388(pos, structure);
            if (!start.method_16657()) continue;
            if (classification != class_1311.field_6302) {
                return landmark.getSpawnableList(classification);
            }
            if (start instanceof TFStructureStart && (s = (TFStructureStart)start).isConquered()) {
                return null;
            }
            if (structure instanceof HollowHillStructure && !(hollowHill = (HollowHillStructure)structure).canSpawnMob(pos, start.method_14969())) {
                return null;
            }
            int index = ChunkGeneratorTwilight.getSpawnListIndexAt(start, pos);
            if (index < 0) {
                return null;
            }
            return landmark.getSpawnableMonsterList(index);
        }
        return null;
    }

    public class_6012<class_5483.class_1964> method_12113(class_6880<class_1959> biome, class_5138 structureManager, class_1311 mobCategory, class_2338 pos) {
        List<class_5483.class_1964> potentialStructureSpawns = ChunkGeneratorTwilight.gatherPotentialSpawns(this, structureManager, mobCategory, pos);
        if (potentialStructureSpawns != null) {
            return class_6012.method_34988(potentialStructureSpawns);
        }
        return super.method_12113(biome, structureManager, mobCategory, pos);
    }

    public TFLandmark pickLandmarkForChunk(class_1923 chunk, class_5281 world) {
        return this.pickLandmarkForChunk(chunk.field_9181, chunk.field_9180, world);
    }

    public TFLandmark pickLandmarkForChunk(int x, int z, class_5281 world) {
        return LegacyLandmarkPlacements.pickLandmarkForChunk(x, z, world);
    }

    public boolean isLandmarkPickedForChunk(TFLandmark landmark, class_6880<class_1959> biome, int chunkX, int chunkZ, long seed) {
        if (!LegacyLandmarkPlacements.chunkHasLandmarkCenter(chunkX, chunkZ)) {
            return false;
        }
        Optional biomeKey = biome.method_40230();
        return biomeKey.filter(biomeResourceKey -> this.biomeLandmarkOverrides.containsKey(biomeResourceKey) ? this.biomeGuaranteedLandmark((class_5321<class_1959>)biomeResourceKey, landmark) : landmark == LegacyLandmarkPlacements.pickVarietyLandmark(chunkX, chunkZ, seed)).isPresent();
    }

    public boolean biomeGuaranteedLandmark(class_5321<class_1959> biome, TFLandmark landmark) {
        if (!this.biomeLandmarkOverrides.containsKey(biome)) {
            return false;
        }
        return this.biomeLandmarkOverrides.getOrDefault(biome, (ImmutableSet<TFLandmark>)ImmutableSet.of()).contains((Object)landmark);
    }

    public void method_16129(class_5455 access, class_7869 state, class_5138 manager, class_2791 chunk, class_3485 templateManager) {
        class_1923 chunkpos = chunk.method_12004();
        class_4076 sectionpos = class_4076.method_33705((class_2791)chunk);
        class_7138 randomstate = state.method_46713();
        state.method_46697().forEach(p_255564_ -> {
            BiomeForcedLandmarkPlacement forced;
            class_6874 structureplacement = ((class_7059)p_255564_.comp_349()).comp_511();
            List list = ((class_7059)p_255564_.comp_349()).comp_510();
            for (class_7059.class_7060 structureset$structureselectionentry : list) {
                class_3449 structurestart = manager.method_26975(sectionpos, (class_3195)structureset$structureselectionentry.comp_512().comp_349(), (class_2810)chunk);
                if (structurestart == null || !structurestart.method_16657()) continue;
                return;
            }
            if (structureplacement instanceof BiomeForcedLandmarkPlacement && (forced = (BiomeForcedLandmarkPlacement)structureplacement).isTFPlacementChunk(this, state, chunkpos.field_9181, chunkpos.field_9180) || structureplacement.method_41639(state, chunkpos.field_9181, chunkpos.field_9180)) {
                if (list.size() == 1) {
                    this.method_41044((class_7059.class_7060)list.get(0), manager, access, randomstate, templateManager, state.method_46714(), chunk, chunkpos, sectionpos);
                } else {
                    ArrayList arraylist = new ArrayList(list.size());
                    arraylist.addAll(list);
                    class_2919 worldgenrandom = new class_2919((class_5819)new class_5820(0L));
                    worldgenrandom.method_12663(state.method_46714(), chunkpos.field_9181, chunkpos.field_9180);
                    int i = 0;
                    for (class_7059.class_7060 structureset$structureselectionentry1 : arraylist) {
                        i += structureset$structureselectionentry1.comp_513();
                    }
                    while (!arraylist.isEmpty()) {
                        class_7059.class_7060 structureset$structureselectionentry2;
                        int j = worldgenrandom.method_43048(i);
                        int k = 0;
                        Iterator iterator = arraylist.iterator();
                        while (iterator.hasNext() && (j -= (structureset$structureselectionentry2 = (class_7059.class_7060)iterator.next()).comp_513()) >= 0) {
                            ++k;
                        }
                        class_7059.class_7060 structureset$structureselectionentry3 = (class_7059.class_7060)arraylist.get(k);
                        if (this.method_41044(structureset$structureselectionentry3, manager, access, randomstate, templateManager, state.method_46714(), chunk, chunkpos, sectionpos)) {
                            return;
                        }
                        arraylist.remove(k);
                        i -= structureset$structureselectionentry3.comp_513();
                    }
                }
            }
        });
    }

    @Nullable
    public Pair<class_2338, class_6880<class_3195>> method_12103(class_3218 level, class_6885<class_3195> targetStructures, class_2338 pos, int searchRadius, boolean skipKnownStructures) {
        class_7869 state = level.method_14178().method_46642();
        @Nullable Pair nearest = super.method_12103(level, targetStructures, pos, searchRadius, skipKnownStructures);
        Object2ObjectArrayMap placementSetMap = new Object2ObjectArrayMap();
        for (class_6880 holder : targetStructures) {
            for (class_6874 structureplacement : state.method_46708(holder)) {
                if (!(structureplacement instanceof BiomeForcedLandmarkPlacement)) continue;
                BiomeForcedLandmarkPlacement landmarkPlacement = (BiomeForcedLandmarkPlacement)structureplacement;
                placementSetMap.computeIfAbsent(landmarkPlacement, v -> new ObjectArraySet()).add(holder);
            }
        }
        if (placementSetMap.isEmpty()) {
            return nearest;
        }
        double distance = nearest == null ? Double.MAX_VALUE : ((class_2338)nearest.getFirst()).method_10262((class_2382)pos);
        for (class_2338 landmarkCenterPosition : LegacyLandmarkPlacements.landmarkCenterScanner(pos, class_3532.method_15386((float)class_3532.method_15355((float)searchRadius)))) {
            for (Map.Entry landmarkPlacement : placementSetMap.entrySet()) {
                if (!((BiomeForcedLandmarkPlacement)((Object)landmarkPlacement.getKey())).isTFPlacementChunk(this, state, landmarkCenterPosition.method_10263() >> 4, landmarkCenterPosition.method_10260() >> 4)) continue;
                for (class_6880 targetStructure : targetStructures) {
                    double newDistance;
                    if (!((Set)landmarkPlacement.getValue()).contains(targetStructure) || !((newDistance = landmarkCenterPosition.method_40081((double)pos.method_10263(), (double)landmarkCenterPosition.method_10264(), (double)pos.method_10260())) < distance)) continue;
                    nearest = new Pair((Object)landmarkCenterPosition, (Object)targetStructure);
                    distance = newDistance;
                }
            }
        }
        return nearest;
    }
}

