/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.biomesources;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import twilightforest.TwilightForestMod;
import twilightforest.init.custom.BiomeLayerStack;
import twilightforest.util.ComparableResourceKey;
import twilightforest.world.components.chunkgenerators.warp.TerrainColumn;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerFactory;
import twilightforest.world.components.layer.vanillalegacy.area.LazyArea;
import twilightforest.world.components.layer.vanillalegacy.context.LazyAreaContext;

@Deprecated
public class TFBiomeProvider
extends class_1966 {
    public static final Codec<TFBiomeProvider> TF_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TerrainColumn.CODEC.listOf().fieldOf("biome_landscape").xmap(l -> l.stream().collect(Collectors.toMap(TerrainColumn::getResourceKey, Function.identity())), m -> m.values().stream().sorted(Comparator.comparing(terrainColumn -> ComparableResourceKey.of(terrainColumn.getResourceKey()))).toList()).forGetter(o -> o.biomeList), (App)Codec.FLOAT.fieldOf("base_offset").forGetter(o -> Float.valueOf(o.baseOffset)), (App)Codec.FLOAT.fieldOf("base_factor").forGetter(o -> Float.valueOf(o.baseFactor)), (App)BiomeLayerStack.HOLDER_CODEC.fieldOf("biome_layer_config").orElseGet(s -> TwilightForestMod.LOGGER.warn(s), BiomeLayerStack::getAllBiomesHolder).forGetter(TFBiomeProvider::getBiomeConfig)).apply((Applicative)instance, instance.stable(TFBiomeProvider::new)));
    private final Map<class_5321<class_1959>, TerrainColumn> biomeList;
    private final float baseOffset;
    private final float baseFactor;
    private final class_6880<BiomeLayerFactory> genBiomeConfig;
    private final Supplier<LazyArea> genBiomes;

    public TFBiomeProvider(List<TerrainColumn> list, float offset, float factor, class_6880<BiomeLayerFactory> biomeLayerFactory) {
        this(list.stream().collect(Collectors.toMap(TerrainColumn::getResourceKey, Function.identity())), offset, factor, biomeLayerFactory);
    }

    public TFBiomeProvider(Map<class_5321<class_1959>, TerrainColumn> list, float offset, float factor, class_6880<BiomeLayerFactory> biomeLayerFactory) {
        this.genBiomeConfig = biomeLayerFactory;
        this.genBiomes = Suppliers.memoize(() -> ((BiomeLayerFactory)this.genBiomeConfig.comp_349()).build(salt -> new LazyAreaContext(25, salt)));
        this.baseOffset = offset;
        this.baseFactor = factor;
        this.biomeList = list;
    }

    protected Stream<class_6880<class_1959>> method_49494() {
        return this.biomeList.values().stream().flatMap(TerrainColumn::getBiomes);
    }

    protected Codec<? extends class_1966> method_28442() {
        return TF_CODEC;
    }

    public float getBaseOffset() {
        return this.baseOffset;
    }

    public float getBaseFactor() {
        return this.baseFactor;
    }

    public float getBiomeDepth(int x, int z) {
        return this.getBiomeDepth(this.genBiomes.get().getBiome(x, z));
    }

    public float getBiomeDepth(class_5321<class_1959> biome) {
        return this.getBiomeValue(biome, TerrainColumn::depth, Float.valueOf(0.0f)).floatValue();
    }

    public Optional<TerrainColumn> getTerrainColumn(int x, int z) {
        return this.getTerrainColumn(this.genBiomes.get().getBiome(x, z));
    }

    public Optional<TerrainColumn> getTerrainColumn(class_5321<class_1959> biome) {
        return this.biomeList.values().stream().filter(p -> p.is(biome)).findFirst();
    }

    public <T> T getBiomeValue(class_5321<class_1959> biome, Function<TerrainColumn, T> function, T other) {
        return this.getTerrainColumn(biome).map(function).orElse(other);
    }

    public class_6880<class_1959> method_38109(int x, int y, int z, class_6544.class_6552 sampler) {
        return this.biomeList.get(this.genBiomes.get().getBiome(x, z)).getBiome(y);
    }

    private class_6880<BiomeLayerFactory> getBiomeConfig() {
        return this.genBiomeConfig;
    }
}

