/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.biomesources;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.fabricators_of_create.porting_lib.util.ServerLifecycleHooks;
import it.unimi.dsi.fastutil.floats.Float2ObjectSortedMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import twilightforest.util.Codecs;

public record SpecialBiomePalette(class_6880<class_1959> river, class_6544.class_6547<class_6880<class_1959>> regularBiomes, class_6885<class_1959> specialBiomes, List<Float2ObjectSortedMap<class_6880<class_1959>>> landmarkGradients, List<class_6880<class_1959>> allBiomes) {
    public static final Codec<SpecialBiomePalette> CODEC = (Codec)class_156.method_656(() -> {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)class_1959.field_24677.fieldOf("river").forGetter(SpecialBiomePalette::river), (App)Codecs.CLIMATE_SYSTEM.fieldOf("common").forGetter(SpecialBiomePalette::regularBiomes), (App)class_1959.field_26750.fieldOf("special").forGetter(SpecialBiomePalette::specialBiomes), (App)Codecs.floatTreeCodec(class_1959.field_24677).listOf().comapFlatMap(l -> class_156.method_33141((List)l, (int)4), Function.identity()).fieldOf("landmarks").forGetter(SpecialBiomePalette::landmarkGradients)).apply((Applicative)instance, SpecialBiomePalette::create));
        return codec.orElseGet(SpecialBiomePalette::create);
    });
    private static final int[][] BINARY_GRID_PERMUTATIONS = new int[][]{{0, 1, 2, 3}, {0, 1, 3, 2}, {0, 2, 1, 3}, {0, 2, 3, 1}, {0, 3, 1, 2}, {0, 3, 2, 1}, {1, 0, 2, 3}, {1, 0, 3, 2}, {1, 2, 0, 3}, {1, 2, 3, 0}, {1, 3, 0, 2}, {1, 3, 2, 0}, {2, 0, 1, 3}, {2, 0, 3, 1}, {2, 1, 0, 3}, {2, 1, 3, 0}, {2, 3, 0, 1}, {2, 3, 1, 0}, {3, 0, 1, 2}, {3, 0, 2, 1}, {3, 1, 0, 2}, {3, 1, 2, 0}, {3, 2, 0, 1}, {3, 2, 1, 0}};

    private static SpecialBiomePalette create() {
        return SpecialBiomePalette.create((class_6880<class_1959>)ServerLifecycleHooks.getCurrentServer().method_30611().method_30530(class_7924.field_41236).method_40290(class_1972.field_9473), (class_6544.class_6547<class_6880<class_1959>>)new class_6544.class_6547(Collections.emptyList()), (class_6885<class_1959>)class_6885.method_40246((class_6880[])new class_6880[0]), Collections.emptyList());
    }

    private static SpecialBiomePalette create(class_6880<class_1959> river, class_6544.class_6547<class_6880<class_1959>> common, class_6885<class_1959> rare, List<Float2ObjectSortedMap<class_6880<class_1959>>> clusters) {
        return new SpecialBiomePalette(river, common, rare, clusters, (List<class_6880<class_1959>>)ImmutableList.builder().add(river).addAll(common.method_38128().stream().map(Pair::getSecond).iterator()).addAll(rare).addAll(clusters.stream().flatMap(tree -> tree.float2ObjectEntrySet().stream()).map(Map.Entry::getValue).iterator()).build());
    }

    @Nullable
    public class_6880<class_1959> getNearestLandmark(float distanceRelative, int landmarkIndex, long permutation) {
        if (distanceRelative > 1.0f) {
            return null;
        }
        return (class_6880)this.getNearestLandmark(landmarkIndex, permutation).get(distanceRelative);
    }

    private Float2ObjectSortedMap<class_6880<class_1959>> getNearestLandmark(int landmarkIndex, long permutation) {
        return this.landmarkGradients().get(BINARY_GRID_PERMUTATIONS[(int)(permutation % 24L)][landmarkIndex]);
    }
}

