/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3195;
import net.minecraft.class_3449;
import net.minecraft.class_4076;
import net.minecraft.class_4208;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.StructureTagGenerator;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.world.components.structures.start.TFStructureStart;

public final class LandmarkUtil {
    public static Optional<class_3449> locateNearestLandmarkStart(class_1936 level, int chunkX, int chunkZ) {
        return LandmarkUtil.locateNearestMatchingLandmark(level, StructureTagGenerator.LANDMARK, chunkX, chunkZ);
    }

    public static Optional<class_3449> locateNearestMatchingLandmark(class_1936 level, class_6862<class_3195> matching, int chunkX, int chunkZ) {
        Optional structureRegistry = level.method_30349().method_33310(class_7924.field_41246);
        if (structureRegistry.isEmpty()) {
            return Optional.empty();
        }
        Optional holders = ((class_2378)structureRegistry.get()).method_40266(matching);
        if (holders.isEmpty()) {
            return Optional.empty();
        }
        return LandmarkUtil.locateNearestMatchingLandmark(level, (class_6885<class_3195>)((class_6885)holders.get()), chunkX, chunkZ);
    }

    public static Optional<class_3449> locateNearestMatchingLandmark(class_1936 level, class_6885<class_3195> matching, int chunkX, int chunkZ) {
        Set structures = matching.method_40239().map(class_6880::comp_349).collect(Collectors.toSet());
        return LandmarkUtil.locateNearestMatchingLandmark(level, structures::contains, chunkX, chunkZ);
    }

    public static Optional<class_3449> locateNearestMatchingLandmark(class_1936 level, Predicate<class_3195> filter, int chunkX, int chunkZ) {
        int centerZ;
        class_2338 nearestFeature = LegacyLandmarkPlacements.getNearestCenterXZ(chunkX, chunkZ);
        int centerX = class_4076.method_18675((int)nearestFeature.method_10263());
        if (!level.method_8393(centerX, centerZ = class_4076.method_18675((int)nearestFeature.method_10260()))) {
            return Optional.empty();
        }
        class_2791 chunkAccess = level.method_22342(centerX, centerZ, class_2806.field_16423);
        for (Map.Entry structureEntry : chunkAccess.method_12016().entrySet()) {
            if (!filter.test((class_3195)structureEntry.getKey())) continue;
            return Optional.of((class_3449)structureEntry.getValue());
        }
        return Optional.empty();
    }

    public static void markStructureConquered(class_1937 level, EnforcedHomePoint mobHome, class_5321<class_3195> structureKey, boolean conquered) {
        LandmarkUtil.markStructureConquered(level, mobHome.getRestrictionPoint(), structureKey, conquered);
    }

    public static void markStructureConquered(class_1937 level, @Nullable class_4208 pos, class_5321<class_3195> structureKey, boolean conquered) {
        if (pos != null && level.method_27983() == pos.method_19442()) {
            class_3449 class_34492;
            Optional<class_3449> nearStart = LandmarkUtil.locateNearestLandmarkStart((class_1936)level, structureKey, pos.method_19446());
            if (nearStart.isEmpty() || !((class_34492 = nearStart.get()) instanceof TFStructureStart)) {
                return;
            }
            TFStructureStart twilightStart = (TFStructureStart)class_34492;
            twilightStart.setConquered(conquered, (class_1936)level);
        }
    }

    @Nullable
    public static class_3195 structureForKey(class_4538 level, class_5321<class_3195> structureKey) {
        Optional registry = level.method_30349().method_33310(class_7924.field_41246);
        return registry.isPresent() ? (class_3195)((class_2378)registry.get()).method_29107(structureKey) : null;
    }

    public static Optional<class_3449> locateNearestLandmarkStart(class_1936 level, class_5321<class_3195> structureKey, class_2338 pos) {
        return LandmarkUtil.locateNearestLandmarkStart(level, structureKey, class_4076.method_18675((int)pos.method_10263()), class_4076.method_18675((int)pos.method_10260()));
    }

    public static Optional<class_3449> locateNearestLandmarkStart(class_1936 level, class_5321<class_3195> structureKey, int chunkX, int chunkZ) {
        class_3195 structure = LandmarkUtil.structureForKey((class_4538)level, structureKey);
        if (structure == null) {
            return Optional.empty();
        }
        return LandmarkUtil.locateNearestLandmarkStart(level, structure, chunkX, chunkZ);
    }

    public static Optional<class_3449> locateNearestLandmarkStart(class_1936 level, class_3195 structure, int chunkX, int chunkZ) {
        class_2338 nearestLandmark = LegacyLandmarkPlacements.getNearestCenterXZ(chunkX, chunkZ);
        class_2791 chunkAccess = level.method_22342(class_4076.method_18675((int)nearestLandmark.method_10263()), class_4076.method_18675((int)nearestLandmark.method_10260()), class_2806.field_16423);
        for (Long packedChunkPos : chunkAccess.method_12180(structure)) {
            class_3449 structureStart;
            int packedZ;
            int packedX = class_1923.method_8325((long)packedChunkPos);
            if (!level.method_8393(packedX, packedZ = class_1923.method_8332((long)packedChunkPos)) || (structureStart = level.method_22342(packedX, packedZ, class_2806.field_16423).method_12181(structure)) == null || !structureStart.method_16657()) continue;
            return Optional.of(structureStart);
        }
        return Optional.empty();
    }

    public static boolean isProgressionEnforced(class_1937 world) {
        return world.method_8450().method_8355(TwilightForestMod.ENFORCED_PROGRESSION_RULE);
    }

    private LandmarkUtil() {
    }
}

