/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;

public record ColorUtil(Function<class_1767, class_2248> function) {
    public static final ColorUtil WOOL = new ColorUtil(color -> switch (color) {
        default -> throw new IncompatibleClassChangeError();
        case class_1767.field_7952 -> class_2246.field_10446;
        case class_1767.field_7946 -> class_2246.field_10095;
        case class_1767.field_7958 -> class_2246.field_10215;
        case class_1767.field_7951 -> class_2246.field_10294;
        case class_1767.field_7947 -> class_2246.field_10490;
        case class_1767.field_7961 -> class_2246.field_10028;
        case class_1767.field_7954 -> class_2246.field_10459;
        case class_1767.field_7944 -> class_2246.field_10423;
        case class_1767.field_7967 -> class_2246.field_10222;
        case class_1767.field_7955 -> class_2246.field_10619;
        case class_1767.field_7945 -> class_2246.field_10259;
        case class_1767.field_7966 -> class_2246.field_10514;
        case class_1767.field_7957 -> class_2246.field_10113;
        case class_1767.field_7942 -> class_2246.field_10170;
        case class_1767.field_7964 -> class_2246.field_10314;
        case class_1767.field_7963 -> class_2246.field_10146;
    });
    public static final ColorUtil TERRACOTTA = new ColorUtil(color -> switch (color) {
        default -> throw new IncompatibleClassChangeError();
        case class_1767.field_7952 -> class_2246.field_10611;
        case class_1767.field_7946 -> class_2246.field_10184;
        case class_1767.field_7958 -> class_2246.field_10015;
        case class_1767.field_7951 -> class_2246.field_10325;
        case class_1767.field_7947 -> class_2246.field_10143;
        case class_1767.field_7961 -> class_2246.field_10014;
        case class_1767.field_7954 -> class_2246.field_10444;
        case class_1767.field_7944 -> class_2246.field_10349;
        case class_1767.field_7967 -> class_2246.field_10590;
        case class_1767.field_7955 -> class_2246.field_10235;
        case class_1767.field_7945 -> class_2246.field_10570;
        case class_1767.field_7966 -> class_2246.field_10409;
        case class_1767.field_7957 -> class_2246.field_10123;
        case class_1767.field_7942 -> class_2246.field_10526;
        case class_1767.field_7964 -> class_2246.field_10328;
        case class_1767.field_7963 -> class_2246.field_10626;
    });
    public static final ColorUtil STAINED_GLASS = new ColorUtil(color -> switch (color) {
        default -> throw new IncompatibleClassChangeError();
        case class_1767.field_7952 -> class_2246.field_10087;
        case class_1767.field_7946 -> class_2246.field_10227;
        case class_1767.field_7958 -> class_2246.field_10574;
        case class_1767.field_7951 -> class_2246.field_10271;
        case class_1767.field_7947 -> class_2246.field_10049;
        case class_1767.field_7961 -> class_2246.field_10157;
        case class_1767.field_7954 -> class_2246.field_10317;
        case class_1767.field_7944 -> class_2246.field_10555;
        case class_1767.field_7967 -> class_2246.field_9996;
        case class_1767.field_7955 -> class_2246.field_10248;
        case class_1767.field_7945 -> class_2246.field_10399;
        case class_1767.field_7966 -> class_2246.field_10060;
        case class_1767.field_7957 -> class_2246.field_10073;
        case class_1767.field_7942 -> class_2246.field_10357;
        case class_1767.field_7964 -> class_2246.field_10272;
        case class_1767.field_7963 -> class_2246.field_9997;
    });
    public static final Map<class_1767, class_2248> WOOL_TO_DYE_IN_RAM_ORDER = ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{ColorUtil.entryOf(class_1767.field_7952, class_2246.field_10446), ColorUtil.entryOf(class_1767.field_7967, class_2246.field_10222), ColorUtil.entryOf(class_1767.field_7944, class_2246.field_10423), ColorUtil.entryOf(class_1767.field_7963, class_2246.field_10146), ColorUtil.entryOf(class_1767.field_7964, class_2246.field_10314), ColorUtil.entryOf(class_1767.field_7946, class_2246.field_10095), ColorUtil.entryOf(class_1767.field_7947, class_2246.field_10490), ColorUtil.entryOf(class_1767.field_7961, class_2246.field_10028), ColorUtil.entryOf(class_1767.field_7942, class_2246.field_10170), ColorUtil.entryOf(class_1767.field_7951, class_2246.field_10294), ColorUtil.entryOf(class_1767.field_7955, class_2246.field_10619), ColorUtil.entryOf(class_1767.field_7966, class_2246.field_10514), ColorUtil.entryOf(class_1767.field_7945, class_2246.field_10259), ColorUtil.entryOf(class_1767.field_7958, class_2246.field_10215), ColorUtil.entryOf(class_1767.field_7954, class_2246.field_10459), ColorUtil.entryOf(class_1767.field_7957, class_2246.field_10113)});

    public class_2680 getColor(class_1767 color) {
        return this.function.apply(color).method_9564();
    }

    public class_2248 getRandomColor(Random rand) {
        class_1767 color = class_1767.method_7791((int)rand.nextInt(16));
        return this.getColor(color).method_26204();
    }

    public static float[] rgbToHSV(int r, int g, int b) {
        float s;
        float h = 0.0f;
        float rabs = (float)r / 255.0f;
        float gabs = (float)g / 255.0f;
        float babs = (float)b / 255.0f;
        float v = Math.max(rabs, Math.max(gabs, babs));
        float diff = v - Math.min(rabs, Math.min(gabs, babs));
        Function<Float, Float> diffc = c -> Float.valueOf((v - c.floatValue()) / 6.0f / diff + 0.0f);
        if (diff == 0.0f) {
            s = 0.0f;
            h = 0.0f;
        } else {
            s = diff / v;
            float rr = diffc.apply(Float.valueOf(rabs)).floatValue();
            float gg = diffc.apply(Float.valueOf(gabs)).floatValue();
            float bb = diffc.apply(Float.valueOf(babs)).floatValue();
            if (rabs == v) {
                h = bb - gg;
            } else if (gabs == v) {
                h = 0.33333334f + rr - bb;
            } else if (babs == v) {
                h = 0.6666667f + gg - rr;
            }
            if (h < 0.0f) {
                h += 1.0f;
            } else if (h > 1.0f) {
                h -= 1.0f;
            }
        }
        return new float[]{h, s, v};
    }

    public static int hsvToRGB(float hue, float saturation, float value) {
        float normaliedHue = hue - (float)Math.floor(hue);
        int h = (int)(normaliedHue * 6.0f);
        float f = normaliedHue * 6.0f - (float)h;
        float p = value * (1.0f - saturation);
        float q = value * (1.0f - f * saturation);
        float t = value * (1.0f - (1.0f - f) * saturation);
        return switch (h) {
            case 0 -> ColorUtil.rgb(value, t, p);
            case 1 -> ColorUtil.rgb(q, value, p);
            case 2 -> ColorUtil.rgb(p, value, t);
            case 3 -> ColorUtil.rgb(p, q, value);
            case 4 -> ColorUtil.rgb(t, p, value);
            case 5 -> ColorUtil.rgb(value, p, q);
            default -> throw new RuntimeException("Something went wrong when converting from HSV to RGB. Input was " + hue + ", " + saturation + ", " + value);
        };
    }

    private static int rgb(float r, float g, float b) {
        return ((int)(r * 255.0f + 0.5f) & 0xFF) << 16 | ((int)(g * 255.0f + 0.5f) & 0xFF) << 8 | (int)(b * 255.0f + 0.5f) & 0xFF;
    }

    public static int argbToABGR(int argbColor) {
        int r = argbColor >> 16 & 0xFF;
        int b = argbColor & 0xFF;
        return argbColor & 0xFF00FF00 | b << 16 | r;
    }

    static <K, V> Map.Entry<K, V> entryOf(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }
}

