/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.pepperbell.simplenetworking.S2CPacket;
import net.minecraft.class_1259;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import twilightforest.TFConfig;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFChestBlock;
import twilightforest.client.renderer.TFWeatherRenderer;
import twilightforest.entity.ai.control.NoClipMoveControl;
import twilightforest.entity.ai.goal.GhastguardHomedFlightGoal;
import twilightforest.entity.ai.goal.UrGhastFlightGoal;
import twilightforest.entity.boss.IBossLootBuffer;
import twilightforest.entity.monster.CarminiteGhastguard;
import twilightforest.entity.monster.CarminiteGhastling;
import twilightforest.entity.projectile.UrGhastFireball;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFEntities;
import twilightforest.init.TFPOITypes;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStructures;
import twilightforest.loot.TFLootTables;
import twilightforest.network.ParticlePacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.EntityUtil;
import twilightforest.util.LandmarkUtil;

public class UrGhast
extends CarminiteGhastguard
implements IBossLootBuffer {
    private static final class_243 DYING_DECENT = new class_243(0.0, -0.03, 0.0);
    private static final class_2940<Boolean> DATA_TANTRUM = class_2945.method_12791(UrGhast.class, (class_2941)class_2943.field_13323);
    private final class_2371<class_1799> dyingInventory = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
    private List<class_2338> trapLocations;
    private int nextTantrumCry;
    private float damageUntilNextPhase = 10.0f;
    private final class_3213 bossInfo = new class_3213(this.method_5476(), class_1259.class_1260.field_5784, class_1259.class_1261.field_5795);
    private final List<class_3222> hurtBy = new ArrayList<class_3222>();

    public UrGhast(class_1299<? extends UrGhast> type, class_1937 world) {
        super(type, world);
        this.wanderFactor = 32.0f;
        this.field_5960 = true;
        this.setInTantrum(false);
        this.field_6194 = 317;
        this.field_6207 = new NoClipMoveControl((class_1308)this);
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossInfo.method_5413(this.method_5476());
    }

    public static class_5132.class_5133 registerAttributes() {
        return CarminiteGhastguard.registerAttributes().method_26868(class_5134.field_23716, 250.0).method_26868(class_5134.field_23717, 128.0).method_26868(class_5134.field_23718, 1.0);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(DATA_TANTRUM, (Object)false);
    }

    public List<class_2338> getTrapLocations() {
        return this.trapLocations;
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.trapLocations = new ArrayList<class_2338>();
        this.field_6201.field_6461.removeIf(e -> e.method_19058() instanceof GhastguardHomedFlightGoal);
        this.field_6201.method_6277(5, (class_1352)new UrGhastFlightGoal(this));
    }

    public boolean method_5974(double dist) {
        return false;
    }

    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801) {
            if (this.isRestrictionPointValid(this.method_37908().method_27983()) && this.method_37908().method_8477(this.getRestrictionPoint().method_19446())) {
                this.method_37908().method_8501(this.getRestrictionPoint().method_19446(), ((class_2248)TFBlocks.UR_GHAST_BOSS_SPAWNER.get()).method_9564());
            }
            this.method_31472();
        } else {
            super.method_5982();
        }
    }

    @Override
    protected class_3414 method_5994() {
        return (class_3414)TFSounds.UR_GHAST_AMBIENT.get();
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)TFSounds.UR_GHAST_HURT.get();
    }

    @Override
    protected class_3414 method_6002() {
        return (class_3414)TFSounds.UR_GHAST_DEATH.get();
    }

    @Override
    public class_3414 getFireSound() {
        return (class_3414)TFSounds.UR_GHAST_SHOOT.get();
    }

    @Override
    public class_3414 getWarnSound() {
        return (class_3414)TFSounds.UR_GHAST_WARN.get();
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().method_8608()) {
            this.bossInfo.method_5408(this.method_6032() / this.method_6063());
        } else if (this.isInTantrum() && !this.method_29504()) {
            this.method_37908().method_8406((class_2394)TFParticleType.BOSS_TEAR.get(), this.method_23317() + (this.method_6051().method_43058() - 0.5) * (double)this.method_17681() * 0.75, this.method_23318() + this.method_6051().method_43058() * (double)this.method_17682() * 0.5, this.method_23321() + (this.method_6051().method_43058() - 0.5) * (double)this.method_17681() * 0.75, 0.0, 0.0, 0.0);
        }
    }

    public boolean method_5679(class_1282 src) {
        return src.method_49708(class_8111.field_42340) || src.method_48789(class_8103.field_42246) || super.method_5679(src);
    }

    public void method_6005(double strength, double xRatio, double zRatio) {
    }

    public boolean method_5643(class_1282 source, float damage) {
        class_3222 player;
        if (this.isInTantrum()) {
            damage /= 10.0f;
        }
        float oldHealth = this.method_6032();
        boolean attackSuccessful = "fireball".equals(source.method_5525()) && source.method_5529() instanceof class_1657 ? super.method_5643(this.method_48923().method_48811(source.method_5529(), source.method_5526()), damage) : super.method_5643(source, damage);
        float lastDamage = oldHealth - this.method_6032();
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_3222 && !this.hurtBy.contains(player = (class_3222)class_12972)) {
            this.hurtBy.add(player);
        }
        if (!this.method_37908().method_8608() && this.field_6235 == this.field_6254 && !this.method_29504()) {
            this.damageUntilNextPhase -= lastDamage;
            if (this.damageUntilNextPhase <= 0.0f) {
                this.switchPhase();
            }
        }
        return attackSuccessful;
    }

    private void switchPhase() {
        if (this.isInTantrum()) {
            this.setInTantrum(false);
        } else {
            this.startTantrum();
        }
        this.resetDamageUntilNextPhase();
    }

    public void resetDamageUntilNextPhase() {
        this.damageUntilNextPhase = 18.0f;
    }

    private void startTantrum() {
        class_3218 serverLevel;
        class_1538 lightningbolt;
        this.setInTantrum(true);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218 && (lightningbolt = (class_1538)class_1299.field_6112.method_5883((class_1937)(serverLevel = (class_3218)class_19372))) != null) {
            class_2338 blockpos = serverLevel.method_18210(class_2338.method_49638((class_2374)this.method_19538().method_1019(new class_243(18.0, 0.0, 0.0).method_1024((float)Math.toRadians(this.method_6051().method_43048(360))))));
            lightningbolt.method_29495(class_243.method_24955((class_2382)blockpos));
            lightningbolt.method_29498(true);
            serverLevel.method_8649((class_1297)lightningbolt);
        }
        this.spawnGhastsAtTraps();
    }

    public void method_5773() {
        if (this.method_37908().method_8608() && !this.method_29504() && this.isInTantrum()) {
            TFWeatherRenderer.urGhastAlive = true;
        }
        super.method_5773();
    }

    public void spawnGhastsAtTraps() {
        ArrayList<class_2338> ghastSpawns = new ArrayList<class_2338>(this.trapLocations);
        Collections.shuffle(ghastSpawns);
        int numSpawns = Math.min(2, ghastSpawns.size());
        for (int i = 0; i < numSpawns; ++i) {
            class_2338 spawnCoord = (class_2338)ghastSpawns.get(i);
            this.spawnMinionGhastsAt(spawnCoord.method_10263(), spawnCoord.method_10264(), spawnCoord.method_10260());
        }
    }

    private void spawnMinionGhastsAt(int x, int y, int z) {
        int tries = 24;
        int spawns = 0;
        int maxSpawns = 6;
        int rangeXZ = 4;
        int rangeY = 8;
        class_1538 bolt = new class_1538(class_1299.field_6112, this.method_37908());
        bolt.method_5814((double)x, (double)(y + 4), (double)z);
        bolt.method_29498(true);
        this.method_37908().method_8649((class_1297)bolt);
        for (int i = 0; i < tries; ++i) {
            CarminiteGhastling minion = (CarminiteGhastling)((class_1299)TFEntities.CARMINITE_GHASTLING.get()).method_5883(this.method_37908());
            double sx = (double)x + (this.method_6051().method_43058() - this.method_6051().method_43058()) * (double)rangeXZ;
            double sy = (double)y + this.method_6051().method_43058() * (double)rangeY;
            double sz = (double)z + (this.method_6051().method_43058() - this.method_6051().method_43058()) * (double)rangeXZ;
            minion.method_5808(sx, sy, sz, this.method_37908().method_8409().method_43057() * 360.0f, 0.0f);
            minion.makeBossMinion();
            if (minion.method_5979((class_1936)this.method_37908(), class_3730.field_16471)) {
                this.method_37908().method_8649((class_1297)minion);
                minion.method_5990();
            }
            if (++spawns >= maxSpawns) break;
        }
    }

    @Override
    protected void method_5958() {
        super.method_5958();
        for (CarminiteGhastling ghast : this.method_37908().method_18467(CarminiteGhastling.class, this.method_5829().method_1014(1.0))) {
            ghast.method_5990();
            ghast.method_31472();
            this.method_6025(2.0f);
        }
        if (this.field_6012 % 60 == 0 && !this.getTrapLocations().isEmpty()) {
            this.getTrapLocations().removeIf(pos -> !this.method_37908().method_8320(pos).method_27852((class_2248)TFBlocks.GHAST_TRAP.get()) || !this.method_37908().method_8311(pos.method_10084()));
        }
        if (this.field_5953 || this.field_6012 % 100 == 0) {
            List<class_2338> addedPositions = this.scanForTraps((class_3218)this.method_37908());
            addedPositions.removeIf(pos -> this.getTrapLocations().contains(pos));
            if (!addedPositions.isEmpty()) {
                this.getTrapLocations().addAll(addedPositions);
            }
        }
        if (this.isInTantrum()) {
            this.method_5980(null);
            if (--this.nextTantrumCry <= 0) {
                this.method_5783((class_3414)TFSounds.UR_GHAST_TANTRUM.get(), this.method_6107(), this.method_6017());
                this.field_6191 = -this.method_5970();
                this.nextTantrumCry = 20 + this.method_6051().method_43048(30);
            }
            if (this.field_6012 % 10 == 0) {
                this.doTantrumDamageEffects();
            }
        }
    }

    public class_2338 getLogicalScanPoint() {
        return !this.isRestrictionPointValid(this.method_37908().method_27983()) ? this.method_24515() : this.getRestrictionPoint().method_19446();
    }

    private List<class_2338> scanForTraps(class_3218 level) {
        class_4153 poimanager = level.method_19494();
        Stream stream = poimanager.method_19125(type -> type.method_40225(TFPOITypes.GHAST_TRAP.getKey()), this.getLogicalScanPoint(), this.getHomeRadius(), class_4153.class_4155.field_18489);
        return stream.map(class_4156::method_19141).filter(trapPos -> level.method_8311(trapPos.method_10084())).sorted(Comparator.comparingDouble(trapPos -> trapPos.method_10262((class_2382)this.getLogicalScanPoint()))).collect(Collectors.toList());
    }

    private void doTantrumDamageEffects() {
        class_238 below = this.method_5829().method_989(0.0, -16.0, 0.0).method_1009(0.0, 16.0, 0.0);
        for (class_1657 player : this.method_37908().method_18467(class_1657.class, below)) {
            if (!this.method_37908().method_22348(player.method_24515())) continue;
            player.method_5643(TFDamageTypes.getEntityDamageSource(this.method_37908(), TFDamageTypes.GHAST_TEAR, (class_1297)this, (class_1299)TFEntities.UR_GHAST.get()), 3.0f);
        }
        for (CarminiteGhastling ghast : this.method_37908().method_18467(CarminiteGhastling.class, below)) {
            ghast.method_5762(0.0, 1.0, 0.0);
        }
    }

    public boolean checkGhastsAtTraps() {
        int trapsWithEnoughGhasts = 0;
        for (class_2338 trap : this.getTrapLocations()) {
            class_238 aabb = new class_238(trap, trap.method_10069(1, 1, 1)).method_1009(8.0, 16.0, 8.0);
            List nearbyGhasts = this.method_37908().method_18467(CarminiteGhastling.class, aabb);
            if (nearbyGhasts.size() < 4) continue;
            ++trapsWithEnoughGhasts;
        }
        return trapsWithEnoughGhasts >= 1;
    }

    @Override
    public void spitFireball() {
        double offsetX = this.method_5968().method_23317() - this.method_23317();
        double offsetY = this.method_5968().method_5829().field_1322 + (double)(this.method_5968().method_17682() / 2.0f) - (this.method_23318() + (double)(this.method_17682() / 2.0f));
        double offsetZ = this.method_5968().method_23321() - this.method_23321();
        UrGhastFireball entityFireball = new UrGhastFireball(this.method_37908(), this, offsetX, offsetY, offsetZ, 1);
        double shotSpawnDistance = 8.5;
        class_243 lookVec = this.method_5828(1.0f);
        entityFireball.method_5814(this.method_23317() + lookVec.method_10216() * shotSpawnDistance, this.method_23318() + (double)(this.method_17682() / 2.0f) + lookVec.method_10214() * shotSpawnDistance, this.method_23321() + lookVec.method_10215() * shotSpawnDistance);
        this.method_37908().method_8649((class_1297)entityFireball);
        for (int i = 0; i < 2; ++i) {
            entityFireball = new UrGhastFireball(this.method_37908(), this, offsetX + (double)((this.method_6051().method_43057() - this.method_6051().method_43057()) * 8.0f), offsetY, offsetZ + (double)((this.method_6051().method_43057() - this.method_6051().method_43057()) * 8.0f), 1);
            entityFireball.method_5814(this.method_23317() + lookVec.method_10216() * shotSpawnDistance, this.method_23318() + (double)(this.method_17682() / 2.0f) + lookVec.method_10214() * shotSpawnDistance, this.method_23321() + lookVec.method_10215() * shotSpawnDistance);
            this.method_37908().method_8649((class_1297)entityFireball);
        }
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossInfo.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossInfo.method_14089(player);
    }

    public boolean method_5809() {
        return false;
    }

    public boolean method_5810() {
        return false;
    }

    public boolean isInTantrum() {
        return (Boolean)this.method_5841().method_12789(DATA_TANTRUM);
    }

    public void setInTantrum(boolean inTantrum) {
        this.method_5841().method_12778(DATA_TANTRUM, (Object)inTantrum);
        this.resetDamageUntilNextPhase();
    }

    @Override
    protected float method_6107() {
        return 16.0f;
    }

    public float method_6017() {
        return (this.method_6051().method_43057() - this.method_6051().method_43057()) * 0.2f + 0.5f;
    }

    @Override
    public void method_5652(class_2487 compound) {
        compound.method_10556("inTantrum", this.isInTantrum());
        this.addDeathItemsSaveData(compound);
        super.method_5652(compound);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setInTantrum(compound.method_10577("inTantrum"));
        this.readDeathItemsSaveData(compound);
        if (this.method_16914()) {
            this.bossInfo.method_5413(this.method_5476());
        }
    }

    public void method_6078(class_1282 cause) {
        super.method_6078(cause);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.bossInfo.method_5408(0.0f);
            IBossLootBuffer.saveDropsIntoBoss(this, TFLootTables.createLootParams((class_1309)this, true, cause).method_51875(class_173.field_1173), serverLevel);
            LandmarkUtil.markStructureConquered(this.method_37908(), this, TFStructures.DARK_TOWER, true);
            for (class_3222 player : this.hurtBy) {
                TFAdvancements.HURT_BOSS.trigger(player, (class_1297)this);
            }
            class_1538 lightningbolt = (class_1538)class_1299.field_6112.method_5883((class_1937)serverLevel);
            if (lightningbolt != null) {
                lightningbolt.method_29495(this.method_19538().method_1031(0.0, (double)(this.method_17682() * 0.5f), 0.0));
                lightningbolt.method_29498(true);
                serverLevel.method_8649((class_1297)lightningbolt);
            }
        }
    }

    protected void method_6108() {
        ++this.field_6213;
        int maxDeath = 80;
        if (this.field_6213 <= maxDeath / 2) {
            float bbWidth = this.method_17681();
            float bbHeight = this.method_17682();
            for (int k = 0; k < 12; ++k) {
                double d = this.field_5974.method_43059() * 0.02;
                double d1 = this.field_5974.method_43059() * 0.02;
                double d2 = this.field_5974.method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)(this.field_5974.method_43056() ? (this.field_5974.method_43056() ? class_2398.field_11203 : class_2398.field_11236) : class_2390.field_11188), this.method_23317() + (double)(this.field_5974.method_43057() * bbWidth * 1.8f) - (double)bbWidth, this.method_23318() + (double)(this.field_5974.method_43057() * bbHeight), this.method_23321() + (double)(this.field_5974.method_43057() * bbWidth * 1.8f) - (double)bbWidth, d, d1, d2);
            }
        } else if (this.method_37908() instanceof class_3218) {
            double z;
            double y;
            double x;
            int i;
            if (this.field_6213 >= maxDeath && !this.method_31481()) {
                this.method_37908().method_8421((class_1297)this, (byte)60);
                this.method_5650(class_1297.class_5529.field_26998);
                return;
            }
            class_243 start = this.method_19538().method_1031(0.0, (double)(this.method_17682() * 0.5f), 0.0);
            class_243 end = class_243.method_24953((class_2382)EntityUtil.bossChestLocation(this));
            class_243 diff = end.method_1020(start);
            int deathTime2 = this.field_6213 - maxDeath / 2 + 1;
            double factor = (double)deathTime2 / (double)(maxDeath / 2);
            class_243 particlePos = start.method_1019(diff.method_1021(factor)).method_1031(Math.sin((double)deathTime2 * Math.PI * 0.1), Math.sin((double)deathTime2 * Math.PI * 0.05), Math.cos((double)deathTime2 * Math.PI * 0.1125));
            ParticlePacket particlePacket = new ParticlePacket();
            if (this.field_6213 >= maxDeath - 2) {
                for (i = 0; i < 40; ++i) {
                    x = (this.field_5974.method_43058() - 0.5) * 0.075 * (double)i;
                    y = (this.field_5974.method_43058() - 0.5) * 0.075 * (double)i;
                    z = (this.field_5974.method_43058() - 0.5) * 0.075 * (double)i;
                    particlePacket.queueParticle((class_2394)class_2398.field_11203, false, end.method_1031(x, y, z), class_243.field_1353);
                }
            }
            for (i = 0; i < 40; ++i) {
                x = (this.field_5974.method_43058() - 0.5) * 0.05 * (double)i;
                y = (this.field_5974.method_43058() - 0.5) * 0.05 * (double)i;
                z = (this.field_5974.method_43058() - 0.5) * 0.05 * (double)i;
                particlePacket.queueParticle((class_2394)class_2390.field_11188, false, particlePos.method_1031(x, y, z), class_243.field_1353);
            }
            TFPacketHandler.CHANNEL.sendToClientsTracking((S2CPacket)particlePacket, (class_1297)this);
        }
    }

    public class_243 method_18798() {
        return this.method_29504() ? DYING_DECENT : super.method_18798();
    }

    public void method_5650(class_1297.class_5529 reason) {
        class_1937 class_19372;
        if (reason.equals((Object)class_1297.class_5529.field_26998) && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            IBossLootBuffer.depositDropsIntoChest(this, ((TFChestBlock)((Object)TFBlocks.DARK_CHEST.get())).method_9564(), EntityUtil.bossChestLocation(this), serverLevel);
        }
        super.method_5650(reason);
    }

    protected boolean method_27071() {
        return (Boolean)TFConfig.COMMON_CONFIG.bossDropChests.get() == false;
    }

    @Override
    public boolean shouldAttack(class_1309 living) {
        return !this.isInTantrum();
    }

    public boolean method_5822() {
        return false;
    }

    @Override
    public class_2371<class_1799> getItemStacks() {
        return this.dyingInventory;
    }
}

