/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1307;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4208;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import twilightforest.advancements.TFAdvancements;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.entity.ai.control.NoClipMoveControl;
import twilightforest.entity.ai.goal.PhantomAttackStartGoal;
import twilightforest.entity.ai.goal.PhantomThrowWeaponGoal;
import twilightforest.entity.ai.goal.PhantomUpdateFormationAndMoveGoal;
import twilightforest.entity.ai.goal.PhantomWatchAndAttackGoal;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFItems;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStructures;
import twilightforest.loot.TFLootTables;
import twilightforest.util.EntityUtil;
import twilightforest.util.LandmarkUtil;

public class KnightPhantom
extends class_1307
implements class_1569,
EnforcedHomePoint {
    private static final class_2940<Optional<class_4208>> HOME_POINT = class_2945.method_12791(KnightPhantom.class, (class_2941)class_2943.field_38825);
    private static final class_2940<Boolean> FLAG_CHARGING = class_2945.method_12791(KnightPhantom.class, (class_2941)class_2943.field_13323);
    private static final class_1322 CHARGING_MODIFIER = new class_1322("Charging attack boost", 7.0, class_1322.class_1323.field_6328);
    private static final class_1322 NON_CHARGING_ARMOR_MODIFIER = new class_1322("Inactive Armor boost", 4.0, class_1322.class_1323.field_6331);
    private final class_3213 bossInfo = new class_3213(this.method_5476(), class_1259.class_1260.field_5786, class_1259.class_1261.field_5795);
    private int number;
    private int totalKnownKnights = 1;
    private int ticksProgress;
    private Formation currentFormation;
    private class_2338 chargePos = class_2338.field_10980;
    private final List<class_3222> hurtBy = new ArrayList<class_3222>();
    private final class_4048 invisibleSize = class_4048.method_18385((float)1.25f, (float)2.5f);
    private final class_4048 visibleSize = class_4048.method_18385((float)1.75f, (float)4.0f);

    public KnightPhantom(class_1299<? extends KnightPhantom> type, class_1937 world) {
        super(type, world);
        this.field_5960 = true;
        this.currentFormation = Formation.HOVER;
        this.field_6194 = 93;
        this.field_6207 = new NoClipMoveControl((class_1308)this);
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossInfo.method_5413(this.method_5476());
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        if (this.getNumber() == 0) {
            this.bossInfo.method_14088(player);
        }
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossInfo.method_14089(player);
    }

    @Nullable
    public class_1315 method_5943(class_5425 accessor, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnDataIn, @Nullable class_2487 dataTag) {
        class_1315 data = super.method_5943(accessor, difficulty, reason, spawnDataIn, dataTag);
        this.method_5964(accessor.method_8409(), difficulty);
        this.method_5984(accessor.method_8409(), difficulty);
        this.method_5996(class_5134.field_23724).method_26835(NON_CHARGING_ARMOR_MODIFIER);
        return data;
    }

    protected void method_5964(class_5819 random, class_1266 difficulty) {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)TFItems.KNIGHTMETAL_SWORD.get()));
        this.method_5673(class_1304.field_6174, new class_1799((class_1935)TFItems.PHANTOM_CHESTPLATE.get()));
        this.method_5673(class_1304.field_6169, new class_1799((class_1935)TFItems.PHANTOM_HELMET.get()));
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(FLAG_CHARGING, (Object)false);
        this.method_5841().method_12784(HOME_POINT, Optional.empty());
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new PhantomWatchAndAttackGoal(this));
        this.field_6201.method_6277(1, (class_1352)new PhantomUpdateFormationAndMoveGoal(this));
        this.field_6201.method_6277(2, (class_1352)new PhantomAttackStartGoal(this));
        this.field_6201.method_6277(3, (class_1352)new PhantomThrowWeaponGoal(this));
        this.field_6185.method_6277(0, (class_1352)new class_1400((class_1308)this, class_1657.class, false));
    }

    public static class_5132.class_5133 registerAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 35.0).method_26868(class_5134.field_23721, 1.0);
    }

    public Formation getCurrentFormation() {
        return this.currentFormation;
    }

    public class_2338 getChargePos() {
        return this.chargePos;
    }

    public void setChargePos(class_2338 pos) {
        this.chargePos = pos;
    }

    public boolean method_5974(double p_213397_1_) {
        return false;
    }

    public boolean method_5679(class_1282 src) {
        return src.method_49708(class_8111.field_42340) || super.method_5679(src);
    }

    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801) {
            if (this.getRestrictionPoint() != null && this.getNumber() == 0) {
                this.method_37908().method_8501(this.getRestrictionPoint().method_19446(), ((class_2248)TFBlocks.KNIGHT_PHANTOM_BOSS_SPAWNER.get()).method_9564());
            }
            this.method_31472();
        } else {
            super.method_5982();
        }
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().method_8608() && this.getNumber() == 0) {
            float health = 0.0f;
            float maxHealth = 0.0f;
            int amount = 0;
            for (KnightPhantom nearbyKnight : this.getNearbyKnights()) {
                health += nearbyKnight.method_6032();
                maxHealth += nearbyKnight.method_6063();
                ++amount;
            }
            int remaining = this.totalKnownKnights - amount;
            if (remaining > 0) {
                maxHealth += this.method_6063() * (float)remaining;
            }
            this.bossInfo.method_5408(health / maxHealth);
        }
        if (this.isChargingAtPlayer()) {
            for (int i = 0; i < 4; ++i) {
                class_1792 particleID = this.method_6051().method_43056() ? (class_1792)TFItems.PHANTOM_HELMET.get() : (class_1792)TFItems.KNIGHTMETAL_SWORD.get();
                this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)particleID)), this.method_23317() + ((double)this.method_6051().method_43057() - 0.5) * (double)this.method_17681(), this.method_23318() + (double)this.method_6051().method_43057() * ((double)this.method_17682() - 0.75) + 0.5, this.method_23321() + ((double)this.method_6051().method_43057() - 0.5) * (double)this.method_17681(), 0.0, -0.1, 0.0);
                this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_23317() + ((double)this.method_6051().method_43057() - 0.5) * (double)this.method_17681(), this.method_23318() + (double)this.method_6051().method_43057() * ((double)this.method_17682() - 0.75) + 0.5, this.method_23321() + ((double)this.method_6051().method_43057() - 0.5) * (double)this.method_17681(), 0.0, 0.1, 0.0);
            }
        }
    }

    protected void method_6108() {
        super.method_6108();
        for (int i = 0; i < 20; ++i) {
            double d0 = this.method_6051().method_43059() * 0.02;
            double d1 = this.method_6051().method_43059() * 0.02;
            double d2 = this.method_6051().method_43059() * 0.02;
            this.method_37908().method_8406((class_2394)class_2398.field_11236, this.method_23317() + (double)(this.method_6051().method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.method_23318() + (double)(this.method_6051().method_43057() * this.method_17682()), this.method_23321() + (double)(this.method_6051().method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), d0, d1, d2);
        }
    }

    public void method_6078(class_1282 cause) {
        super.method_6078(cause);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            List<KnightPhantom> knights = this.getNearbyKnights();
            if (!knights.isEmpty()) {
                knights.forEach(KnightPhantom::updateMyNumber);
            } else if (!cause.method_48789(class_8103.field_42242)) {
                this.bossInfo.method_5408(0.0f);
                class_2338 treasurePos = this.getRestrictionPoint() != null ? (serverLevel.method_8320(this.getRestrictionPoint().method_19446().method_10074()).method_45474() ? this.getRestrictionPoint().method_19446().method_10074() : this.getRestrictionPoint().method_19446()) : this.method_24515();
                TFLootTables.STRONGHOLD_BOSS.generateChest((class_5281)serverLevel, treasurePos, class_2350.field_11043, false);
                class_1297 class_12972 = cause.method_5529();
                if (class_12972 instanceof class_3222) {
                    class_3222 player = (class_3222)class_12972;
                    TFAdvancements.KILL_ALL_PHANTOMS.trigger(player);
                }
                LandmarkUtil.markStructureConquered(this.method_37908(), this, TFStructures.KNIGHT_STRONGHOLD, true);
                for (class_3222 player : this.hurtBy) {
                    TFAdvancements.HURT_BOSS.trigger(player, (class_1297)this);
                }
                for (class_3222 player : this.method_37908().method_18467(class_3222.class, new class_238(treasurePos).method_1014(64.0))) {
                    TFAdvancements.HURT_BOSS.trigger(player, (class_1297)this);
                }
            }
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_3222 player;
        class_1297 class_12972;
        if (this.method_6061(source)) {
            this.method_5783(class_3417.field_15150, 1.0f, 0.8f + this.method_37908().method_8409().method_43057() * 0.4f);
        }
        if ((class_12972 = source.method_5529()) instanceof class_3222 && !this.hurtBy.contains(player = (class_3222)class_12972)) {
            this.hurtBy.add(player);
        }
        return super.method_5643(source, amount);
    }

    public void method_5730() {
        if (!this.method_5753()) {
            this.method_5639(5);
            if (this.method_5643(this.method_48923().method_48817(), 4.0f)) {
                this.method_5783(class_3417.field_14821, 0.4f, 2.0f + this.field_5974.method_43057() * 0.4f);
                EntityUtil.killLavaAround((class_1297)this);
            }
        }
    }

    public boolean method_6121(class_1297 entity) {
        return EntityUtil.properlyApplyCustomDamageSource((class_1308)this, entity, TFDamageTypes.getEntityDamageSource(this.method_37908(), TFDamageTypes.HAUNT, (class_1297)this, new class_1299[0]));
    }

    public boolean method_5810() {
        return true;
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }

    public void method_6005(double damage, double xRatio, double zRatio) {
        this.field_6007 = true;
        float f = class_3532.method_15355((float)((float)(xRatio * xRatio + zRatio * zRatio)));
        float distance = 0.2f;
        this.method_18799(new class_243(this.method_18798().method_10216() / 2.0, this.method_18798().method_10214() / 2.0, this.method_18798().method_10215() / 2.0));
        this.method_18799(new class_243(this.method_18798().method_10216() - xRatio / (double)f * (double)distance, this.method_18798().method_10214() + (double)distance, this.method_18798().method_10215() - zRatio / (double)f * (double)distance));
        if (this.method_18798().method_10214() > 0.4) {
            this.method_18800(this.method_18798().method_10216(), 0.4, this.method_18798().method_10215());
        }
    }

    public List<KnightPhantom> getNearbyKnights() {
        return this.method_37908().method_8390(KnightPhantom.class, this.method_5829().method_1014(64.0), class_1309::method_5805);
    }

    private void updateMyNumber() {
        ArrayList nums = Lists.newArrayList();
        List<KnightPhantom> knights = this.getNearbyKnights();
        for (KnightPhantom knight : knights) {
            if (knight == this || !knight.method_5805()) continue;
            nums.add(knight.getNumber());
            if (knight.getNumber() != 0) continue;
            this.setRestrictionPoint(knight.getRestrictionPoint());
        }
        if (nums.isEmpty()) {
            this.setNumber(0);
            return;
        }
        int[] n = Ints.toArray((Collection)nums);
        Arrays.sort(n);
        int smallest = n[0];
        int largest = knights.size() + 1;
        int smallestUnused = largest + 1;
        if (smallest > 0) {
            smallestUnused = 0;
        } else {
            for (int i = 1; i < largest; ++i) {
                if (Arrays.binarySearch(n, i) >= 0) continue;
                smallestUnused = i;
                break;
            }
        }
        if (this.totalKnownKnights < largest) {
            this.totalKnownKnights = largest;
        }
        if (this.number > smallestUnused || nums.contains(this.number)) {
            this.setNumber(smallestUnused);
        }
    }

    public boolean isChargingAtPlayer() {
        return (Boolean)this.method_5841().method_12789(FLAG_CHARGING);
    }

    private void setChargingAtPlayer(boolean flag) {
        this.method_5841().method_12778(FLAG_CHARGING, (Object)flag);
        if (!this.method_37908().method_8608()) {
            if (flag) {
                if (!this.method_5996(class_5134.field_23721).method_6196(CHARGING_MODIFIER)) {
                    this.method_5996(class_5134.field_23721).method_26835(CHARGING_MODIFIER);
                }
                if (this.method_5996(class_5134.field_23724).method_6196(NON_CHARGING_ARMOR_MODIFIER)) {
                    this.method_5996(class_5134.field_23724).method_6202(NON_CHARGING_ARMOR_MODIFIER);
                }
            } else {
                this.method_5996(class_5134.field_23721).method_6202(CHARGING_MODIFIER);
                if (!this.method_5996(class_5134.field_23724).method_6196(NON_CHARGING_ARMOR_MODIFIER)) {
                    this.method_5996(class_5134.field_23724).method_26835(NON_CHARGING_ARMOR_MODIFIER);
                }
            }
        }
    }

    public void method_5674(class_2940<?> accessor) {
        if (FLAG_CHARGING.equals(accessor)) {
            this.method_18382();
        }
        super.method_5674(accessor);
    }

    public class_4048 method_18377(class_4050 pose) {
        return this.isChargingAtPlayer() ? this.visibleSize : this.invisibleSize;
    }

    protected class_3414 method_5994() {
        return (class_3414)TFSounds.KNIGHT_PHANTOM_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)TFSounds.KNIGHT_PHANTOM_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)TFSounds.KNIGHT_PHANTOM_DEATH.get();
    }

    private void switchToFormationByNumber(int formationNumber) {
        this.currentFormation = Formation.values()[formationNumber];
        this.ticksProgress = 0;
    }

    public void switchToFormation(Formation formation) {
        this.currentFormation = formation;
        this.ticksProgress = 0;
        this.updateMyNumber();
        this.setChargingAtPlayer(this.currentFormation == Formation.ATTACK_PLAYER_START || this.currentFormation == Formation.ATTACK_PLAYER_ATTACK);
    }

    private int getFormationAsNumber() {
        return this.currentFormation.ordinal();
    }

    public int getTicksProgress() {
        return this.ticksProgress;
    }

    public void setTicksProgress(int ticksProgress) {
        this.ticksProgress = ticksProgress;
    }

    public int getMaxTicksForFormation() {
        return this.currentFormation.duration;
    }

    public boolean isSwordKnight() {
        return this.method_6047().method_31574((class_1792)TFItems.KNIGHTMETAL_SWORD.get());
    }

    public boolean isAxeKnight() {
        return this.method_6047().method_31574((class_1792)TFItems.KNIGHTMETAL_AXE.get());
    }

    public boolean isPickKnight() {
        return this.method_6047().method_31574((class_1792)TFItems.KNIGHTMETAL_PICKAXE.get());
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
        if (number == 0) {
            this.method_37908().method_18467(class_3222.class, this.method_5829().method_1014(64.0)).forEach(this::method_5837);
        }
        switch (number % 3) {
            case 0: {
                this.method_5673(class_1304.field_6173, new class_1799((class_1935)TFItems.KNIGHTMETAL_SWORD.get()));
                break;
            }
            case 1: {
                this.method_5673(class_1304.field_6173, new class_1799((class_1935)TFItems.KNIGHTMETAL_AXE.get()));
                break;
            }
            case 2: {
                this.method_5673(class_1304.field_6173, new class_1799((class_1935)TFItems.KNIGHTMETAL_PICKAXE.get()));
            }
        }
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        this.saveHomePointToNbt(compound);
        compound.method_10569("MyNumber", this.getNumber());
        compound.method_10569("Formation", this.getFormationAsNumber());
        compound.method_10569("TicksProgress", this.getTicksProgress());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.loadHomePointFromNbt(compound);
        this.setNumber(compound.method_10550("MyNumber"));
        this.switchToFormationByNumber(compound.method_10550("Formation"));
        this.setTicksProgress(compound.method_10550("TicksProgress"));
        if (this.method_16914()) {
            this.bossInfo.method_5413(this.method_5476());
        }
    }

    @Override
    @Nullable
    public class_4208 getRestrictionPoint() {
        return ((Optional)this.method_5841().method_12789(HOME_POINT)).orElse(null);
    }

    @Override
    public void setRestrictionPoint(@Nullable class_4208 pos) {
        this.method_5841().method_12778(HOME_POINT, Optional.ofNullable(pos));
        if (pos != null) {
            this.chargePos = pos.method_19446();
        }
    }

    @Override
    public int getHomeRadius() {
        return 30;
    }

    protected boolean method_5860(class_1297 entityIn) {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    protected float method_6120() {
        return 1.0f;
    }

    public boolean method_5822() {
        return false;
    }

    public static enum Formation {
        HOVER(90),
        LARGE_CLOCKWISE(180),
        SMALL_CLOCKWISE(90),
        LARGE_ANTICLOCKWISE(180),
        SMALL_ANTICLOCKWISE(90),
        CHARGE_PLUSX(180),
        CHARGE_MINUSX(180),
        CHARGE_PLUSZ(180),
        CHARGE_MINUSZ(180),
        WAITING_FOR_LEADER(10),
        ATTACK_PLAYER_START(50),
        ATTACK_PLAYER_ATTACK(50);

        final int duration;

        private Formation(int duration) {
            this.duration = duration;
        }
    }
}

