/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import io.github.fabricators_of_create.porting_lib.block.EntityDestroyBlock;
import io.github.fabricators_of_create.porting_lib.entity.IEntityAdditionalSpawnData;
import io.github.fabricators_of_create.porting_lib.entity.PartEntity;
import net.minecraft.class_1268;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1657;
import net.minecraft.class_1682;
import net.minecraft.class_1687;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;
import twilightforest.entity.Chain;
import twilightforest.entity.monster.BlockChainGoblin;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFEnchantments;
import twilightforest.init.TFItems;
import twilightforest.init.TFSounds;
import twilightforest.util.WorldUtil;

public class ChainBlock
extends class_1682
implements IEntityAdditionalSpawnData {
    private static final int MAX_SMASH = 12;
    private static final int MAX_CHAIN = 16;
    private static final class_2940<Boolean> HAND = class_2945.method_12791(ChainBlock.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_FOIL = class_2945.method_12791(ChainBlock.class, (class_2941)class_2943.field_13323);
    private boolean isReturning = false;
    private boolean canSmashBlocks;
    private boolean hitEntity = false;
    private class_1799 stack;
    private int blocksSmashed = 0;
    private double velX;
    private double velY;
    private double velZ;
    public final Chain chain1;
    public final Chain chain2;
    public final Chain chain3;
    public final Chain chain4;
    public final Chain chain5;
    private final BlockChainGoblin.MultipartGenericsAreDumb[] partsArray;

    public ChainBlock(class_1299<? extends ChainBlock> type, class_1937 world) {
        super(type, world);
        this.chain1 = new Chain((class_1297)this);
        this.chain2 = new Chain((class_1297)this);
        this.chain3 = new Chain((class_1297)this);
        this.chain4 = new Chain((class_1297)this);
        this.chain5 = new Chain((class_1297)this);
        this.partsArray = new BlockChainGoblin.MultipartGenericsAreDumb[]{this.chain1, this.chain2, this.chain3, this.chain4, this.chain5};
    }

    public ChainBlock(class_1299<? extends ChainBlock> type, class_1937 world, class_1309 thrower, class_1268 hand, class_1799 stack) {
        super(type, thrower, world);
        this.isReturning = false;
        this.canSmashBlocks = class_1890.method_8225((class_1887)((class_1887)TFEnchantments.DESTRUCTION.get()), (class_1799)stack) > 0 && !thrower.method_6059(class_1294.field_5901);
        this.stack = stack;
        this.setHand(hand);
        this.chain1 = new Chain((class_1297)this);
        this.chain2 = new Chain((class_1297)this);
        this.chain3 = new Chain((class_1297)this);
        this.chain4 = new Chain((class_1297)this);
        this.chain5 = new Chain((class_1297)this);
        this.partsArray = new BlockChainGoblin.MultipartGenericsAreDumb[]{this.chain1, this.chain2, this.chain3, this.chain4, this.chain5};
        this.method_24919((class_1297)thrower, thrower.method_36455(), thrower.method_36454(), 0.0f, 1.5f, 1.0f);
        this.method_5841().method_12778(IS_FOIL, (Object)stack.method_7958());
    }

    private void setHand(class_1268 hand) {
        this.method_5841().method_12778(HAND, (Object)(hand == class_1268.field_5808 ? 1 : 0));
    }

    public class_1268 getHand() {
        return (Boolean)this.method_5841().method_12789(HAND) != false ? class_1268.field_5808 : class_1268.field_5810;
    }

    public boolean isFoil() {
        return (Boolean)this.method_5841().method_12789(IS_FOIL);
    }

    public boolean method_5822() {
        return false;
    }

    public void method_7485(double x, double y, double z, float speed, float accuracy) {
        super.method_7485(x, y, z, speed, accuracy);
        this.velX = this.method_18798().method_10216();
        this.velY = this.method_18798().method_10214();
        this.velZ = this.method_18798().method_10215();
    }

    protected float method_7490() {
        return 0.05f;
    }

    protected void method_7454(class_3966 result) {
        super.method_7454(result);
        if (!this.method_37908().method_8608() && result.method_17782() != this.method_24921()) {
            class_1657 player;
            class_1309 living;
            float damage = 0.0f;
            class_1297 class_12972 = result.method_17782();
            if (class_12972 instanceof class_1309) {
                living = (class_1309)class_12972;
                damage = 10.0f + class_1890.method_8218((class_1799)this.stack, (class_1310)living.method_6046());
            } else {
                PartEntity part;
                class_12972 = result.method_17782();
                if (class_12972 instanceof PartEntity && (class_12972 = (part = (PartEntity)class_12972).getParent()) instanceof class_1309) {
                    class_1309 living2 = (class_1309)class_12972;
                    damage = 10.0f + class_1890.method_8218((class_1799)this.stack, (class_1310)living2.method_6046());
                }
            }
            class_1297 class_12973 = result.method_17782();
            if (class_12973 instanceof class_1657 && (player = (class_1657)class_12973).method_6115() && player.method_6030().method_7909() instanceof class_1819) {
                player.method_6030().method_7956(5, (class_1309)player, event -> event.method_20236(player.method_6058()));
                player.method_7284(true);
            }
            if (damage > 0.0f && result.method_17782().method_5643(TFDamageTypes.getIndirectEntityDamageSource(this.method_37908(), TFDamageTypes.SPIKED, (class_1297)this, this.method_24921(), new class_1299[0]), damage)) {
                this.method_5783((class_3414)TFSounds.BLOCK_AND_CHAIN_HIT.get(), 1.0f, this.field_5974.method_43057());
                this.hitEntity = true;
                this.isReturning = true;
                this.field_6012 += 60;
                class_12973 = this.method_24921();
                if (class_12973 instanceof class_1309) {
                    living = (class_1309)class_12973;
                    this.stack.method_7956(1, living, user -> user.method_20236(this.getHand()));
                }
            }
        }
    }

    protected void method_24920(class_3965 result) {
        super.method_24920(result);
        if (!this.method_37908().method_8608() && !this.method_37908().method_22347(result.method_17777())) {
            if (!this.stack.method_7951(this.method_37908().method_8320(result.method_17777()))) {
                if (!this.isReturning && !this.hitEntity) {
                    this.method_5783((class_3414)TFSounds.BLOCK_AND_CHAIN_COLLIDE.get(), 0.125f, this.field_5974.method_43057());
                    this.method_32876(class_5712.field_28159);
                }
                this.isReturning = true;
                double bounce = 0.6;
                this.velX *= bounce;
                this.velY *= bounce;
                this.velZ *= bounce;
                switch (result.method_17780()) {
                    case field_11033: {
                        if (!(this.velY > 0.0)) break;
                        this.velY *= -bounce;
                        break;
                    }
                    case field_11036: {
                        if (!(this.velY < 0.0)) break;
                        this.velY *= -bounce;
                        break;
                    }
                    case field_11043: {
                        if (!(this.velZ > 0.0)) break;
                        this.velZ *= -bounce;
                        break;
                    }
                    case field_11035: {
                        if (!(this.velZ < 0.0)) break;
                        this.velZ *= -bounce;
                        break;
                    }
                    case field_11039: {
                        if (!(this.velX > 0.0)) break;
                        this.velX *= -bounce;
                        break;
                    }
                    case field_11034: {
                        if (!(this.velX < 0.0)) break;
                        this.velX *= -bounce;
                    }
                }
            }
            if (this.canSmashBlocks) {
                class_238 aabb = this.method_5829().method_1014(0.25);
                this.affectBlocksInAABB(aabb.method_997(result.method_17784().method_1020(aabb.method_1005()).method_1031(-0.5, 0.0, 0.0)));
            }
        }
        if (this.blocksSmashed > 12) {
            this.isReturning = true;
            if (this.field_6012 < 60) {
                this.field_6012 += 60;
            }
        }
    }

    protected boolean canEntityDestroy(class_2248 block, class_2680 state, class_1922 level, class_2338 pos, class_1297 entity) {
        if (block instanceof EntityDestroyBlock) {
            EntityDestroyBlock destroyBlock = (EntityDestroyBlock)block;
            return destroyBlock.canEntityDestroy(state, level, pos, entity);
        }
        if (entity instanceof class_1510) {
            return !state.method_26164(class_3481.field_17753);
        }
        if (!(entity instanceof class_1528) && !(entity instanceof class_1687)) {
            return true;
        }
        return state.method_26215() || class_1528.method_6883((class_2680)state);
    }

    private void affectBlocksInAABB(class_238 box) {
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            boolean creative = player.method_31549().field_7477;
            for (class_2338 pos : WorldUtil.getAllInBB(box)) {
                class_2680 state = this.method_37908().method_8320(pos);
                class_2248 block = state.method_26204();
                if (state.method_26215() || !this.stack.method_7951(state) || !this.canEntityDestroy(block, state, (class_1922)this.method_37908(), pos, (class_1297)this)) continue;
                this.method_37908().method_22352(pos, false);
                if (!creative) {
                    block.method_9556(this.method_37908(), player, pos, state, this.method_37908().method_8321(pos), player.method_5998(this.getHand()));
                }
                ++this.blocksSmashed;
                if (this.blocksSmashed <= 12) continue;
                break;
            }
        }
    }

    public boolean canDestroy(class_2680 state, class_1922 level, class_2338 pos, class_1297 entity) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof EntityDestroyBlock) {
            EntityDestroyBlock destroyBlock = (EntityDestroyBlock)class_22482;
            return destroyBlock.canEntityDestroy(state, level, pos, entity);
        }
        if (entity instanceof class_1510) {
            return !state.method_26204().method_9564().method_26164(class_3481.field_17753);
        }
        if (entity instanceof class_1528 || entity instanceof class_1687) {
            return state.method_26215() || class_1528.method_6883((class_2680)state);
        }
        return true;
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.chain1.method_5773();
            this.chain2.method_5773();
            this.chain3.method_5773();
            this.chain4.method_5773();
            this.chain5.method_5773();
            if (this.method_24921() != null) {
                class_243 handVec = this.method_24921().method_5720().method_1024(this.getHand() == class_1268.field_5808 ? -0.4f : 0.4f);
                double sx = this.method_24921().method_23317() + handVec.method_10216();
                double sy = this.method_24921().method_23318() + handVec.method_10214() - (double)0.4f + (double)this.method_24921().method_5751();
                double sz = this.method_24921().method_23321() + handVec.method_10215();
                double ox = sx - this.method_23317();
                double oy = sy - this.method_23318() - 0.25;
                double oz = sz - this.method_23321();
                this.chain1.method_5814(sx - ox * 0.05, sy - oy * 0.05, sz - oz * 0.05);
                this.chain2.method_5814(sx - ox * 0.25, sy - oy * 0.25, sz - oz * 0.25);
                this.chain3.method_5814(sx - ox * 0.45, sy - oy * 0.45, sz - oz * 0.45);
                this.chain4.method_5814(sx - ox * 0.65, sy - oy * 0.65, sz - oz * 0.65);
                this.chain5.method_5814(sx - ox * 0.85, sy - oy * 0.85, sz - oz * 0.85);
            }
        } else if (this.method_24921() == null) {
            this.method_31472();
        } else {
            double distToPlayer = this.method_5739(this.method_24921());
            if (!this.isReturning && distToPlayer > 16.0) {
                this.isReturning = true;
            }
            if (this.isReturning) {
                if (distToPlayer < 2.0) {
                    class_1297 sy = this.method_24921();
                    if (sy instanceof class_1309) {
                        class_1309 living = (class_1309)sy;
                        if (this.blocksSmashed > 0) {
                            this.stack.method_7956(Math.min(this.blocksSmashed, 3), living, user -> user.method_20236(this.getHand()));
                        }
                    }
                    this.method_31472();
                }
                class_1309 returnTo = (class_1309)this.method_24921();
                class_243 back = new class_243(returnTo.method_23317(), returnTo.method_23318() + (double)returnTo.method_5751(), returnTo.method_23321()).method_1020(this.method_19538()).method_1029();
                float age = Math.min((float)this.field_6012 * 0.03f, 1.0f);
                this.method_18799(new class_243(this.velX * (1.0 - (double)age) + back.method_10216() * 2.0 * (double)age, this.velY * (1.0 - (double)age) + back.method_10214() * 2.0 * (double)age - (double)this.method_7490(), this.velZ * (1.0 - (double)age) + back.method_10215() * 2.0 * (double)age));
            }
        }
    }

    protected void method_5693() {
        this.method_5841().method_12784(HAND, (Object)true);
        this.method_5841().method_12784(IS_FOIL, (Object)false);
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        class_1309 thrower = (class_1309)this.method_24921();
        if (thrower != null && thrower.method_6030().method_31574((class_1792)TFItems.BLOCK_AND_CHAIN.get())) {
            thrower.method_6021();
        }
    }

    protected void method_5749(class_2487 pCompound) {
        super.method_5749(pCompound);
        if (pCompound.method_10573("BlockAndChainStack", 10)) {
            this.stack = class_1799.method_7915((class_2487)pCompound.method_10562("BlockAndChainStack"));
        }
    }

    protected void method_5652(class_2487 pCompound) {
        super.method_5652(pCompound);
        pCompound.method_10566("BlockAndChainStack", (class_2520)this.stack.method_7953(new class_2487()));
    }

    public void writeSpawnData(class_2540 buffer) {
        buffer.writeInt(this.method_24921() != null ? this.method_24921().method_5628() : -1);
        buffer.writeBoolean(this.getHand() == class_1268.field_5808);
    }

    public void readSpawnData(class_2540 buf) {
        class_1297 e = this.method_37908().method_8469(buf.readInt());
        if (e instanceof class_1309) {
            this.method_7432(e);
        }
        this.setHand(buf.readBoolean() ? class_1268.field_5808 : class_1268.field_5810);
    }
}

