/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom.stalactites.entry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5819;
import twilightforest.TwilightForestMod;
import twilightforest.data.custom.stalactites.entry.Stalactite;
import twilightforest.world.components.feature.BlockSpikeFeature;

public class StalactiteReloadListener
extends class_4309
implements IdentifiableResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(Stalactite.class, (Object)new Stalactite.Serializer()).create();
    private final Map<class_2960, Stalactite> smallStalactites = new HashMap<class_2960, Stalactite>();
    private final Map<class_2960, Stalactite> mediumStalactites = new HashMap<class_2960, Stalactite>();
    private final Map<class_2960, Stalactite> largeStalactites = new HashMap<class_2960, Stalactite>();

    public StalactiteReloadListener() {
        super(GSON, "stalactites");
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        block12: for (Stalactite.HollowHillType type : Stalactite.HollowHillType.values()) {
            class_2960 resourcelocation = new class_2960("twilightforest", "stalactites/" + type.name().toLowerCase(Locale.ROOT) + "_hollow_hill.json");
            ArrayList<class_2960> finalLocations = new ArrayList<class_2960>();
            Map<class_2960, Stalactite> mapToUse = type == Stalactite.HollowHillType.LARGE ? this.largeStalactites : (type == Stalactite.HollowHillType.MEDIUM ? this.mediumStalactites : this.smallStalactites);
            for (class_3298 resource : resourceManager.method_14489(resourcelocation)) {
                try (InputStream inputstream = resource.method_14482();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                    JsonObject jsonobject = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
                    boolean replace = jsonobject.get("replace").getAsBoolean();
                    if (replace) {
                        finalLocations.clear();
                    }
                    JsonArray entryList = jsonobject.get("stalactites").getAsJsonArray();
                    for (JsonElement entry : entryList) {
                        class_2960 loc = new class_2960(entry.getAsString().replace(":", ":entries/"));
                        finalLocations.remove(loc);
                        finalLocations.add(loc);
                    }
                }
                catch (IOException | RuntimeException ioexception) {
                    TwilightForestMod.LOGGER.error("Couldn't read Hollow Hill list {} in data pack {}", (Object)resourcelocation, (Object)resource.method_14480(), (Object)ioexception);
                }
                if (finalLocations.isEmpty()) {
                    TwilightForestMod.LOGGER.warn("Hollow Hill list {} was empty, adding default stone entry so things don't break!", (Object)resourcelocation);
                    mapToUse.put(new class_2960("twilightforest", "default_fallback_stone"), BlockSpikeFeature.STONE_STALACTITE);
                    continue block12;
                }
                for (class_2960 location : finalLocations) {
                    JsonElement json = object.get(location);
                    mapToUse.put(location, (Stalactite)GSON.fromJson(json, Stalactite.class));
                }
            }
        }
        TwilightForestMod.LOGGER.info("Loaded {} Stalactite configs!", (Object)this.getLargeStalactites().size());
    }

    public static JsonElement serialize(Stalactite stalactite) {
        return GSON.toJsonTree((Object)stalactite);
    }

    public Map<class_2960, Stalactite> getLargeStalactites() {
        Map<class_2960, Stalactite> finalMap = this.largeStalactites;
        finalMap.putAll(this.getMediumStalactites());
        return finalMap;
    }

    public Map<class_2960, Stalactite> getMediumStalactites() {
        Map<class_2960, Stalactite> finalMap = this.mediumStalactites;
        finalMap.putAll(this.getSmallStalactites());
        return finalMap;
    }

    public Map<class_2960, Stalactite> getSmallStalactites() {
        return this.smallStalactites;
    }

    public Stalactite getRandomStalactiteFromList(class_5819 random, Map<class_2960, Stalactite> map) {
        Stalactite[] list = map.values().toArray(new Stalactite[0]);
        return list[random.method_43048(list.length)];
    }

    public class_2960 getFabricId() {
        return TwilightForestMod.prefix("stalactites");
    }
}

