/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;

public class OverlayedItemHandler {
    private final OverlayedItemHandlerSlot[] originalSlots;
    private final OverlayedItemHandlerSlot[] slots;
    private final IItemTransfer overlayedHandler;

    public OverlayedItemHandler(@Nonnull IItemTransfer toOverlay) {
        this.slots = new OverlayedItemHandlerSlot[toOverlay.getSlots()];
        this.originalSlots = new OverlayedItemHandlerSlot[toOverlay.getSlots()];
        this.overlayedHandler = toOverlay;
    }

    public void reset() {
        for (int i = 0; i < this.originalSlots.length; ++i) {
            if (this.originalSlots[i] == null) continue;
            this.slots[i] = this.originalSlots[i].copy();
        }
    }

    public int getSlots() {
        return this.overlayedHandler.getSlots();
    }

    private void initSlot(int slot) {
        if (this.originalSlots[slot] == null) {
            class_1799 stackToMirror = this.overlayedHandler.getStackInSlot(slot);
            int slotLimit = this.overlayedHandler.getSlotLimit(slot);
            this.originalSlots[slot] = new OverlayedItemHandlerSlot(stackToMirror, slotLimit);
            this.slots[slot] = new OverlayedItemHandlerSlot(stackToMirror, slotLimit);
        }
    }

    public int insertStackedItemStack(@Nonnull class_1799 stack, int amountToInsert) {
        int insertedAmount;
        int canInsertUpTo;
        int lastKnownPopulatedSlot = 0;
        int i = 0;
        while (i < this.slots.length) {
            this.initSlot(i);
            class_1799 slotKey = this.slots[i].getItemStack();
            if ((slotKey.method_7960() || ItemStackHashStrategy.comparingAllButCount().equals(slotKey, stack)) && (canInsertUpTo = this.slots[i].getSlotLimit() - this.slots[i].getCount()) > 0) {
                insertedAmount = Math.min(canInsertUpTo, amountToInsert);
                this.slots[i].setItemStack(stack.method_7972());
                this.slots[i].setCount(this.slots[i].getCount() + insertedAmount);
                amountToInsert -= insertedAmount;
            }
            lastKnownPopulatedSlot = i++;
            if (amountToInsert != 0) continue;
            return 0;
        }
        if (amountToInsert > 0) {
            for (i = lastKnownPopulatedSlot + 1; i < this.slots.length; ++i) {
                OverlayedItemHandlerSlot slot = this.slots[i];
                if (!slot.getItemStack().method_7960()) continue;
                canInsertUpTo = Math.min(stack.method_7914(), slot.getSlotLimit());
                if (canInsertUpTo > 0) {
                    insertedAmount = Math.min(canInsertUpTo, amountToInsert);
                    slot.setItemStack(stack.method_7972());
                    slot.setCount(insertedAmount);
                    amountToInsert -= insertedAmount;
                }
                if (amountToInsert != 0) continue;
                return 0;
            }
        }
        return amountToInsert;
    }

    private static class OverlayedItemHandlerSlot {
        private class_1799 itemStack = class_1799.field_8037;
        private int count = 0;
        private int slotLimit;

        protected OverlayedItemHandlerSlot(@Nonnull class_1799 stackToMirror, int slotLimit) {
            if (!stackToMirror.method_7960()) {
                this.itemStack = stackToMirror.method_7972();
                this.count = stackToMirror.method_7947();
                this.slotLimit = Math.min(this.itemStack.method_7914(), slotLimit);
            } else {
                this.slotLimit = slotLimit;
            }
        }

        protected OverlayedItemHandlerSlot(@Nonnull class_1799 itemStack, int slotLimit, int count) {
            this.itemStack = itemStack;
            this.count = count;
            this.slotLimit = slotLimit;
        }

        public int getSlotLimit() {
            return this.slotLimit;
        }

        public int getCount() {
            return this.count;
        }

        @Nonnull
        public class_1799 getItemStack() {
            return this.itemStack;
        }

        public void setItemStack(@Nonnull class_1799 itemStack) {
            if (!ItemStackHashStrategy.comparingAllButCount().equals(this.itemStack, itemStack)) {
                this.itemStack = itemStack;
                this.slotLimit = Math.min(itemStack.method_7914(), this.slotLimit);
            }
        }

        public void setCount(int count) {
            this.count = count;
        }

        @Nonnull
        OverlayedItemHandlerSlot copy() {
            return new OverlayedItemHandlerSlot(this.itemStack, this.slotLimit, this.count);
        }
    }
}

