/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.utils.CycleItemStackHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;

public class GTOreProcessingWidget
extends WidgetGroup {
    public GTOreProcessingWidget(Material material) {
        super(0, 0, 186, 174);
        this.setClientSideWidget();
        ArrayList<List<class_1799>> mainproducts = new ArrayList<List<class_1799>>();
        ArrayList<List<class_1799>> byproducts = new ArrayList<List<class_1799>>();
        ArrayList<List<class_1799>> machines = new ArrayList<List<class_1799>>();
        ArrayList<Content> chanceContent = new ArrayList<Content>();
        OreProperty prop = material.getProperty(PropertyKey.ORE);
        this.addItemSlots(mainproducts, byproducts, material, prop, chanceContent);
        this.addMachineSlots(machines);
        this.setupGui(mainproducts, byproducts, machines, material, prop, chanceContent);
    }

    private void setupGui(List<List<class_1799>> mainproducts, List<List<class_1799>> byproducts, List<List<class_1799>> machines, Material material, OreProperty prop, List<Content> chanceContent) {
        this.setupBaseGui(mainproducts, byproducts, machines, chanceContent);
        if (!material.hasProperty(PropertyKey.BLAST)) {
            this.setupSmeltGui(mainproducts, machines);
        }
        if (prop.getWashedIn().getLeft() != null) {
            this.setupChemGui(mainproducts, byproducts, machines, prop, chanceContent);
        }
        if (prop.getSeparatedInto() != null && !prop.getSeparatedInto().isEmpty()) {
            this.setupSepGui(mainproducts, byproducts, machines, chanceContent);
        }
        if (material.hasProperty(PropertyKey.GEM)) {
            this.setupSiftGui(mainproducts, byproducts, machines, chanceContent);
        }
    }

    private void setupBaseGui(List<List<class_1799>> mainproducts, List<List<class_1799>> byproducts, List<List<class_1799>> machines, List<Content> chanceContent) {
        this.addWidget((Widget)new ImageWidget(0, 0, 186, 174, (IGuiTexture)GuiTextures.OREBY_BASE));
        this.setupBaseGuiItems(mainproducts, byproducts, chanceContent);
        this.setupBaseGuiMachines(machines);
    }

    private void setupBaseGuiMachines(List<List<class_1799>> machines) {
        SlotWidget maceratorSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 1, 3, 25, false, false);
        maceratorSlot.setBackgroundTexture(null);
        maceratorSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)maceratorSlot);
        SlotWidget maceratorSlot2 = new SlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 1, 23, 70, false, false);
        maceratorSlot2.setBackgroundTexture(null);
        maceratorSlot2.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)maceratorSlot2);
        SlotWidget maceratorSlot3 = new SlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 1, 114, 47, false, false);
        maceratorSlot3.setBackgroundTexture(null);
        maceratorSlot3.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)maceratorSlot3);
        SlotWidget maceratorSlot4 = new SlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 1, 70, 80, false, false);
        maceratorSlot4.setBackgroundTexture(null);
        maceratorSlot4.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)maceratorSlot4);
        SlotWidget washerSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 2, 25, 25, false, false);
        washerSlot.setBackgroundTexture(null);
        washerSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)washerSlot);
        TankWidget waterSlot = new TankWidget((IFluidStorage)new FluidStorage(GTMaterials.Water.getFluid(1000L)), 42, 25, false, false);
        waterSlot.initTemplate();
        waterSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)waterSlot);
        SlotWidget centrifugeSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 4, 51, 80, false, false);
        centrifugeSlot.setBackgroundTexture(null);
        centrifugeSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)centrifugeSlot);
        SlotWidget centrifugeSlot2 = new SlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 4, 133, 70, false, false);
        centrifugeSlot2.setBackgroundTexture(null);
        centrifugeSlot2.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)centrifugeSlot2);
        SlotWidget thermalCentrifugeSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 5, 97, 70, false, false);
        thermalCentrifugeSlot.setBackgroundTexture(null);
        thermalCentrifugeSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)thermalCentrifugeSlot);
        SlotWidget cauldronWasherSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 8, 4, 124, false, false);
        cauldronWasherSlot.setBackgroundTexture(null);
        cauldronWasherSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)cauldronWasherSlot);
        SlotWidget cauldronWasherSlot2 = new SlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 8, 42, 144, false, false);
        cauldronWasherSlot2.setBackgroundTexture(null);
        cauldronWasherSlot2.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)cauldronWasherSlot2);
        SlotWidget cauldronWasherSlot3 = new SlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 8, 103, 144, false, false);
        cauldronWasherSlot3.setBackgroundTexture(null);
        cauldronWasherSlot3.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)cauldronWasherSlot3);
    }

    private void setupBaseGuiItems(List<List<class_1799>> mainproducts, List<List<class_1799>> byproducts, List<Content> chanceContent) {
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 0, 3, 3, false, false).setIngredientIO(IngredientIO.INPUT));
        SlotWidget crushedSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 2, 3, 47, false, false);
        crushedSlot.setIngredientIO(IngredientIO.BOTH);
        this.addWidget((Widget)crushedSlot);
        SlotWidget crushedOreBPSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 0, 3, 65, false, false);
        crushedOreBPSlot.setXEIChance(chanceContent.get((int)1).chance);
        crushedOreBPSlot.setOverlay(chanceContent.get(1).createOverlay(false));
        crushedOreBPSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(14.0f)) + "%"}));
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", 8.5) + "%"}));
        });
        crushedOreBPSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)crushedOreBPSlot);
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 3, 64, 25, false, false).setIngredientIO(IngredientIO.BOTH));
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 1, 82, 25, false, false).setIngredientIO(IngredientIO.OUTPUT));
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 5, 23, 92, false, false).setIngredientIO(IngredientIO.BOTH));
        SlotWidget crushingCrushedOreBPSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 0, 23, 110, false, false);
        crushingCrushedOreBPSlot.setXEIChance(chanceContent.get((int)2).chance);
        crushingCrushedOreBPSlot.setOverlay(chanceContent.get(2).createOverlay(false));
        crushingCrushedOreBPSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(14.0f)) + "%"}));
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", 8.5) + "%"}));
        });
        crushingCrushedOreBPSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)crushingCrushedOreBPSlot);
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 7, 51, 101, false, false).setIngredientIO(IngredientIO.BOTH));
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 5, 51, 119, false, false).setIngredientIO(IngredientIO.OUTPUT));
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 6, 137, 47, false, false).setIngredientIO(IngredientIO.BOTH));
        SlotWidget crushingWashedOreBPSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 3, 155, 47, false, false);
        crushingWashedOreBPSlot.setXEIChance(chanceContent.get((int)3).chance);
        crushingWashedOreBPSlot.setOverlay(chanceContent.get(3).createOverlay(false));
        crushingWashedOreBPSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(14.0f)) + "%"}));
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", 8.5) + "%"}));
        });
        crushingWashedOreBPSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)crushingWashedOreBPSlot);
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 7, 133, 92, false, false).setIngredientIO(IngredientIO.BOTH));
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 6, 133, 110, false, false).setIngredientIO(IngredientIO.OUTPUT));
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 7, 51, 101, false, false).setIngredientIO(IngredientIO.BOTH));
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 5, 51, 119, false, false).setIngredientIO(IngredientIO.OUTPUT));
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 4, 97, 92, false, false).setIngredientIO(IngredientIO.BOTH));
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 7, 97, 110, false, false).setIngredientIO(IngredientIO.OUTPUT));
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 7, 70, 101, false, false).setIngredientIO(IngredientIO.BOTH));
        SlotWidget crushingTCedOreBPSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 4, 70, 119, false, false);
        crushingTCedOreBPSlot.setXEIChance(chanceContent.get((int)4).chance);
        crushingTCedOreBPSlot.setOverlay(chanceContent.get(4).createOverlay(false));
        crushingTCedOreBPSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(14.0f)) + "%"}));
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", 8.5) + "%"}));
        });
        crushingTCedOreBPSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)crushingTCedOreBPSlot);
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 9, 3, 105, false, false).setIngredientIO(IngredientIO.INPUT));
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 3, 3, 145, false, false).setIngredientIO(IngredientIO.OUTPUT));
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 5, 23, 145, false, false).setIngredientIO(IngredientIO.INPUT));
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 7, 63, 145, false, false).setIngredientIO(IngredientIO.OUTPUT));
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 6, 84, 145, false, false).setIngredientIO(IngredientIO.INPUT));
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 7, 124, 145, false, false).setIngredientIO(IngredientIO.OUTPUT));
    }

    private void setupSmeltGui(List<List<class_1799>> mainproducts, List<List<class_1799>> machines) {
        this.addWidget((Widget)new ImageWidget(0, 0, 186, 174, (IGuiTexture)GuiTextures.OREBY_SMELT));
        this.setupSmeltGuiItems(mainproducts);
        this.setupSmeltGuiMachines(machines);
    }

    private void setupSmeltGuiMachines(List<List<class_1799>> machines) {
        SlotWidget furnaceSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 0, 23, 3, false, false);
        furnaceSlot.setBackgroundTexture(null).setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)furnaceSlot);
    }

    private void setupSmeltGuiItems(List<List<class_1799>> mainproducts) {
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 1, 46, 3, false, false).setIngredientIO(IngredientIO.OUTPUT));
    }

    private void setupChemGui(List<List<class_1799>> mainproducts, List<List<class_1799>> byproducts, List<List<class_1799>> machines, OreProperty prop, List<Content> chanceContent) {
        this.addWidget((Widget)new ImageWidget(0, 0, 186, 174, (IGuiTexture)GuiTextures.OREBY_CHEM));
        this.setupChemGuiItems(mainproducts, byproducts, chanceContent);
        this.setupChemGuiMachines(machines, prop);
    }

    private void setupChemGuiMachines(List<List<class_1799>> machines, OreProperty prop) {
        Pair<Material, Integer> reagent = prop.getWashedIn();
        SlotWidget chembathSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 3, 25, 48, false, false);
        chembathSlot.setBackgroundTexture(null);
        this.addWidget((Widget)chembathSlot);
        TankWidget washingReagentSlot = new TankWidget((IFluidStorage)new FluidStorage(((Material)reagent.getLeft()).getFluid(((Integer)reagent.getRight()).intValue())), 42, 48, false, false);
        washingReagentSlot.initTemplate();
        washingReagentSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)washingReagentSlot);
    }

    private void setupChemGuiItems(List<List<class_1799>> mainproducts, List<List<class_1799>> byproducts, List<Content> chanceContent) {
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 3, 64, 48, false, false).setIngredientIO(IngredientIO.OUTPUT));
        SlotWidget bathingCrushedOreBPSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 8, 82, 48);
        bathingCrushedOreBPSlot.setXEIChance(chanceContent.get((int)5).chance);
        bathingCrushedOreBPSlot.setOverlay(chanceContent.get(5).createOverlay(false));
        bathingCrushedOreBPSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(70.0f)) + "%"}));
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", 5.8) + "%"}));
        });
        bathingCrushedOreBPSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)bathingCrushedOreBPSlot);
    }

    private void setupSepGui(List<List<class_1799>> mainproducts, List<List<class_1799>> byproducts, List<List<class_1799>> machines, List<Content> chanceContent) {
        this.addWidget((Widget)new ImageWidget(0, 0, 186, 174, (IGuiTexture)GuiTextures.OREBY_SEP));
        this.setupSepGuiItems(mainproducts, byproducts, chanceContent);
        this.setupSepGuiMachines(machines);
    }

    private void setupSepGuiMachines(List<List<class_1799>> machines) {
        SlotWidget separatorSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 7, 155, 69, false, false);
        separatorSlot.setBackgroundTexture(null);
        separatorSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)separatorSlot);
    }

    private void setupSepGuiItems(List<List<class_1799>> mainproducts, List<List<class_1799>> byproducts, List<Content> chanceContent) {
        this.addWidget((Widget)new SlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 7, 155, 92, false, false).setIngredientIO(IngredientIO.INPUT));
        SlotWidget separatorBPSlot1 = new SlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 9, 155, 110, false, false);
        separatorBPSlot1.setXEIChance(chanceContent.get((int)6).chance);
        separatorBPSlot1.setOverlay(chanceContent.get(6).createOverlay(false));
        separatorBPSlot1.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(40.0f)) + "%"}));
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", 8.5) + "%"}));
        });
        separatorBPSlot1.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)separatorBPSlot1);
        SlotWidget separatorBPSlot2 = new SlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 10, 155, 128, false, false);
        separatorBPSlot2.setXEIChance(chanceContent.get((int)7).chance);
        separatorBPSlot2.setOverlay(chanceContent.get(7).createOverlay(false));
        separatorBPSlot2.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(20.0f)) + "%"}));
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", Float.valueOf(6.0f)) + "%"}));
        });
        separatorBPSlot2.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)separatorBPSlot2);
    }

    private void setupSiftGui(List<List<class_1799>> mainproducts, List<List<class_1799>> byproducts, List<List<class_1799>> machines, List<Content> chanceContent) {
        this.addWidget((Widget)new ImageWidget(0, 0, 186, 174, (IGuiTexture)GuiTextures.OREBY_SIFT));
        this.setupSiftGuiItems(mainproducts, byproducts, chanceContent);
        this.setupSiftGuiMachines(machines);
    }

    private void setupSiftGuiMachines(List<List<class_1799>> machines) {
        SlotWidget sifterSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 6, 101, 24, false, false);
        sifterSlot.setBackgroundTexture(null);
        sifterSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)sifterSlot);
    }

    private void setupSiftGuiItems(List<List<class_1799>> mainproducts, List<List<class_1799>> byproducts, List<Content> chanceContent) {
        SlotWidget exquisiteSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 11, 119, 3, false, false);
        exquisiteSlot.setXEIChance(chanceContent.get((int)8).chance);
        exquisiteSlot.setOverlay(chanceContent.get(8).createOverlay(false));
        exquisiteSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(3.0f)) + "%"}));
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", Float.valueOf(1.0f)) + "%"}));
        });
        exquisiteSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)exquisiteSlot);
        SlotWidget flawlessSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 12, 137, 3, false, false);
        flawlessSlot.setXEIChance(chanceContent.get((int)9).chance);
        flawlessSlot.setOverlay(chanceContent.get(9).createOverlay(false));
        flawlessSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(3.0f)) + "%"}));
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", Float.valueOf(1.0f)) + "%"}));
        });
        flawlessSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)flawlessSlot);
        SlotWidget gemSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 13, 155, 3, false, false);
        gemSlot.setXEIChance(chanceContent.get((int)10).chance);
        gemSlot.setOverlay(chanceContent.get(10).createOverlay(false));
        gemSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(3.0f)) + "%"}));
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", Float.valueOf(1.0f)) + "%"}));
        });
        gemSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)gemSlot);
        SlotWidget dustSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 6, 119, 21, false, false);
        dustSlot.setXEIChance(chanceContent.get((int)0).chance);
        dustSlot.setOverlay(chanceContent.get(0).createOverlay(false));
        dustSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(3.0f)) + "%"}));
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", Float.valueOf(1.0f)) + "%"}));
        });
        dustSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)dustSlot);
        SlotWidget flawedSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 14, 137, 21, false, false);
        flawlessSlot.setXEIChance(chanceContent.get((int)11).chance);
        flawlessSlot.setOverlay(chanceContent.get(11).createOverlay(false));
        flawedSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(3.0f)) + "%"}));
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", Float.valueOf(1.0f)) + "%"}));
        });
        flawedSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)flawedSlot);
        SlotWidget chippedSlot = new SlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 15, 155, 21, false, false);
        chippedSlot.setXEIChance(chanceContent.get((int)12).chance);
        chippedSlot.setOverlay(chanceContent.get(12).createOverlay(false));
        chippedSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(3.0f)) + "%"}));
            tooltips.add(class_2561.method_43469((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", Float.valueOf(1.0f)) + "%"}));
        });
        chippedSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)chippedSlot);
    }

    private void addMachineSlots(List<List<class_1799>> machines) {
        List<class_1799> furnaceSlot = Collections.singletonList(new class_1799((class_1935)class_2246.field_10181.method_8389()));
        machines.add(furnaceSlot);
        List<class_1799> maceratorSlot = Collections.singletonList(GTMachines.MACERATOR[1].asStack());
        machines.add(maceratorSlot);
        List<class_1799> washerSlot = Collections.singletonList(GTMachines.ORE_WASHER[1].asStack());
        machines.add(washerSlot);
        List<class_1799> bathSlot = Collections.singletonList(GTMachines.CHEMICAL_BATH[1].asStack());
        machines.add(bathSlot);
        List<class_1799> centrifugeSlot = Collections.singletonList(GTMachines.CENTRIFUGE[1].asStack());
        machines.add(centrifugeSlot);
        List<class_1799> thermalCentrifugeSlot = Collections.singletonList(GTMachines.THERMAL_CENTRIFUGE[1].asStack());
        machines.add(thermalCentrifugeSlot);
        List<class_1799> sifterSlot = Collections.singletonList(GTMachines.SIFTER[1].asStack());
        machines.add(sifterSlot);
        List<class_1799> separatorSlot = Collections.singletonList(GTMachines.ELECTROMAGNETIC_SEPARATOR[1].asStack());
        machines.add(separatorSlot);
        ArrayList<class_1799> cauldronWasherSlot = new ArrayList<class_1799>();
        cauldronWasherSlot.add(new class_1799((class_1935)class_1802.field_8638));
        cauldronWasherSlot.add(GTMachines.ORE_WASHER[1].asStack());
        machines.add(cauldronWasherSlot);
    }

    private void addItemSlots(List<List<class_1799>> mainproducts, List<List<class_1799>> byproducts, Material material, OreProperty prop, List<Content> chanceContent) {
        this.setupMainProducts(mainproducts, material, prop, chanceContent);
        this.setupByproducts(byproducts, material, prop, chanceContent);
    }

    private void setupMainProducts(List<List<class_1799>> mainproducts, Material material, OreProperty prop, List<Content> chanceContent) {
        List<Object> oreSlot = new ArrayList();
        for (class_6862<class_1792> tag : TagPrefix.ore.getItemTags(material)) {
            for (class_6880 itemHolder : class_7923.field_41178.method_40286(tag)) {
                oreSlot.add(new class_1799((class_1935)itemHolder.comp_349()));
            }
        }
        if (oreSlot.isEmpty()) {
            oreSlot = Collections.singletonList(ChemicalHelper.get(TagPrefix.ore, material));
        }
        mainproducts.add(oreSlot);
        Material smeltingResult = prop.getDirectSmeltResult() != null ? prop.getDirectSmeltResult() : material;
        ArrayList<class_1799> smeltSlot = new ArrayList<class_1799>();
        if (smeltingResult.hasProperty(PropertyKey.INGOT)) {
            smeltSlot.add(ChemicalHelper.get(TagPrefix.ingot, smeltingResult));
        } else if (smeltingResult.hasProperty(PropertyKey.GEM)) {
            smeltSlot.add(ChemicalHelper.get(TagPrefix.gem, smeltingResult));
        } else if (smeltingResult.hasProperty(PropertyKey.DUST)) {
            smeltSlot.add(ChemicalHelper.get(TagPrefix.dust, smeltingResult));
        } else {
            smeltSlot.add(new class_1799((class_1935)class_1802.field_8162));
        }
        mainproducts.add(smeltSlot);
        List<class_1799> crushedSlot = class_7923.field_41178.method_40260(ChemicalHelper.getTag(TagPrefix.crushed, material)).method_40239().map(class_6880::comp_349).map(item -> new class_1799((class_1935)item, 2 * prop.getOreMultiplier())).toList();
        mainproducts.add(crushedSlot);
        List<class_1799> crushedPurifiedSlot = class_7923.field_41178.method_40260(ChemicalHelper.getTag(TagPrefix.crushedPurified, material)).method_40239().map(class_6880::comp_349).map(class_1799::new).toList();
        mainproducts.add(crushedPurifiedSlot);
        List<class_1799> crushedRefinedSlot = class_7923.field_41178.method_40260(ChemicalHelper.getTag(TagPrefix.crushedRefined, material)).method_40239().map(class_6880::comp_349).map(class_1799::new).toList();
        mainproducts.add(crushedRefinedSlot);
        List<class_1799> dustImpureSlot = class_7923.field_41178.method_40260(ChemicalHelper.getTag(TagPrefix.dustImpure, material)).method_40239().map(class_6880::comp_349).map(class_1799::new).toList();
        mainproducts.add(dustImpureSlot);
        List<class_1799> dustPureSlot = class_7923.field_41178.method_40260(ChemicalHelper.getTag(TagPrefix.dustPure, material)).method_40239().map(class_6880::comp_349).map(class_1799::new).toList();
        mainproducts.add(dustPureSlot);
        List<class_1799> dustSlot = class_7923.field_41178.method_40260(ChemicalHelper.getTag(TagPrefix.dust, material)).method_40239().map(class_6880::comp_349).map(class_1799::new).toList();
        mainproducts.add(dustSlot);
        ArrayList<class_1799> gemSlot = new ArrayList<class_1799>();
        if (material.hasProperty(PropertyKey.GEM)) {
            gemSlot.add(ChemicalHelper.get(TagPrefix.gem, material));
        }
        mainproducts.add(gemSlot);
        chanceContent.add(new Content(gemSlot, 0.35f, 0.05f, null, null));
        List<class_1799> simpleCrushedSlot = class_7923.field_41178.method_40260(ChemicalHelper.getTag(TagPrefix.crushed, material)).method_40239().map(class_6880::comp_349).map(class_1799::new).toList();
        mainproducts.add(simpleCrushedSlot);
    }

    private void setupByproducts(List<List<class_1799>> byproducts, Material material, OreProperty prop, List<Content> chanceContent) {
        Material byproductMaterial1 = GTUtil.selectItemInList(0, material, prop.getOreByProducts(), Material.class);
        Material byproductMaterial2 = GTUtil.selectItemInList(1, material, prop.getOreByProducts(), Material.class);
        Material byproductMaterial3 = GTUtil.selectItemInList(3, material, prop.getOreByProducts(), Material.class);
        List<Material> separatedMaterial = prop.getSeparatedInto();
        class_1799 crushingOreByproductStack = ChemicalHelper.get(TagPrefix.gem, byproductMaterial1);
        if (crushingOreByproductStack.method_7960()) {
            crushingOreByproductStack = ChemicalHelper.get(TagPrefix.dust, byproductMaterial1);
        }
        List<class_1799> maceratorBPSlot1 = Collections.singletonList(crushingOreByproductStack);
        byproducts.add(maceratorBPSlot1);
        chanceContent.add(new Content(crushingOreByproductStack, 0.14f, 0.07f, null, null));
        List<class_1799> washerBPSlot = class_7923.field_41178.method_40260(ChemicalHelper.getTag(TagPrefix.dustTiny, byproductMaterial1)).method_40239().map(class_6880::comp_349).map(item -> new class_1799((class_1935)item, 3)).toList();
        byproducts.add(washerBPSlot);
        List<class_1799> maceratorBPSlot2 = class_7923.field_41178.method_40260(ChemicalHelper.getTag(TagPrefix.dust, byproductMaterial1)).method_40239().map(class_6880::comp_349).map(class_1799::new).toList();
        byproducts.add(maceratorBPSlot2);
        chanceContent.add(new Content(maceratorBPSlot2, 0.14f, 0.085f, null, null));
        List<class_1799> maceratorBPSlot3 = class_7923.field_41178.method_40260(ChemicalHelper.getTag(TagPrefix.dust, byproductMaterial2)).method_40239().map(class_6880::comp_349).map(class_1799::new).toList();
        byproducts.add(maceratorBPSlot3);
        chanceContent.add(new Content(maceratorBPSlot3, 0.14f, 0.085f, null, null));
        List<class_1799> maceratorBPSlot4 = class_7923.field_41178.method_40260(ChemicalHelper.getTag(TagPrefix.dust, byproductMaterial2)).method_40239().map(class_6880::comp_349).map(class_1799::new).toList();
        byproducts.add(maceratorBPSlot4);
        chanceContent.add(new Content(maceratorBPSlot4, 0.14f, 0.085f, null, null));
        List<class_1799> centrifugeBPSlot = class_7923.field_41178.method_40260(ChemicalHelper.getTag(TagPrefix.dustTiny, byproductMaterial1)).method_40239().map(class_6880::comp_349).map(class_1799::new).toList();
        byproducts.add(centrifugeBPSlot);
        List<class_1799> centrifugeBPSlot2 = class_7923.field_41178.method_40260(ChemicalHelper.getTag(TagPrefix.dustTiny, byproductMaterial2)).method_40239().map(class_6880::comp_349).map(class_1799::new).toList();
        byproducts.add(centrifugeBPSlot2);
        List<class_1799> tcBPSlot = class_7923.field_41178.method_40260(ChemicalHelper.getTag(TagPrefix.dustTiny, byproductMaterial2)).method_40239().map(class_6880::comp_349).map(item -> new class_1799((class_1935)item, 3)).toList();
        byproducts.add(tcBPSlot);
        List<class_1799> bathBPSlot = class_7923.field_41178.method_40260(ChemicalHelper.getTag(TagPrefix.dust, byproductMaterial3)).method_40239().map(class_6880::comp_349).map(class_1799::new).toList();
        byproducts.add(bathBPSlot);
        chanceContent.add(new Content(bathBPSlot, 0.7f, 0.58f, null, null));
        class_1799 separatedStack1 = new class_1799((class_1935)class_1802.field_8162);
        class_1799 separatedStack2 = new class_1799((class_1935)class_1802.field_8162);
        if (prop.getSeparatedInto() != null && !prop.getSeparatedInto().isEmpty()) {
            separatedStack1 = ChemicalHelper.get(TagPrefix.dustSmall, separatedMaterial.get(0));
            TagPrefix prefix = separatedMaterial.get(separatedMaterial.size() - 1).getBlastTemperature() == 0 && separatedMaterial.get(separatedMaterial.size() - 1).hasProperty(PropertyKey.INGOT) ? TagPrefix.nugget : TagPrefix.dustSmall;
            separatedStack2 = ChemicalHelper.get(prefix, separatedMaterial.get(separatedMaterial.size() - 1), prefix == TagPrefix.nugget ? 2 : 1);
        }
        List<class_1799> sepBPSlot1 = Collections.singletonList(separatedStack1);
        byproducts.add(sepBPSlot1);
        chanceContent.add(new Content(sepBPSlot1, 0.4f, 0.85f, null, null));
        List<class_1799> sepBPSlot2 = Collections.singletonList(separatedStack2);
        byproducts.add(sepBPSlot2);
        chanceContent.add(new Content(sepBPSlot2, 0.2f, 0.6f, null, null));
        if (material.hasProperty(PropertyKey.GEM)) {
            List<class_1799> siftBPSlot1 = class_7923.field_41178.method_40260(ChemicalHelper.getTag(TagPrefix.gemExquisite, material)).method_40239().map(class_6880::comp_349).map(class_1799::new).toList();
            List<class_1799> siftBPSlot2 = class_7923.field_41178.method_40260(ChemicalHelper.getTag(TagPrefix.gemFlawless, material)).method_40239().map(class_6880::comp_349).map(class_1799::new).toList();
            List<class_1799> siftBPSlot3 = class_7923.field_41178.method_40260(ChemicalHelper.getTag(TagPrefix.gem, material)).method_40239().map(class_6880::comp_349).map(class_1799::new).toList();
            List<class_1799> siftBPSlot4 = class_7923.field_41178.method_40260(ChemicalHelper.getTag(TagPrefix.gemFlawed, material)).method_40239().map(class_6880::comp_349).map(class_1799::new).toList();
            List<class_1799> siftBPSlot5 = class_7923.field_41178.method_40260(ChemicalHelper.getTag(TagPrefix.gemChipped, material)).method_40239().map(class_6880::comp_349).map(class_1799::new).toList();
            byproducts.add(siftBPSlot1);
            chanceContent.add(new Content(siftBPSlot1, 0.03f, 0.01f, null, null));
            byproducts.add(siftBPSlot2);
            chanceContent.add(new Content(siftBPSlot2, 0.1f, 0.015f, null, null));
            byproducts.add(siftBPSlot3);
            chanceContent.add(new Content(siftBPSlot3, 0.5f, 0.075f, null, null));
            byproducts.add(siftBPSlot4);
            chanceContent.add(new Content(siftBPSlot4, 0.25f, 0.03f, null, null));
            byproducts.add(siftBPSlot5);
            chanceContent.add(new Content(siftBPSlot5, 0.35f, 0.04f, null, null));
        }
    }
}

