/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IngotProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2444;

public class PolarizingRecipeHandler {
    private static final TagPrefix[] POLARIZING_PREFIXES = new TagPrefix[]{TagPrefix.rod, TagPrefix.rodLong, TagPrefix.plate, TagPrefix.ingot, TagPrefix.plateDense, TagPrefix.rotor, TagPrefix.bolt, TagPrefix.screw, TagPrefix.wireFine, TagPrefix.foil, TagPrefix.ring};

    public static void init(Consumer<class_2444> provider) {
        for (TagPrefix orePrefix : POLARIZING_PREFIXES) {
            orePrefix.executeHandler(PropertyKey.INGOT, (tagPrefix, material, property) -> PolarizingRecipeHandler.processPolarizing(tagPrefix, material, property, provider));
        }
    }

    public static void processPolarizing(TagPrefix polarizingPrefix, Material material, IngotProperty property, Consumer<class_2444> provider) {
        Material magneticMaterial = property.getMagneticMaterial();
        if (magneticMaterial != null && polarizingPrefix.doGenerateItem(magneticMaterial)) {
            class_1799 magneticStack = ChemicalHelper.get(polarizingPrefix, magneticMaterial);
            GTRecipeTypes.POLARIZER_RECIPES.recipeBuilder("polarize_" + material.getName() + "_" + polarizingPrefix.name, new Object[0]).inputItems(polarizingPrefix, material).outputItems(magneticStack).duration((int)((long)((int)material.getMass()) * polarizingPrefix.getMaterialAmount(material) / 3628800L)).EUt(8L * (long)PolarizingRecipeHandler.getVoltageMultiplier(material)).save(provider);
            VanillaRecipeHelper.addSmeltingRecipe(provider, "demagnetize_" + magneticMaterial.getName() + "_" + polarizingPrefix, ChemicalHelper.getTag(polarizingPrefix, magneticMaterial), ChemicalHelper.get(polarizingPrefix, material));
        }
    }

    private static int getVoltageMultiplier(Material material) {
        return material.getBlastTemperature() >= 1200 ? GTValues.VA[1] : 2;
    }
}

