/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.configurable;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2444;
import net.minecraft.class_3489;
import net.minecraft.class_6862;

public class RecipeAddition {
    public static void init(Consumer<class_2444> provider) {
        RecipeAddition.hardMiscRecipes(provider);
        RecipeAddition.hardRedstoneRecipes(provider);
        RecipeAddition.disableManualCompression(provider);
        RecipeAddition.hardToolArmorRecipes(provider);
        RecipeAddition.harderRods(provider);
        RecipeAddition.nerfWoodCrafting(provider);
        RecipeAddition.harderBrickRecipes(provider);
        RecipeAddition.steelSteamMultiblocks(provider);
        if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
            RecipeAddition.hardWoodRecipes(provider);
        }
        if (ConfigHolder.INSTANCE.recipes.hardIronRecipes) {
            RecipeAddition.hardIronRecipes(provider);
        }
        if (ConfigHolder.INSTANCE.recipes.hardGlassRecipes) {
            RecipeAddition.hardGlassRecipes(provider);
        }
        if (ConfigHolder.INSTANCE.recipes.nerfPaperCrafting) {
            RecipeAddition.nerfPaperCrafting(provider);
        }
        if (ConfigHolder.INSTANCE.recipes.hardAdvancedIronRecipes) {
            RecipeAddition.hardAdvancedIronRecipes(provider);
        }
        if (ConfigHolder.INSTANCE.recipes.hardDyeRecipes) {
            RecipeAddition.hardDyeRecipes(provider);
        }
        if (ConfigHolder.INSTANCE.recipes.harderCharcoalRecipe) {
            RecipeAddition.harderCharcoalRecipes(provider);
        }
        if (ConfigHolder.INSTANCE.recipes.flintAndSteelRequireSteel) {
            RecipeAddition.flintAndSteelRequireSteel(provider);
        }
        if (ConfigHolder.INSTANCE.recipes.removeVanillaBlockRecipes) {
            RecipeAddition.removeVanillaBlockRecipes(provider);
        }
    }

    private static void steelSteamMultiblocks(Consumer<class_2444> provider) {
        if (ConfigHolder.INSTANCE.machines.steelSteamMultiblocks) {
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_oven", GTMachines.STEAM_OVEN.asStack(), "CGC", "FMF", "CGC", Character.valueOf('F'), GTBlocks.FIREBOX_STEEL.asStack(), Character.valueOf('C'), GTBlocks.CASING_STEEL_SOLID.asStack(), Character.valueOf('M'), ((MachineDefinition)GTMachines.STEAM_FURNACE.right()).asStack(), Character.valueOf('G'), new UnificationEntry(TagPrefix.gear, GTMaterials.Invar));
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_grinder", GTMachines.STEAM_GRINDER.asStack(), "CGC", "CFC", "CGC", Character.valueOf('G'), new UnificationEntry(TagPrefix.gear, GTMaterials.Potin), Character.valueOf('F'), ((MachineDefinition)GTMachines.STEAM_MACERATOR.right()).asStack(), Character.valueOf('C'), GTBlocks.CASING_STEEL_SOLID.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_hatch", GTMachines.STEAM_HATCH.asStack(), "BPB", "BTB", "BPB", Character.valueOf('B'), new UnificationEntry(TagPrefix.plate, GTMaterials.Steel), Character.valueOf('P'), new UnificationEntry(TagPrefix.pipeNormalFluid, GTMaterials.Steel), Character.valueOf('T'), GTMachines.STEEL_DRUM.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_input_bus", GTMachines.STEAM_IMPORT_BUS.asStack(), "C", "H", Character.valueOf('H'), GTBlocks.STEEL_HULL.asStack(), Character.valueOf('C'), CustomTags.TAG_WOODEN_CHESTS);
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_output_bus", GTMachines.STEAM_EXPORT_BUS.asStack(), "H", "C", Character.valueOf('H'), GTBlocks.STEEL_HULL.asStack(), Character.valueOf('C'), CustomTags.TAG_WOODEN_CHESTS);
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_oven", GTMachines.STEAM_OVEN.asStack(), "CGC", "FMF", "CGC", Character.valueOf('F'), GTBlocks.FIREBOX_BRONZE.asStack(), Character.valueOf('C'), GTBlocks.CASING_BRONZE_BRICKS.asStack(), Character.valueOf('M'), ((MachineDefinition)GTMachines.STEAM_FURNACE.left()).asStack(), Character.valueOf('G'), new UnificationEntry(TagPrefix.gear, GTMaterials.Invar));
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_grinder", GTMachines.STEAM_GRINDER.asStack(), "CGC", "CFC", "CGC", Character.valueOf('G'), new UnificationEntry(TagPrefix.gear, GTMaterials.Potin), Character.valueOf('F'), ((MachineDefinition)GTMachines.STEAM_MACERATOR.left()).asStack(), Character.valueOf('C'), GTBlocks.CASING_BRONZE_BRICKS.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_hatch", GTMachines.STEAM_HATCH.asStack(), "BPB", "BTB", "BPB", Character.valueOf('B'), new UnificationEntry(TagPrefix.plate, GTMaterials.Bronze), Character.valueOf('P'), new UnificationEntry(TagPrefix.pipeNormalFluid, GTMaterials.Bronze), Character.valueOf('T'), GTMachines.BRONZE_DRUM.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_input_bus", GTMachines.STEAM_IMPORT_BUS.asStack(), "C", "H", Character.valueOf('H'), GTBlocks.BRONZE_HULL.asStack(), Character.valueOf('C'), CustomTags.TAG_WOODEN_CHESTS);
            VanillaRecipeHelper.addShapedRecipe(provider, true, "steam_output_bus", GTMachines.STEAM_EXPORT_BUS.asStack(), "H", "C", Character.valueOf('H'), GTBlocks.BRONZE_HULL.asStack(), Character.valueOf('C'), CustomTags.TAG_WOODEN_CHESTS);
        }
    }

    private static void disableManualCompression(Consumer<class_2444> provider) {
        if (!ConfigHolder.INSTANCE.recipes.disableManualCompression) {
            VanillaRecipeHelper.addShapelessRecipe(provider, "nether_quartz_block_to_nether_quartz", new class_1799((class_1935)class_1802.field_8155, 4), class_2246.field_10153);
        }
    }

    private static void harderBrickRecipes(Consumer<class_2444> provider) {
        if (ConfigHolder.INSTANCE.recipes.harderBrickRecipes) {
            VanillaRecipeHelper.addShapedRecipe(provider, "brick_from_water", new class_1799((class_1935)class_2246.field_10104, 2), "BBB", "BWB", "BBB", Character.valueOf('B'), new class_1799((class_1935)class_1802.field_8621), Character.valueOf('W'), new class_1799((class_1935)class_1802.field_8705));
            VanillaRecipeHelper.addShapedRecipe(provider, "bucket_of_concrete", new class_1799((class_1935)GTMaterials.Concrete.getBucket()), "CBS", "CWQ", " L ", Character.valueOf('C'), new UnificationEntry(TagPrefix.dust, GTMaterials.Calcite), Character.valueOf('S'), new UnificationEntry(TagPrefix.dust, GTMaterials.Stone), Character.valueOf('W'), new class_1799((class_1935)class_1802.field_8705), Character.valueOf('Q'), new UnificationEntry(TagPrefix.dust, GTMaterials.QuartzSand), Character.valueOf('L'), new UnificationEntry(TagPrefix.dust, GTMaterials.Clay), Character.valueOf('B'), new class_1799((class_1935)class_1802.field_8550));
            VanillaRecipeHelper.addShapedRecipe(provider, "casing_primitive_bricks", GTBlocks.CASING_PRIMITIVE_BRICKS.asStack(), "BGB", "BCB", "BGB", Character.valueOf('B'), GTItems.FIRECLAY_BRICK.asStack(), Character.valueOf('G'), new UnificationEntry(TagPrefix.dust, GTMaterials.Gypsum), Character.valueOf('C'), new class_1799((class_1935)GTMaterials.Concrete.getBucket()));
            VanillaRecipeHelper.addShapelessRecipe(provider, "compressed_clay", GTItems.COMPRESSED_CLAY.asStack(), GTItems.WOODEN_FORM_BRICK.asStack(), new class_1799((class_1935)class_1802.field_8696));
            VanillaRecipeHelper.addSmeltingRecipe(provider, "brick_from_compressed_clay", GTItems.COMPRESSED_CLAY.asStack(), new class_1799((class_1935)class_1802.field_8621), 0.3f);
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, "casing_primitive_bricks", GTBlocks.CASING_PRIMITIVE_BRICKS.asStack(), "XX", "XX", Character.valueOf('X'), GTItems.FIRECLAY_BRICK);
        }
    }

    private static void nerfWoodCrafting(Consumer<class_2444> provider) {
        boolean nerfed = ConfigHolder.INSTANCE.recipes.nerfWoodCrafting;
        if (nerfed) {
            VanillaRecipeHelper.addShapedRecipe(provider, "stick_saw", new class_1799((class_1935)class_1802.field_8600, 4), "s", "P", "P", Character.valueOf('P'), class_3489.field_15537);
            VanillaRecipeHelper.addShapedRecipe(provider, "stick_normal", new class_1799((class_1935)class_1802.field_8600, 2), "P", "P", Character.valueOf('P'), class_3489.field_15537);
            VanillaRecipeHelper.addShapedRecipe(provider, "treated_wood_stick_saw", ChemicalHelper.get(TagPrefix.rod, GTMaterials.TreatedWood, 4), "s", "P", "P", Character.valueOf('P'), GTBlocks.TREATED_WOOD_PLANK.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "treated_wood_stick_normal", ChemicalHelper.get(TagPrefix.rod, GTMaterials.TreatedWood, 2), "P", "P", Character.valueOf('P'), GTBlocks.TREATED_WOOD_PLANK.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "oak_planks", new class_1799((class_1935)class_1802.field_8118, 2), "L", Character.valueOf('L'), class_1802.field_8583.method_7854());
            VanillaRecipeHelper.addShapedRecipe(provider, "spruce_planks", new class_1799((class_1935)class_1802.field_8113, 2), "L", Character.valueOf('L'), class_1802.field_8684.method_7854());
            VanillaRecipeHelper.addShapedRecipe(provider, "birch_planks", new class_1799((class_1935)class_1802.field_8191, 2), "L", Character.valueOf('L'), class_1802.field_8170.method_7854());
            VanillaRecipeHelper.addShapedRecipe(provider, "jungle_planks", new class_1799((class_1935)class_1802.field_8842, 2), "L", Character.valueOf('L'), class_1802.field_8125.method_7854());
            VanillaRecipeHelper.addShapedRecipe(provider, "acacia_planks", new class_1799((class_1935)class_1802.field_8651, 2), "L", Character.valueOf('L'), class_1802.field_8820.method_7854());
            VanillaRecipeHelper.addShapedRecipe(provider, "dark_oak_planks", new class_1799((class_1935)class_1802.field_8404, 2), "L", Character.valueOf('L'), class_1802.field_8652.method_7854());
            VanillaRecipeHelper.addShapedRecipe(provider, "mangrove_planks", new class_1799((class_1935)class_1802.field_37507, 2), "L", Character.valueOf('L'), class_1802.field_37512.method_7854());
            VanillaRecipeHelper.addShapedRecipe(provider, "crimson_planks", new class_1799((class_1935)class_1802.field_22031, 2), "L", Character.valueOf('L'), class_1802.field_21981.method_7854());
            VanillaRecipeHelper.addShapedRecipe(provider, "warped_planks", new class_1799((class_1935)class_1802.field_22032, 2), "L", Character.valueOf('L'), class_1802.field_21982.method_7854());
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, "treated_wood_stick_normal", ChemicalHelper.get(TagPrefix.rod, GTMaterials.TreatedWood, 4), "L", "L", Character.valueOf('L'), GTBlocks.TREATED_WOOD_PLANK.asStack());
        }
        VanillaRecipeHelper.addShapedRecipe(provider, "oak_planks_saw", new class_1799((class_1935)class_1802.field_8118, nerfed ? 4 : 6), "s", "L", Character.valueOf('L'), class_1802.field_8583.method_7854());
        VanillaRecipeHelper.addShapedRecipe(provider, "spruce_planks_saw", new class_1799((class_1935)class_1802.field_8113, nerfed ? 4 : 6), "s", "L", Character.valueOf('L'), class_1802.field_8684.method_7854());
        VanillaRecipeHelper.addShapedRecipe(provider, "birch_planks_saw", new class_1799((class_1935)class_1802.field_8191, nerfed ? 4 : 6), "s", "L", Character.valueOf('L'), class_1802.field_8170.method_7854());
        VanillaRecipeHelper.addShapedRecipe(provider, "jungle_planks_saw", new class_1799((class_1935)class_1802.field_8842, nerfed ? 4 : 6), "s", "L", Character.valueOf('L'), class_1802.field_8125.method_7854());
        VanillaRecipeHelper.addShapedRecipe(provider, "acacia_planks_saw", new class_1799((class_1935)class_1802.field_8651, nerfed ? 4 : 6), "s", "L", Character.valueOf('L'), class_1802.field_8820.method_7854());
        VanillaRecipeHelper.addShapedRecipe(provider, "dark_oak_planks_saw", new class_1799((class_1935)class_1802.field_8404, nerfed ? 4 : 6), "s", "L", Character.valueOf('L'), class_1802.field_8652.method_7854());
        VanillaRecipeHelper.addShapedRecipe(provider, "mangrove_planks_saw", new class_1799((class_1935)class_1802.field_37507, nerfed ? 4 : 6), "s", "L", Character.valueOf('L'), class_1802.field_37512.method_7854());
        VanillaRecipeHelper.addShapedRecipe(provider, "crimson_planks_saw", new class_1799((class_1935)class_1802.field_22031, nerfed ? 4 : 6), "s", "L", Character.valueOf('L'), class_1802.field_21981.method_7854());
        VanillaRecipeHelper.addShapedRecipe(provider, "warped_planks_saw", new class_1799((class_1935)class_1802.field_22032, nerfed ? 4 : 6), "s", "L", Character.valueOf('L'), class_1802.field_21982.method_7854());
    }

    private static void hardWoodRecipes(Consumer<class_2444> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "ladder", new class_1799((class_1935)class_2246.field_9983, 2), "SrS", "SRS", "ShS", Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('R'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood));
        VanillaRecipeHelper.addShapedRecipe(provider, "oak_door", new class_1799((class_1935)class_1802.field_8691), "PTd", "PRS", "PPs", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10161), Character.valueOf('T'), new class_1799((class_1935)class_2246.field_10137), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("oak_door", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10137)).inputItems(new class_1799((class_1935)class_2246.field_10161, 4)).inputFluids(GTMaterials.Iron.getFluid(16L)).outputItems(new class_1799((class_1935)class_1802.field_8691)).duration(400).EUt(4L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "spruce_door", new class_1799((class_1935)class_1802.field_8165), "PTd", "PRS", "PPs", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_9975), Character.valueOf('T'), new class_1799((class_1935)class_2246.field_10323), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("spruce_door", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10323)).inputItems(new class_1799((class_1935)class_2246.field_9975, 4)).inputFluids(GTMaterials.Iron.getFluid(16L)).outputItems(new class_1799((class_1935)class_1802.field_8165)).duration(400).EUt(4L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "birch_door", new class_1799((class_1935)class_1802.field_8438), "PTd", "PRS", "PPs", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10148), Character.valueOf('T'), new class_1799((class_1935)class_2246.field_10486), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("birch_door", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10486)).inputItems(new class_1799((class_1935)class_2246.field_10148, 4)).inputFluids(GTMaterials.Iron.getFluid(16L)).outputItems(new class_1799((class_1935)class_1802.field_8438)).duration(400).EUt(4L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "jungle_door", new class_1799((class_1935)class_1802.field_8199), "PTd", "PRS", "PPs", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10334), Character.valueOf('T'), new class_1799((class_1935)class_2246.field_10017), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("jungle_door", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10017)).inputItems(new class_1799((class_1935)class_2246.field_10334, 4)).inputFluids(GTMaterials.Iron.getFluid(16L)).outputItems(new class_1799((class_1935)class_1802.field_8199)).duration(400).EUt(4L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "acacia_door", new class_1799((class_1935)class_1802.field_8758), "PTd", "PRS", "PPs", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10218), Character.valueOf('T'), new class_1799((class_1935)class_2246.field_10608), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("acacia_door", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10608)).inputItems(new class_1799((class_1935)class_2246.field_10218, 4)).inputFluids(GTMaterials.Iron.getFluid(16L)).outputItems(new class_1799((class_1935)class_1802.field_8758)).duration(400).EUt(4L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "dark_oak_door", new class_1799((class_1935)class_1802.field_8517), "PTd", "PRS", "PPs", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10075), Character.valueOf('T'), new class_1799((class_1935)class_2246.field_10246), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("dark_oak_door", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10246)).inputItems(new class_1799((class_1935)class_2246.field_10075, 4)).inputFluids(GTMaterials.Iron.getFluid(16L)).outputItems(new class_1799((class_1935)class_1802.field_8517)).duration(400).EUt(4L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "mangrove_door", new class_1799((class_1935)class_1802.field_37528), "PTd", "PRS", "PPs", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_37577), Character.valueOf('T'), new class_1799((class_1935)class_2246.field_37555), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("mangrove_door", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_37577, 4)).inputItems(new class_1799((class_1935)class_2246.field_37555)).inputFluids(GTMaterials.Iron.getFluid(16L)).outputItems(new class_1799((class_1935)class_1802.field_37528)).duration(400).EUt(4L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "crimson_door", new class_1799((class_1935)class_1802.field_22010), "PTd", "PRS", "PPs", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_22126), Character.valueOf('T'), new class_1799((class_1935)class_2246.field_22094), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("crimson_door", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_22094)).inputItems(new class_1799((class_1935)class_2246.field_22126, 4)).inputFluids(GTMaterials.Iron.getFluid(16L)).outputItems(new class_1799((class_1935)class_1802.field_22010)).duration(400).EUt(4L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "warped_door", new class_1799((class_1935)class_1802.field_22009), "PTd", "PRS", "PPs", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_22127), Character.valueOf('T'), new class_1799((class_1935)class_2246.field_22095), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("warped_door", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_22095)).inputItems(new class_1799((class_1935)class_2246.field_22127, 4)).inputFluids(GTMaterials.Iron.getFluid(16L)).outputItems(new class_1799((class_1935)class_1802.field_22009)).duration(400).EUt(4L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "bamboo_door", new class_1799((class_1935)class_1802.field_40222), "PTd", "PRS", "PPs", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_40294), Character.valueOf('T'), new class_1799((class_1935)class_2246.field_40285), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("bamboo_door", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_40285)).inputItems(new class_1799((class_1935)class_2246.field_40294, 4)).inputFluids(GTMaterials.Iron.getFluid(16L)).outputItems(new class_1799((class_1935)class_1802.field_40222)).duration(400).EUt(4L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "cherry_door", new class_1799((class_1935)class_1802.field_42705), "PTd", "PRS", "PPs", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_42751), Character.valueOf('T'), new class_1799((class_1935)class_2246.field_42740), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cherry_door", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_42740)).inputItems(new class_1799((class_1935)class_2246.field_42751, 4)).inputFluids(GTMaterials.Iron.getFluid(16L)).outputItems(new class_1799((class_1935)class_1802.field_40222)).duration(400).EUt(4L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "oak_trapdoor", new class_1799((class_1935)class_2246.field_10137), "SRS", "RRR", "SRS", Character.valueOf('S'), new class_1799((class_1935)class_2246.field_10119), Character.valueOf('R'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "spruce_trapdoor", new class_1799((class_1935)class_2246.field_10323), "SRS", "RRR", "SRS", Character.valueOf('S'), new class_1799((class_1935)class_2246.field_10071), Character.valueOf('R'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "birch_trapdoor", new class_1799((class_1935)class_2246.field_10486), "SRS", "RRR", "SRS", Character.valueOf('S'), new class_1799((class_1935)class_2246.field_10257), Character.valueOf('R'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "jungle_trapdoor", new class_1799((class_1935)class_2246.field_10017), "SRS", "RRR", "SRS", Character.valueOf('S'), new class_1799((class_1935)class_2246.field_10617), Character.valueOf('R'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "acacia_trapdoor", new class_1799((class_1935)class_2246.field_10608), "SRS", "RRR", "SRS", Character.valueOf('S'), new class_1799((class_1935)class_2246.field_10031), Character.valueOf('R'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "dark_oak_trapdoor", new class_1799((class_1935)class_2246.field_10246), "SRS", "RRR", "SRS", Character.valueOf('S'), new class_1799((class_1935)class_2246.field_10500), Character.valueOf('R'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "mangrove_trapdoor", new class_1799((class_1935)class_2246.field_37555), "SRS", "RRR", "SRS", Character.valueOf('S'), new class_1799((class_1935)class_2246.field_37564), Character.valueOf('R'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "crimson_trapdoor", new class_1799((class_1935)class_2246.field_22094), "SRS", "RRR", "SRS", Character.valueOf('S'), new class_1799((class_1935)class_2246.field_22128), Character.valueOf('R'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "warped_trapdoor", new class_1799((class_1935)class_2246.field_22095), "SRS", "RRR", "SRS", Character.valueOf('S'), new class_1799((class_1935)class_2246.field_22129), Character.valueOf('R'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "bamboo_trapdoor", new class_1799((class_1935)class_2246.field_40285), "SRS", "RRR", "SRS", Character.valueOf('S'), new class_1799((class_1935)class_2246.field_40292), Character.valueOf('R'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "cherry_trapdoor", new class_1799((class_1935)class_2246.field_42740), "SRS", "RRR", "SRS", Character.valueOf('S'), new class_1799((class_1935)class_2246.field_42746), Character.valueOf('R'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "bowl", new class_1799((class_1935)class_1802.field_8428), "k", "X", Character.valueOf('X'), class_3489.field_15537);
        VanillaRecipeHelper.addShapedRecipe(provider, "chest", new class_1799((class_1935)class_2246.field_10034), "LPL", "PFP", "LPL", Character.valueOf('L'), class_3489.field_15539, Character.valueOf('P'), class_3489.field_15537, Character.valueOf('F'), new class_1799((class_1935)class_1802.field_8145));
        VanillaRecipeHelper.addShapedRecipe(provider, "oak_boat", new class_1799((class_1935)class_1802.field_8533), "PHP", "PkP", "SSS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10161), Character.valueOf('S'), new class_1799((class_1935)class_2246.field_10119), Character.valueOf('H'), new class_1799((class_1935)class_1802.field_8876));
        VanillaRecipeHelper.addShapedRecipe(provider, "spruce_boat", new class_1799((class_1935)class_1802.field_8486), "PHP", "PkP", "SSS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_9975), Character.valueOf('S'), new class_1799((class_1935)class_2246.field_10071), Character.valueOf('H'), new class_1799((class_1935)class_1802.field_8876));
        VanillaRecipeHelper.addShapedRecipe(provider, "birch_boat", new class_1799((class_1935)class_1802.field_8442), "PHP", "PkP", "SSS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10148), Character.valueOf('S'), new class_1799((class_1935)class_2246.field_10257), Character.valueOf('H'), new class_1799((class_1935)class_1802.field_8876));
        VanillaRecipeHelper.addShapedRecipe(provider, "jungle_boat", new class_1799((class_1935)class_1802.field_8730), "PHP", "PkP", "SSS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10334), Character.valueOf('S'), new class_1799((class_1935)class_2246.field_10617), Character.valueOf('H'), new class_1799((class_1935)class_1802.field_8876));
        VanillaRecipeHelper.addShapedRecipe(provider, "acacia_boat", new class_1799((class_1935)class_1802.field_8094), "PHP", "PkP", "SSS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10218), Character.valueOf('S'), new class_1799((class_1935)class_2246.field_10031), Character.valueOf('H'), new class_1799((class_1935)class_1802.field_8876));
        VanillaRecipeHelper.addShapedRecipe(provider, "dark_oak_boat", new class_1799((class_1935)class_1802.field_8138), "PHP", "PkP", "SSS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10075), Character.valueOf('S'), new class_1799((class_1935)class_2246.field_10500), Character.valueOf('H'), new class_1799((class_1935)class_1802.field_8876));
        VanillaRecipeHelper.addShapedRecipe(provider, "mangrove_boat", new class_1799((class_1935)class_1802.field_37531), "PHP", "PkP", "SSS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_37577), Character.valueOf('S'), new class_1799((class_1935)class_2246.field_37564), Character.valueOf('H'), new class_1799((class_1935)class_1802.field_8876));
        VanillaRecipeHelper.addShapedRecipe(provider, "bamboo_raft", new class_1799((class_1935)class_1802.field_40224), "PHP", "PkP", "SSS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_40294), Character.valueOf('S'), new class_1799((class_1935)class_2246.field_40292), Character.valueOf('H'), new class_1799((class_1935)class_1802.field_8876));
        VanillaRecipeHelper.addShapedRecipe(provider, "cherry_boat", new class_1799((class_1935)class_1802.field_42706), "PHP", "PkP", "SSS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_42751), Character.valueOf('S'), new class_1799((class_1935)class_2246.field_42746), Character.valueOf('H'), new class_1799((class_1935)class_1802.field_8876));
        VanillaRecipeHelper.addShapedRecipe(provider, "oak_fence", new class_1799((class_1935)class_2246.field_10620), "PSP", "PSP", "PSP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10161), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "spruce_fence", new class_1799((class_1935)class_2246.field_10020), "PSP", "PSP", "PSP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_9975), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "birch_fence", new class_1799((class_1935)class_2246.field_10299), "PSP", "PSP", "PSP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10148), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "jungle_fence", new class_1799((class_1935)class_2246.field_10319), "PSP", "PSP", "PSP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10334), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "acacia_fence", new class_1799((class_1935)class_2246.field_10144), "PSP", "PSP", "PSP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10218), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "dark_oak_fence", new class_1799((class_1935)class_2246.field_10132), "PSP", "PSP", "PSP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10075), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "mangrove_fence", new class_1799((class_1935)class_2246.field_37565), "PSP", "PSP", "PSP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_37577), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "crimson_fence", new class_1799((class_1935)class_2246.field_22132), "PSP", "PSP", "PSP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_22126), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "warped_fence", new class_1799((class_1935)class_2246.field_22133), "PSP", "PSP", "PSP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_22127), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "bamboo_fence", new class_1799((class_1935)class_2246.field_40290), "PSP", "PSP", "PSP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_40294), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "cherry_fence", new class_1799((class_1935)class_2246.field_42747), "PSP", "PSP", "PSP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_42751), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600));
        VanillaRecipeHelper.addShapedRecipe(provider, "oak_fence_gate", new class_1799((class_1935)class_2246.field_10188), "F F", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10161), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('F'), new class_1799((class_1935)class_1802.field_8145));
        VanillaRecipeHelper.addShapedRecipe(provider, "spruce_fence_gate", new class_1799((class_1935)class_2246.field_10291), "F F", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_9975), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('F'), new class_1799((class_1935)class_1802.field_8145));
        VanillaRecipeHelper.addShapedRecipe(provider, "birch_fence_gate", new class_1799((class_1935)class_2246.field_10513), "F F", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10148), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('F'), new class_1799((class_1935)class_1802.field_8145));
        VanillaRecipeHelper.addShapedRecipe(provider, "jungle_fence_gate", new class_1799((class_1935)class_2246.field_10041), "F F", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10334), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('F'), new class_1799((class_1935)class_1802.field_8145));
        VanillaRecipeHelper.addShapedRecipe(provider, "acacia_fence_gate", new class_1799((class_1935)class_2246.field_10457), "F F", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10218), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('F'), new class_1799((class_1935)class_1802.field_8145));
        VanillaRecipeHelper.addShapedRecipe(provider, "dark_oak_fence_gate", new class_1799((class_1935)class_2246.field_10196), "F F", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10075), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('F'), new class_1799((class_1935)class_1802.field_8145));
        VanillaRecipeHelper.addShapedRecipe(provider, "mangrove_fence_gate", new class_1799((class_1935)class_2246.field_37563), "F F", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_37577), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('F'), new class_1799((class_1935)class_1802.field_8145));
        VanillaRecipeHelper.addShapedRecipe(provider, "crimson_fence_gate", new class_1799((class_1935)class_2246.field_22096), "F F", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_22126), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('F'), new class_1799((class_1935)class_1802.field_8145));
        VanillaRecipeHelper.addShapedRecipe(provider, "warped_fence_gate", new class_1799((class_1935)class_2246.field_22097), "F F", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_22127), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('F'), new class_1799((class_1935)class_1802.field_8145));
        VanillaRecipeHelper.addShapedRecipe(provider, "bamboo_fence_gate", new class_1799((class_1935)class_2246.field_40289), "F F", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_40294), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('F'), new class_1799((class_1935)class_1802.field_8145));
        VanillaRecipeHelper.addShapedRecipe(provider, "cherry_fence_gate", new class_1799((class_1935)class_2246.field_42745), "F F", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_42751), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('F'), new class_1799((class_1935)class_1802.field_8145));
        VanillaRecipeHelper.addShapedRecipe(provider, "oak_fence_gate_screws", new class_1799((class_1935)class_2246.field_10188, 2), "IdI", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10161), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('I'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "spruce_fence_gate_screws", new class_1799((class_1935)class_2246.field_10291, 2), "IdI", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_9975), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('I'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "birch_fence_gate_screws", new class_1799((class_1935)class_2246.field_10513, 2), "IdI", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10148), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('I'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "jungle_fence_gate_screws", new class_1799((class_1935)class_2246.field_10041, 2), "IdI", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10334), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('I'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "acacia_fence_gate_screws", new class_1799((class_1935)class_2246.field_10457, 2), "IdI", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10218), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('I'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "dark_oak_fence_gate_screws", new class_1799((class_1935)class_2246.field_10196, 2), "IdI", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10075), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('I'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "mangrove_fence_gate_screws", new class_1799((class_1935)class_2246.field_37563, 2), "IdI", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_37577), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('I'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "crimson_fence_gate_screws", new class_1799((class_1935)class_2246.field_22096, 2), "IdI", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_22126), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('I'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "warped_fence_gate_screws", new class_1799((class_1935)class_2246.field_22097, 2), "IdI", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_22127), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('I'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "bamboo_fence_gate_screws", new class_1799((class_1935)class_2246.field_40289, 2), "IdI", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_40294), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('I'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "cherry_fence_gate_screws", new class_1799((class_1935)class_2246.field_42745, 2), "IdI", "SPS", "SPS", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_42751), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('I'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
    }

    private static void hardIronRecipes(Consumer<class_2444> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "cauldron", new class_1799((class_1935)class_1802.field_8638), "X X", "XhX", "XXX", Character.valueOf('X'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "hopper", new class_1799((class_1935)class_2246.field_10312), "XCX", "XGX", "wXh", Character.valueOf('X'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('C'), CustomTags.TAG_WOODEN_CHESTS, Character.valueOf('G'), new UnificationEntry(TagPrefix.gearSmall, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "iron_bars", new class_1799((class_1935)class_2246.field_10576, 8), " h ", "XXX", "XXX", Character.valueOf('X'), new UnificationEntry(TagPrefix.rod, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "iron_bucket", new class_1799((class_1935)class_1802.field_8550), "XhX", " X ", Character.valueOf('X'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron));
    }

    private static void hardRedstoneRecipes(Consumer<class_2444> provider) {
        if (ConfigHolder.INSTANCE.recipes.hardRedstoneRecipes) {
            VanillaRecipeHelper.addShapedRecipe(provider, "dispenser", new class_1799((class_1935)class_2246.field_10200), "CRC", "STS", "GAG", Character.valueOf('C'), class_3489.field_25808, Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron), Character.valueOf('T'), new class_1799((class_1935)class_1802.field_8276), Character.valueOf('G'), new UnificationEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('A'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("dispenser", new Object[0]).duration(100).EUt(GTValues.VA[1]).inputItems((class_6862<class_1792>)class_3489.field_25808, 2).inputItems(TagPrefix.ring, GTMaterials.Iron).inputItems(TagPrefix.spring, GTMaterials.Iron, 2).inputItems(TagPrefix.gearSmall, GTMaterials.Iron, 2).inputItems(TagPrefix.rod, GTMaterials.RedAlloy).inputItems(new class_1799((class_1935)class_1802.field_8276)).outputItems(new class_1799((class_1935)class_2246.field_10200)).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "sticky_piston", new class_1799((class_1935)class_2246.field_10615), "h", "R", "P", Character.valueOf('R'), new class_1799((class_1935)class_1802.field_8777), Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10560));
            VanillaRecipeHelper.addShapedRecipe(provider, "piston_iron", new class_1799((class_1935)class_2246.field_10560), "WWW", "GFG", "CRC", Character.valueOf('W'), class_3489.field_15537, Character.valueOf('C'), class_3489.field_25808, Character.valueOf('R'), new UnificationEntry(TagPrefix.plate, GTMaterials.RedAlloy), Character.valueOf('G'), new UnificationEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('F'), class_3489.field_17620);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_iron", new Object[0]).inputItems(TagPrefix.rod, GTMaterials.Iron).inputItems(TagPrefix.gearSmall, GTMaterials.Iron).inputItems((class_6862<class_1792>)class_3489.field_15534).inputItems((class_6862<class_1792>)class_3489.field_25808).inputFluids(GTMaterials.RedAlloy.getFluid(144L)).outputItems(new class_1799((class_1935)class_2246.field_10560)).duration(240).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_steel", new Object[0]).inputItems(TagPrefix.rod, GTMaterials.Steel).inputItems(TagPrefix.gearSmall, GTMaterials.Steel).inputItems((class_6862<class_1792>)class_3489.field_15534, 2).inputItems((class_6862<class_1792>)class_3489.field_25808, 2).inputFluids(GTMaterials.RedAlloy.getFluid(288L)).outputItems(new class_1799((class_1935)class_2246.field_10560, 2)).duration(240).EUt(16L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_aluminium", new Object[0]).inputItems(TagPrefix.rod, GTMaterials.Aluminium).inputItems(TagPrefix.gearSmall, GTMaterials.Aluminium).inputItems((class_6862<class_1792>)class_3489.field_15534, 4).inputItems((class_6862<class_1792>)class_3489.field_25808, 4).inputFluids(GTMaterials.RedAlloy.getFluid(432L)).outputItems(new class_1799((class_1935)class_2246.field_10560, 4)).duration(240).EUt(GTValues.VA[1]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_stainless_steel", new Object[0]).inputItems(TagPrefix.rod, GTMaterials.StainlessSteel).inputItems(TagPrefix.gearSmall, GTMaterials.StainlessSteel).inputItems((class_6862<class_1792>)class_3489.field_15534, 8).inputItems((class_6862<class_1792>)class_3489.field_25808, 8).inputFluids(GTMaterials.RedAlloy.getFluid(576L)).outputItems(new class_1799((class_1935)class_2246.field_10560, 8)).duration(600).EUt(GTValues.VA[1]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_titanium", new Object[0]).inputItems(TagPrefix.rod, GTMaterials.Titanium).inputItems(TagPrefix.gearSmall, GTMaterials.Titanium).inputItems((class_6862<class_1792>)class_3489.field_15534, 16).inputItems((class_6862<class_1792>)class_3489.field_25808, 16).inputFluids(GTMaterials.RedAlloy.getFluid(1152L)).outputItems(new class_1799((class_1935)class_2246.field_10560, 16)).duration(800).EUt(GTValues.VA[1]).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "stone_pressure_plate", new class_1799((class_1935)class_2246.field_10158, 2), "ShS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('L'), new class_1799((class_1935)class_2246.field_10454), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "oak_pressure_plate", new class_1799((class_1935)class_2246.field_10484, 2), "SrS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('L'), class_2246.field_10119.method_8389(), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "birch_pressure_plate", new class_1799((class_1935)class_2246.field_10592, 2), "SrS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('L'), class_2246.field_10257.method_8389(), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "spruce_pressure_plate", new class_1799((class_1935)class_2246.field_10332, 2), "SrS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('L'), class_2246.field_10071.method_8389(), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "jungle_pressure_plate", new class_1799((class_1935)class_2246.field_10026, 2), "SrS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('L'), class_2246.field_10617.method_8389(), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "acacia_pressure_plate", new class_1799((class_1935)class_2246.field_10397, 2), "SrS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('L'), class_2246.field_10031.method_8389(), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "dark_oak_pressure_plate", new class_1799((class_1935)class_2246.field_10470, 2), "SrS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('L'), class_2246.field_10500.method_8389(), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "crimson_pressure_plate", new class_1799((class_1935)class_2246.field_22130, 2), "SrS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('L'), class_2246.field_22128.method_8389(), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "warped_pressure_plate", new class_1799((class_1935)class_2246.field_22131, 2), "SrS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('L'), class_2246.field_22129.method_8389(), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "mangrove_pressure_plate", new class_1799((class_1935)class_2246.field_37553, 2), "SrS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('L'), class_2246.field_37564.method_8389(), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "heavy_weighted_pressure_plate", new class_1799((class_1935)class_2246.field_10224), "ShS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Steel), Character.valueOf('L'), new UnificationEntry(TagPrefix.plate, GTMaterials.Gold), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Steel));
            VanillaRecipeHelper.addShapedRecipe(provider, "light_weighted_pressure_plate", new class_1799((class_1935)class_2246.field_10582), "ShS", "LCL", "SdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Steel), Character.valueOf('L'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('C'), new UnificationEntry(TagPrefix.spring, GTMaterials.Steel));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("stone_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(new class_1799((class_1935)class_2246.field_10454, 2)).outputItems(new class_1799((class_1935)class_2246.field_10158, 2)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("oak_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(new class_1799((class_1935)class_2246.field_10119, 2)).outputItems(new class_1799((class_1935)class_2246.field_10484, 2)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("birch_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(new class_1799((class_1935)class_2246.field_10257, 2)).outputItems(new class_1799((class_1935)class_2246.field_10592, 2)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("spruce_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(new class_1799((class_1935)class_2246.field_10071, 2)).outputItems(new class_1799((class_1935)class_2246.field_10332, 2)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("jungle_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(new class_1799((class_1935)class_2246.field_10617, 2)).outputItems(new class_1799((class_1935)class_2246.field_10026, 2)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("acacia_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(new class_1799((class_1935)class_2246.field_10031, 2)).outputItems(new class_1799((class_1935)class_2246.field_10397, 2)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("dark_oak_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(new class_1799((class_1935)class_2246.field_10500, 2)).outputItems(new class_1799((class_1935)class_2246.field_10470, 2)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("crimson_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(new class_1799((class_1935)class_2246.field_22128, 2)).outputItems(new class_1799((class_1935)class_2246.field_22130, 2)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("warped_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(new class_1799((class_1935)class_2246.field_22129, 2)).outputItems(new class_1799((class_1935)class_2246.field_22131, 2)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("mangrove_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Iron).inputItems(new class_1799((class_1935)class_2246.field_37564, 2)).outputItems(new class_1799((class_1935)class_2246.field_37553, 2)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("light_weighted_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Steel).inputItems(TagPrefix.plate, GTMaterials.Gold).outputItems(new class_1799((class_1935)class_2246.field_10224)).duration(200).EUt(16L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("heavy_weighted_pressure_plate", new Object[0]).inputItems(TagPrefix.spring, GTMaterials.Steel).inputItems(TagPrefix.plate, GTMaterials.Iron).outputItems(new class_1799((class_1935)class_2246.field_10582)).duration(200).EUt(16L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "stone_button", new class_1799((class_1935)class_2246.field_10494, 6), "sP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10158));
            VanillaRecipeHelper.addShapedRecipe(provider, "oak_button", new class_1799((class_1935)class_2246.field_10057, 6), "sP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10484));
            VanillaRecipeHelper.addShapedRecipe(provider, "birch_button", new class_1799((class_1935)class_2246.field_10417, 6), "sP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10592));
            VanillaRecipeHelper.addShapedRecipe(provider, "spruce_button", new class_1799((class_1935)class_2246.field_10066, 6), "sP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10332));
            VanillaRecipeHelper.addShapedRecipe(provider, "jungle_button", new class_1799((class_1935)class_2246.field_10553, 6), "sP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10026));
            VanillaRecipeHelper.addShapedRecipe(provider, "acacia_button", new class_1799((class_1935)class_2246.field_10278, 6), "sP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10397));
            VanillaRecipeHelper.addShapedRecipe(provider, "dark_oak_button", new class_1799((class_1935)class_2246.field_10493, 6), "sP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10470));
            VanillaRecipeHelper.addShapedRecipe(provider, "crimson_button", new class_1799((class_1935)class_2246.field_22100, 6), "sP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_22130));
            VanillaRecipeHelper.addShapedRecipe(provider, "warped_button", new class_1799((class_1935)class_2246.field_22101, 6), "sP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_22131));
            VanillaRecipeHelper.addShapedRecipe(provider, "mangrove_button", new class_1799((class_1935)class_2246.field_37559, 6), "sP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_37553));
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("stone_button", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10158)).outputItems(new class_1799((class_1935)class_2246.field_10494, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("oak_button", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10484)).outputItems(new class_1799((class_1935)class_2246.field_10057, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("birch_button", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10592)).outputItems(new class_1799((class_1935)class_2246.field_10417, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("spruce_button", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10332)).outputItems(new class_1799((class_1935)class_2246.field_10066, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("jungle_button", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10026)).outputItems(new class_1799((class_1935)class_2246.field_10553, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("acacia_button", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10397)).outputItems(new class_1799((class_1935)class_2246.field_10278, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("dark_oak_button", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10470)).outputItems(new class_1799((class_1935)class_2246.field_10493, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("crimson_button", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_22130)).outputItems(new class_1799((class_1935)class_2246.field_22100, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("warped_button", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_22131)).outputItems(new class_1799((class_1935)class_2246.field_22101, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("mangrove_button", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_37553)).outputItems(new class_1799((class_1935)class_2246.field_37559, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "lever", new class_1799((class_1935)class_2246.field_10363), "B", "S", Character.valueOf('B'), new class_1799((class_1935)class_2246.field_10494), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600));
            VanillaRecipeHelper.addShapedRecipe(provider, "daylight_detector", new class_1799((class_1935)class_2246.field_10429), "GGG", "PPP", "SRS", Character.valueOf('G'), new class_1799((class_1935)class_2246.field_10033), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.NetherQuartz), Character.valueOf('S'), class_3489.field_15534, Character.valueOf('R'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "daylight_detector_certus", new class_1799((class_1935)class_2246.field_10429), "GGG", "PPP", "SRS", Character.valueOf('G'), new class_1799((class_1935)class_2246.field_10033), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.CertusQuartz), Character.valueOf('S'), class_3489.field_15534, Character.valueOf('R'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "daylight_detector_quartzite", new class_1799((class_1935)class_2246.field_10429), "GGG", "PPP", "SRS", Character.valueOf('G'), new class_1799((class_1935)class_2246.field_10033, 1), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Quartzite), Character.valueOf('S'), class_3489.field_15534, Character.valueOf('R'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "redstone_lamp", new class_1799((class_1935)class_2246.field_10524), "PPP", "PGP", "PRP", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10285), Character.valueOf('G'), new class_1799((class_1935)class_2246.field_10171), Character.valueOf('R'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "tripwire_hook", new class_1799((class_1935)class_2246.field_10348), "IRI", "SRS", " S ", Character.valueOf('I'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('R'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8276));
            VanillaRecipeHelper.addShapedRecipe(provider, "dropper", new class_1799((class_1935)class_2246.field_10228), "CRC", "STS", "GAG", Character.valueOf('C'), class_3489.field_25808, Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.springSmall, GTMaterials.Iron), Character.valueOf('T'), new class_1799((class_1935)class_1802.field_8276), Character.valueOf('G'), new UnificationEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('A'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "observer", new class_1799((class_1935)class_2246.field_10282), "RCR", "CQC", "GSG", Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('C'), class_3489.field_25808, Character.valueOf('Q'), new UnificationEntry(TagPrefix.plate, GTMaterials.NetherQuartz), Character.valueOf('G'), new UnificationEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "observer_certus", new class_1799((class_1935)class_2246.field_10282), "RCR", "CQC", "GSG", Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('C'), class_3489.field_25808, Character.valueOf('Q'), new UnificationEntry(TagPrefix.plate, GTMaterials.CertusQuartz), Character.valueOf('G'), new UnificationEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "observer_quartzite", new class_1799((class_1935)class_2246.field_10282), "RCR", "CQC", "GSG", Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('C'), class_3489.field_25808, Character.valueOf('Q'), new UnificationEntry(TagPrefix.plate, GTMaterials.Quartzite), Character.valueOf('G'), new UnificationEntry(TagPrefix.gearSmall, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "repeater", new class_1799((class_1935)class_1802.field_8619), "S S", "TdT", "PRP", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('T'), new class_1799((class_1935)class_2246.field_10523), Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10158), Character.valueOf('R'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            VanillaRecipeHelper.addShapedRecipe(provider, "comparator", new class_1799((class_1935)class_1802.field_8857), "STS", "TQT", "PdP", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('T'), new class_1799((class_1935)class_2246.field_10523), Character.valueOf('Q'), new UnificationEntry(TagPrefix.plate, GTMaterials.NetherQuartz), Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10158));
            VanillaRecipeHelper.addShapedRecipe(provider, "comparator_certus", new class_1799((class_1935)class_1802.field_8857), "STS", "TQT", "PdP", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('T'), new class_1799((class_1935)class_2246.field_10523), Character.valueOf('Q'), new UnificationEntry(TagPrefix.plate, GTMaterials.CertusQuartz), Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10158));
            VanillaRecipeHelper.addShapedRecipe(provider, "comparator_quartzite", new class_1799((class_1935)class_1802.field_8857), "STS", "TQT", "PdP", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('T'), new class_1799((class_1935)class_2246.field_10523), Character.valueOf('Q'), new UnificationEntry(TagPrefix.plate, GTMaterials.Quartzite), Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10158));
            VanillaRecipeHelper.addShapedRecipe(provider, "powered_rail", new class_1799((class_1935)class_2246.field_10425, 6), "SPS", "IWI", "GdG", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Steel), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.RedAlloy), Character.valueOf('I'), new UnificationEntry(TagPrefix.rod, GTMaterials.Iron), Character.valueOf('W'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('G'), new UnificationEntry(TagPrefix.rod, GTMaterials.Gold));
            VanillaRecipeHelper.addShapedRecipe(provider, "detector_rail", new class_1799((class_1935)class_2246.field_10025, 6), "SPS", "IWI", "IdI", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10582), Character.valueOf('I'), new UnificationEntry(TagPrefix.rod, GTMaterials.Iron), Character.valueOf('W'), new class_1799((class_1935)class_1802.field_8600));
            VanillaRecipeHelper.addShapedRecipe(provider, "rail", new class_1799((class_1935)class_2246.field_10167, 8), "ShS", "IWI", "IdI", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('I'), new UnificationEntry(TagPrefix.rod, GTMaterials.Iron), Character.valueOf('W'), new class_1799((class_1935)class_1802.field_8600));
            VanillaRecipeHelper.addShapedRecipe(provider, "activator_rail", new class_1799((class_1935)class_2246.field_10546, 6), "SPS", "IWI", "IdI", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10523), Character.valueOf('I'), new UnificationEntry(TagPrefix.rod, GTMaterials.Iron), Character.valueOf('W'), new class_1799((class_1935)class_1802.field_8600));
            VanillaRecipeHelper.addShapedRecipe(provider, "redstone_torch", new class_1799((class_1935)class_2246.field_10523), "R", "T", Character.valueOf('R'), new UnificationEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('T'), new class_1799((class_1935)class_1802.field_8600));
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, "piston_bronze", new class_1799((class_1935)class_2246.field_10560, 1), "WWW", "CBC", "CRC", Character.valueOf('W'), class_3489.field_15537, Character.valueOf('C'), class_3489.field_25808, Character.valueOf('R'), new UnificationEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('B'), new UnificationEntry(TagPrefix.ingot, GTMaterials.Bronze));
            VanillaRecipeHelper.addShapedRecipe(provider, "piston_steel", new class_1799((class_1935)class_2246.field_10560, 2), "WWW", "CBC", "CRC", Character.valueOf('W'), class_3489.field_15537, Character.valueOf('C'), class_3489.field_25808, Character.valueOf('R'), new UnificationEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('B'), new UnificationEntry(TagPrefix.ingot, GTMaterials.Steel));
            VanillaRecipeHelper.addShapedRecipe(provider, "piston_aluminium", new class_1799((class_1935)class_2246.field_10560, 4), "WWW", "CBC", "CRC", Character.valueOf('W'), class_3489.field_15537, Character.valueOf('C'), class_3489.field_25808, Character.valueOf('R'), new UnificationEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('B'), new UnificationEntry(TagPrefix.ingot, GTMaterials.Aluminium));
            VanillaRecipeHelper.addShapedRecipe(provider, "piston_titanium", new class_1799((class_1935)class_2246.field_10560, 8), "WWW", "CBC", "CRC", Character.valueOf('W'), class_3489.field_15537, Character.valueOf('C'), class_3489.field_25808, Character.valueOf('R'), new UnificationEntry(TagPrefix.dust, GTMaterials.Redstone), Character.valueOf('B'), new UnificationEntry(TagPrefix.ingot, GTMaterials.Titanium));
            VanillaRecipeHelper.addShapedRecipe(provider, "sticky_piston_resin", new class_1799((class_1935)class_2246.field_10615), "h", "R", "P", Character.valueOf('R'), GTItems.STICKY_RESIN.asStack(), Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10560));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_iron", new Object[0]).duration(100).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Iron).inputItems((class_6862<class_1792>)class_3489.field_15537, 3).inputItems((class_6862<class_1792>)class_3489.field_25808, 4).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new class_1799((class_1935)class_2246.field_10560)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_bronze", new Object[0]).duration(100).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Bronze).inputItems((class_6862<class_1792>)class_3489.field_15537, 3).inputItems((class_6862<class_1792>)class_3489.field_25808, 4).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new class_1799((class_1935)class_2246.field_10560)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_steel", new Object[0]).duration(100).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Steel).inputItems((class_6862<class_1792>)class_3489.field_15537, 3).inputItems((class_6862<class_1792>)class_3489.field_25808, 4).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new class_1799((class_1935)class_2246.field_10560, 2)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_aluminium", new Object[0]).duration(100).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Aluminium).inputItems((class_6862<class_1792>)class_3489.field_15537, 3).inputItems((class_6862<class_1792>)class_3489.field_25808, 4).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new class_1799((class_1935)class_2246.field_10560, 4)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("piston_titanium", new Object[0]).duration(100).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Titanium).inputItems((class_6862<class_1792>)class_3489.field_15537, 3).inputItems((class_6862<class_1792>)class_3489.field_25808, 4).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new class_1799((class_1935)class_2246.field_10560, 8)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("light_weighted_pressure_plate", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Gold, 2).outputItems(new class_1799((class_1935)class_2246.field_10224)).circuitMeta(2).duration(100).EUt(4L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("heavy_weighted_pressure_plate", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Iron, 2).outputItems(new class_1799((class_1935)class_2246.field_10582)).circuitMeta(2).duration(100).EUt(4L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "comparator_certus", new class_1799((class_1935)class_1802.field_8857), " T ", "TQT", "SSS", Character.valueOf('T'), new class_1799((class_1935)class_2246.field_10523), Character.valueOf('Q'), new UnificationEntry(TagPrefix.gem, GTMaterials.CertusQuartz), Character.valueOf('S'), new class_1799((class_1935)class_2246.field_10340));
            VanillaRecipeHelper.addShapedRecipe(provider, "comparator_quartzite", new class_1799((class_1935)class_1802.field_8857), " T ", "TQT", "SSS", Character.valueOf('T'), new class_1799((class_1935)class_2246.field_10523), Character.valueOf('Q'), new UnificationEntry(TagPrefix.gem, GTMaterials.Quartzite), Character.valueOf('S'), new class_1799((class_1935)class_2246.field_10340));
            VanillaRecipeHelper.addShapedRecipe(provider, "daylight_detector_certus", new class_1799((class_1935)class_2246.field_10429), "GGG", "CCC", "PPP", Character.valueOf('G'), new class_1799((class_1935)class_2246.field_10033), Character.valueOf('C'), new UnificationEntry(TagPrefix.gem, GTMaterials.CertusQuartz), Character.valueOf('P'), class_3489.field_15534);
            VanillaRecipeHelper.addShapedRecipe(provider, "daylight_detector_quartzite", new class_1799((class_1935)class_2246.field_10429), "GGG", "CCC", "PPP", Character.valueOf('G'), new class_1799((class_1935)class_2246.field_10033), Character.valueOf('C'), new UnificationEntry(TagPrefix.gem, GTMaterials.Quartzite), Character.valueOf('P'), class_3489.field_15534);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("note_block", new Object[0]).duration(100).EUt(16L).inputItems((class_6862<class_1792>)class_3489.field_15537, 8).inputItems(TagPrefix.dust, GTMaterials.Redstone).circuitMeta(1).outputItems(new class_1799((class_1935)class_2246.field_10179)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("jukebox", new Object[0]).duration(100).EUt(16L).inputItems((class_6862<class_1792>)class_3489.field_15537, 8).inputItems(TagPrefix.gem, GTMaterials.Diamond).outputItems(new class_1799((class_1935)class_2246.field_10223)).save(provider);
        }
    }

    private static void hardToolArmorRecipes(Consumer<class_2444> provider) {
        if (ConfigHolder.INSTANCE.recipes.hardToolArmorRecipes) {
            RecipeAddition.createShovelRecipe(provider, "iron_shovel", new class_1799((class_1935)class_1802.field_8699), GTMaterials.Iron);
            RecipeAddition.createPickaxeRecipe(provider, "iron_pickaxe", new class_1799((class_1935)class_1802.field_8403), GTMaterials.Iron);
            RecipeAddition.createAxeRecipe(provider, "iron_axe", new class_1799((class_1935)class_1802.field_8475), GTMaterials.Iron);
            RecipeAddition.createSwordRecipe(provider, "iron_sword", new class_1799((class_1935)class_1802.field_8371), GTMaterials.Iron);
            RecipeAddition.createHoeRecipe(provider, "iron_hoe", new class_1799((class_1935)class_1802.field_8609), GTMaterials.Iron);
            RecipeAddition.createHelmetRecipe(provider, "iron_helmet", new class_1799((class_1935)class_1802.field_8743), GTMaterials.Iron);
            RecipeAddition.createChestplateRecipe(provider, "iron_chestplate", new class_1799((class_1935)class_1802.field_8523), GTMaterials.Iron);
            RecipeAddition.createLeggingsRecipe(provider, "iron_leggings", new class_1799((class_1935)class_1802.field_8396), GTMaterials.Iron);
            RecipeAddition.createBootsRecipe(provider, "iron_boots", new class_1799((class_1935)class_1802.field_8660), GTMaterials.Iron);
            RecipeAddition.createShovelRecipe(provider, "golden_shovel", new class_1799((class_1935)class_1802.field_8322), GTMaterials.Gold);
            RecipeAddition.createPickaxeRecipe(provider, "golden_pickaxe", new class_1799((class_1935)class_1802.field_8335), GTMaterials.Gold);
            RecipeAddition.createAxeRecipe(provider, "golden_axe", new class_1799((class_1935)class_1802.field_8825), GTMaterials.Gold);
            RecipeAddition.createSwordRecipe(provider, "golden_sword", new class_1799((class_1935)class_1802.field_8845), GTMaterials.Gold);
            RecipeAddition.createHoeRecipe(provider, "golden_hoe", new class_1799((class_1935)class_1802.field_8303), GTMaterials.Gold);
            RecipeAddition.createHelmetRecipe(provider, "golden_helmet", new class_1799((class_1935)class_1802.field_8862), GTMaterials.Gold);
            RecipeAddition.createChestplateRecipe(provider, "golden_chestplate", new class_1799((class_1935)class_1802.field_8678), GTMaterials.Gold);
            RecipeAddition.createLeggingsRecipe(provider, "golden_leggings", new class_1799((class_1935)class_1802.field_8416), GTMaterials.Gold);
            RecipeAddition.createBootsRecipe(provider, "golden_boots", new class_1799((class_1935)class_1802.field_8753), GTMaterials.Gold);
            RecipeAddition.createShovelRecipe(provider, "diamond_shovel", new class_1799((class_1935)class_1802.field_8250), GTMaterials.Diamond);
            RecipeAddition.createPickaxeRecipe(provider, "diamond_pickaxe", new class_1799((class_1935)class_1802.field_8377), GTMaterials.Diamond);
            RecipeAddition.createAxeRecipe(provider, "diamond_axe", new class_1799((class_1935)class_1802.field_8556), GTMaterials.Diamond);
            RecipeAddition.createSwordRecipe(provider, "diamond_sword", new class_1799((class_1935)class_1802.field_8802), GTMaterials.Diamond);
            RecipeAddition.createHoeRecipe(provider, "diamond_hoe", new class_1799((class_1935)class_1802.field_8527), GTMaterials.Diamond);
            RecipeAddition.createHelmetRecipe(provider, "diamond_helmet", new class_1799((class_1935)class_1802.field_8805), GTMaterials.Diamond);
            RecipeAddition.createChestplateRecipe(provider, "diamond_chestplate", new class_1799((class_1935)class_1802.field_8058), GTMaterials.Diamond);
            RecipeAddition.createLeggingsRecipe(provider, "diamond_leggings", new class_1799((class_1935)class_1802.field_8348), GTMaterials.Diamond);
            RecipeAddition.createBootsRecipe(provider, "diamond_boots", new class_1799((class_1935)class_1802.field_8285), GTMaterials.Diamond);
            VanillaRecipeHelper.addShapedRecipe(provider, "compass", new class_1799((class_1935)class_1802.field_8251), "SGB", "RPR", "AdS", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('G'), new class_1799((class_1935)class_2246.field_10285), Character.valueOf('B'), new UnificationEntry(TagPrefix.bolt, GTMaterials.IronMagnetic), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Zinc), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('A'), new UnificationEntry(TagPrefix.bolt, GTMaterials.RedAlloy));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("compass", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Iron).inputItems(TagPrefix.ring, GTMaterials.Zinc).inputItems(TagPrefix.bolt, GTMaterials.RedAlloy).inputItems(TagPrefix.bolt, GTMaterials.IronMagnetic).inputItems(TagPrefix.screw, GTMaterials.Iron, 2).outputItems(new class_1799((class_1935)class_1802.field_8251)).duration(100).EUt(16L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "fishing_rod", new class_1799((class_1935)class_1802.field_8378), "  S", " SL", "SxR", Character.valueOf('S'), new UnificationEntry(TagPrefix.rodLong, GTMaterials.Wood), Character.valueOf('L'), new class_1799((class_1935)class_1802.field_8276), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "clock", new class_1799((class_1935)class_1802.field_8557), "RPR", "BCB", "dSw", Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Gold), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Gold), Character.valueOf('B'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Gold), Character.valueOf('C'), new class_1799((class_1935)class_1802.field_8857), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Gold));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("clock", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Gold).inputItems(TagPrefix.ring, GTMaterials.Gold).inputItems(TagPrefix.bolt, GTMaterials.Gold, 2).inputItems(TagPrefix.screw, GTMaterials.Gold).inputItems(new class_1799((class_1935)class_1802.field_8857)).outputItems(new class_1799((class_1935)class_1802.field_8557)).duration(100).EUt(16L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "shears", new class_1799((class_1935)class_1802.field_8868), "PSP", "hRf", "TdT", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('T'), new class_1799((class_1935)class_1802.field_8600));
            VanillaRecipeHelper.addShapedRecipe(provider, "shield", new class_1799((class_1935)class_1802.field_8255), "BRB", "LPL", "BRB", Character.valueOf('B'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Iron), Character.valueOf('R'), new UnificationEntry(TagPrefix.rod, GTMaterials.Iron), Character.valueOf('L'), new UnificationEntry(TagPrefix.rodLong, GTMaterials.Iron), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Wood));
        } else {
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("compass", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Redstone).inputItems(TagPrefix.plate, GTMaterials.Iron, 4).circuitMeta(1).outputItems(new class_1799((class_1935)class_1802.field_8251)).duration(100).EUt(4L).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("clock", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Redstone).inputItems(TagPrefix.plate, GTMaterials.Gold, 4).outputItems(new class_1799((class_1935)class_1802.field_8557)).duration(100).EUt(4L).save(provider);
        }
    }

    private static void harderRods(Consumer<class_2444> provider) {
        if (ConfigHolder.INSTANCE.recipes.harderRods) {
            GTRecipeTypes.LATHE_RECIPES.recipeBuilder("stone_rod_from_cobblestone", new Object[0]).inputItems((class_6862<class_1792>)class_3489.field_25808).outputItems(TagPrefix.rod, GTMaterials.Stone, 1).outputItems(TagPrefix.dustSmall, GTMaterials.Stone, 2).duration(20).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.LATHE_RECIPES.recipeBuilder("stone_rod_from_stone", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10340)).outputItems(TagPrefix.rod, GTMaterials.Stone, 1).outputItems(TagPrefix.dustSmall, GTMaterials.Stone, 2).duration(20).EUt(GTValues.VA[0]).save(provider);
        } else {
            GTRecipeTypes.LATHE_RECIPES.recipeBuilder("stone_rod_from_cobblestone", new Object[0]).inputItems((class_6862<class_1792>)class_3489.field_25808).outputItems(TagPrefix.rod, GTMaterials.Stone, 2).duration(20).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.LATHE_RECIPES.recipeBuilder("stone_rod_from_stone", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10340)).outputItems(TagPrefix.rod, GTMaterials.Stone, 2).duration(20).EUt(GTValues.VA[0]).save(provider);
        }
    }

    private static void hardMiscRecipes(Consumer<class_2444> provider) {
        if (ConfigHolder.INSTANCE.recipes.hardMiscRecipes) {
            VanillaRecipeHelper.addShapedRecipe(provider, "beacon", new class_1799((class_1935)class_2246.field_10327), "GLG", "GSG", "OOO", Character.valueOf('G'), new class_1799((class_1935)class_2246.field_10033), Character.valueOf('L'), new UnificationEntry(TagPrefix.lens, GTMaterials.NetherStar), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8137), Character.valueOf('O'), new UnificationEntry(TagPrefix.plate, GTMaterials.Obsidian));
            VanillaRecipeHelper.addShapedRecipe(provider, "lit_pumpkin", new class_1799((class_1935)class_2246.field_10009), "PT", "k ", Character.valueOf('P'), new class_1799((class_1935)class_2246.field_10261), Character.valueOf('T'), new class_1799((class_1935)class_2246.field_10336));
            VanillaRecipeHelper.addShapedRecipe(provider, "book", new class_1799((class_1935)class_1802.field_8529), "SPL", "SPG", "SPL", Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8276), Character.valueOf('P'), new class_1799((class_1935)class_1802.field_8407), Character.valueOf('L'), new class_1799((class_1935)class_1802.field_8745), Character.valueOf('G'), GTItems.STICKY_RESIN.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "brewing_stand", new class_1799((class_1935)class_1802.field_8740), "RBR", "ABA", "SCS", Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Aluminium), Character.valueOf('B'), new UnificationEntry(TagPrefix.rod, GTMaterials.Blaze), Character.valueOf('A'), new UnificationEntry(TagPrefix.rod, GTMaterials.Aluminium), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Aluminium), Character.valueOf('C'), new class_1799((class_1935)class_1802.field_8638));
            VanillaRecipeHelper.addShapedRecipe(provider, "enchanting_table", new class_1799((class_1935)class_2246.field_10485), "DCD", "PBP", "DPD", Character.valueOf('D'), new UnificationEntry(TagPrefix.gem, GTMaterials.Diamond), Character.valueOf('C'), new class_1799((class_1935)class_2246.field_10536), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Obsidian), Character.valueOf('B'), new class_1799((class_1935)class_2246.field_10504));
            VanillaRecipeHelper.addShapedRecipe(provider, "jukebox", new class_1799((class_1935)class_2246.field_10223), "LBL", "NRN", "LGL", Character.valueOf('L'), class_3489.field_15539, Character.valueOf('B'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Diamond), Character.valueOf('N'), new class_1799((class_1935)class_2246.field_10179), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('G'), new UnificationEntry(TagPrefix.gear, GTMaterials.Iron));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("jukebox", new Object[0]).inputItems(TagPrefix.bolt, GTMaterials.Diamond).inputItems(TagPrefix.gear, GTMaterials.Iron).inputItems(TagPrefix.ring, GTMaterials.Iron).inputItems(TagPrefix.plate, GTMaterials.Wood, 4).inputItems(new class_1799((class_1935)class_2246.field_10179, 2)).outputItems(new class_1799((class_1935)class_2246.field_10223)).duration(100).EUt(16L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "note_block", new class_1799((class_1935)class_2246.field_10179), "PPP", "BGB", "PRP", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Wood), Character.valueOf('B'), new class_1799((class_1935)class_2246.field_10576), Character.valueOf('G'), new UnificationEntry(TagPrefix.gear, GTMaterials.Wood), Character.valueOf('R'), new UnificationEntry(TagPrefix.rod, GTMaterials.RedAlloy));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("note_block", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Wood, 4).inputItems(TagPrefix.gear, GTMaterials.Wood).inputItems(TagPrefix.rod, GTMaterials.RedAlloy).inputItems(new class_1799((class_1935)class_2246.field_10576, 2)).outputItems(new class_1799((class_1935)class_2246.field_10179)).duration(100).EUt(16L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "furnace", new class_1799((class_1935)class_2246.field_10181), "CCC", "FFF", "CCC", Character.valueOf('F'), new class_1799((class_1935)class_1802.field_8145), Character.valueOf('C'), class_3489.field_25808);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("furnace", new Object[0]).circuitMeta(8).inputItems((class_6862<class_1792>)class_3489.field_25808, 8).inputItems(new class_1799((class_1935)class_1802.field_8145)).outputItems(new class_1799((class_1935)class_2246.field_10181)).duration(100).EUt(GTValues.VA[0]).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "crafting_table", new class_1799((class_1935)class_2246.field_9980), "FF", "WW", Character.valueOf('F'), new class_1799((class_1935)class_1802.field_8145), Character.valueOf('W'), class_3489.field_15539);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("crafting_table", new Object[0]).duration(80).EUt(6L).inputItems((class_6862<class_1792>)class_3489.field_15539).inputItems(new class_1799((class_1935)class_1802.field_8145)).outputItems(new class_1799((class_1935)class_2246.field_9980)).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, "lead", new class_1799((class_1935)class_1802.field_8719), "SSS", "SBS", "SSS", Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8276), Character.valueOf('B'), new class_1799((class_1935)class_1802.field_8777));
            VanillaRecipeHelper.addShapedRecipe(provider, "bow", new class_1799((class_1935)class_1802.field_8102), "hLS", "LRS", "fLS", Character.valueOf('L'), new UnificationEntry(TagPrefix.rodLong, GTMaterials.Wood), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8276), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron));
            VanillaRecipeHelper.addShapedRecipe(provider, "item_frame", new class_1799((class_1935)class_1802.field_8143), "SRS", "TLT", "TTT", Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8276), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('T'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('L'), new class_1799((class_1935)class_1802.field_8745));
            VanillaRecipeHelper.addShapedRecipe(provider, "painting", new class_1799((class_1935)class_1802.field_8892), "SRS", "TCT", "TTT", Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8276), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('T'), new class_1799((class_1935)class_1802.field_8600), Character.valueOf('C'), class_3489.field_15542);
            VanillaRecipeHelper.addShapedRecipe(provider, "chest_minecart", new class_1799((class_1935)class_1802.field_8388), "hIw", " M ", " d ", Character.valueOf('I'), CustomTags.TAG_WOODEN_CHESTS, Character.valueOf('M'), new class_1799((class_1935)class_1802.field_8045));
            VanillaRecipeHelper.addShapedRecipe(provider, "furnace_minecart", new class_1799((class_1935)class_1802.field_8063), "hIw", " M ", " d ", Character.valueOf('I'), new class_1799((class_1935)class_2246.field_10181), Character.valueOf('M'), new class_1799((class_1935)class_1802.field_8045));
            VanillaRecipeHelper.addShapedRecipe(provider, "tnt_minecart", new class_1799((class_1935)class_1802.field_8069), "hIw", " M ", " d ", Character.valueOf('I'), new class_1799((class_1935)class_2246.field_10375), Character.valueOf('M'), new class_1799((class_1935)class_1802.field_8045));
            VanillaRecipeHelper.addShapedRecipe(provider, "hopper_minecart", new class_1799((class_1935)class_1802.field_8836), "hIw", " M ", " d ", Character.valueOf('I'), new class_1799((class_1935)class_2246.field_10312), Character.valueOf('M'), new class_1799((class_1935)class_1802.field_8045));
        } else {
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("crafting_table", new Object[0]).duration(80).EUt(6L).circuitMeta(4).inputItems((class_6862<class_1792>)class_3489.field_15537, 4).outputItems(new class_1799((class_1935)class_2246.field_9980)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("furnace", new Object[0]).circuitMeta(8).inputItems((class_6862<class_1792>)class_3489.field_25808, 8).outputItems(new class_1799((class_1935)class_2246.field_10181)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("enchanting_table", new Object[0]).inputItems(new class_1799((class_1935)class_2246.field_10540, 4)).inputItems(TagPrefix.gem, GTMaterials.Diamond, 2).inputItems(new class_1799((class_1935)class_1802.field_8529)).outputItems(new class_1799((class_1935)class_2246.field_10485)).duration(100).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("dispenser", new Object[0]).duration(100).EUt(GTValues.VA[1]).circuitMeta(1).inputItems((class_6862<class_1792>)class_3489.field_25808, 7).inputItems(new class_1799((class_1935)class_1802.field_8102)).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new class_1799((class_1935)class_2246.field_10200)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("dropper", new Object[0]).duration(100).EUt(GTValues.VA[1]).circuitMeta(2).inputItems((class_6862<class_1792>)class_3489.field_25808, 7).inputItems(TagPrefix.dust, GTMaterials.Redstone).outputItems(new class_1799((class_1935)class_2246.field_10228)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("observer_nether_quartz", new Object[0]).duration(100).EUt(GTValues.VA[1]).inputItems((class_6862<class_1792>)class_3489.field_25808, 6).inputItems(TagPrefix.dust, GTMaterials.Redstone, 2).inputItems(TagPrefix.plate, GTMaterials.NetherQuartz).outputItems(new class_1799((class_1935)class_2246.field_10282)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("observer_certus_quartz", new Object[0]).duration(100).EUt(GTValues.VA[1]).inputItems((class_6862<class_1792>)class_3489.field_25808, 6).inputItems(TagPrefix.dust, GTMaterials.Redstone, 2).inputItems(TagPrefix.plate, GTMaterials.CertusQuartz).outputItems(new class_1799((class_1935)class_2246.field_10282)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("observer_quartzite", new Object[0]).duration(100).EUt(GTValues.VA[1]).inputItems((class_6862<class_1792>)class_3489.field_25808, 6).inputItems(TagPrefix.dust, GTMaterials.Redstone, 2).inputItems(TagPrefix.plate, GTMaterials.Quartzite).outputItems(new class_1799((class_1935)class_2246.field_10282)).save(provider);
        }
    }

    private static void hardGlassRecipes(Consumer<class_2444> provider) {
    }

    private static void nerfPaperCrafting(Consumer<class_2444> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "paper_dust", ChemicalHelper.get(TagPrefix.dust, GTMaterials.Paper, 2), "SSS", " m ", Character.valueOf('S'), new class_1799((class_1935)class_1802.field_17531));
        VanillaRecipeHelper.addShapedRecipe(provider, "sugar", ChemicalHelper.get(TagPrefix.dust, GTMaterials.Sugar, 1), "Sm ", Character.valueOf('S'), new class_1799((class_1935)class_1802.field_17531));
        VanillaRecipeHelper.addShapedRecipe(provider, "paper", new class_1799((class_1935)class_1802.field_8407, 2), " r ", "SSS", " B ", Character.valueOf('S'), new UnificationEntry(TagPrefix.dust, GTMaterials.Paper), Character.valueOf('B'), new class_1799((class_1935)class_1802.field_8705));
    }

    private static void hardAdvancedIronRecipes(Consumer<class_2444> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "iron_door", new class_1799((class_1935)class_1802.field_8594), "PTh", "PRS", "PPd", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('T'), new class_1799((class_1935)class_2246.field_10576), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Steel), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Steel));
        VanillaRecipeHelper.addShapedRecipe(provider, "anvil", new class_1799((class_1935)class_2246.field_10535), "BBB", "SBS", "PBP", Character.valueOf('B'), new UnificationEntry(TagPrefix.block, GTMaterials.Iron), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "iron_trapdoor", new class_1799((class_1935)class_2246.field_10453), "SPS", "PTP", "sPd", Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('T'), class_3489.field_15550);
        VanillaRecipeHelper.addShapedRecipe(provider, "minecart", new class_1799((class_1935)class_1802.field_8045), "RhR", "PwP", "RPR", Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron));
    }

    private static void hardDyeRecipes(Consumer<class_2444> provider) {
    }

    private static void harderCharcoalRecipes(Consumer<class_2444> provider) {
    }

    private static void flintAndSteelRequireSteel(Consumer<class_2444> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "flint_and_steel", new class_1799((class_1935)class_1802.field_8884), "G", "F", "S", Character.valueOf('G'), new UnificationEntry(TagPrefix.gearSmall, GTMaterials.Steel), Character.valueOf('F'), new class_1799((class_1935)class_1802.field_8145), Character.valueOf('S'), new UnificationEntry(TagPrefix.springSmall, GTMaterials.Steel));
    }

    private static void removeVanillaBlockRecipes(Consumer<class_2444> provider) {
    }

    private static void createShovelRecipe(Consumer<class_2444> provider, String regName, class_1799 output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, regName, output, "hPf", " S ", " S ", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600));
    }

    private static void createPickaxeRecipe(Consumer<class_2444> provider, String regName, class_1799 output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, regName, output, "PII", "hSf", " S ", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material), Character.valueOf('I'), new UnificationEntry(material.equals(GTMaterials.Diamond) ? TagPrefix.gem : TagPrefix.ingot, material), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600));
    }

    private static void createAxeRecipe(Consumer<class_2444> provider, String regName, class_1799 output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, regName, output, "PIf", "PS ", "hS ", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material), Character.valueOf('I'), new UnificationEntry(material.equals(GTMaterials.Diamond) ? TagPrefix.gem : TagPrefix.ingot, material), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600));
    }

    private static void createSwordRecipe(Consumer<class_2444> provider, String regName, class_1799 output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, regName, output, " P ", "hPf", " S ", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600));
    }

    private static void createHoeRecipe(Consumer<class_2444> provider, String regName, class_1799 output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, regName, output, "PIf", "hS ", " S ", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material), Character.valueOf('I'), new UnificationEntry(material.equals(GTMaterials.Diamond) ? TagPrefix.gem : TagPrefix.ingot, material), Character.valueOf('S'), new class_1799((class_1935)class_1802.field_8600));
    }

    private static void createHelmetRecipe(Consumer<class_2444> provider, String regName, class_1799 output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, regName, output, "PPP", "PhP", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material));
    }

    private static void createChestplateRecipe(Consumer<class_2444> provider, String regName, class_1799 output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, regName, output, "PhP", "PPP", "PPP", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material));
    }

    private static void createLeggingsRecipe(Consumer<class_2444> provider, String regName, class_1799 output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, regName, output, "PPP", "PhP", "P P", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material));
    }

    private static void createBootsRecipe(Consumer<class_2444> provider, String regName, class_1799 output, Material material) {
        VanillaRecipeHelper.addShapedRecipe(provider, regName, output, "P P", "PhP", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material));
    }
}

