/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.core.mixins;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKey;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.core.IGTTagLoader;
import com.gregtechceu.gtceu.core.MixinHelpers;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_3497;
import net.minecraft.class_3503;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3503.class})
public class TagLoaderMixin<T>
implements IGTTagLoader<T> {
    @Unique
    @Nullable
    private class_2378<T> gtceu$storedRegistry;

    @Inject(method={"load"}, at={@At(value="RETURN")})
    public void gtceu$load(class_3300 resourceManager, CallbackInfoReturnable<Map<class_2960, List<class_3503.class_5145>>> cir) {
        Map tagMap = (Map)cir.getReturnValue();
        if (this.gtceu$getRegistry() == null) {
            return;
        }
        if (this.gtceu$getRegistry() == class_7923.field_41178) {
            ChemicalHelper.UNIFICATION_ENTRY_ITEM.forEach((entry, itemLikes) -> {
                if (itemLikes.isEmpty()) {
                    return;
                }
                Material material = entry.material;
                if (material != null) {
                    class_6862<class_1792>[] materialTags;
                    for (class_6862<class_1792> materialTag : materialTags = entry.tagPrefix.getAllItemTags(material)) {
                        ArrayList tags = new ArrayList();
                        itemLikes.forEach(item -> tags.add(new class_3503.class_5145(class_3497.method_43937((class_2960)class_7923.field_41178.method_10221((Object)item.method_8389())), "GTCEu Custom Tags")));
                        tagMap.computeIfAbsent(materialTag.comp_327(), path -> new ArrayList()).addAll(tags);
                    }
                }
            });
            GTItems.TOOL_ITEMS.rowMap().forEach((material, map) -> map.forEach((type, item) -> {
                if (item != null) {
                    class_3503.class_5145 entry = new class_3503.class_5145(class_3497.method_43937((class_2960)item.getId()), "GTCEu Custom Tags");
                    for (class_6862<class_1792> tag : type.itemTags) {
                        tagMap.computeIfAbsent(tag.comp_327(), path -> new ArrayList()).add(entry);
                    }
                }
            }));
        } else if (this.gtceu$getRegistry() == class_7923.field_41175) {
            GTBlocks.MATERIAL_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockTags(tagMap, prefix, map));
            GTBlocks.CABLE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockTags(tagMap, prefix, map));
            GTBlocks.FLUID_PIPE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockTags(tagMap, prefix, map));
            GTBlocks.ITEM_PIPE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockTags(tagMap, prefix, map));
            GTRegistries.MACHINES.forEach(machine -> {
                class_2960 id = machine.getId();
                tagMap.computeIfAbsent(GTToolType.WRENCH.harvestTags.get(0).comp_327(), path -> new ArrayList()).add(new class_3503.class_5145(class_3497.method_43937((class_2960)id), "GTCEu Custom Tags"));
                if (!ConfigHolder.INSTANCE.machines.requireGTToolsForBlocks) {
                    tagMap.computeIfAbsent(class_3481.field_33715.comp_327(), path -> new ArrayList()).add(new class_3503.class_5145(class_3497.method_43937((class_2960)id), "GTCEu Custom Tags"));
                }
            });
            GTBlocks.ALL_FUSION_CASINGS.forEach((casingType, block) -> {
                class_2960 blockId = class_7923.field_41175.method_10221((Object)((class_2248)block.get()));
                tagMap.computeIfAbsent(CustomTags.TOOL_TIERS[casingType.getHarvestLevel()].comp_327(), path -> new ArrayList()).add(new class_3503.class_5145(class_3497.method_43937((class_2960)blockId), "GTCEu Custom Tags"));
            });
        } else if (this.gtceu$getRegistry() == class_7923.field_41173) {
            for (Material material2 : GTRegistries.MATERIALS) {
                if (!material2.hasProperty(PropertyKey.FLUID)) continue;
                FluidProperty property = material2.getProperty(PropertyKey.FLUID);
                for (FluidStorageKey key : FluidStorageKey.allKeys()) {
                    class_3611 fluid = property.getStorage().get(key);
                    if (fluid == null) continue;
                    ChemicalHelper.FLUID_MATERIAL.put(fluid, material2);
                    class_2960 fluidId = class_7923.field_41173.method_10221((Object)fluid);
                    tagMap.computeIfAbsent(TagUtil.createFluidTag(fluidId.method_12832()).comp_327(), path -> new ArrayList()).add(new class_3503.class_5145(class_3497.method_43937((class_2960)fluidId), "GTCEu Custom Tags"));
                }
            }
        }
    }

    @Override
    @Nullable
    public class_2378<T> gtceu$getRegistry() {
        return this.gtceu$storedRegistry;
    }

    @Override
    public void gtceu$setRegistry(class_2378<T> registry) {
        this.gtceu$storedRegistry = registry;
    }
}

