/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.recipe;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.capability.ICleanroomReceiver;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.ICleanroomProvider;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.config.ConfigHolder;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3518;
import org.jetbrains.annotations.NotNull;

public class CleanroomCondition
extends RecipeCondition {
    public static final CleanroomCondition INSTANCE = new CleanroomCondition();
    private CleanroomType cleanroom = CleanroomType.CLEANROOM;

    @Override
    public String getType() {
        return "cleanroom";
    }

    @Override
    public class_2561 getTooltips() {
        return this.cleanroom == null ? null : class_2561.method_43469((String)"gtceu.recipe.cleanroom", (Object[])new Object[]{class_2561.method_43471((String)this.cleanroom.getTranslationKey())});
    }

    @Override
    public boolean test(@NotNull GTRecipe recipe, @NotNull RecipeLogic recipeLogic) {
        MetaMachine machine = recipeLogic.getMachine();
        if (machine instanceof ICleanroomReceiver) {
            ICleanroomReceiver receiver = (ICleanroomReceiver)((Object)machine);
            if (this.cleanroom != null) {
                if (ConfigHolder.INSTANCE.machines.cleanMultiblocks && machine instanceof IMultiController) {
                    return true;
                }
                ICleanroomProvider provider = receiver.getCleanroom();
                if (provider == null) {
                    return false;
                }
                return provider.isClean() && provider.getTypes().contains(this.cleanroom);
            }
        }
        return true;
    }

    @Override
    @NotNull
    public JsonObject serialize() {
        JsonObject value = super.serialize();
        value.addProperty("cleanroom", this.cleanroom.getName());
        return value;
    }

    @Override
    public RecipeCondition deserialize(@NotNull JsonObject config) {
        super.deserialize(config);
        this.cleanroom = CleanroomType.getByNameOrDefault(class_3518.method_15253((JsonObject)config, (String)"cleanroom", (String)"cleanroom"));
        return this;
    }

    @Override
    public void toNetwork(class_2540 buf) {
        super.toNetwork(buf);
        buf.method_10814(this.cleanroom.getName());
    }

    @Override
    public RecipeCondition fromNetwork(class_2540 buf) {
        super.fromNetwork(buf);
        this.cleanroom = CleanroomType.getByNameOrDefault(buf.method_19772());
        return this;
    }

    @Override
    public RecipeCondition createTemplate() {
        return new CleanroomCondition();
    }

    public CleanroomCondition(CleanroomType cleanroom) {
        this.cleanroom = cleanroom;
    }

    public CleanroomCondition() {
    }

    public CleanroomType getCleanroom() {
        return this.cleanroom;
    }
}

