/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.fluidpipe;

import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.api.misc.RateCounter;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.FluidPipeData;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.FluidPipeNetWalker;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.PipeNetRoutePath;
import com.lowdragmc.lowdraglib.pipelike.LevelPipeNet;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;

public class FluidPipeNet
extends PipeNet<FluidPipeData> {
    private final Map<class_2338, List<PipeNetRoutePath>> NET_DATA = new HashMap<class_2338, List<PipeNetRoutePath>>();
    private final Long2ObjectMap<class_3611[]> channelFluidsByBlock = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<RateCounter[]> throughputsCountersByBlock = new Long2ObjectOpenHashMap();
    private long lastUpdate;

    public FluidPipeNet(LevelPipeNet<FluidPipeData, ? extends PipeNet> world) {
        super(world);
        this.lastUpdate = world.getWorld().method_8510();
    }

    public List<PipeNetRoutePath> getNetData(class_2338 pipePos) {
        List<PipeNetRoutePath> data = this.NET_DATA.get(pipePos);
        if (data == null) {
            data = FluidPipeNetWalker.createNetData(this, pipePos);
            if (data == null) {
                return Collections.emptyList();
            }
            data.sort(Comparator.comparingInt(PipeNetRoutePath::getDistance));
            this.NET_DATA.put(pipePos, data);
        }
        return data;
    }

    public void onNeighbourUpdate(class_2338 fromPos) {
        this.NET_DATA.clear();
    }

    public void onPipeConnectionsUpdate() {
        this.NET_DATA.clear();
    }

    public long getLastSecondTotalThroughput(class_2338 blockPos, int channel) {
        return this.getThroughputCounters(blockPos.method_10063())[channel].getUsedSum();
    }

    public int getChannel(class_2338 pos, class_3611 fluid) {
        this.updateTick();
        class_3611[] channelFluids = this.getChannelFluids(pos.method_10063());
        for (int channel = 0; channel < channelFluids.length; ++channel) {
            if (channelFluids[channel] == null || !channelFluids[channel].equals(fluid)) continue;
            return channel;
        }
        return -1;
    }

    public int useChannel(class_2338 pos, class_3611 fluid) {
        int channel = this.getChannel(pos, fluid);
        if (channel != -1) {
            return channel;
        }
        int newChannel = this.findBestFreeChannel(pos.method_10063());
        if (newChannel == -1) {
            return -1;
        }
        this.getChannelFluids((long)pos.method_10063())[newChannel] = fluid;
        return newChannel;
    }

    public void useThroughput(class_2338 pos, int channel, long amount) {
        this.updateTick();
        this.getThroughputCounters(pos.method_10063())[channel].addUsed(amount);
    }

    public class_3611 getFluid(class_2338 pos, int channel) {
        this.updateTick();
        return this.getChannelFluids(pos.method_10063())[channel];
    }

    private void updateTick() {
        long latestTime = this.getWorldData().getWorld().method_8510();
        if (this.lastUpdate == latestTime) {
            return;
        }
        this.channelFluidsByBlock.forEach((k, v) -> Arrays.fill(v, null));
        this.lastUpdate = latestTime;
    }

    @NotNull
    private RateCounter[] getThroughputCounters(long blockPos) {
        return (RateCounter[])this.throughputsCountersByBlock.computeIfAbsent(blockPos, bp -> (RateCounter[])Stream.generate(() -> new RateCounter(() -> this.getLevel().method_8510(), 20)).limit(9L).toArray(RateCounter[]::new));
    }

    private class_3611[] getChannelFluids(long blockPos) {
        return (class_3611[])this.channelFluidsByBlock.computeIfAbsent(blockPos, bp -> new class_3611[9]);
    }

    private long[] getLastSecondTotalUsagePerChannel(long blockPos) {
        return Arrays.stream(this.getThroughputCounters(blockPos)).mapToLong(RateCounter::getUsedSum).toArray();
    }

    private int findBestFreeChannel(long pos) {
        class_3611[] channelFluids = this.getChannelFluids(pos);
        long[] lastSecondUsagePerChannel = this.getLastSecondTotalUsagePerChannel(pos);
        long leastUsedAmount = Long.MAX_VALUE;
        int bestChannel = -1;
        FluidPipeData nodeData = (FluidPipeData)this.getNodeAt((class_2338)class_2338.method_10092((long)pos)).data;
        for (int channel = 0; channel < nodeData.properties.getChannels(); ++channel) {
            if (channelFluids[channel] != null || lastSecondUsagePerChannel[channel] >= leastUsedAmount) continue;
            leastUsedAmount = lastSecondUsagePerChannel[channel];
            bestChannel = channel;
        }
        return bestChannel;
    }

    protected void writeNodeData(FluidPipeData nodeData, class_2487 tagCompound) {
        tagCompound.method_10569("max_temperature", nodeData.properties.getMaxFluidTemperature());
        tagCompound.method_10544("throughput", nodeData.properties.getThroughput());
        tagCompound.method_10556("gas_proof", nodeData.properties.isGasProof());
        tagCompound.method_10556("acid_proof", nodeData.properties.isAcidProof());
        tagCompound.method_10556("cryo_proof", nodeData.properties.isCryoProof());
        tagCompound.method_10556("plasma_proof", nodeData.properties.isPlasmaProof());
        tagCompound.method_10569("channels", nodeData.properties.getChannels());
        tagCompound.method_10567("connections", nodeData.connections());
    }

    protected FluidPipeData readNodeData(class_2487 tagCompound) {
        int maxTemperature = tagCompound.method_10550("max_temperature");
        long throughput = tagCompound.method_10537("throughput");
        boolean gasProof = tagCompound.method_10577("gas_proof");
        boolean acidProof = tagCompound.method_10577("acid_proof");
        boolean cryoProof = tagCompound.method_10577("cryo_proof");
        boolean plasmaProof = tagCompound.method_10577("plasma_proof");
        int channels = tagCompound.method_10550("channels");
        return new FluidPipeData(new FluidPipeProperties(maxTemperature, throughput, gasProof, acidProof, cryoProof, plasmaProof, channels), tagCompound.method_10571("connections"));
    }

    public Snapshot createSnapshot() {
        Long2ObjectOpenHashMap channelUsedCopied = new Long2ObjectOpenHashMap();
        this.channelFluidsByBlock.forEach((arg_0, arg_1) -> FluidPipeNet.lambda$createSnapshot$6((Long2ObjectMap)channelUsedCopied, arg_0, arg_1));
        Long2ObjectOpenHashMap throughputCountersCopied = new Long2ObjectOpenHashMap();
        this.throughputsCountersByBlock.forEach((k, v) -> throughputCountersCopied.put(k.longValue(), (Object)((RateCounter[])Arrays.stream(v).map(RateCounter::copy).toArray(RateCounter[]::new))));
        return new Snapshot((Long2ObjectMap<class_3611[]>)channelUsedCopied, (Long2ObjectMap<RateCounter[]>)throughputCountersCopied);
    }

    public void resetData(Snapshot snapshot) {
        this.channelFluidsByBlock.clear();
        this.channelFluidsByBlock.putAll(snapshot.channelFluids);
        this.throughputsCountersByBlock.clear();
        this.throughputsCountersByBlock.putAll(snapshot.throughputCounters);
    }

    private static /* synthetic */ void lambda$createSnapshot$6(Long2ObjectMap channelUsedCopied, Long k, class_3611[] v) {
        channelUsedCopied.put(k.longValue(), (Object)Arrays.copyOf(v, v.length));
    }

    public record Snapshot(Long2ObjectMap<class_3611[]> channelFluids, Long2ObjectMap<RateCounter[]> throughputCounters) {
    }
}

