/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait.miner;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.IMiner;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.misc.IgnoreEnergyRecipeHandler;
import com.gregtechceu.gtceu.api.misc.ItemRecipeHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.misc.ItemTransferList;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class MinerLogic
extends RecipeLogic
implements IRecipeCapabilityHolder {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MinerLogic.class, RecipeLogic.MANAGED_FIELD_HOLDER);
    private static final short MAX_SPEED = Short.MAX_VALUE;
    private static final byte POWER = 5;
    private static final byte TICK_TOLERANCE = 20;
    private static final double DIVIDEND = 32767.0 * Math.pow(20.0, 5.0);
    protected final IMiner miner;
    @Nullable
    private ItemTransferList cachedItemTransfer = null;
    private final int fortune;
    private final int speed;
    private final int maximumRadius;
    public class_1799 pickaxeTool;
    private final LinkedList<class_2338> blocksToMine = new LinkedList();
    @Persisted
    protected int x = Integer.MAX_VALUE;
    @Persisted
    protected int y = Integer.MAX_VALUE;
    @Persisted
    protected int z = Integer.MAX_VALUE;
    @Persisted
    protected int startX = Integer.MAX_VALUE;
    @Persisted
    protected int startZ = Integer.MAX_VALUE;
    @Persisted
    protected int startY = Integer.MAX_VALUE;
    @Persisted
    protected int pipeY = Integer.MAX_VALUE;
    @Persisted
    protected int mineX = Integer.MAX_VALUE;
    @Persisted
    protected int mineZ = Integer.MAX_VALUE;
    @Persisted
    protected int mineY = Integer.MAX_VALUE;
    private int minBuildHeight = Integer.MAX_VALUE;
    @Persisted
    private int pipeLength = 0;
    @Persisted
    private int currentRadius;
    @Persisted
    private boolean isDone;
    private boolean isInventoryFull;
    private final Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> capabilitiesProxy;
    private final ItemRecipeHandler inputItemHandler;
    private final ItemRecipeHandler outputItemHandler;
    private final IgnoreEnergyRecipeHandler inputEnergyHandler;

    public MinerLogic(@Nonnull IRecipeLogicMachine machine, int fortune, int speed, int maximumRadius) {
        super(machine);
        this.miner = (IMiner)machine;
        this.fortune = fortune;
        this.speed = speed;
        this.currentRadius = maximumRadius;
        this.maximumRadius = maximumRadius;
        this.isDone = false;
        this.pickaxeTool = ((ItemProviderEntry)GTItems.TOOL_ITEMS.get((Object)GTMaterials.Neutronium, (Object)GTToolType.PICKAXE)).asStack();
        this.pickaxeTool.method_7978(class_1893.field_9130, fortune);
        this.capabilitiesProxy = Tables.newCustomTable(new EnumMap(IO.class), HashMap::new);
        this.inputItemHandler = new ItemRecipeHandler(IO.IN, machine.getRecipeType().getMaxInputs(ItemRecipeCapability.CAP));
        this.outputItemHandler = new ItemRecipeHandler(IO.OUT, machine.getRecipeType().getMaxOutputs(ItemRecipeCapability.CAP));
        this.inputEnergyHandler = new IgnoreEnergyRecipeHandler();
        this.capabilitiesProxy.put((Object)IO.IN, this.inputItemHandler.getCapability(), List.of(this.inputItemHandler));
        this.capabilitiesProxy.put((Object)IO.IN, this.inputEnergyHandler.getCapability(), List.of(this.inputEnergyHandler));
        this.capabilitiesProxy.put((Object)IO.OUT, this.inputItemHandler.getCapability(), List.of(this.outputItemHandler));
    }

    @Override
    public void resetRecipeLogic() {
        super.resetRecipeLogic();
        this.resetArea();
        this.cachedItemTransfer = null;
        this.pipeLength = 0;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void inValid() {
        super.inValid();
        this.cachedItemTransfer = null;
        this.pipeLength = 0;
    }

    private static class_2680 findMiningReplacementBlock(class_1937 level) {
        try {
            return class_2259.method_41957((class_7225)level.method_45448(class_7924.field_41254), (String)ConfigHolder.INSTANCE.machines.replaceMinedBlocksWith, (boolean)false).comp_622();
        }
        catch (CommandSyntaxException ignored) {
            GTCEu.LOGGER.error("failed to parse replaceMinedBlocksWith, invalid BlockState: {}", (Object)ConfigHolder.INSTANCE.machines.replaceMinedBlocksWith);
            return class_2246.field_10445.method_9564();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void serverTick() {
        block10: {
            class_2680 blockState;
            class_2371 blockDrops;
            class_3218 serverLevel;
            block11: {
                block9: {
                    class_1937 class_19372;
                    if (this.isSuspend() || !((class_19372 = this.getMachine().getLevel()) instanceof class_3218)) break block9;
                    serverLevel = (class_3218)class_19372;
                    if (!this.checkCanMine()) break block9;
                    if (!this.isInventoryFull()) {
                        this.miner.drainInput(false);
                        this.setStatus(RecipeLogic.Status.WORKING);
                    } else if (this.isWorking()) {
                        this.setWaiting((class_2561)class_2561.method_43471((String)"gtceu.recipe_logic.insufficient_out").method_27693(": ").method_10852(ItemRecipeCapability.CAP.getTraslateComponent()));
                    }
                    if (this.mineY < this.pipeY) {
                        class_2338 miningPos = this.getMiningPos();
                        serverLevel.method_22352(new class_2338(miningPos.method_10263(), this.pipeY, miningPos.method_10260()), false);
                        --this.pipeY;
                        this.incrementPipeLength();
                    }
                    this.checkBlocksToMine();
                    if (this.getMachine().getOffsetTimer() % (long)this.speed != 0L || this.blocksToMine.isEmpty()) break block10;
                    blockDrops = class_2371.method_10211();
                    blockState = serverLevel.method_8320(this.blocksToMine.getFirst());
                    break block11;
                }
                this.setStatus(RecipeLogic.Status.IDLE);
                if (this.subscription == null) return;
                this.subscription.unsubscribe();
                this.subscription = null;
                return;
            }
            while (!blockState.method_26164(CustomTags.ORE_BLOCKS)) {
                this.blocksToMine.removeFirst();
                if (this.blocksToMine.isEmpty()) break;
                blockState = serverLevel.method_8320(this.blocksToMine.getFirst());
            }
            if (!this.blocksToMine.isEmpty() & blockState.method_26164(CustomTags.ORE_BLOCKS)) {
                class_8567.class_8568 builder = new class_8567.class_8568(serverLevel).method_51874(class_181.field_1224, (Object)blockState).method_51874(class_181.field_24424, (Object)class_243.method_24954((class_2382)((class_2382)this.blocksToMine.getFirst()))).method_51874(class_181.field_1229, (Object)this.getPickaxeTool());
                this.getSmallOreBlockDrops((class_2371<class_1799>)blockDrops, blockState, builder);
                if (this.isSilkTouchMode()) {
                    this.getSilkTouchDrops((class_2371<class_1799>)blockDrops, blockState, builder);
                } else {
                    this.getRegularBlockDrops((class_2371<class_1799>)blockDrops, blockState, builder);
                }
                if (this.hasPostProcessing()) {
                    this.doPostProcessing((class_2371<class_1799>)blockDrops, blockState, builder);
                }
                this.mineAndInsertItems((class_2371<class_1799>)blockDrops, serverLevel);
            }
        }
        if (!this.blocksToMine.isEmpty()) return;
        this.x = this.mineX;
        this.y = this.mineY;
        this.z = this.mineZ;
        this.blocksToMine.addAll(this.getBlocksToMine());
        if (!this.blocksToMine.isEmpty()) return;
        this.isDone = true;
        this.setStatus(RecipeLogic.Status.IDLE);
    }

    protected boolean checkCanMine() {
        if (!this.isDone && this.checkCoordinatesInvalid()) {
            this.initPos(this.getMiningPos(), this.currentRadius);
        }
        return !this.isDone && this.miner.drainInput(true);
    }

    protected void onMineOperation() {
    }

    protected void getSmallOreBlockDrops(class_2371<class_1799> blockDrops, class_2680 blockState, class_8567.class_8568 builder) {
    }

    protected boolean hasPostProcessing() {
        return false;
    }

    protected boolean isSilkTouchMode() {
        return false;
    }

    protected void getRegularBlockDrops(class_2371<class_1799> blockDrops, class_2680 blockState, class_8567.class_8568 builder) {
        blockDrops.addAll((Collection)blockState.method_26189(builder));
    }

    protected int getVoltageTier() {
        return 0;
    }

    protected boolean doPostProcessing(class_2371<class_1799> blockDrops, class_2680 blockState, class_8567.class_8568 builder) {
        class_1799 oreDrop = (class_1799)blockDrops.get(0);
        this.inputItemHandler.storage.setStackInSlot(0, oreDrop);
        this.inputItemHandler.storage.onContentsChanged(0);
        this.outputItemHandler.storage.setStackInSlot(0, class_1799.field_8037);
        this.outputItemHandler.storage.onContentsChanged(0);
        List<GTRecipe> matches = this.machine.getRecipeType().searchRecipe(this.getRecipeManager(), this);
        for (GTRecipe match : matches) {
            long eut = RecipeHelper.getInputEUt(match);
            if (GTUtil.getTierByVoltage(eut) > this.getVoltageTier() || !match.handleRecipeIO(IO.OUT, this)) continue;
            blockDrops.clear();
            ArrayList<class_1799> result = new ArrayList<class_1799>();
            for (int i = 0; i < this.outputItemHandler.storage.getSlots(); ++i) {
                class_1799 stack = this.outputItemHandler.storage.getStackInSlot(i);
                if (stack.method_7960()) continue;
                result.add(stack);
            }
            this.dropPostProcessing(blockDrops, result, blockState, builder);
            return true;
        }
        return false;
    }

    protected void dropPostProcessing(class_2371<class_1799> blockDrops, List<class_1799> outputs, class_2680 blockState, class_8567.class_8568 builder) {
        blockDrops.addAll(outputs);
    }

    protected void getSilkTouchDrops(class_2371<class_1799> blockDrops, class_2680 blockState, class_8567.class_8568 builder) {
        blockDrops.add((Object)new class_1799((class_1935)blockState.method_26204()));
    }

    protected ItemTransferList getCachedItemTransfer() {
        if (this.cachedItemTransfer == null) {
            this.cachedItemTransfer = new ItemTransferList(((List)this.machine.getCapabilitiesProxy().get((Object)IO.OUT, (Object)ItemRecipeCapability.CAP)).stream().map(IItemTransfer.class::cast).toList());
        }
        return this.cachedItemTransfer;
    }

    private void mineAndInsertItems(class_2371<class_1799> blockDrops, class_3218 world) {
        ItemTransferList transfer = this.getCachedItemTransfer();
        if (transfer != null) {
            if (GTTransferUtils.addItemsToItemHandler((IItemTransfer)transfer, true, blockDrops)) {
                GTTransferUtils.addItemsToItemHandler((IItemTransfer)transfer, false, blockDrops);
                world.method_8652(this.blocksToMine.getFirst(), MinerLogic.findMiningReplacementBlock((class_1937)world), 3);
                this.mineX = this.blocksToMine.getFirst().method_10263();
                this.mineZ = this.blocksToMine.getFirst().method_10260();
                this.mineY = this.blocksToMine.getFirst().method_10264();
                this.blocksToMine.removeFirst();
                this.onMineOperation();
                this.isInventoryFull = false;
            } else {
                this.isInventoryFull = true;
            }
        }
    }

    public void initPos(@Nonnull class_2338 pos, int currentRadius) {
        this.x = pos.method_10263() - currentRadius;
        this.z = pos.method_10260() - currentRadius;
        this.y = pos.method_10264() - 1;
        this.startX = pos.method_10263() - currentRadius;
        this.startZ = pos.method_10260() - currentRadius;
        this.startY = pos.method_10264();
        this.pipeY = pos.method_10264() - 1;
        this.mineX = pos.method_10263() - currentRadius;
        this.mineZ = pos.method_10260() - currentRadius;
        this.mineY = pos.method_10264() - 1;
        this.onRemove();
    }

    private boolean checkCoordinatesInvalid() {
        return this.x == Integer.MAX_VALUE && this.y == Integer.MAX_VALUE && this.z == Integer.MAX_VALUE;
    }

    public void checkBlocksToMine() {
        if (this.blocksToMine.isEmpty()) {
            this.blocksToMine.addAll(this.getBlocksToMine());
        }
    }

    public void resetArea() {
        this.initPos(this.getMiningPos(), this.currentRadius);
        if (this.isDone) {
            this.setWorkingEnabled(false);
        }
        this.isDone = false;
        this.blocksToMine.clear();
        this.checkBlocksToMine();
    }

    private LinkedList<class_2338> getBlocksToMine() {
        LinkedList<class_2338> blocks = new LinkedList<class_2338>();
        double quotient = MinerLogic.getQuotient(MinerLogic.getMeanTickTime(this.getMachine().getLevel()));
        int calcAmount = quotient < 1.0 ? 1 : (int)Math.min(quotient, 32767.0);
        int calculated = 0;
        if (this.minBuildHeight == Integer.MAX_VALUE) {
            this.minBuildHeight = this.getMachine().getLevel().method_31607();
        }
        while (calculated < calcAmount) {
            if (this.y > this.minBuildHeight) {
                if (this.z <= this.startZ + this.currentRadius * 2) {
                    if (this.x <= this.startX + this.currentRadius * 2) {
                        class_2338 blockPos = new class_2338(this.x, this.y, this.z);
                        class_2680 state = this.getMachine().getLevel().method_8320(blockPos);
                        if (state.method_26204().method_36555() >= 0.0f && this.getMachine().getLevel().method_8321(blockPos) == null && state.method_26164(CustomTags.ORE_BLOCKS)) {
                            blocks.addLast(blockPos);
                        }
                        ++this.x;
                    } else {
                        this.x = this.startX;
                        ++this.z;
                    }
                } else {
                    this.z = this.startZ;
                    --this.y;
                }
            } else {
                return blocks;
            }
            if (blocks.isEmpty()) continue;
            ++calculated;
        }
        return blocks;
    }

    private static long mean(@Nonnull long[] values) {
        if ((long)values.length == 0L) {
            return 0L;
        }
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    private static double getMeanTickTime(@Nonnull class_1937 world) {
        return (double)MinerLogic.mean(Objects.requireNonNull(world.method_8503()).field_4573) * 1.0E-6;
    }

    private static double getQuotient(double base) {
        return DIVIDEND / Math.pow(base, 5.0);
    }

    private void incrementPipeLength() {
        ++this.pipeLength;
        class_1937 class_19372 = this.getMachine().getLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_2338 pos = this.getMiningPos().method_10079(class_2350.field_11033, this.pipeLength);
            serverLevel.method_8501(pos, GTBlocks.MINER_PIPE.getDefaultState());
        }
    }

    public class_2338 getMiningPos() {
        return this.getMachine().getPos();
    }

    public void onRemove() {
        this.pipeLength = 0;
        class_1937 class_19372 = this.getMachine().getLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_2338 pos = this.getMiningPos().method_10093(class_2350.field_11033);
            while (serverLevel.method_8320(pos).method_27852((class_2248)GTBlocks.MINER_PIPE.get())) {
                serverLevel.method_8650(pos, false);
                pos = pos.method_10093(class_2350.field_11033);
            }
        }
    }

    public int getFortune() {
        return this.fortune;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getMaximumRadius() {
        return this.maximumRadius;
    }

    public class_1799 getPickaxeTool() {
        return this.pickaxeTool;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int getStartX() {
        return this.startX;
    }

    public int getStartZ() {
        return this.startZ;
    }

    public int getStartY() {
        return this.startY;
    }

    public int getPipeY() {
        return this.pipeY;
    }

    public int getMineX() {
        return this.mineX;
    }

    public int getMineZ() {
        return this.mineZ;
    }

    public int getMineY() {
        return this.mineY;
    }

    public int getMinBuildHeight() {
        return this.minBuildHeight;
    }

    public int getPipeLength() {
        return this.pipeLength;
    }

    public int getCurrentRadius() {
        return this.currentRadius;
    }

    public void setCurrentRadius(int currentRadius) {
        this.currentRadius = currentRadius;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public boolean isInventoryFull() {
        return this.isInventoryFull;
    }

    @Override
    public Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> getCapabilitiesProxy() {
        return this.capabilitiesProxy;
    }
}

