/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.steam;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamBoilerMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class SteamLiquidBoilerMachine
extends SteamBoilerMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(SteamLiquidBoilerMachine.class, SteamBoilerMachine.MANAGED_FIELD_HOLDER);
    public static final Object2BooleanMap<class_3611> FUEL_CACHE = new Object2BooleanOpenHashMap();
    @Persisted
    public final NotifiableFluidTank fuelTank;

    public SteamLiquidBoilerMachine(IMachineBlockEntity holder, boolean isHighPressure, Object ... args) {
        super(holder, isHighPressure, args);
        this.fuelTank = this.createFuelTank(args).setFilter(fluid -> FUEL_CACHE.computeIfAbsent((Object)fluid.getFluid(), f -> {
            if (this.isRemote()) {
                return true;
            }
            return this.recipeLogic.getRecipeManager().method_30027((class_3956)this.getRecipeType()).stream().anyMatch(recipe -> {
                List list = recipe.inputs.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList());
                if (!list.isEmpty()) {
                    return Arrays.stream(((FluidIngredient)FluidRecipeCapability.CAP.of(((Content)list.get((int)0)).content)).getStacks()).anyMatch(stack -> stack.getFluid() == f);
                }
                return false;
            });
        }));
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableFluidTank createFuelTank(Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, 1, 16L * FluidHelper.getBucket(), IO.IN);
    }

    @Override
    protected long getBaseSteamOutput() {
        return this.isHighPressure ? 600 : 240;
    }

    @Override
    public ModularUI createUI(class_1657 entityPlayer) {
        return super.createUI(entityPlayer).widget((Widget)new TankWidget((IFluidStorage)this.fuelTank.storages[0], 119, 26, 10, 54, true, true).setShowAmount(false).setFillDirection(ProgressTexture.FillDirection.DOWN_TO_UP).setBackground((IGuiTexture)GuiTextures.PROGRESS_BAR_BOILER_EMPTY.get(this.isHighPressure)));
    }

    @Override
    protected void randomDisplayTick(class_5819 random, float x, float y, float z) {
        super.randomDisplayTick(random, x, y, z);
        if (random.method_43057() < 0.3f) {
            this.getLevel().method_8406((class_2394)class_2398.field_11239, (double)(x + random.method_43057()), (double)y, (double)(z + random.method_43057()), 0.0, 0.0, 0.0);
        }
    }
}

