/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.generator;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IRotorHolderMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3545;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class LargeTurbineMachine
extends WorkableElectricMultiblockMachine
implements ITieredMachine {
    public static final int MIN_DURABILITY_TO_WARN = 10;
    private final int BASE_EU_OUTPUT;
    private final int tier;
    private int excessVoltage;

    public LargeTurbineMachine(IMachineBlockEntity holder, int tier) {
        super(holder, new Object[0]);
        this.tier = tier;
        this.BASE_EU_OUTPUT = (int)GTValues.V[tier] * 2;
    }

    @Nullable
    private IRotorHolderMachine getRotorHolder() {
        for (IMultiPart part : this.getParts()) {
            if (!(part instanceof IRotorHolderMachine)) continue;
            IRotorHolderMachine rotorHolder = (IRotorHolderMachine)part;
            return rotorHolder;
        }
        return null;
    }

    @Override
    public long getOverclockVoltage() {
        IRotorHolderMachine rotorHolder = this.getRotorHolder();
        if (rotorHolder != null && rotorHolder.hasRotor()) {
            return (long)this.BASE_EU_OUTPUT * (long)rotorHolder.getTotalPower() / 100L;
        }
        return 0L;
    }

    protected long boostProduction(long production) {
        IRotorHolderMachine rotorHolder = this.getRotorHolder();
        if (rotorHolder != null && rotorHolder.hasRotor()) {
            int maxSpeed = rotorHolder.getMaxRotorHolderSpeed();
            int currentSpeed = rotorHolder.getRotorSpeed();
            if (currentSpeed >= maxSpeed) {
                return production;
            }
            return (long)((double)production * Math.pow(1.0 * (double)currentSpeed / (double)maxSpeed, 2.0));
        }
        return 0L;
    }

    @Nullable
    public static GTRecipe recipeModifier(MetaMachine machine, @Nonnull GTRecipe recipe) {
        if (machine instanceof LargeTurbineMachine) {
            LargeTurbineMachine turbineMachine = (LargeTurbineMachine)machine;
            IRotorHolderMachine rotorHolder = turbineMachine.getRotorHolder();
            long EUt = RecipeHelper.getOutputEUt(recipe);
            if (rotorHolder != null && EUt > 0L) {
                int turbineMaxVoltage = (int)turbineMachine.getOverclockVoltage();
                if (turbineMachine.excessVoltage >= turbineMaxVoltage) {
                    turbineMachine.excessVoltage -= turbineMaxVoltage;
                } else {
                    double holderEfficiency = (double)rotorHolder.getTotalEfficiency() / 100.0;
                    int maxParallel = (int)((double)(turbineMaxVoltage - turbineMachine.excessVoltage) / ((double)EUt * holderEfficiency));
                    turbineMachine.excessVoltage += (int)((double)((long)maxParallel * EUt) * holderEfficiency - (double)turbineMaxVoltage);
                    class_3545<GTRecipe, Integer> parallelResult = GTRecipeModifiers.fastParallel(turbineMachine, recipe, Math.max(1, maxParallel), false);
                    recipe = parallelResult.method_15442() == recipe ? recipe.copy() : (GTRecipe)parallelResult.method_15442();
                    long eut = turbineMachine.boostProduction((long)((double)EUt * holderEfficiency * (double)((Integer)parallelResult.method_15441()).intValue()));
                    recipe.tickOutputs.put(EURecipeCapability.CAP, List.of(new Content(eut, 1.0f, 0.0f, null, null)));
                    return recipe;
                }
            }
        }
        return null;
    }

    @Override
    public boolean dampingWhenWaiting() {
        return false;
    }

    @Override
    public boolean canVoidRecipeOutputs(RecipeCapability<?> capability) {
        return capability != EURecipeCapability.CAP;
    }

    @Override
    public void addDisplayText(List<class_2561> textList) {
        IRotorHolderMachine rotorHolder;
        super.addDisplayText(textList);
        if (this.isFormed() && (rotorHolder = this.getRotorHolder()) != null && rotorHolder.getRotorEfficiency() > 0) {
            int rotorDurability;
            textList.add((class_2561)class_2561.method_43469((String)"gtceu.multiblock.turbine.rotor_speed", (Object[])new Object[]{FormattingUtil.formatNumbers(rotorHolder.getRotorSpeed()), FormattingUtil.formatNumbers(rotorHolder.getMaxRotorHolderSpeed())}));
            textList.add((class_2561)class_2561.method_43469((String)"gtceu.multiblock.turbine.efficiency", (Object[])new Object[]{rotorHolder.getTotalEfficiency()}));
            long maxProduction = this.getOverclockVoltage();
            long currentProduction = this.isActive() ? this.boostProduction((int)maxProduction) : 0L;
            String voltageName = GTValues.VNF[GTUtil.getTierByVoltage(currentProduction)];
            if (this.isActive()) {
                textList.add(3, (class_2561)class_2561.method_43469((String)"gtceu.multiblock.turbine.energy_per_tick", (Object[])new Object[]{FormattingUtil.formatNumbers(currentProduction), voltageName}));
            }
            if ((rotorDurability = rotorHolder.getRotorDurabilityPercent()) > 10) {
                textList.add((class_2561)class_2561.method_43469((String)"gtceu.multiblock.turbine.rotor_durability", (Object[])new Object[]{rotorDurability}));
            } else {
                textList.add((class_2561)class_2561.method_43469((String)"gtceu.multiblock.turbine.rotor_durability", (Object[])new Object[]{rotorDurability}).method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
            }
        }
    }

    @Override
    public int getTier() {
        return this.tier;
    }
}

