/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.api.syncdata.UpdateListener;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3965;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class TransformerMachine
extends TieredEnergyMachine
implements IControllable {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(TransformerMachine.class, TieredEnergyMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    @UpdateListener(methodName="onTransformUpdated")
    private boolean isTransformUp;
    @Persisted
    private boolean isWorkingEnabled = true;
    private final int baseAmp;

    public TransformerMachine(IMachineBlockEntity holder, int tier, int baseAmp, Object ... args) {
        super(holder, tier, baseAmp, args);
        this.baseAmp = baseAmp;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    private void onTransformUpdated(boolean newValue, boolean oldValue) {
        this.scheduleRenderUpdate();
        this.updateEnergyContainer(newValue);
    }

    @Override
    protected NotifiableEnergyContainer createEnergyContainer(Object ... args) {
        int n;
        Object object;
        if (args.length > 0 && (object = args[0]) instanceof Integer) {
            Integer a = (Integer)object;
            n = a;
        } else {
            n = 1;
        }
        int amp = n;
        long tierVoltage = GTValues.V[this.getTier()];
        NotifiableEnergyContainer energyContainer = new NotifiableEnergyContainer(this, tierVoltage * 8L, tierVoltage * 4L, amp, tierVoltage, 4L * (long)amp);
        energyContainer.setSideInputCondition(s -> s == this.getFrontFacing() && this.isWorkingEnabled());
        energyContainer.setSideOutputCondition(s -> s != this.getFrontFacing() && this.isWorkingEnabled());
        return energyContainer;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.updateEnergyContainer(this.isTransformUp);
    }

    public void updateEnergyContainer(boolean isTransformUp) {
        long tierVoltage = GTValues.V[this.getTier()];
        if (isTransformUp) {
            this.energyContainer.resetBasicInfo(tierVoltage * 8L, tierVoltage, (long)this.baseAmp * 4L, tierVoltage * 4L, this.baseAmp);
            this.energyContainer.setSideInputCondition(s -> s != this.getFrontFacing() && this.isWorkingEnabled());
            this.energyContainer.setSideOutputCondition(s -> s == this.getFrontFacing() && this.isWorkingEnabled());
        } else {
            this.energyContainer.resetBasicInfo(tierVoltage * 8L, tierVoltage * 4L, this.baseAmp, tierVoltage, (long)this.baseAmp * 4L);
            this.energyContainer.setSideInputCondition(s -> s == this.getFrontFacing() && this.isWorkingEnabled());
            this.energyContainer.setSideOutputCondition(s -> s != this.getFrontFacing() && this.isWorkingEnabled());
        }
    }

    @Override
    public int tintColor(int index) {
        if (index == 2) {
            return GTValues.VC[this.getTier() + 1];
        }
        if (index == 3) {
            return GTValues.VC[this.getTier()];
        }
        return super.tintColor(index);
    }

    public void setTransformUp(boolean isTransformUp) {
        if (this.isTransformUp != isTransformUp && !this.isRemote()) {
            this.isTransformUp = isTransformUp;
            this.updateEnergyContainer(isTransformUp);
        }
    }

    @Override
    protected class_1269 onScrewdriverClick(class_1657 playerIn, class_1268 hand, class_2350 gridSide, class_3965 hitResult) {
        if (!this.isRemote()) {
            if (this.isTransformUp()) {
                this.setTransformUp(false);
                playerIn.method_43496((class_2561)class_2561.method_43469((String)"gtceu.machine.transformer.message_transform_down", (Object[])new Object[]{this.energyContainer.getInputVoltage(), this.energyContainer.getInputAmperage(), this.energyContainer.getOutputVoltage(), this.energyContainer.getOutputAmperage()}));
            } else {
                this.setTransformUp(true);
                playerIn.method_43496((class_2561)class_2561.method_43469((String)"gtceu.machine.transformer.message_transform_up", (Object[])new Object[]{this.energyContainer.getInputVoltage(), this.energyContainer.getInputAmperage(), this.energyContainer.getOutputVoltage(), this.energyContainer.getOutputAmperage()}));
            }
        }
        return class_1269.field_21466;
    }

    public boolean isTransformUp() {
        return this.isTransformUp;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingEnabled) {
        this.isWorkingEnabled = isWorkingEnabled;
    }

    public int getBaseAmp() {
        return this.baseAmp;
    }
}

