/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.detector;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.common.cover.detector.DetectorCover;
import com.gregtechceu.gtceu.utils.RedstoneUtil;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;

public class EnergyDetectorCover
extends DetectorCover {
    public EnergyDetectorCover(CoverDefinition definition, ICoverable coverHolder, class_2350 attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    @Override
    public boolean canAttach() {
        return this.getEnergyContainer() != null;
    }

    @Override
    protected void update() {
        if (this.coverHolder.getOffsetTimer() % 20L != 0L) {
            return;
        }
        IEnergyContainer energyContainer = this.getEnergyContainer();
        if (energyContainer != null) {
            long storedEnergy = energyContainer.getEnergyStored();
            long energyCapacity = energyContainer.getEnergyCapacity();
            if (energyCapacity == 0L) {
                return;
            }
            this.setRedstoneSignalOutput(RedstoneUtil.computeRedstoneValue(storedEnergy, energyCapacity, this.isInverted()));
        }
    }

    @Nullable
    protected IEnergyContainer getEnergyContainer() {
        return GTCapabilityHelper.getEnergyContainer(this.coverHolder.getLevel(), this.coverHolder.getPos(), this.attachedSide);
    }
}

