/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.gregtechceu.gtceu.common.machine.electric.TransformerMachine;
import com.lowdragmc.lowdraglib.client.bakedpipeline.FaceQuad;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;

public class TransformerRenderer
extends TieredHullMachineRenderer {
    public static final class_2960 ENERGY_IN = GTCEu.id("block/overlay/machine/overlay_energy_in");
    public static final class_2960 ENERGY_OUT = GTCEu.id("block/overlay/machine/overlay_energy_out");
    public static final class_2960 ENERGY_IN_HI = GTCEu.id("block/overlay/machine/overlay_energy_in_hi");
    public static final class_2960 ENERGY_OUT_HI = GTCEu.id("block/overlay/machine/overlay_energy_out_hi");
    public static final class_2960 ENERGY_IN_MULTI = GTCEu.id("block/overlay/machine/overlay_energy_in_multi");
    public static final class_2960 ENERGY_OUT_MULTI = GTCEu.id("block/overlay/machine/overlay_energy_out_multi");
    public static final class_2960 ENERGY_IN_ULTRA = GTCEu.id("block/overlay/machine/overlay_energy_in_ultra");
    public static final class_2960 ENERGY_OUT_ULTRA = GTCEu.id("block/overlay/machine/overlay_energy_out_ultra");
    private final int baseAmp;

    public TransformerRenderer(int tier, int baseAmp) {
        super(tier, GTCEu.id("block/machine/hull_machine"));
        this.baseAmp = baseAmp;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderMachine(List<class_777> quads, MachineDefinition definition, @Nullable MetaMachine machine, class_2350 frontFacing, @Nullable class_2350 side, class_5819 rand, class_2350 modelFacing, class_3665 modelState) {
        super.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
        class_2960 otherFaceTexture = ENERGY_OUT;
        class_2960 frontFaceTexture = ENERGY_IN_MULTI;
        boolean isTransformUp = false;
        if (machine instanceof TransformerMachine) {
            TransformerMachine transformer = (TransformerMachine)machine;
            isTransformUp = transformer.isTransformUp();
        }
        switch (this.baseAmp) {
            case 1: {
                otherFaceTexture = isTransformUp ? ENERGY_IN : otherFaceTexture;
                frontFaceTexture = isTransformUp ? ENERGY_OUT_MULTI : frontFaceTexture;
                break;
            }
            case 2: {
                otherFaceTexture = isTransformUp ? ENERGY_IN_MULTI : ENERGY_OUT_MULTI;
                frontFaceTexture = isTransformUp ? ENERGY_OUT_HI : ENERGY_IN_HI;
                break;
            }
            default: {
                otherFaceTexture = isTransformUp ? ENERGY_IN_HI : ENERGY_OUT_HI;
                class_2960 class_29602 = frontFaceTexture = isTransformUp ? ENERGY_OUT_ULTRA : ENERGY_IN_ULTRA;
            }
        }
        if (side == frontFacing && modelFacing != null) {
            quads.add(FaceQuad.bakeFace((class_2350)modelFacing, (class_1058)ModelFactory.getBlockSprite((class_2960)frontFaceTexture), (class_3665)modelState, (int)2));
        } else if (side != null && modelFacing != null) {
            quads.add(FaceQuad.bakeFace((class_2350)modelFacing, (class_1058)ModelFactory.getBlockSprite((class_2960)otherFaceTexture), (class_3665)modelState, (int)3));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onPrepareTextureAtlas(class_2960 atlasName, Consumer<class_2960> register) {
        super.onPrepareTextureAtlas(atlasName, register);
        if (atlasName.equals((Object)class_1059.field_5275)) {
            register.accept(ENERGY_IN);
            register.accept(ENERGY_OUT);
            register.accept(ENERGY_IN_MULTI);
            register.accept(ENERGY_OUT_MULTI);
            register.accept(ENERGY_IN_HI);
            register.accept(ENERGY_OUT_HI);
            register.accept(ENERGY_IN_ULTRA);
            register.accept(ENERGY_OUT_ULTRA);
        }
    }
}

