/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.block;

import com.google.gson.JsonElement;
import com.gregtechceu.gtceu.api.block.MaterialBlock;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconSet;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconType;
import com.gregtechceu.gtceu.data.pack.GTDynamicResourcePack;
import com.gregtechceu.gtceu.utils.GradientUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1011;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_4910;
import net.minecraft.class_4940;
import net.minecraft.class_4941;
import net.minecraft.class_7923;

public class MaterialBlockRenderer {
    public static final String LAYER_2_SUFFIX = "_layer2";
    private static final Set<MaterialBlockRenderer> MODELS = new HashSet<MaterialBlockRenderer>();
    private final class_2248 block;
    private final MaterialIconType type;
    private final MaterialIconSet iconSet;

    public static void create(class_2248 block, MaterialIconType type, MaterialIconSet iconSet) {
        MODELS.add(new MaterialBlockRenderer(block, type, iconSet));
    }

    public static void reinitModels() {
        for (MaterialBlockRenderer model : MODELS) {
            class_2960 blockId = class_7923.field_41175.method_10221((Object)model.block);
            class_2960 modelId = blockId.method_45138("block/");
            GTDynamicResourcePack.addBlockModel(modelId, (Supplier<JsonElement>)new class_4940(model.type.getBlockModelPath(model.iconSet, true)));
            GTDynamicResourcePack.addBlockState(blockId, (Supplier<JsonElement>)class_4910.method_25644((class_2248)model.block, (class_2960)modelId));
            GTDynamicResourcePack.addItemModel(class_7923.field_41178.method_10221((Object)model.block.method_8389()), (Supplier<JsonElement>)new class_4940(class_4941.method_25842((class_2248)model.block)));
        }
    }

    public static void initTextures() {
        for (MaterialBlockRenderer model : MODELS) {
            class_2960 blockId = class_7923.field_41175.method_10221((Object)model.block);
            class_3298 file1 = class_310.method_1551().method_1478().method_14486(GTDynamicResourcePack.getTextureLocation(null, model.type.getBlockTexturePath(model.iconSet, true))).orElse(null);
            if (file1 == null) continue;
            try {
                InputStream stream1 = file1.method_14482();
                try {
                    class_2248 class_22482 = model.block;
                    if (!(class_22482 instanceof MaterialBlock)) continue;
                    MaterialBlock materialBlock = (MaterialBlock)class_22482;
                    int materialRGBA = GradientUtil.argbToRgba(materialBlock.material.getMaterialARGB());
                    class_1011 image1 = class_1011.method_4309((InputStream)stream1);
                    try (class_1011 result = new class_1011(image1.method_4307(), image1.method_4323(), true);){
                        for (int x = 0; x < image1.method_4307(); ++x) {
                            for (int y = 0; y < image1.method_4323(); ++y) {
                                int color = image1.method_4315(x, y);
                                result.method_4305(x, y, GradientUtil.multiplyBlendRGBA(color, materialRGBA));
                            }
                        }
                        if (materialBlock.material.getMaterialSecondaryARGB() != -1) {
                            int materialSecondaryRGBA = GradientUtil.argbToRgba(materialBlock.material.getMaterialSecondaryARGB());
                            class_3298 file2 = class_310.method_1551().method_1478().method_14486(GTDynamicResourcePack.getTextureLocation(null, model.type.getBlockTexturePath(model.iconSet, true).method_48331(LAYER_2_SUFFIX))).orElse(null);
                            if (file2 != null) {
                                try (InputStream stream2 = file2.method_14482();){
                                    class_1011 image2 = class_1011.method_4309((InputStream)stream2);
                                    for (int x = 0; x < image1.method_4307(); ++x) {
                                        for (int y = 0; y < image1.method_4323(); ++y) {
                                            int color = image2.method_4315(x, y);
                                            result.method_35624(x, y, GradientUtil.multiplyBlendRGBA(color, materialSecondaryRGBA));
                                        }
                                    }
                                }
                            }
                        }
                        GTDynamicResourcePack.addBlockTexture(blockId, result.method_24036());
                    }
                }
                finally {
                    if (stream1 == null) continue;
                    stream1.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected MaterialBlockRenderer(class_2248 block, MaterialIconType type, MaterialIconSet iconSet) {
        this.block = block;
        this.type = type;
        this.iconSet = iconSet;
    }
}

