/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.sound;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.sound.ConfiguredSoundEvent;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class WrappedSoundEntry
extends SoundEntry {
    private final List<ConfiguredSoundEvent> wrappedEvents;
    private final List<CompiledSoundEvent> compiledEvents;

    public WrappedSoundEntry(class_2960 id, String subtitle, List<ConfiguredSoundEvent> wrappedEvents, class_3419 category, int attenuationDistance) {
        super(id, subtitle, category, attenuationDistance);
        this.wrappedEvents = wrappedEvents;
        this.compiledEvents = new ArrayList<CompiledSoundEvent>();
    }

    @Override
    public void prepare() {
        for (int i = 0; i < this.wrappedEvents.size(); ++i) {
            ConfiguredSoundEvent wrapped = this.wrappedEvents.get(i);
            class_2960 location = this.getIdOf(i);
            this.compiledEvents.add(new CompiledSoundEvent(class_3414.method_47908((class_2960)location), wrapped.volume(), wrapped.pitch()));
        }
    }

    @Override
    public void register(Consumer<class_3414> registry) {
        for (CompiledSoundEvent compiledEvent : this.compiledEvents) {
            registry.accept(compiledEvent.event());
        }
    }

    @Override
    public class_3414 getMainEvent() {
        return this.compiledEvents.get(0).event();
    }

    protected class_2960 getIdOf(int i) {
        return new class_2960(this.id.method_12836(), (String)(i == 0 ? this.id.method_12832() : this.id.method_12832() + "_compounded_" + i));
    }

    @Override
    public void write(JsonObject json) {
        for (int i = 0; i < this.wrappedEvents.size(); ++i) {
            ConfiguredSoundEvent event = this.wrappedEvents.get(i);
            JsonObject entry = new JsonObject();
            JsonArray list = new JsonArray();
            JsonObject s = new JsonObject();
            s.addProperty("name", event.event().get().method_14833().toString());
            s.addProperty("type", "event");
            if (this.attenuationDistance != 0) {
                s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
            }
            list.add((JsonElement)s);
            entry.add("sounds", (JsonElement)list);
            if (i == 0 && this.hasSubtitle()) {
                entry.addProperty("subtitle", this.getSubtitleKey());
            }
            json.add(this.getIdOf(i).method_12832(), (JsonElement)entry);
        }
    }

    @Override
    public void play(class_1937 world, class_1657 entity, double x, double y, double z, float volume, float pitch) {
        for (CompiledSoundEvent event : this.compiledEvents) {
            world.method_43128(entity, x, y, z, event.event(), this.category, event.volume() * volume, event.pitch() * pitch);
        }
    }

    @Override
    public void playAt(class_1937 world, double x, double y, double z, float volume, float pitch, boolean fade) {
        for (CompiledSoundEvent event : this.compiledEvents) {
            world.method_8486(x, y, z, event.event(), this.category, event.volume() * volume, event.pitch() * pitch, fade);
        }
    }

    private record CompiledSoundEvent(class_3414 event, float volume, float pitch) {
    }
}

