/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.core.mixins.ShapedRecipeAccessor;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_6319;
import net.minecraft.class_6328;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

@class_6328
@class_6319
public class ShapedEnergyTransferRecipe
extends class_1869 {
    public static final class_1865<ShapedEnergyTransferRecipe> SERIALIZER = new Serializer();
    @Nullable
    private class_8566 craftingContainer;
    private final class_1856 chargeIngredient;
    private final boolean transferMaxCharge;
    private final boolean overrideCharge;

    public ShapedEnergyTransferRecipe(class_2960 id, String group, int width, int height, class_1856 chargeIngredient, boolean overrideCharge, boolean transferMaxCharge, class_2371<class_1856> recipeItems, class_1799 result) {
        super(id, group, class_7710.field_40251, width, height, recipeItems, result);
        this.chargeIngredient = chargeIngredient;
        this.transferMaxCharge = transferMaxCharge;
        this.overrideCharge = overrideCharge;
    }

    public boolean method_17728(class_8566 inv, class_1937 level) {
        this.craftingContainer = inv;
        return super.method_17728(inv, level);
    }

    public class_1799 method_8110(class_5455 registryManager) {
        long maxCharge = 0L;
        long charge = 0L;
        if (this.craftingContainer == null) {
            final List items = this.method_8117().stream().map(i -> i.method_8105()[0]).collect(Collectors.toList());
            this.craftingContainer = new class_8566(){

                public int method_17398() {
                    return 3;
                }

                public int method_17397() {
                    return 3;
                }

                public List<class_1799> method_51305() {
                    return items;
                }

                public int method_5439() {
                    return 9;
                }

                public boolean method_5442() {
                    return false;
                }

                public class_1799 method_5438(int slot) {
                    return (class_1799)items.get(slot);
                }

                public class_1799 method_5434(int slot, int amount) {
                    ((class_1799)items.get(slot)).method_7934(amount);
                    return ((class_1799)items.get(slot)).method_7960() ? class_1799.field_8037 : (class_1799)items.get(slot);
                }

                public class_1799 method_5441(int slot) {
                    return items.set(slot, class_1799.field_8037);
                }

                public void method_5447(int slot, class_1799 stack) {
                    items.set(slot, stack);
                }

                public void method_5431() {
                }

                public boolean method_5443(class_1657 player) {
                    return true;
                }

                public void method_5448() {
                    for (int i = 0; i < items.size(); ++i) {
                        items.set(i, class_1799.field_8037);
                    }
                }

                public void method_7683(class_1662 helper) {
                    for (class_1799 stack : items) {
                        helper.method_7400(stack);
                    }
                }
            };
        }
        class_1799 resultStack = super.method_8110(registryManager);
        for (class_1799 chargeStack : this.chargeIngredient.method_8105()) {
            for (int i2 = 0; i2 < this.craftingContainer.method_5439(); ++i2) {
                class_1799 stack;
                IElectricItem electricItem;
                if (!class_1799.method_7984((class_1799)this.craftingContainer.method_5438(i2), (class_1799)chargeStack) || (electricItem = GTCapabilityHelper.getElectricItem(stack = this.craftingContainer.method_5438(i2))) == null) continue;
                resultStack.method_7948().method_10544("MaxCharge", maxCharge += electricItem.getMaxCharge());
                resultStack.method_7948().method_10544("Charge", charge += electricItem.getCharge());
                return resultStack;
            }
        }
        return resultStack;
    }

    public class_1856 getChargeIngredient() {
        return this.chargeIngredient;
    }

    public boolean isTransferMaxCharge() {
        return this.transferMaxCharge;
    }

    public boolean isOverrideCharge() {
        return this.overrideCharge;
    }

    public static class Serializer
    implements class_1865<ShapedEnergyTransferRecipe> {
        public ShapedEnergyTransferRecipe fromJson(class_2960 recipeId, JsonObject json) {
            String string = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            Map<String, class_1856> map = ShapedRecipeAccessor.callKeyFromJson(class_3518.method_15296((JsonObject)json, (String)"key"));
            String[] strings = ShapedRecipeAccessor.callPatternFromJson(class_3518.method_15261((JsonObject)json, (String)"pattern"));
            int i = strings[0].length();
            int j = strings.length;
            class_2371<class_1856> nonNullList = ShapedRecipeAccessor.callDissolvePattern(strings, map, i, j);
            boolean overrideCharge = class_3518.method_15270((JsonObject)json, (String)"overrideCharge");
            boolean transferMaxCharge = class_3518.method_15270((JsonObject)json, (String)"transferMaxCharge");
            class_1856 chargeIngredient = class_1856.method_52177((JsonElement)class_3518.method_15296((JsonObject)json, (String)"chargeIngredient"));
            class_1799 itemStack = ShapedEnergyTransferRecipe.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            return new ShapedEnergyTransferRecipe(recipeId, string, i, j, chargeIngredient, overrideCharge, transferMaxCharge, nonNullList, itemStack);
        }

        public ShapedEnergyTransferRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            int i = buffer.method_10816();
            int j = buffer.method_10816();
            boolean overrideCharge = buffer.readBoolean();
            boolean transferMaxCharge = buffer.readBoolean();
            class_1856 chargeIngredient = class_1856.method_8086((class_2540)buffer);
            String string = buffer.method_19772();
            class_2371 nonNullList = class_2371.method_10213((int)(i * j), (Object)class_1856.field_9017);
            nonNullList.replaceAll(ignored -> class_1856.method_8086((class_2540)buffer));
            class_1799 itemStack = buffer.method_10819();
            return new ShapedEnergyTransferRecipe(recipeId, string, i, j, chargeIngredient, overrideCharge, transferMaxCharge, (class_2371<class_1856>)nonNullList, itemStack);
        }

        public void toNetwork(class_2540 buffer, ShapedEnergyTransferRecipe recipe) {
            buffer.method_10804(recipe.method_8150());
            buffer.method_10804(recipe.method_8158());
            buffer.writeBoolean(recipe.isOverrideCharge());
            buffer.writeBoolean(recipe.isTransferMaxCharge());
            recipe.getChargeIngredient().method_8088(buffer);
            buffer.method_10814(recipe.method_8112());
            for (class_1856 ingredient : recipe.method_8117()) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(recipe.method_8110(GTRegistries.builtinRegistry()));
        }
    }
}

