/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1865;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class GTRecipeSerializer
implements class_1865<GTRecipe> {
    public static final GTRecipeSerializer SERIALIZER = new GTRecipeSerializer();

    public Map<RecipeCapability<?>, List<Content>> capabilitiesFromJson(JsonObject json) {
        HashMap capabilities = new HashMap();
        for (String key : json.keySet()) {
            JsonArray contentsJson = json.getAsJsonArray(key);
            RecipeCapability capability = (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(key);
            if (capability == null) continue;
            ArrayList<Content> contents = new ArrayList<Content>();
            for (JsonElement contentJson : contentsJson) {
                contents.add(capability.serializer.fromJsonContent(contentJson));
            }
            capabilities.put(capability, contents);
        }
        return capabilities;
    }

    @NotNull
    public GTRecipe fromJson(@NotNull class_2960 id, @NotNull JsonObject json) {
        String recipeType = class_3518.method_15265((JsonObject)json, (String)"type");
        int duration = json.has("duration") ? class_3518.method_15260((JsonObject)json, (String)"duration") : 100;
        class_2487 data = new class_2487();
        try {
            if (json.has("data")) {
                data = class_2522.method_10718((String)json.get("data").toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Map<RecipeCapability<?>, List<Content>> inputs = this.capabilitiesFromJson(json.has("inputs") ? json.getAsJsonObject("inputs") : new JsonObject());
        Map<RecipeCapability<?>, List<Content>> tickInputs = this.capabilitiesFromJson(json.has("tickInputs") ? json.getAsJsonObject("tickInputs") : new JsonObject());
        Map<RecipeCapability<?>, List<Content>> outputs = this.capabilitiesFromJson(json.has("outputs") ? json.getAsJsonObject("outputs") : new JsonObject());
        Map<RecipeCapability<?>, List<Content>> tickOutputs = this.capabilitiesFromJson(json.has("tickOutputs") ? json.getAsJsonObject("tickOutputs") : new JsonObject());
        ArrayList<RecipeCondition> conditions = new ArrayList<RecipeCondition>();
        JsonArray conditionsJson = json.has("recipeConditions") ? json.getAsJsonArray("recipeConditions") : new JsonArray();
        for (JsonElement jsonElement : conditionsJson) {
            RecipeCondition condition;
            JsonObject jsonObject;
            String conditionKey;
            Class clazz;
            if (!(jsonElement instanceof JsonObject) || (clazz = (Class)GTRegistries.RECIPE_CONDITIONS.get(conditionKey = class_3518.method_15253((JsonObject)(jsonObject = (JsonObject)jsonElement), (String)"type", (String)""))) == null || (condition = RecipeCondition.create(clazz)) == null) continue;
            conditions.add(condition.deserialize(class_3518.method_15281((JsonObject)jsonObject, (String)"data", (JsonObject)new JsonObject())));
        }
        boolean isFuel = class_3518.method_15258((JsonObject)json, (String)"isFuel", (boolean)false);
        return new GTRecipe((GTRecipeType)class_7923.field_41188.method_10223(new class_2960(recipeType)), id, inputs, outputs, tickInputs, tickOutputs, conditions, data, duration, isFuel);
    }

    public static class_3545<RecipeCapability<?>, List<Content>> entryReader(class_2540 buf) {
        RecipeCapability capability = (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(buf.method_19772());
        List contents = buf.method_34066(capability.serializer::fromNetworkContent);
        return new class_3545((Object)capability, (Object)contents);
    }

    public static void entryWriter(class_2540 buf, Map.Entry<RecipeCapability<?>, ? extends List<Content>> entry) {
        RecipeCapability<?> capability = entry.getKey();
        List<Content> contents = entry.getValue();
        buf.method_10814((String)GTRegistries.RECIPE_CAPABILITIES.getKey(capability));
        buf.method_34062(contents, capability.serializer::toNetworkContent);
    }

    public static RecipeCondition conditionReader(class_2540 buf) {
        RecipeCondition condition = RecipeCondition.create((Class)GTRegistries.RECIPE_CONDITIONS.get(buf.method_19772()));
        return condition.fromNetwork(buf);
    }

    public static void conditionWriter(class_2540 buf, RecipeCondition condition) {
        buf.method_10814((String)GTRegistries.RECIPE_CONDITIONS.getKey(condition.getClass()));
        condition.toNetwork(buf);
    }

    public static Map<RecipeCapability<?>, List<Content>> tuplesToMap(List<class_3545<RecipeCapability<?>, List<Content>>> entries) {
        HashMap map = new HashMap();
        entries.forEach(entry -> map.put((RecipeCapability)entry.method_15442(), (List)entry.method_15441()));
        return map;
    }

    @NotNull
    public GTRecipe fromNetwork(@NotNull class_2960 id, @NotNull class_2540 buf) {
        String recipeType = buf.method_19772();
        int duration = buf.method_10816();
        Map<RecipeCapability<?>, List<Content>> inputs = GTRecipeSerializer.tuplesToMap((List)buf.method_34068(c -> new ArrayList(), GTRecipeSerializer::entryReader));
        Map<RecipeCapability<?>, List<Content>> tickInputs = GTRecipeSerializer.tuplesToMap((List)buf.method_34068(c -> new ArrayList(), GTRecipeSerializer::entryReader));
        Map<RecipeCapability<?>, List<Content>> outputs = GTRecipeSerializer.tuplesToMap((List)buf.method_34068(c -> new ArrayList(), GTRecipeSerializer::entryReader));
        Map<RecipeCapability<?>, List<Content>> tickOutputs = GTRecipeSerializer.tuplesToMap((List)buf.method_34068(c -> new ArrayList(), GTRecipeSerializer::entryReader));
        List conditions = (List)buf.method_34068(c -> new ArrayList(), GTRecipeSerializer::conditionReader);
        class_2487 data = buf.method_10798();
        boolean isFuel = buf.readBoolean();
        return new GTRecipe((GTRecipeType)class_7923.field_41188.method_10223(new class_2960(recipeType)), id, inputs, outputs, tickInputs, tickOutputs, conditions, data, duration, isFuel);
    }

    public void toNetwork(class_2540 buf, GTRecipe recipe) {
        buf.method_10814(recipe.recipeType == null ? "dummy" : recipe.recipeType.toString());
        buf.method_10804(recipe.duration);
        buf.method_34062(recipe.inputs.entrySet(), GTRecipeSerializer::entryWriter);
        buf.method_34062(recipe.tickInputs.entrySet(), GTRecipeSerializer::entryWriter);
        buf.method_34062(recipe.outputs.entrySet(), GTRecipeSerializer::entryWriter);
        buf.method_34062(recipe.tickOutputs.entrySet(), GTRecipeSerializer::entryWriter);
        buf.method_34062(recipe.conditions, GTRecipeSerializer::conditionWriter);
        buf.method_10794(recipe.data);
        buf.writeBoolean(recipe.isFuel);
    }
}

