/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pipenet.longdistance;

import com.gregtechceu.gtceu.api.pipenet.longdistance.ILDEndpoint;
import com.gregtechceu.gtceu.api.pipenet.longdistance.LongDistancePipeType;
import com.gregtechceu.gtceu.api.pipenet.longdistance.NetworkBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class LongDistanceNetwork {
    private final ObjectOpenHashSet<class_2338> longDistancePipeBlocks = new ObjectOpenHashSet();
    private final LongDistancePipeType pipeType;
    private final WorldData world;
    private final List<ILDEndpoint> endpoints = new ArrayList<ILDEndpoint>();
    private final List<class_2338> endpointPoss = new ArrayList<class_2338>();
    private int activeInputIndex = -1;
    private int activeOutputIndex = -1;

    protected LongDistanceNetwork(LongDistancePipeType pipeType, WorldData world) {
        this.pipeType = pipeType;
        this.world = world;
    }

    @Nullable
    public static LongDistanceNetwork get(class_1936 world, class_2338 pos) {
        return WorldData.get(world).getNetwork(pos);
    }

    protected void recalculateNetwork(Collection<class_2338> starts) {
        for (class_2338 pos : this.longDistancePipeBlocks) {
            this.world.removeNetwork(pos);
        }
        this.invalidateEndpoints();
        this.endpoints.clear();
        this.longDistancePipeBlocks.clear();
        Thread thread = new Thread(new NetworkBuilder(this.world, this, starts));
        thread.start();
    }

    protected void setData(Collection<class_2338> pipes, List<ILDEndpoint> endpoints) {
        this.invalidateEndpoints();
        boolean wasEmpty = this.longDistancePipeBlocks.isEmpty();
        this.longDistancePipeBlocks.clear();
        this.longDistancePipeBlocks.addAll(pipes);
        this.endpoints.clear();
        this.endpoints.addAll(endpoints);
        if (this.longDistancePipeBlocks.isEmpty()) {
            this.invalidateNetwork();
            return;
        }
        if (wasEmpty) {
            this.world.networkList.add((Object)this);
        }
        for (class_2338 pos : this.longDistancePipeBlocks) {
            this.world.putNetwork(pos, this);
        }
    }

    public void onRemovePipe(class_2338 pos) {
        this.longDistancePipeBlocks.remove((Object)pos);
        this.world.removeNetwork(pos);
        if (this.longDistancePipeBlocks.isEmpty()) {
            this.invalidateNetwork();
            return;
        }
        ArrayList<class_2338> neighbours = new ArrayList<class_2338>();
        class_2338.class_2339 offsetPos = new class_2338.class_2339();
        for (class_2350 facing : class_2350.values()) {
            offsetPos.method_10101((class_2382)pos).method_10098(facing);
            LongDistanceNetwork network = this.world.getNetwork((class_2338)offsetPos);
            if (network != this) continue;
            neighbours.add(offsetPos.method_10062());
        }
        if (neighbours.size() > 1) {
            this.recalculateNetwork(neighbours);
        }
    }

    protected void addEndpoint(ILDEndpoint endpoint) {
        if (!this.endpoints.contains(endpoint)) {
            this.endpoints.add(endpoint);
        }
    }

    protected void addEndpoint(Collection<ILDEndpoint> endpoints) {
        for (ILDEndpoint endpoint : endpoints) {
            if (this.endpoints.contains(endpoint)) continue;
            this.endpoints.add(endpoint);
        }
    }

    public void onRemoveEndpoint(ILDEndpoint endpoint) {
        endpoint.invalidateLink();
        if (this.endpoints.remove(endpoint)) {
            this.invalidateEndpoints();
        }
        this.onRemovePipe(endpoint.getPos());
    }

    public void onPlacePipe(class_2338 pos) {
        this.longDistancePipeBlocks.add((Object)pos);
        this.world.putNetwork(pos, this);
    }

    public void onPlaceEndpoint(ILDEndpoint endpoint) {
        this.addEndpoint(endpoint);
        this.longDistancePipeBlocks.add((Object)endpoint.getPos());
        this.world.putNetwork(endpoint.getPos(), this);
    }

    protected void mergePipeNet(LongDistanceNetwork network) {
        if (this.getPipeType() != network.getPipeType()) {
            throw new IllegalStateException("Can't merge unequal pipe types, " + this.getPipeType().getName() + " and " + network.getPipeType().getName() + " !");
        }
        for (class_2338 pos : network.longDistancePipeBlocks) {
            this.world.putNetwork(pos, this);
            this.longDistancePipeBlocks.add((Object)pos);
        }
        this.addEndpoint(network.endpoints);
        for (ILDEndpoint endpoint1 : this.endpoints) {
            endpoint1.invalidateLink();
        }
        network.invalidateNetwork();
    }

    protected void invalidateNetwork() {
        this.longDistancePipeBlocks.clear();
        this.world.networkList.remove((Object)this);
        this.invalidateEndpoints();
        this.endpoints.clear();
    }

    protected void invalidateEndpoints() {
        this.activeInputIndex = -1;
        this.activeOutputIndex = -1;
        for (ILDEndpoint endpoint : this.endpoints) {
            endpoint.invalidateLink();
        }
    }

    @Nullable
    public ILDEndpoint getOtherEndpoint(ILDEndpoint endpoint) {
        if (!this.isValid() || !endpoint.isInput() && !endpoint.isOutput()) {
            return null;
        }
        if (this.isIOIndexInvalid()) {
            this.invalidateEndpoints();
        } else if (this.activeInputIndex >= 0) {
            ILDEndpoint out;
            ILDEndpoint in = this.endpoints.get(this.activeInputIndex);
            if (!this.pipeType.satisfiesMinLength(in, out = this.endpoints.get(this.activeOutputIndex))) {
                this.invalidateEndpoints();
                return this.getOtherEndpoint(endpoint);
            }
            if (in == endpoint) {
                if (!endpoint.isInput()) {
                    throw new IllegalStateException("Other endpoint from input was itself");
                }
                return out;
            }
            if (out == endpoint) {
                if (!endpoint.isOutput()) {
                    throw new IllegalStateException("Other endpoint from output was itself");
                }
                return in;
            }
            return null;
        }
        int otherIndex = this.find(endpoint);
        if (otherIndex >= 0) {
            int thisIndex = this.endpoints.indexOf(endpoint);
            if (thisIndex < 0) {
                throw new IllegalStateException("Tried to get endpoint that is not part of this network. Something is seriously wrong!");
            }
            ILDEndpoint other = this.endpoints.get(otherIndex);
            this.activeOutputIndex = endpoint.isOutput() ? thisIndex : otherIndex;
            this.activeInputIndex = endpoint.isInput() ? thisIndex : otherIndex;
            return other;
        }
        return null;
    }

    private int find(ILDEndpoint endpoint) {
        for (int i = 0; i < this.endpoints.size(); ++i) {
            ILDEndpoint other = this.endpoints.get(i);
            if (endpoint == other || !other.isOutput() && !other.isInput() || other.isInput() == endpoint.isInput() || !this.pipeType.satisfiesMinLength(endpoint, other)) continue;
            return i;
        }
        return -1;
    }

    public boolean isIOIndexInvalid() {
        return this.activeInputIndex >= 0 && this.activeInputIndex >= this.endpoints.size() || this.activeOutputIndex >= 0 && this.activeOutputIndex >= this.endpoints.size() || this.activeInputIndex < 0 != this.activeOutputIndex < 0;
    }

    public ILDEndpoint getActiveInputIndex() {
        return this.activeInputIndex >= 0 ? this.endpoints.get(this.activeInputIndex) : null;
    }

    public ILDEndpoint getActiveOutputIndex() {
        return this.activeOutputIndex >= 0 ? this.endpoints.get(this.activeOutputIndex) : null;
    }

    public int getTotalSize() {
        return this.longDistancePipeBlocks.size();
    }

    public int getEndpointAmount() {
        return this.endpoints.size();
    }

    public int getPipeAmount() {
        return this.getTotalSize() - this.getEndpointAmount();
    }

    public boolean isValid() {
        return this.getEndpointAmount() > 1;
    }

    public LongDistancePipeType getPipeType() {
        return this.pipeType;
    }

    public static class WorldData
    extends class_18 {
        private final Long2ObjectMap<Object2ObjectMap<class_2338, LongDistanceNetwork>> networks = new Long2ObjectOpenHashMap();
        private final ObjectOpenHashSet<LongDistanceNetwork> networkList = new ObjectOpenHashSet();
        private WeakReference<class_1936> worldRef = new WeakReference<Object>(null);

        public static WorldData create(class_3218 level) {
            WorldData data = new WorldData();
            data.setWorldAndInit((class_1936)level);
            return data;
        }

        public static WorldData get(class_1936 level) {
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                return (WorldData)serverLevel.method_17983().method_17924(WorldData::load, () -> WorldData.create(serverLevel), "gtceu_long_dist_pipe");
            }
            return null;
        }

        private static long getChunkPos(class_2338 pos) {
            return class_1923.method_8331((int)(pos.method_10263() >> 4), (int)(pos.method_10260() >> 4));
        }

        protected void setWorldAndInit(class_1936 world) {
            if (this.worldRef.get() != world) {
                for (LongDistanceNetwork ld : this.networkList) {
                    if (ld.endpointPoss.isEmpty()) continue;
                    ld.endpoints.clear();
                    for (class_2338 pos : ld.endpointPoss) {
                        ILDEndpoint endpoint = ILDEndpoint.tryGet(world, pos);
                        if (endpoint == null) continue;
                        ld.addEndpoint(endpoint);
                    }
                }
            }
            this.worldRef = new WeakReference<class_1936>(world);
            this.method_80();
        }

        public LongDistanceNetwork getNetwork(class_2338 pos) {
            return (LongDistanceNetwork)((Object2ObjectMap)this.networks.getOrDefault(WorldData.getChunkPos(pos), (Object)Object2ObjectMaps.emptyMap())).get((Object)pos);
        }

        private void putNetwork(class_2338 pos, LongDistanceNetwork network) {
            long chunkPos = WorldData.getChunkPos(pos);
            Object2ObjectMap chunkNetworks = (Object2ObjectMap)this.networks.get(chunkPos);
            if (chunkNetworks == null) {
                chunkNetworks = new Object2ObjectOpenHashMap();
                this.networks.put(chunkPos, (Object)chunkNetworks);
            }
            chunkNetworks.put((Object)pos, (Object)network);
            this.networkList.add((Object)network);
            this.method_80();
        }

        private void removeNetwork(class_2338 pos) {
            long chunkPos = WorldData.getChunkPos(pos);
            Object2ObjectMap chunkNetworks = (Object2ObjectMap)this.networks.get(chunkPos);
            if (chunkNetworks != null) {
                chunkNetworks.remove((Object)pos);
                if (chunkNetworks.isEmpty()) {
                    this.networks.remove(chunkPos);
                }
            }
            this.method_80();
        }

        public static WorldData load(@NotNull class_2487 nbtTagCompound) {
            WorldData data = new WorldData();
            data.networks.clear();
            data.networkList.clear();
            class_2499 list = nbtTagCompound.method_10554("nets", 10);
            for (class_2520 nbt : list) {
                class_2487 tag = (class_2487)nbt;
                LongDistancePipeType pipeType = LongDistancePipeType.getPipeType(tag.method_10558("class"));
                LongDistanceNetwork ld = pipeType.createNetwork(data);
                ld.activeInputIndex = tag.method_10550("in");
                ld.activeOutputIndex = tag.method_10550("out");
                data.networkList.add((Object)ld);
                class_2499 posList = tag.method_10554("pipes", 4);
                for (class_2520 nbtPos : posList) {
                    class_2338 pos = class_2338.method_10092((long)((class_2503)nbtPos).method_10699());
                    data.putNetwork(pos, ld);
                    ld.longDistancePipeBlocks.add((Object)pos);
                }
                class_2499 endpoints = tag.method_10554("endpoints", 4);
                for (class_2520 nbtPos : endpoints) {
                    class_2338 pos = class_2338.method_10092((long)((class_2503)nbtPos).method_10699());
                    if (ld.endpointPoss.contains(pos)) continue;
                    ld.endpointPoss.add(pos);
                }
            }
            return data;
        }

        @NotNull
        public class_2487 method_75(@NotNull class_2487 nbtTagCompound) {
            class_2499 list = new class_2499();
            for (LongDistanceNetwork network : this.networkList) {
                class_2487 tag = new class_2487();
                list.add((Object)tag);
                String name = network.getPipeType().getName();
                tag.method_10582("class", name);
                tag.method_10569("in", network.activeInputIndex);
                tag.method_10569("out", network.activeOutputIndex);
                class_2499 posList = new class_2499();
                tag.method_10566("pipes", (class_2520)posList);
                for (class_2338 pos : network.longDistancePipeBlocks) {
                    posList.add((Object)class_2503.method_23251((long)pos.method_10063()));
                }
                class_2499 endpoints = new class_2499();
                tag.method_10566("endpoints", (class_2520)endpoints);
                for (ILDEndpoint endpoint : network.endpoints) {
                    endpoints.add((Object)class_2503.method_23251((long)endpoint.getPos().method_10063()));
                }
            }
            nbtTagCompound.method_10566("nets", (class_2520)list);
            return nbtTagCompound;
        }

        public class_1936 getWorld() {
            return (class_1936)this.worldRef.get();
        }
    }
}

