/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pattern;

import com.gregtechceu.gtceu.api.block.ActiveBlock;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.pattern.MultiblockWorldSavedData;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.error.PatternError;
import com.gregtechceu.gtceu.api.pattern.error.PatternStringError;
import com.gregtechceu.gtceu.api.pattern.predicates.SimplePredicate;
import com.gregtechceu.gtceu.api.pattern.util.PatternMatchContext;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class MultiblockState {
    public static final PatternError UNLOAD_ERROR = new PatternStringError("multiblocked.pattern.error.chunk");
    public static final PatternError UNINIT_ERROR = new PatternStringError("multiblocked.pattern.error.init");
    private class_2338 pos;
    private class_2680 blockState;
    private class_2586 tileEntity;
    private boolean tileEntityInitialized;
    private final PatternMatchContext matchContext;
    private Map<SimplePredicate, Integer> globalCount;
    private Map<SimplePredicate, Integer> layerCount;
    public TraceabilityPredicate predicate;
    public IO io;
    public PatternError error;
    public final class_1937 world;
    public final class_2338 controllerPos;
    public IMultiController lastController;
    public LongOpenHashSet cache;

    public MultiblockState(class_1937 world, class_2338 controllerPos) {
        this.world = world;
        this.controllerPos = controllerPos;
        this.error = UNINIT_ERROR;
        this.matchContext = new PatternMatchContext();
    }

    protected void clean() {
        this.matchContext.reset();
        this.globalCount = new HashMap<SimplePredicate, Integer>();
        this.layerCount = new HashMap<SimplePredicate, Integer>();
        this.cache = new LongOpenHashSet();
    }

    protected boolean update(class_2338 posIn, TraceabilityPredicate predicate) {
        this.pos = posIn;
        this.blockState = null;
        this.tileEntity = null;
        this.tileEntityInitialized = false;
        this.predicate = predicate;
        this.error = null;
        if (!this.world.method_8477(posIn)) {
            this.error = UNLOAD_ERROR;
            return false;
        }
        return true;
    }

    public IMultiController getController() {
        if (this.world.method_8477(this.controllerPos)) {
            IMachineBlockEntity machineBlockEntity;
            Object object = this.world.method_8321(this.controllerPos);
            if (object instanceof IMachineBlockEntity && (object = (machineBlockEntity = (IMachineBlockEntity)object).getMetaMachine()) instanceof IMultiController) {
                IMultiController controller;
                this.lastController = controller = (IMultiController)object;
                return this.lastController;
            }
        } else {
            this.error = UNLOAD_ERROR;
        }
        return null;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public void setError(PatternError error) {
        this.error = error;
        if (error != null) {
            error.setWorldState(this);
        }
    }

    public class_2680 getBlockState() {
        if (this.blockState == null) {
            this.blockState = this.world.method_8320(this.pos);
        }
        if (this.blockState == null) {
            System.out.printf("error", new Object[0]);
        }
        return this.blockState;
    }

    @Nullable
    public class_2586 getTileEntity() {
        if (!this.getBlockState().method_31709()) {
            return null;
        }
        if (this.tileEntity == null && !this.tileEntityInitialized) {
            this.tileEntity = this.world.method_8321(this.pos);
            this.tileEntityInitialized = true;
        }
        return this.tileEntity;
    }

    public class_2338 getPos() {
        return this.pos.method_10062();
    }

    public class_2680 getOffsetState(class_2350 face) {
        if (this.pos instanceof class_2338.class_2339) {
            ((class_2338.class_2339)this.pos).method_10098(face);
            class_2680 blockState = this.world.method_8320(this.pos);
            ((class_2338.class_2339)this.pos).method_10098(face.method_10153());
            return blockState;
        }
        return this.world.method_8320(this.pos.method_10093(face));
    }

    public class_1937 getWorld() {
        return this.world;
    }

    public void addPosCache(class_2338 pos) {
        this.cache.add(pos.method_10063());
    }

    public boolean isPosInCache(class_2338 pos) {
        return this.cache.contains(pos.method_10063());
    }

    public Collection<class_2338> getCache() {
        return this.cache.stream().map(class_2338::method_10092).collect(Collectors.toList());
    }

    public void onBlockStateChanged(class_2338 pos, class_2680 state) {
        class_1937 class_19372 = this.world;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (pos.equals((Object)this.controllerPos)) {
                if (this.lastController != null && !state.method_27852(this.lastController.self().getBlockState().method_26204())) {
                    this.lastController.onStructureInvalid();
                    MultiblockWorldSavedData mwsd = MultiblockWorldSavedData.getOrCreate(serverLevel);
                    mwsd.removeMapping(this);
                }
            } else {
                IMultiController controller = this.getController();
                if (controller != null) {
                    LongSet activeBlocks;
                    if (controller.isFormed() && state.method_26204() instanceof ActiveBlock && (activeBlocks = this.getMatchContext().getOrDefault("vaBlocks", LongSets.emptySet())).contains(pos.method_10063())) {
                        return;
                    }
                    if (controller.checkPatternWithLock()) {
                        controller.onStructureFormed();
                    } else {
                        controller.onStructureInvalid();
                        MultiblockWorldSavedData mwsd = MultiblockWorldSavedData.getOrCreate(serverLevel);
                        mwsd.removeMapping(this);
                        mwsd.addAsyncLogic(controller);
                    }
                }
            }
        }
    }

    public PatternMatchContext getMatchContext() {
        return this.matchContext;
    }

    public Map<SimplePredicate, Integer> getGlobalCount() {
        return this.globalCount;
    }

    public Map<SimplePredicate, Integer> getLayerCount() {
        return this.layerCount;
    }
}

