/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc;

import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import java.util.List;
import net.minecraft.class_2350;

public class EnergyContainerList
implements IEnergyContainer {
    private final List<? extends IEnergyContainer> energyContainerList;

    public EnergyContainerList(List<? extends IEnergyContainer> energyContainerList) {
        this.energyContainerList = energyContainerList;
    }

    @Override
    public long acceptEnergyFromNetwork(class_2350 side, long voltage, long amperage) {
        long amperesUsed = 0L;
        List<? extends IEnergyContainer> energyContainerList = this.energyContainerList;
        for (IEnergyContainer iEnergyContainer : energyContainerList) {
            if (amperage != (amperesUsed += iEnergyContainer.acceptEnergyFromNetwork(null, voltage, amperage))) continue;
            return amperesUsed;
        }
        return amperesUsed;
    }

    @Override
    public long changeEnergy(long energyToAdd) {
        long energyAdded = 0L;
        List<? extends IEnergyContainer> energyContainerList = this.energyContainerList;
        for (IEnergyContainer iEnergyContainer : energyContainerList) {
            if ((energyAdded += iEnergyContainer.changeEnergy(energyToAdd - energyAdded)) != energyToAdd) continue;
            return energyAdded;
        }
        return energyAdded;
    }

    @Override
    public long getEnergyStored() {
        long energyStored = 0L;
        for (IEnergyContainer iEnergyContainer : this.energyContainerList) {
            energyStored += iEnergyContainer.getEnergyStored();
        }
        return energyStored;
    }

    @Override
    public long getEnergyCapacity() {
        long energyCapacity = 0L;
        for (IEnergyContainer iEnergyContainer : this.energyContainerList) {
            energyCapacity += iEnergyContainer.getEnergyCapacity();
        }
        return energyCapacity;
    }

    @Override
    public long getInputAmperage() {
        return 1L;
    }

    @Override
    public long getOutputAmperage() {
        return 1L;
    }

    @Override
    public long getInputVoltage() {
        long inputVoltage = 0L;
        for (IEnergyContainer iEnergyContainer : this.energyContainerList) {
            inputVoltage += iEnergyContainer.getInputVoltage() * iEnergyContainer.getInputAmperage();
        }
        return inputVoltage;
    }

    @Override
    public long getOutputVoltage() {
        long outputVoltage = 0L;
        for (IEnergyContainer iEnergyContainer : this.energyContainerList) {
            outputVoltage += iEnergyContainer.getOutputVoltage() * iEnergyContainer.getOutputAmperage();
        }
        return outputVoltage;
    }

    @Override
    public boolean inputsEnergy(class_2350 side) {
        return true;
    }

    @Override
    public boolean outputsEnergy(class_2350 side) {
        return true;
    }
}

