/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.tool;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.item.tool.fabric.ToolHelperImpl;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.DummyMachineBlockEntity;
import com.gregtechceu.gtceu.utils.InfiniteEnergyContainer;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.simibubi.create.content.decoration.palettes.GlassPaneBlock;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1838;
import net.minecraft.class_1856;
import net.minecraft.class_1885;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2560;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_5552;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolHelper {
    public static final String TOOL_TAG_KEY = "GT.Tool";
    public static final String BEHAVIOURS_TAG_KEY = "GT.Behaviours";
    public static final String MAX_CHARGE_KEY = "MaxCharge";
    public static final String CHARGE_KEY = "Charge";
    public static final String UNBREAKABLE_KEY = "Unbreakable";
    public static final String HIDE_FLAGS = "HideFlags";
    public static final String DISALLOW_CONTAINER_ITEM_KEY = "DisallowContainerItem";
    public static final String TINT_COLOR_KEY = "TintColor";
    public static final String DURABILITY_KEY = "Damage";
    public static final String MAX_DURABILITY_KEY = "MaxDamage";
    public static final String TOOL_SPEED_KEY = "ToolSpeed";
    public static final String ATTACK_DAMAGE_KEY = "AttackDamage";
    public static final String ATTACK_SPEED_KEY = "AttackSpeed";
    public static final String ENCHANTABILITY_KEY = "Enchantability";
    public static final String HARVEST_LEVEL_KEY = "HarvestLevel";
    public static final String LAST_CRAFTING_USE_KEY = "LastCraftingUse";
    public static final String MAX_AOE_COLUMN_KEY = "MaxAoEColumn";
    public static final String MAX_AOE_ROW_KEY = "MaxAoERow";
    public static final String MAX_AOE_LAYER_KEY = "MaxAoELayer";
    public static final String AOE_COLUMN_KEY = "AoEColumn";
    public static final String AOE_ROW_KEY = "AoERow";
    public static final String AOE_LAYER_KEY = "AoELayer";
    public static final String HARVEST_ICE_KEY = "HarvestIce";
    public static final String TORCH_PLACING_KEY = "TorchPlacing";
    public static final String TORCH_PLACING_CACHE_SLOT_KEY = "TorchPlacing$Slot";
    public static final String TREE_FELLING_KEY = "TreeFelling";
    public static final String DISABLE_SHIELDS_KEY = "DisableShields";
    public static final String RELOCATE_MINED_BLOCKS_KEY = "RelocateMinedBlocks";
    private static final BiMap<Character, GTToolType> symbols = HashBiMap.create();

    private ToolHelper() {
    }

    public static Character getSymbolFromTool(GTToolType tool) {
        return (Character)symbols.inverse().get((Object)tool);
    }

    public static GTToolType getToolFromSymbol(Character symbol) {
        return (GTToolType)symbols.get((Object)symbol);
    }

    public static Set<Character> getToolSymbols() {
        return symbols.keySet();
    }

    public static void registerToolSymbol(Character symbol, GTToolType tool) {
        symbols.put((Object)symbol, (Object)tool);
    }

    public static class_2487 getToolTag(class_1799 stack) {
        return stack.method_7911(TOOL_TAG_KEY);
    }

    public static class_2487 getBehaviorsTag(class_1799 stack) {
        return stack.method_7911(BEHAVIOURS_TAG_KEY);
    }

    public static boolean hasBehaviorsTag(class_1799 stack) {
        return stack.method_7941(BEHAVIOURS_TAG_KEY) != null;
    }

    public static class_1799 get(GTToolType toolType, Material material) {
        ItemProviderEntry entry;
        if (material.hasProperty(PropertyKey.TOOL) && (entry = (ItemProviderEntry)GTItems.TOOL_ITEMS.get((Object)material, (Object)toolType)) != null) {
            return ((IGTTool)entry.get()).get();
        }
        return class_1799.field_8037;
    }

    public static boolean is(class_1799 stack, GTToolType toolType) {
        return ToolHelper.getToolTypes(stack).contains(toolType);
    }

    public static boolean canUse(class_1799 stack) {
        return stack.method_7919() <= stack.method_7936();
    }

    public static void damageItem(@Nonnull class_1799 stack, @Nullable class_1309 user, int damage) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof IGTTool)) {
            if (user != null) {
                stack.method_7956(damage, user, p -> {});
            }
        } else {
            class_1657 player;
            IGTTool tool = (IGTTool)class_17922;
            if (stack.method_7969() != null && stack.method_7969().method_10577(UNBREAKABLE_KEY)) {
                return;
            }
            if (!(user instanceof class_1657) || !(player = (class_1657)user).method_7337()) {
                class_5819 random;
                class_5819 class_58192 = random = user == null ? GTValues.RNG : user.method_6051();
                if (tool.isElectric()) {
                    int electricDamage = damage * ConfigHolder.INSTANCE.machines.energyUsageMultiplier;
                    IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
                    if (electricItem != null) {
                        electricItem.discharge(electricDamage, tool.getElectricTier(), true, false, false);
                        if (electricItem.getCharge() > 0L && random.method_43048(100) > ConfigHolder.INSTANCE.tools.rngDamageElectricTools) {
                            return;
                        }
                    } else {
                        throw new IllegalStateException("Electric tool does not have an attached electric item capability.");
                    }
                }
                int unbreakingLevel = class_1890.method_8225((class_1887)class_1893.field_9119, (class_1799)stack);
                int negated = 0;
                for (int k = 0; unbreakingLevel > 0 && k < damage; ++k) {
                    if (!class_1885.method_8176((class_1799)stack, (int)unbreakingLevel, (class_5819)random)) continue;
                    ++negated;
                }
                if ((damage -= negated) <= 0) {
                    return;
                }
                int newDurability = stack.method_7919() + damage;
                if (user instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)user;
                    class_174.field_1185.method_8960(serverPlayer, stack, newDurability);
                }
                stack.method_7974(newDurability);
                if (newDurability > stack.method_7936()) {
                    if (user instanceof class_1657) {
                        class_1657 player2 = (class_1657)user;
                        class_3445 stat = class_3468.field_15383.method_14956((Object)stack.method_7909());
                        player2.method_7259(stat);
                    }
                    if (user != null) {
                        user.method_6045(stack);
                    }
                    stack.method_7934(1);
                }
            }
        }
    }

    public static void playToolSound(GTToolType toolType, class_3222 player) {
        if (toolType.soundEntry != null) {
            toolType.soundEntry.playOnServer(player.method_37908(), (class_2382)player.method_24515());
        }
    }

    public static class_1799 getAndSetToolData(GTToolType toolType, Material material, int maxDurability, int harvestLevel, float toolSpeed, float attackDamage) {
        ItemProviderEntry entry = (ItemProviderEntry)GTItems.TOOL_ITEMS.get((Object)material, (Object)toolType);
        if (entry == null) {
            return class_1799.field_8037;
        }
        class_1799 stack = ((IGTTool)entry.get()).getRaw();
        stack.method_7948().method_10569(HIDE_FLAGS, 2);
        class_2487 toolTag = ToolHelper.getToolTag(stack);
        toolTag.method_10569(MAX_DURABILITY_KEY, maxDurability);
        toolTag.method_10569(HARVEST_LEVEL_KEY, harvestLevel);
        toolTag.method_10548(TOOL_SPEED_KEY, toolSpeed);
        toolTag.method_10548(ATTACK_DAMAGE_KEY, attackDamage);
        ToolProperty toolProperty = material.getProperty(PropertyKey.TOOL);
        if (toolProperty != null) {
            toolProperty.getEnchantments().forEach((enchantment, level) -> {
                if (((IGTTool)entry.get()).definition$canApplyAtEnchantingTable(stack, (class_1887)enchantment)) {
                    stack.method_7978(enchantment, level.intValue());
                }
            });
        }
        return stack;
    }

    public static boolean areaOfEffectBlockBreakRoutine(class_1799 stack, class_3222 player) {
        int currentDurability = stack.method_7919();
        int maximumDurability = stack.method_7936();
        int remainingUses = maximumDurability - currentDurability;
        Set<class_2338> harvestableBlocks = ToolHelper.getHarvestableBlocks(stack, (class_1657)player);
        if (!harvestableBlocks.isEmpty()) {
            for (class_2338 pos : harvestableBlocks) {
                IGTTool gtTool;
                if (!ToolHelper.breakBlockRoutine(player, stack, pos)) {
                    return true;
                }
                class_1792 class_17922 = stack.method_7909();
                if (class_17922 instanceof IGTTool && !(gtTool = (IGTTool)class_17922).isElectric() && --remainingUses == 0) {
                    return true;
                }
                if (class_1799.method_7984((class_1799)player.method_6047(), (class_1799)stack)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static AoESymmetrical getMaxAoEDefinition(class_1799 stack) {
        return AoESymmetrical.readMax(ToolHelper.getBehaviorsTag(stack));
    }

    public static AoESymmetrical getAoEDefinition(class_1799 stack) {
        return AoESymmetrical.read(ToolHelper.getBehaviorsTag(stack), ToolHelper.getMaxAoEDefinition(stack));
    }

    public static Set<class_2338> iterateAoE(class_1799 stack, AoESymmetrical aoeDefinition, class_1937 world, class_1657 player, class_239 rayTraceResult, AOEFunction function) {
        class_3965 blockHit;
        if (aoeDefinition != AoESymmetrical.none() && rayTraceResult instanceof class_3965 && (blockHit = (class_3965)rayTraceResult).method_17780() != null) {
            int column = aoeDefinition.column;
            int row = aoeDefinition.row;
            int layer = aoeDefinition.layer;
            class_2350 playerFacing = player.method_5735();
            class_2350.class_2351 playerAxis = playerFacing.method_10166();
            class_2350.class_2351 sideHitAxis = blockHit.method_17780().method_10166();
            class_2350.class_2352 sideHitAxisDir = blockHit.method_17780().method_10171();
            ObjectOpenHashSet validPositions = new ObjectOpenHashSet();
            if (sideHitAxis.method_10178()) {
                boolean isX = playerAxis == class_2350.class_2351.field_11048;
                boolean isDown = sideHitAxisDir == class_2350.class_2352.field_11060;
                for (int y = 0; y <= layer; ++y) {
                    for (int x = isX ? -row : -column; x <= (isX ? row : column); ++x) {
                        for (int z = isX ? -column : -row; z <= (isX ? column : row); ++z) {
                            class_2338 pos;
                            if (x == 0 && y == 0 && z == 0 || !player.method_7343((pos = blockHit.method_17777().method_10069(x, isDown ? y : -y, z)).method_10093(blockHit.method_17780()), blockHit.method_17780(), stack) || !function.apply(stack, world, player, pos, new class_1838(player.method_37908(), player, player.method_6058(), stack, blockHit))) continue;
                            validPositions.add(pos);
                        }
                    }
                }
            } else {
                boolean isX = sideHitAxis == class_2350.class_2351.field_11048;
                boolean isNegative = sideHitAxisDir == class_2350.class_2352.field_11060;
                for (int x = 0; x <= layer; ++x) {
                    for (int y = row == 0 ? 0 : -1; y <= (row == 0 ? 0 : row * 2 - 1); ++y) {
                        for (int z = -column; z <= column; ++z) {
                            if (x == 0 && y == 0 && z == 0) continue;
                            class_2338 pos = blockHit.method_17777().method_10069(isX ? (isNegative ? x : -x) : (isNegative ? z : -z), y, isX ? (isNegative ? z : -z) : (isNegative ? x : -x));
                            if (!function.apply(stack, world, player, pos, new class_1838(player.method_37908(), player, player.method_6058(), stack, blockHit))) continue;
                            validPositions.add(pos);
                        }
                    }
                }
            }
            return validPositions;
        }
        return Collections.emptySet();
    }

    public static Set<class_2338> getHarvestableBlocks(class_1799 stack, AoESymmetrical aoeDefinition, class_1937 world, class_1657 player, class_239 rayTraceResult) {
        return ToolHelper.iterateAoE(stack, aoeDefinition, world, player, rayTraceResult, ToolHelper::isBlockAoEHarvestable);
    }

    private static boolean isBlockAoEHarvestable(class_1799 stack, class_1937 world, class_1657 player, class_2338 pos, class_1838 context) {
        if (world.method_8320(pos).method_26215()) {
            return false;
        }
        class_2680 state = world.method_8320(pos);
        if (state.method_26204() instanceof class_2404) {
            return false;
        }
        class_2338 hitBlockPos = context.method_8037();
        class_2680 hitBlockState = world.method_8320(hitBlockPos);
        if (state.method_26214((class_1922)world, pos) < 0.0f || state.method_26214((class_1922)world, pos) - hitBlockState.method_26214((class_1922)world, hitBlockPos) > 8.0f) {
            return false;
        }
        return stack.method_7909().method_7856(state);
    }

    public static void applyHammerDropConversion(class_3218 world, class_2338 pos, class_1799 tool, class_2680 state, List<class_1799> drops, int fortune, float dropChance, class_5819 random) {
        if (ToolHelper.is(tool, GTToolType.HARD_HAMMER)) {
            List<class_1799> silktouchDrops = ToolHelper.getSilkTouchDrop(world, pos, state);
            for (class_1799 silktouchDrop : silktouchDrops) {
                if (silktouchDrop.method_7960()) continue;
                Table caps = Tables.newCustomTable(new EnumMap(IO.class), IdentityHashMap::new);
                DummyMachineBlockEntity be = new DummyMachineBlockEntity(1, GTRecipeTypes.FORGE_HAMMER_RECIPES, GTMachines.defaultTankSizeFunction, caps, new Object[0]);
                caps.put((Object)IO.IN, (Object)EURecipeCapability.CAP, List.of(new InfiniteEnergyContainer(be.getMetaMachine(), GTValues.V[1], GTValues.V[1], 1L, GTValues.V[1], 1L)));
                caps.put((Object)IO.IN, (Object)ItemRecipeCapability.CAP, List.of(new NotifiableItemStackHandler(be.getMetaMachine(), 1, IO.IN, IO.IN, slots -> new ItemStackTransfer(silktouchDrop))));
                caps.put((Object)IO.OUT, (Object)ItemRecipeCapability.CAP, List.of(new NotifiableItemStackHandler(be.getMetaMachine(), 2, IO.OUT)));
                be.getMetaMachine().reinitializeCapabilities(caps);
                List<GTRecipe> hammerRecipes = GTRecipeTypes.FORGE_HAMMER_RECIPES.searchRecipe(Platform.getMinecraftServer().method_3772(), be.metaMachine);
                GTRecipe hammerRecipe = hammerRecipes.isEmpty() ? null : hammerRecipes.get(0);
                if (hammerRecipe == null || !hammerRecipe.handleRecipeIO(IO.IN, be.metaMachine)) continue;
                drops.clear();
                TagPrefix prefix = ChemicalHelper.getPrefix((class_1935)silktouchDrop.method_7909());
                if (prefix == null) {
                    for (Content output : hammerRecipe.getOutputContents(ItemRecipeCapability.CAP)) {
                        if (!(dropChance >= 1.0f) && !(random.method_43057() <= dropChance)) continue;
                        drops.add(SizedIngredient.copy((class_1856)ItemRecipeCapability.CAP.of(output.content)).method_8105()[0]);
                    }
                    continue;
                }
                if (!TagPrefix.ORES.containsKey(prefix)) continue;
                for (Content content : hammerRecipe.getOutputContents(ItemRecipeCapability.CAP)) {
                    class_1799 output;
                    if (!(dropChance >= 1.0f) && !(random.method_43057() <= dropChance) || ChemicalHelper.getPrefix((class_1935)(output = ((class_1856)ItemRecipeCapability.CAP.of(content.content)).method_8105()[0]).method_7909()) != TagPrefix.crushed) continue;
                    output = output.method_7972();
                    output.method_7933(random.method_43048(fortune));
                    drops.add(output);
                }
            }
        }
    }

    public static boolean breakBlockRoutine(class_3222 player, class_1799 tool, class_2338 pos) {
        if (ToolHelper.isTool(tool, GTToolType.SHEARS) && ToolHelper.shearBlockRoutine(player, tool, pos) == 0) {
            return false;
        }
        class_1937 world = player.method_37908();
        boolean canBreak = ToolHelper.onBlockBreakEvent(world, player.field_13974.method_14257(), player, pos);
        if (!canBreak) {
            return false;
        }
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        class_2586 tile = world.method_8321(pos);
        if (block instanceof class_5552 && !player.method_7338()) {
            world.method_8413(pos, state, state, 3);
            return false;
        }
        if (player.method_21701(world, pos, player.field_13974.method_14257())) {
            return false;
        }
        if (player.method_7337()) {
            return ToolHelper.removeBlockRoutine(state, world, player, pos);
        }
        world.method_8444((class_1657)player, 2001, pos, class_2248.method_9507((class_2680)state));
        boolean successful = ToolHelper.removeBlockRoutine(state, world, player, pos);
        class_1799 copiedTool = tool.method_7972();
        boolean canHarvest = player.method_7305(state);
        tool.method_7952(world, state, pos, (class_1657)player);
        if (tool.method_7960() && !copiedTool.method_7960()) {
            ToolHelper.onPlayerDestroyItem((class_1657)player, copiedTool, class_1268.field_5808);
        }
        if (successful && canHarvest) {
            block.method_9556(world, (class_1657)player, pos, state, tile, copiedTool);
        }
        return successful;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean onBlockBreakEvent(class_1937 level, class_1934 gameType, class_3222 player, class_2338 pos) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ToolHelperImpl.onBlockBreakEvent(level, (class_1934)var1_1, (class_3222)var2_2, (class_2338)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void onPlayerDestroyItem(class_1657 player, class_1799 stack, class_1268 hand) {
        void var2_2;
        void var1_1;
        ToolHelperImpl.onPlayerDestroyItem(player, (class_1799)var1_1, (class_1268)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean onBlockStartBreak(class_1799 itemstack, class_2338 pos, class_1657 player) {
        void var2_2;
        void var1_1;
        return ToolHelperImpl.onBlockStartBreak(itemstack, (class_2338)var1_1, (class_1657)var2_2);
    }

    public static boolean removeBlockRoutine(@Nullable class_2680 state, class_1937 world, class_3222 player, class_2338 pos) {
        state = state == null ? world.method_8320(pos) : state;
        state.method_26204().method_9576(world, pos, state, (class_1657)player);
        boolean successful = world.method_22352(pos, false);
        if (successful) {
            state.method_26204().method_9585((class_1936)world, pos, state);
        }
        return successful;
    }

    public static Set<class_2338> getHarvestableBlocks(class_1799 stack, class_1937 world, class_1657 player, class_239 rayTraceResult) {
        return ToolHelper.getHarvestableBlocks(stack, ToolHelper.getAoEDefinition(stack), world, player, rayTraceResult);
    }

    public static Set<class_2338> getHarvestableBlocks(class_1799 stack, class_1657 player) {
        if (!ToolHelper.hasBehaviorsTag(stack)) {
            return Collections.emptySet();
        }
        AoESymmetrical aoeDefiniton = ToolHelper.getAoEDefinition(stack);
        if (aoeDefiniton == AoESymmetrical.none()) {
            return Collections.emptySet();
        }
        class_239 rayTraceResult = ToolHelper.getPlayerDefaultRaytrace(player);
        return ToolHelper.getHarvestableBlocks(stack, aoeDefiniton, player.method_37908(), player, rayTraceResult);
    }

    public static class_239 getPlayerDefaultRaytrace(@NotNull class_1657 player) {
        return player.method_5745(ToolHelper.getPlayerBlockReach(player), 1.0f, false);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static double getPlayerBlockReach(@NotNull class_1657 player) {
        return ToolHelperImpl.getPlayerBlockReach(player);
    }

    public static void onActionDone(@NotNull class_1657 player, @NotNull class_1937 world, @NotNull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        IGTTool tool = (IGTTool)stack.method_7909();
        ToolHelper.damageItem(stack, (class_1309)player);
        if (tool.getSound() != null) {
            world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), tool.getSound().getMainEvent(), class_3419.field_15248, 1.0f, 1.0f);
        }
        player.method_6104(hand);
    }

    public static Set<GTToolType> getToolTypes(class_1799 tool) {
        HashSet<GTToolType> types = new HashSet<GTToolType>();
        class_1792 class_17922 = tool.method_7909();
        if (class_17922 instanceof IGTTool) {
            IGTTool gtTool = (IGTTool)class_17922;
            return gtTool.getToolClasses(tool);
        }
        for (GTToolType toolType : GTToolType.getTypes().values()) {
            if (!toolType.itemTags.stream().anyMatch(arg_0 -> ((class_1799)tool).method_31573(arg_0))) continue;
            types.add(toolType);
        }
        return types;
    }

    public static boolean isTool(class_1799 tool, GTToolType ... toolClasses) {
        for (GTToolType toolType : toolClasses) {
            if (!toolType.itemTags.stream().anyMatch(arg_0 -> ((class_1799)tool).method_31573(arg_0))) continue;
            return true;
        }
        class_1792 class_17922 = tool.method_7909();
        if (class_17922 instanceof IGTTool) {
            IGTTool igtTool = (IGTTool)class_17922;
            if (toolClasses.length == 1) {
                return igtTool.getToolClasses(tool).contains(toolClasses[0]);
            }
            for (GTToolType toolClass : igtTool.getToolClasses(tool)) {
                for (GTToolType specified : toolClasses) {
                    if (!toolClass.equals(specified)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isToolEffective(class_2680 state, Set<GTToolType> toolClasses, int harvestLevel) {
        class_2248 block = state.method_26204();
        if (toolClasses.stream().anyMatch(type -> type.harvestTags.stream().anyMatch(arg_0 -> ((class_2680)state).method_26164(arg_0)))) {
            return ToolHelper.isCorrectTierForDrops(state, harvestLevel);
        }
        if (toolClasses.contains(GTToolType.PICKAXE)) {
            if (class_2246.field_10540 == block && harvestLevel >= 3) {
                return true;
            }
            if (state.method_26164(class_3481.field_33718) && harvestLevel >= 2) {
                return true;
            }
            if (state.method_26164(class_3481.field_33719) && harvestLevel >= 1) {
                return true;
            }
            if (state.method_26164(class_3481.field_33715)) {
                return true;
            }
        }
        if (toolClasses.contains(GTToolType.SHOVEL)) {
            if (state.method_26164(class_3481.field_33716)) {
                return true;
            }
            if (block == class_2246.field_10491 || block == class_2246.field_10477) {
                return true;
            }
        }
        if (toolClasses.contains(GTToolType.AXE) && state.method_26164(class_3481.field_33713)) {
            return true;
        }
        if (toolClasses.contains(GTToolType.SWORD) && block instanceof class_2560) {
            return true;
        }
        if (toolClasses.contains(GTToolType.SCYTHE)) {
            // empty if block
        }
        if (toolClasses.contains(GTToolType.FILE) && block instanceof GlassPaneBlock) {
            return true;
        }
        if (toolClasses.contains(GTToolType.CROWBAR)) {
            return block instanceof class_2241;
        }
        return false;
    }

    public static void damageItemWhenCrafting(@NotNull class_1799 stack, @Nullable class_1309 entity) {
        int damage = 2;
        if (stack.method_7909() instanceof IGTTool) {
            damage = ((IGTTool)stack.method_7909()).getToolStats().getToolDamagePerCraft(stack);
        } else if (stack.method_40133().anyMatch(s -> s.comp_327().method_12832().startsWith("tool") || s.comp_327().method_12832().startsWith("crafting_tool"))) {
            damage = 1;
        }
        ToolHelper.damageItem(stack, entity, damage);
    }

    public static void damageItem(@NotNull class_1799 stack, @Nullable class_1309 entity) {
        ToolHelper.damageItem(stack, entity, 1);
    }

    public static float getDestroySpeed(class_2680 state, Set<GTToolType> toolClasses) {
        class_2248 block;
        if (toolClasses.contains(GTToolType.SWORD) && (block = state.method_26204()) instanceof class_2560) {
            return 15.0f;
        }
        return -1.0f;
    }

    public static int shearBlockRoutine(class_3222 player, class_1799 tool, class_2338 pos) {
        if (!player.method_7337()) {
            class_3218 world = player.method_51469();
            class_2680 class_26802 = world.method_8320(pos);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static boolean isCorrectTierForDrops(class_2680 state, int tier) {
        void var1_1;
        return ToolHelperImpl.isCorrectTierForDrops(state, (int)var1_1);
    }

    @NotNull
    public static List<class_1799> getSilkTouchDrop(class_3218 world, class_2338 origin, @NotNull class_2680 state) {
        class_1799 tool = ((IGTTool)((ItemProviderEntry)GTItems.TOOL_ITEMS.get((Object)GTMaterials.Neutronium, (Object)GTToolType.PICKAXE)).get()).get();
        tool.method_7978(class_1893.field_9099, 1);
        return state.method_26189(new class_8567.class_8568(world).method_51874(class_181.field_1224, (Object)state).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)origin)).method_51874(class_181.field_1229, (Object)tool));
    }

    @FunctionalInterface
    public static interface AOEFunction {
        public boolean apply(class_1799 var1, class_1937 var2, class_1657 var3, class_2338 var4, class_1838 var5);
    }
}

