/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.component;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IDurabilityBar;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.item.component.IItemLifeCycle;
import com.gregtechceu.gtceu.api.item.component.ISubItemHandler;
import com.gregtechceu.gtceu.api.item.component.fabric.ElectricStatsImpl;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class ElectricStats
implements IInteractionItem,
ISubItemHandler,
IAddInformation,
IItemLifeCycle,
IDurabilityBar {
    public static final ElectricStats EMPTY = ElectricStats.create(0L, 0L, false, false);
    public final long maxCharge;
    public final int tier;
    public final boolean chargeable;
    public final boolean dischargeable;

    protected ElectricStats(long maxCharge, long tier, boolean chargeable, boolean dischargeable) {
        this.maxCharge = maxCharge;
        this.tier = (int)tier;
        this.chargeable = chargeable;
        this.dischargeable = dischargeable;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ElectricStats create(long maxCharge, long tier, boolean chargeable, boolean dischargeable) {
        void var5_3;
        void var4_2;
        void var2_1;
        return ElectricStatsImpl.create(maxCharge, (long)var2_1, (boolean)var4_2, (boolean)var5_3);
    }

    public static float getStoredPredicate(class_1799 itemStack) {
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(itemStack);
        if (electricItem != null) {
            long per = electricItem.getCharge() * 7L / electricItem.getMaxCharge();
            return (float)per / 100.0f;
        }
        return 0.0f;
    }

    @Override
    public class_1271<class_1799> use(class_1792 item, class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 itemStack = player.method_5998(usedHand);
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(itemStack);
        if (electricItem != null && electricItem.canProvideChargeExternally() && player.method_18276()) {
            if (!level.field_9236) {
                boolean isInDischargeMode = ElectricStats.isInDischargeMode(itemStack);
                String locale = "metaitem.electric.discharge_mode." + (isInDischargeMode ? "disabled" : "enabled");
                player.method_43496((class_2561)class_2561.method_43471((String)locale));
                ElectricStats.setInDischargeMode(itemStack, !isInDischargeMode);
            }
            return class_1271.method_22427((Object)itemStack);
        }
        return IInteractionItem.super.use(item, level, player, usedHand);
    }

    @Override
    public void inventoryTick(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
        if (!level.field_9236 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (electricItem != null && electricItem.canProvideChargeExternally() && ElectricStats.isInDischargeMode(stack) && electricItem.getCharge() > 0L) {
                long chargedAmount;
                class_1799 itemInSlot;
                IElectricItem slotElectricItem;
                class_1661 inventoryPlayer = player.method_31548();
                long transferLimit = electricItem.getTransferLimit();
                for (int i = 0; i < inventoryPlayer.method_5439() && ((slotElectricItem = GTCapabilityHelper.getElectricItem(itemInSlot = inventoryPlayer.method_5438(i))) == null || slotElectricItem.canProvideChargeExternally() || (chargedAmount = ElectricStats.chargeElectricItem(transferLimit, electricItem, slotElectricItem)) <= 0L || (transferLimit -= chargedAmount) != 0L); ++i) {
                }
            }
        }
    }

    private static long chargeElectricItem(long maxDischargeAmount, IElectricItem source, IElectricItem target) {
        long maxDischarged = source.discharge(maxDischargeAmount, source.getTier(), false, false, true);
        long maxReceived = target.charge(maxDischarged, source.getTier(), false, true);
        if (maxReceived > 0L) {
            long resultDischarged = source.discharge(maxReceived, source.getTier(), false, true, false);
            target.charge(resultDischarged, source.getTier(), false, false);
            return resultDischarged;
        }
        return 0L;
    }

    private static void setInDischargeMode(class_1799 itemStack, boolean isDischargeMode) {
        class_2487 tagCompound = itemStack.method_7948();
        if (isDischargeMode) {
            tagCompound.method_10556("DischargeMode", true);
        } else {
            tagCompound.method_10551("DischargeMode");
            if (tagCompound.method_33133()) {
                itemStack.method_7980(null);
            }
        }
    }

    @Override
    public void appendHoverText(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
        if (electricItem != null && electricItem.canProvideChargeExternally()) {
            ElectricStats.addTotalChargeTooltip(tooltipComponents, electricItem.getMaxCharge(), electricItem.getTier());
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"metaitem.electric.discharge_mode.tooltip"));
        }
    }

    private static void addTotalChargeTooltip(List<class_2561> tooltip, long maxCharge, int tier) {
        String unit;
        long chargeTime;
        Instant end;
        Instant start = Instant.now();
        Duration duration = Duration.between(start, end = Instant.now().plusSeconds((long)((double)maxCharge * 1.0 / (double)GTValues.V[tier] / 20.0)));
        if (duration.getSeconds() <= 180L) {
            chargeTime = duration.getSeconds();
            unit = LocalizationUtils.format((String)"item.gtceu.battery.charge_unit.second", (Object[])new Object[0]);
        } else if (duration.toMinutes() <= 180L) {
            chargeTime = duration.toMinutes();
            unit = LocalizationUtils.format((String)"item.gtceu.battery.charge_unit.minute", (Object[])new Object[0]);
        } else {
            chargeTime = duration.toHours();
            unit = LocalizationUtils.format((String)"item.gtceu.battery.charge_unit.hour", (Object[])new Object[0]);
        }
        tooltip.add((class_2561)class_2561.method_43469((String)"item.gtceu.battery.charge_time", (Object[])new Object[]{chargeTime, unit, GTValues.VNF[tier]}));
    }

    private static boolean isInDischargeMode(class_1799 itemStack) {
        class_2487 tagCompound = itemStack.method_7969();
        return tagCompound != null && tagCompound.method_10577("DischargeMode");
    }

    @Override
    public void fillItemCategory(ComponentItem item, class_1761 category, class_2371<class_1799> items) {
        items.add((Object)new class_1799((class_1935)item));
        class_1799 stack = new class_1799((class_1935)item);
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
        if (electricItem != null) {
            electricItem.charge(electricItem.getMaxCharge(), electricItem.getTier(), true, false);
            items.add((Object)stack);
        }
    }

    public static ElectricStats createElectricItem(long maxCharge, long tier) {
        return ElectricStats.create(maxCharge, tier, true, false);
    }

    public static ElectricStats createRechargeableBattery(long maxCharge, int tier) {
        return ElectricStats.create(maxCharge, tier, true, true);
    }

    public static ElectricStats createBattery(long maxCharge, int tier, boolean rechargeable) {
        return ElectricStats.create(maxCharge, tier, rechargeable, true);
    }

    @Override
    public float getDurabilityForDisplay(class_1799 stack) {
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
        return electricItem == null ? 1.0f : (float)electricItem.getCharge() * 1.0f / (float)electricItem.getMaxCharge();
    }

    @Override
    public boolean isBarVisible(class_1799 stack) {
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
        return electricItem != null && electricItem.getCharge() < electricItem.getMaxCharge();
    }
}

