/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.DustProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.capability.ElectricItem;
import com.gregtechceu.gtceu.api.item.component.IItemUIFactory;
import com.gregtechceu.gtceu.api.item.fabric.IGTToolImpl;
import com.gregtechceu.gtceu.api.item.gui.PlayerInventoryHolder;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.IGTToolDefinition;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.TreeFellingHelper;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.core.ICraftRemainder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gregtechceu.gtceu.utils.ModHandler;
import com.lowdragmc.lowdraglib.gui.factory.HeldItemUIFactory;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1885;
import net.minecraft.class_1887;
import net.minecraft.class_1899;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_326;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public interface IGTTool
extends IItemUIFactory,
class_1935 {
    public Material getMaterial();

    public boolean isElectric();

    public int getElectricTier();

    public class_1832 method_8022();

    public IGTToolDefinition getToolStats();

    @Nullable
    public SoundEntry getSound();

    public boolean playSoundOnBlockDestroy();

    default public class_1792 method_8389() {
        return (class_1792)this;
    }

    default public class_1799 getRaw() {
        class_1799 stack = new class_1799((class_1935)this.method_8389());
        ToolHelper.getBehaviorsTag(stack);
        return stack;
    }

    default public class_1799 get() {
        class_1799 stack = new class_1799((class_1935)this.method_8389());
        class_2487 stackCompound = stack.method_7948();
        stackCompound.method_10556("DisallowContainerItem", false);
        class_2487 toolTag = ToolHelper.getToolTag(stack);
        IGTToolDefinition toolStats = this.getToolStats();
        stackCompound.method_10569("HideFlags", 2);
        AoESymmetrical aoeDefinition = this.getToolStats().getAoEDefinition(stack);
        ToolProperty toolProperty = this.getMaterial().getProperty(PropertyKey.TOOL);
        int durability = toolProperty.getDurability() * toolProperty.getDurabilityMultiplier();
        durability = toolStats.getBaseDurability(stack) == 0 ? (int)((float)durability * toolStats.getDurabilityMultiplier(stack)) : (int)((float)durability + (float)toolStats.getBaseDurability(stack) * toolStats.getDurabilityMultiplier(stack));
        toolTag.method_10569("MaxDamage", durability - 1);
        toolTag.method_10569("Damage", 0);
        if (toolProperty.isUnbreakable()) {
            stackCompound.method_10556("Unbreakable", true);
        }
        Object2IntOpenHashMap enchantments = new Object2IntOpenHashMap(toolProperty.getEnchantments());
        enchantments.putAll(toolStats.getDefaultEnchantments(stack));
        enchantments.forEach((enchantment, level) -> {
            if (enchantment.method_8192(stack)) {
                stack.method_7978(enchantment, level.intValue());
            }
        });
        class_2487 behaviourTag = ToolHelper.getBehaviorsTag(stack);
        this.getToolStats().getBehaviors().forEach(behavior -> behavior.addBehaviorNBT(stack, behaviourTag));
        if (aoeDefinition != AoESymmetrical.none()) {
            behaviourTag.method_10569("MaxAoEColumn", aoeDefinition.column);
            behaviourTag.method_10569("MaxAoERow", aoeDefinition.row);
            behaviourTag.method_10569("MaxAoELayer", aoeDefinition.layer);
            behaviourTag.method_10569("AoEColumn", aoeDefinition.column);
            behaviourTag.method_10569("AoERow", aoeDefinition.row);
            behaviourTag.method_10569("AoELayer", aoeDefinition.layer);
        }
        if (toolProperty.isMagnetic()) {
            behaviourTag.method_10556("RelocateMinedBlocks", true);
        }
        return stack;
    }

    default public class_1799 get(long defaultCharge, long defaultMaxCharge) {
        ElectricItem electricItem;
        class_1799 stack = this.get();
        if (this.isElectric() && (electricItem = (ElectricItem)GTCapabilityHelper.getElectricItem(stack)) != null) {
            electricItem.setMaxChargeOverride(defaultMaxCharge);
            electricItem.setCharge(defaultCharge);
        }
        return stack;
    }

    default public class_1799 get(long defaultMaxCharge) {
        return this.get(defaultMaxCharge, defaultMaxCharge);
    }

    default public Material getToolMaterial(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof IGTTool) {
            IGTTool tool = (IGTTool)class_17922;
            return tool.getMaterial();
        }
        return GTMaterials.Iron;
    }

    @Nullable
    default public ToolProperty getToolProperty(class_1799 stack) {
        return this.getToolMaterial(stack).getProperty(PropertyKey.TOOL);
    }

    @Nullable
    default public DustProperty getDustProperty(class_1799 stack) {
        return this.getToolMaterial(stack).getProperty(PropertyKey.DUST);
    }

    default public float getMaterialToolSpeed(class_1799 stack) {
        ToolProperty toolProperty = this.getToolProperty(stack);
        return toolProperty == null ? 0.0f : toolProperty.getHarvestSpeed();
    }

    default public float getMaterialAttackDamage(class_1799 stack) {
        ToolProperty toolProperty = this.getToolProperty(stack);
        return toolProperty == null ? 0.0f : toolProperty.getAttackDamage();
    }

    default public float getMaterialAttackSpeed(class_1799 stack) {
        ToolProperty toolProperty = this.getToolProperty(stack);
        return toolProperty == null ? 0.0f : toolProperty.getAttackSpeed();
    }

    default public int getMaterialDurability(class_1799 stack) {
        ToolProperty toolProperty = this.getToolProperty(stack);
        return toolProperty == null ? 0 : toolProperty.getDurability() * toolProperty.getDurabilityMultiplier();
    }

    default public int getMaterialEnchantability(class_1799 stack) {
        ToolProperty toolProperty = this.getToolProperty(stack);
        return toolProperty == null ? 0 : toolProperty.getEnchantability();
    }

    default public int getMaterialHarvestLevel(class_1799 stack) {
        ToolProperty toolProperty = this.getToolProperty(stack);
        return toolProperty == null ? 0 : toolProperty.getHarvestLevel();
    }

    default public long getMaxCharge(class_1799 stack) {
        class_2487 tag;
        if (this.isElectric() && (tag = stack.method_7969()) != null && tag.method_10573("MaxCharge", 4)) {
            return tag.method_10537("MaxCharge");
        }
        return -1L;
    }

    default public long getCharge(class_1799 stack) {
        class_2487 tag;
        if (this.isElectric() && (tag = stack.method_7969()) != null && tag.method_10573("Charge", 4)) {
            return tag.method_10537("Charge");
        }
        return -1L;
    }

    default public float getTotalToolSpeed(class_1799 stack) {
        class_2487 toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.method_10573("ToolSpeed", 5)) {
            return toolTag.method_10583("ToolSpeed");
        }
        float toolSpeed = this.getToolStats().getEfficiencyMultiplier(stack) * this.getMaterialToolSpeed(stack) + this.getToolStats().getBaseEfficiency(stack);
        toolTag.method_10548("ToolSpeed", toolSpeed);
        return toolSpeed;
    }

    default public float getTotalAttackDamage(class_1799 stack) {
        class_2487 toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.method_10573("AttackDamage", 5)) {
            return toolTag.method_10583("AttackDamage");
        }
        float baseDamage = this.getToolStats().getBaseDamage(stack);
        float attackDamage = 0.0f;
        if (baseDamage != Float.MIN_VALUE) {
            attackDamage = this.getMaterialAttackDamage(stack) + baseDamage;
        }
        toolTag.method_10548("AttackDamage", attackDamage);
        return attackDamage;
    }

    default public float getTotalAttackSpeed(class_1799 stack) {
        class_2487 toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.method_10573("AttackSpeed", 5)) {
            return toolTag.method_10583("AttackSpeed");
        }
        float attackSpeed = this.getMaterialAttackSpeed(stack) + this.getToolStats().getAttackSpeed(stack);
        toolTag.method_10548("AttackSpeed", attackSpeed);
        return attackSpeed;
    }

    default public int getTotalMaxDurability(class_1799 stack) {
        class_2487 toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.method_10573("MaxDamage", 3)) {
            return toolTag.method_10550("MaxDamage");
        }
        IGTToolDefinition toolStats = this.getToolStats();
        int maxDurability = this.getMaterialDurability(stack);
        int builderDurability = (int)((float)toolStats.getBaseDurability(stack) * toolStats.getDurabilityMultiplier(stack));
        maxDurability = builderDurability == 0 ? (int)((float)maxDurability * toolStats.getDurabilityMultiplier(stack)) : maxDurability + builderDurability;
        toolTag.method_10569("MaxDamage", maxDurability);
        return maxDurability;
    }

    default public int getTotalEnchantability(class_1799 stack) {
        class_2487 toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.method_10573("Enchantability", 3)) {
            return toolTag.method_10550("Enchantability");
        }
        int enchantability = this.getMaterialEnchantability(stack);
        toolTag.method_10569("Enchantability", enchantability);
        return enchantability;
    }

    default public int getTotalHarvestLevel(class_1799 stack) {
        class_2487 toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.method_10573("HarvestLevel", 3)) {
            return toolTag.method_10550("HarvestLevel");
        }
        int harvestLevel = this.getMaterialHarvestLevel(stack) + this.getToolStats().getBaseQuality(stack);
        toolTag.method_10569("HarvestLevel", harvestLevel);
        return harvestLevel;
    }

    default public float definition$getDestroySpeed(class_1799 stack, class_2680 state) {
        float specialValue = ToolHelper.getDestroySpeed(state, this.getToolClasses(stack));
        if (specialValue != -1.0f) {
            return specialValue;
        }
        if (ToolHelper.isToolEffective(state, this.getToolClasses(stack), this.getTotalHarvestLevel(stack))) {
            return this.getTotalToolSpeed(stack);
        }
        return this.getToolStats().isToolEffective(state) ? this.getTotalToolSpeed(stack) : 1.0f;
    }

    default public boolean definition$hurtEnemy(class_1799 stack, class_1309 target, class_1309 attacker) {
        this.getToolStats().getBehaviors().forEach(behavior -> behavior.hitEntity(stack, target, attacker));
        ToolHelper.damageItem(stack, attacker, this.getToolStats().getToolDamagePerAttack(stack));
        return true;
    }

    default public boolean definition$onBlockStartBreak(class_1799 stack, class_2338 pos, class_1657 player) {
        if (player.method_37908().field_9236) {
            return false;
        }
        this.getToolStats().getBehaviors().forEach(behavior -> behavior.onBlockStartBreak(stack, pos, player));
        if (!player.method_18276()) {
            class_3222 playerMP = (class_3222)player;
            int result = -1;
            if (ToolHelper.isTool(stack, GTToolType.SHEARS)) {
                result = ToolHelper.shearBlockRoutine(playerMP, stack, pos);
            }
            if (result != 0) {
                class_2680 state = player.method_37908().method_8320(pos);
                boolean effective = false;
                for (GTToolType type : this.getToolClasses(stack)) {
                    if (!type.harvestTags.stream().anyMatch(arg_0 -> ((class_2680)state).method_26164(arg_0))) continue;
                    effective = true;
                    break;
                }
                if (effective |= ToolHelper.isToolEffective(state, this.getToolClasses(stack), this.getTotalHarvestLevel(stack))) {
                    if (ToolHelper.areaOfEffectBlockBreakRoutine(stack, playerMP)) {
                        if (this.playSoundOnBlockDestroy()) {
                            this.playSound(player);
                        }
                    } else if (result == -1) {
                        if (ToolHelper.getBehaviorsTag(stack).method_10577("TreeFelling") && state.method_26164(class_3481.field_15475)) {
                            new TreeFellingHelper().fellTree(stack, player.method_37908(), state, pos, (class_1309)player);
                        }
                        if (this.playSoundOnBlockDestroy()) {
                            this.playSound(player);
                        }
                    } else {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    default public boolean definition$mineBlock(class_1799 stack, class_1937 worldIn, class_2680 state, class_2338 pos, class_1309 entityLiving) {
        if (!worldIn.field_9236) {
            this.getToolStats().getBehaviors().forEach(behavior -> behavior.onBlockDestroyed(stack, worldIn, state, pos, entityLiving));
            if ((double)state.method_26214((class_1922)worldIn, pos) != 0.0) {
                ToolHelper.damageItem(stack, entityLiving, this.getToolStats().getToolDamagePerBlockBreak(stack));
            }
            if (entityLiving instanceof class_1657 && this.playSoundOnBlockDestroy() && entityLiving.method_18276()) {
                this.playSound((class_1657)entityLiving);
            }
        }
        return true;
    }

    default public boolean definition$isValidRepairItem(class_1799 toRepair, class_1799 repair) {
        if (toRepair.method_7919() == 0) {
            return false;
        }
        class_1792 class_17922 = repair.method_7909();
        if (class_17922 instanceof IGTTool) {
            IGTTool gtTool = (IGTTool)class_17922;
            return this.getToolMaterial(toRepair) == gtTool.getToolMaterial(repair);
        }
        UnificationEntry entry = ChemicalHelper.getUnificationEntry((class_1935)repair.method_7909());
        if (entry == null || entry.material == null) {
            return false;
        }
        if (entry.material == this.getToolMaterial(toRepair)) {
            if (entry.tagPrefix == TagPrefix.plate) {
                return true;
            }
            if (entry.material.hasProperty(PropertyKey.INGOT)) {
                return entry.tagPrefix == TagPrefix.ingot;
            }
            if (entry.material.hasProperty(PropertyKey.GEM)) {
                return entry.tagPrefix == TagPrefix.gem;
            }
        }
        return false;
    }

    default public Multimap<class_1320, class_1322> definition$getDefaultAttributeModifiers(class_1304 equipmentSlot, class_1799 stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == class_1304.field_6173) {
            multimap.put((Object)class_5134.field_23721, (Object)new class_1322(class_1792.field_8006, "Weapon modifier", (double)this.getTotalAttackDamage(stack), class_1322.class_1323.field_6328));
            multimap.put((Object)class_5134.field_23723, (Object)new class_1322(class_1792.field_8001, "Weapon modifier", Math.max(-3.9, (double)this.getTotalAttackSpeed(stack)), class_1322.class_1323.field_6328));
        }
        return multimap;
    }

    default public int definition$getHarvestLevel(class_1799 stack, GTToolType toolClass, @Nullable class_1657 player, @Nullable class_2680 blockState) {
        return this.getToolClasses(stack).contains(toolClass) ? this.getTotalHarvestLevel(stack) : -1;
    }

    default public boolean definition$canDisableShield(class_1799 stack, class_1799 shield, class_1309 entity, class_1309 attacker) {
        return this.getToolStats().getBehaviors().stream().anyMatch(behavior -> behavior.canDisableShield(stack, shield, entity, attacker));
    }

    default public boolean definition$doesSneakBypassUse(@Nonnull class_1799 stack, @Nonnull class_1922 world, @Nonnull class_2338 pos, @Nonnull class_1657 player) {
        return this.getToolStats().doesSneakBypassUse();
    }

    default public boolean definition$shouldCauseBlockBreakReset(class_1799 oldStack, class_1799 newStack) {
        return oldStack.method_7909() != newStack.method_7909() || oldStack.method_7919() < newStack.method_7919();
    }

    default public boolean definition$hasCraftingRemainingItem(class_1799 stack) {
        return stack.method_7969() == null || !stack.method_7969().method_10577("DisallowContainerItem");
    }

    default public class_1799 definition$getCraftingRemainingItem(class_1799 stack) {
        if (!this.definition$hasCraftingRemainingItem(stack)) {
            return class_1799.field_8037;
        }
        stack = stack.method_7972();
        class_1657 player = ICraftRemainder.craftingPlayer.get();
        ToolHelper.damageItemWhenCrafting(stack, (class_1309)player);
        this.playCraftingSound(player, stack);
        if (stack.method_7960()) {
            return this.getToolStats().getBrokenStack();
        }
        return stack;
    }

    default public boolean definition$shouldCauseReequipAnimation(class_1799 oldStack, class_1799 newStack, boolean slotChanged) {
        if (this.getCharge(oldStack) != this.getCharge(newStack)) {
            return slotChanged;
        }
        return !oldStack.equals(newStack);
    }

    default public boolean definition$onEntitySwing(class_1309 entityLiving, class_1799 stack) {
        this.getToolStats().getBehaviors().forEach(behavior -> behavior.onEntitySwing(entityLiving, stack));
        return false;
    }

    default public boolean definition$canDestroyBlockInCreative(class_1937 world, class_2338 pos, class_1799 stack, class_1657 player) {
        return true;
    }

    default public boolean definition$isDamaged(class_1799 stack) {
        return this.definition$getDamage(stack) > 0;
    }

    default public int definition$getDamage(class_1799 stack) {
        class_2487 toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.method_10573("Damage", 3)) {
            return toolTag.method_10550("Damage");
        }
        toolTag.method_10569("Damage", 0);
        return 0;
    }

    default public int definition$getMaxDamage(class_1799 stack) {
        return this.getTotalMaxDurability(stack);
    }

    default public void definition$setDamage(class_1799 stack, int durability) {
        class_2487 toolTag = ToolHelper.getToolTag(stack);
        toolTag.method_10569("Damage", durability);
    }

    default public double definition$getDurabilityForDisplay(class_1799 stack) {
        int damage = stack.method_7919();
        int maxDamage = stack.method_7936();
        if (damage == 0) {
            return 1.0;
        }
        return (double)(maxDamage - damage) / (double)maxDamage;
    }

    default public void definition$init() {
        this.getToolStats().getBehaviors().forEach(behavior -> behavior.init(this));
    }

    default public class_1269 definition$onItemUseFirst(class_1799 stack, class_1838 context) {
        for (IToolBehavior behavior : this.getToolStats().getBehaviors()) {
            if (behavior.onItemUseFirst(stack, context) != class_1269.field_5812) continue;
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    default public class_1269 definition$onItemUse(class_1838 context) {
        for (IToolBehavior behavior : this.getToolStats().getBehaviors()) {
            if (behavior.onItemUse(context) != class_1269.field_5812) continue;
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    default public class_1271<class_1799> definition$use(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!world.field_9236 && player.method_18276() && ToolHelper.getMaxAoEDefinition(stack) != AoESymmetrical.none()) {
            PlayerInventoryHolder.openHandItemUI(player, hand);
            return class_1271.method_22427((Object)stack);
        }
        for (IToolBehavior behavior : this.getToolStats().getBehaviors()) {
            if (behavior.onItemRightClick(world, player, hand).method_5467() != class_1269.field_5812) continue;
            return class_1271.method_22427((Object)stack);
        }
        return class_1271.method_22430((Object)stack);
    }

    default public void definition$fillItemCategory(class_1761 category, @Nonnull class_2371<class_1799> items) {
        if (this.isElectric()) {
            items.add((Object)this.get(Integer.MAX_VALUE));
        } else {
            items.add((Object)this.get());
        }
    }

    @Environment(value=EnvType.CLIENT)
    default public void definition$appendHoverText(@Nonnull class_1799 stack, @Nullable class_1937 world, @Nonnull List<class_2561> tooltip, class_1836 flag) {
        class_2487 behaviorsTag;
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof IGTTool)) {
            return;
        }
        IGTTool tool = (IGTTool)class_17922;
        class_2487 tagCompound = stack.method_7969();
        if (tagCompound == null) {
            return;
        }
        IGTToolDefinition toolStats = tool.getToolStats();
        if (this.isElectric()) {
            tooltip.add((class_2561)class_2561.method_43469((String)"metaitem.generic.electric_item.tooltip", (Object[])new Object[]{this.getCharge(stack), this.getMaxCharge(stack), GTValues.VNF[this.getElectricTier()]}));
        }
        if (!tagCompound.method_10577("Unbreakable")) {
            int damageRemaining = tool.getTotalMaxDurability(stack) - stack.method_7919() + 1;
            if (toolStats.isSuitableForCrafting(stack)) {
                tooltip.add((class_2561)class_2561.method_43469((String)"item.gtceu.tool.tooltip.crafting_uses", (Object[])new Object[]{FormattingUtil.formatNumbers(damageRemaining / Math.max(1, toolStats.getToolDamagePerCraft(stack)))}));
            }
            tooltip.add((class_2561)class_2561.method_43469((String)"item.gtceu.tool.tooltip.general_uses", (Object[])new Object[]{FormattingUtil.formatNumbers(damageRemaining)}));
        }
        if (toolStats.isSuitableForAttacking(stack)) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.gtceu.tool.tooltip.attack_damage", (Object[])new Object[]{FormattingUtil.formatNumbers(2.0f + tool.getTotalAttackDamage(stack))}));
            tooltip.add((class_2561)class_2561.method_43469((String)"item.gtceu.tool.tooltip.attack_speed", (Object[])new Object[]{FormattingUtil.formatNumbers(4.0f + tool.getTotalAttackSpeed(stack))}));
        }
        if (toolStats.isSuitableForBlockBreak(stack)) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.gtceu.tool.tooltip.mining_speed", (Object[])new Object[]{FormattingUtil.formatNumbers(tool.getTotalToolSpeed(stack))}));
            int harvestLevel = tool.getTotalHarvestLevel(stack);
            String harvestName = "item.gtceu.tool.harvest_level." + harvestLevel;
            if (class_1074.method_4663((String)harvestName)) {
                tooltip.add((class_2561)class_2561.method_43469((String)"item.gtceu.tool.tooltip.harvest_level_extra", (Object[])new Object[]{harvestLevel, class_2561.method_43471((String)harvestName)}));
            } else {
                tooltip.add((class_2561)class_2561.method_43469((String)"item.gtceu.tool.tooltip.harvest_level", (Object[])new Object[]{harvestLevel}));
            }
        }
        boolean addedBehaviorNewLine = false;
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(stack);
        if (aoeDefinition != AoESymmetrical.none()) {
            addedBehaviorNewLine = tooltip.add((class_2561)class_2561.method_43470((String)""));
            tooltip.add((class_2561)class_2561.method_43469((String)"item.gtceu.tool.behavior.aoe_mining", (Object[])new Object[]{aoeDefinition.column * 2 + 1, aoeDefinition.row * 2 + 1, aoeDefinition.layer + 1}));
        }
        if ((behaviorsTag = ToolHelper.getBehaviorsTag(stack)).method_10577("RelocateMinedBlocks")) {
            if (!addedBehaviorNewLine) {
                addedBehaviorNewLine = true;
                tooltip.add((class_2561)class_2561.method_43470((String)""));
            }
            tooltip.add((class_2561)class_2561.method_43471((String)"item.gtceu.tool.behavior.relocate_mining"));
        }
        if (!addedBehaviorNewLine && !toolStats.getBehaviors().isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43470((String)""));
        }
        toolStats.getBehaviors().forEach(behavior -> behavior.addInformation(stack, world, tooltip, flag));
        String uniqueTooltip = "item.gtceu.tool." + class_7923.field_41178.method_10221((Object)this.method_8389()).method_12832() + ".tooltip";
        if (class_1074.method_4663((String)uniqueTooltip)) {
            tooltip.add((class_2561)class_2561.method_43470((String)""));
            tooltip.add((class_2561)class_2561.method_43471((String)uniqueTooltip));
        }
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43469((String)"item.gtceu.tool.usable_as", (Object[])new Object[]{this.getToolClasses(stack).stream().map(s -> class_2561.method_43471((String)("gtceu.tool.class." + s.name))).collect(class_2561::method_43473, FormattingUtil::combineComponents, FormattingUtil::combineComponents)}));
        if (!tagCompound.method_10577("Unbreakable")) {
            if (GTUtil.isShiftDown()) {
                Material material = this.getToolMaterial(stack);
                ArrayList<class_5250> repairItems = new ArrayList<class_5250>();
                if (!ModHandler.isMaterialWood(material)) {
                    if (material.hasProperty(PropertyKey.INGOT)) {
                        repairItems.add(TagPrefix.ingot.getLocalizedName(material));
                    } else if (material.hasProperty(PropertyKey.GEM)) {
                        repairItems.add(TagPrefix.gem.getLocalizedName(material));
                    }
                }
                if (!ChemicalHelper.get(TagPrefix.plate, material).method_7960()) {
                    repairItems.add(TagPrefix.plate.getLocalizedName(material));
                }
                if (!repairItems.isEmpty()) {
                    tooltip.add((class_2561)class_2561.method_43469((String)"item.gtceu.tool.tooltip.repair_material", (Object[])new Object[]{repairItems.stream().collect(class_2561::method_43473, FormattingUtil::combineComponents, FormattingUtil::combineComponents)}));
                }
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.gtceu.tool.tooltip.repair_info"));
            }
        }
        if (this.isElectric()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.gtceu.tool.replace_tool_head"));
        }
    }

    default public boolean definition$canApplyAtEnchantingTable(@Nonnull class_1799 stack, class_1887 enchantment) {
        if (stack.method_7960()) {
            return false;
        }
        switch (enchantment.method_8184()) {
            case "enchantment.cofhcore.smashing": {
                return false;
            }
            case "enchantment.autosmelt": 
            case "enchantment.cofhcore.smelting": 
            case "enchantment.as.smelting": {
                return this.getToolStats().getAoEDefinition(stack) == AoESymmetrical.none() && !ToolHelper.getBehaviorsTag(stack).method_10545("TreeFelling");
            }
        }
        if (this.isElectric() && (enchantment instanceof class_1899 || enchantment instanceof class_1885)) {
            return false;
        }
        if (enchantment.field_9083 == null) {
            return true;
        }
        switch (enchantment.field_9083) {
            case field_9069: {
                return this.getToolStats().isSuitableForBlockBreak(stack);
            }
            case field_9074: {
                return this.getToolStats().isSuitableForAttacking(stack);
            }
            case field_9082: {
                return stack.method_7969() != null && !stack.method_7969().method_10577("Unbreakable");
            }
        }
        ToolProperty property = this.getToolProperty(stack);
        if (property == null) {
            return false;
        }
        if (!property.getEnchantments().isEmpty() && property.getEnchantments().containsKey((Object)enchantment)) {
            return true;
        }
        return this.getToolStats().isEnchantable(stack) && this.getToolStats().canApplyEnchantment(stack, enchantment);
    }

    @Environment(value=EnvType.CLIENT)
    default public int getColor(class_1799 stack, int tintIndex) {
        return tintIndex % 2 == 1 ? this.getToolMaterial(stack).getMaterialRGB() : 0xFFFFFF;
    }

    default public void playCraftingSound(class_1657 player, class_1799 stack) {
        if (ConfigHolder.INSTANCE.client.toolCraftingSounds && this.getSound() != null && player != null && this.canPlaySound(stack)) {
            this.setLastCraftingSoundTime(stack);
            this.playSound(player);
        }
    }

    default public void setLastCraftingSoundTime(class_1799 stack) {
        ToolHelper.getToolTag(stack).method_10569("LastCraftingUse", (int)System.currentTimeMillis());
    }

    default public boolean canPlaySound(class_1799 stack) {
        return Math.abs((int)System.currentTimeMillis() - ToolHelper.getToolTag(stack).method_10550("LastCraftingUse")) > 1000;
    }

    default public void playSound(class_1657 player) {
        if (ConfigHolder.INSTANCE.client.toolUseSounds && this.getSound() != null) {
            player.method_37908().method_43128(null, player.method_19538().field_1352, player.method_19538().field_1351, player.method_19538().field_1350, this.getSound().getMainEvent(), class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    @Override
    default public ModularUI createUI(HeldItemUIFactory.HeldItemHolder holder, class_1657 entityPlayer) {
        class_2487 tag = ToolHelper.getBehaviorsTag(holder.getHeld());
        AoESymmetrical defaultDefinition = ToolHelper.getMaxAoEDefinition(holder.getHeld());
        return new ModularUI(120, 80, (IUIHolder)holder, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)new LabelWidget(6, 10, "item.gtceu.tool.aoe.columns")).widget((Widget)new LabelWidget(49, 10, "item.gtceu.tool.aoe.rows")).widget((Widget)new LabelWidget(79, 10, "item.gtceu.tool.aoe.layers")).widget((Widget)new ButtonWidget(15, 24, 20, 20, (IGuiTexture)new TextTexture("+"), data -> {
            AoESymmetrical.increaseColumn(tag, defaultDefinition);
            holder.markAsDirty();
        })).widget((Widget)new ButtonWidget(15, 44, 20, 20, (IGuiTexture)new TextTexture("-"), data -> {
            AoESymmetrical.decreaseColumn(tag, defaultDefinition);
            holder.markAsDirty();
        })).widget((Widget)new ButtonWidget(50, 24, 20, 20, (IGuiTexture)new TextTexture("+"), data -> {
            AoESymmetrical.increaseRow(tag, defaultDefinition);
            holder.markAsDirty();
        })).widget((Widget)new ButtonWidget(50, 44, 20, 20, (IGuiTexture)new TextTexture("-"), data -> {
            AoESymmetrical.decreaseRow(tag, defaultDefinition);
            holder.markAsDirty();
        })).widget((Widget)new ButtonWidget(85, 24, 20, 20, (IGuiTexture)new TextTexture("+"), data -> {
            AoESymmetrical.increaseLayer(tag, defaultDefinition);
            holder.markAsDirty();
        })).widget((Widget)new ButtonWidget(85, 44, 20, 20, (IGuiTexture)new TextTexture("-"), data -> {
            AoESymmetrical.decreaseLayer(tag, defaultDefinition);
            holder.markAsDirty();
        })).widget((Widget)new LabelWidget(23, 65, () -> Integer.toString(1 + 2 * AoESymmetrical.getColumn(ToolHelper.getBehaviorsTag(holder.getHeld()), defaultDefinition)))).widget((Widget)new LabelWidget(58, 65, () -> Integer.toString(1 + 2 * AoESymmetrical.getRow(ToolHelper.getBehaviorsTag(holder.getHeld()), defaultDefinition)))).widget((Widget)new LabelWidget(93, 65, () -> Integer.toString(1 + AoESymmetrical.getLayer(ToolHelper.getBehaviorsTag(holder.getHeld()), defaultDefinition))));
    }

    public Set<GTToolType> getToolClasses(class_1799 var1);

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean definition$isCorrectToolForDrops(class_1799 stack, class_2680 state) {
        void var1_1;
        return IGTToolImpl.definition$isCorrectToolForDrops(stack, (class_2680)var1_1);
    }

    @Environment(value=EnvType.CLIENT)
    public static class_326 tintColor() {
        return (itemStack, index) -> {
            class_1792 patt37906$temp = itemStack.method_7909();
            if (patt37906$temp instanceof IGTTool) {
                IGTTool item = (IGTTool)patt37906$temp;
                Material material = item.getMaterial();
                return switch (index) {
                    case -101, 0 -> {
                        if (item.getToolClasses(itemStack).contains(GTToolType.CROWBAR) && itemStack.method_7985() && ToolHelper.getToolTag(itemStack).method_10573("TintColor", 3)) {
                            yield ToolHelper.getToolTag(itemStack).method_10550("TintColor");
                        }
                        yield -1;
                    }
                    case -111, 1 -> material.getMaterialARGB();
                    case -121, 2 -> {
                        if (material.getMaterialSecondaryARGB() != -1) {
                            yield material.getMaterialSecondaryARGB();
                        }
                        yield material.getMaterialARGB();
                    }
                    default -> -1;
                };
            }
            return -1;
        };
    }
}

