/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.texture;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.misc.PacketProspecting;
import com.gregtechceu.gtceu.api.gui.misc.ProspectorMode;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.lang.reflect.Array;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_6328;
import net.minecraft.class_757;
import org.joml.Matrix4f;

@ParametersAreNonnullByDefault
@class_6328
@Environment(value=EnvType.CLIENT)
public class ProspectingTexture
extends class_1044 {
    public static final String SELECTED_ALL = "[all]";
    private String selected = "[all]";
    private boolean darkMode;
    private final int imageWidth;
    private final int imageHeight;
    public final Object[][][] data;
    private final int playerXGui;
    private final int playerYGui;
    private final float direction;
    private final int playerChunkX;
    private final int playerChunkZ;
    private final ProspectorMode mode;
    private final int radius;

    public ProspectingTexture(int playerChunkX, int playerChunkZ, int posX, int posZ, float direction, ProspectorMode mode, int radius, boolean darkMode) {
        this.darkMode = darkMode;
        this.radius = radius;
        this.mode = mode;
        this.data = (Object[][][])Array.newInstance(mode.getItemClass(), (radius * 2 - 1) * mode.cellSize, (radius * 2 - 1) * mode.cellSize, 0);
        this.imageWidth = (radius * 2 - 1) * 16;
        this.imageHeight = (radius * 2 - 1) * 16;
        this.playerChunkX = playerChunkX;
        this.playerChunkZ = playerChunkZ;
        this.direction = (direction + 180.0f) % 360.0f;
        this.playerXGui = posX - (playerChunkX - this.radius + 1) * 16 + (posX > 0 ? 1 : 0);
        this.playerYGui = posZ - (playerChunkZ - this.radius + 1) * 16 + (posX > 0 ? 1 : 0);
    }

    public void updateTexture(PacketProspecting packet) {
        int ox = packet.chunkX > 0 && this.playerChunkX > 0 || packet.chunkX < 0 && this.playerChunkX < 0 ? Math.abs(Math.abs(packet.chunkX) - Math.abs(this.playerChunkX)) : Math.abs(this.playerChunkX) + Math.abs(packet.chunkX);
        if (this.playerChunkX > packet.chunkX) {
            ox = -ox;
        }
        int oy = packet.chunkZ > 0 && this.playerChunkZ > 0 || packet.chunkZ < 0 && this.playerChunkZ < 0 ? Math.abs(Math.abs(packet.chunkZ) - Math.abs(this.playerChunkZ)) : Math.abs(this.playerChunkZ) + Math.abs(packet.chunkZ);
        if (this.playerChunkZ > packet.chunkZ) {
            oy = -oy;
        }
        int currentColumn = this.radius - 1 + ox;
        int currentRow = this.radius - 1 + oy;
        if (currentRow < 0) {
            return;
        }
        for (int x = 0; x < this.mode.cellSize; ++x) {
            System.arraycopy(packet.data[x], 0, this.data[x + currentColumn * this.mode.cellSize], currentRow * this.mode.cellSize, this.mode.cellSize);
        }
        this.load();
    }

    private class_1011 getImage() {
        int wh = (this.radius * 2 - 1) * 16;
        class_1011 image = new class_1011(wh, wh, false);
        for (int i = 0; i < wh; ++i) {
            for (int j = 0; j < wh; ++j) {
                Object[] items = this.data[i * this.mode.cellSize / 16][j * this.mode.cellSize / 16];
                image.method_4305(i, j, this.darkMode ? ColorPattern.GRAY.color : ColorPattern.WHITE.color);
                for (Object item : items) {
                    if (!this.selected.equals(SELECTED_ALL) && !this.selected.equals(this.mode.getUniqueID(item))) continue;
                    int color = this.mode.getItemColor(item);
                    image.method_4305(i, j, ProspectingTexture.combine(255, ColorUtils.blueI((int)color), ColorUtils.greenI((int)color), ColorUtils.redI((int)color)));
                    break;
                }
                if (i % 16 != 0 && j % 16 != 0) continue;
                image.method_4305(i, j, ColorUtils.averageColor((int[])new int[]{image.method_4315(i, j), -16777216}));
            }
        }
        return image;
    }

    public static int combine(int alpha, int blue, int green, int red) {
        return (alpha & 0xFF) << 24 | (blue & 0xFF) << 16 | (green & 0xFF) << 8 | (red & 0xFF) << 0;
    }

    public void load() {
        this.doLoad(this.getImage());
    }

    private void doLoad(class_1011 image) {
        TextureUtil.prepareImage((int)this.method_4624(), (int)0, (int)image.method_4307(), (int)image.method_4323());
        image.method_22619(0, 0, 0, 0, 0, image.method_4307(), image.method_4323(), false, false, false, true);
    }

    public void draw(class_332 graphics, int x, int y) {
        if (this.method_4624() == -1) {
            return;
        }
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (int)this.method_4624());
        Matrix4f matrix4f = graphics.method_51448().method_23760().method_23761();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferbuilder.method_22918(matrix4f, (float)x, (float)(y + this.imageHeight), 0.0f).method_22913(0.0f, 1.0f).method_39415(-1).method_1344();
        bufferbuilder.method_22918(matrix4f, (float)(x + this.imageWidth), (float)(y + this.imageHeight), 0.0f).method_22913(1.0f, 1.0f).method_39415(-1).method_1344();
        bufferbuilder.method_22918(matrix4f, (float)(x + this.imageWidth), (float)y, 0.0f).method_22913(1.0f, 0.0f).method_39415(-1).method_1344();
        bufferbuilder.method_22918(matrix4f, (float)x, (float)y, 0.0f).method_22913(0.0f, 0.0f).method_39415(-1).method_1344();
        tessellator.method_1350();
        for (int cx = 0; cx < this.radius * 2 - 1; ++cx) {
            for (int cz = 0; cz < this.radius * 2 - 1; ++cz) {
                if (this.data[cx][cz] == null || this.data[cx][cz].length <= 0) continue;
                Object[] items = this.data[cx][cz];
                this.mode.drawSpecialGrid(graphics, items, x + cx * 16 + 1, y + cz * 16 + 1, 16, 16);
            }
        }
        GuiTextures.UP.copy().setColor(ColorPattern.RED.color).rotate(this.direction / 2.0f).draw(graphics, 0, 0, (float)(x + this.playerXGui - 20), (float)(y + this.playerYGui - 20), 40, 40);
        if (this.playerXGui % 16 > 7 || this.playerXGui % 16 == 0) {
            DrawerHelper.drawSolidRect((class_332)graphics, (int)(x + this.playerXGui - 1), (int)y, (int)1, (int)this.imageHeight, (int)ColorPattern.RED.color);
        } else {
            DrawerHelper.drawSolidRect((class_332)graphics, (int)(x + this.playerXGui), (int)y, (int)1, (int)this.imageHeight, (int)ColorPattern.RED.color);
        }
        if (this.playerYGui % 16 > 7 || this.playerYGui % 16 == 0) {
            DrawerHelper.drawSolidRect((class_332)graphics, (int)x, (int)(y + this.playerYGui - 1), (int)this.imageWidth, (int)1, (int)ColorPattern.RED.color);
        } else {
            DrawerHelper.drawSolidRect((class_332)graphics, (int)x, (int)(y + this.playerYGui), (int)this.imageWidth, (int)1, (int)ColorPattern.RED.color);
        }
    }

    public void method_4625(class_3300 resourceManager) throws IOException {
    }

    public void setDarkMode(boolean darkMode) {
        if (this.darkMode != darkMode) {
            this.darkMode = darkMode;
            this.load();
        }
    }

    public void setSelected(String uniqueID) {
        if (!this.selected.equals(uniqueID)) {
            this.selected = uniqueID;
            this.load();
        }
    }

    public String getSelected() {
        return this.selected;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }
}

