/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.fancy;

import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class TooltipsPanel
extends Widget {
    protected List<IFancyTooltip> tooltips = new ArrayList<IFancyTooltip>();

    public TooltipsPanel() {
        super(202, 2, 20, 0);
    }

    public void clear() {
        this.tooltips.clear();
    }

    public void attachTooltips(IFancyTooltip ... tooltips) {
        this.tooltips.addAll(Arrays.asList(tooltips));
    }

    @Environment(value=EnvType.CLIENT)
    public void drawInBackground(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Position position = this.getPosition();
        Size size = this.getSize();
        int offsetY = 0;
        for (IFancyTooltip tooltip : this.tooltips) {
            if (!tooltip.showFancyTooltip()) continue;
            tooltip.getFancyTooltipIcon().draw(graphics, mouseX, mouseY, (float)position.x, (float)(position.y + offsetY), size.width, size.width);
            offsetY += size.getWidth() + 2;
        }
        this.setSize(new Size(this.getSize().width, Math.max(0, offsetY)));
    }

    @Environment(value=EnvType.CLIENT)
    public void drawInForeground(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.getHoverElement(mouseX, mouseY) == this && this.gui != null && this.gui.getModularUIGui() != null) {
            Position position = this.getPosition();
            Size size = this.getSize();
            int offsetY = 0;
            for (IFancyTooltip tooltip : this.tooltips) {
                if (!tooltip.showFancyTooltip()) continue;
                if (TooltipsPanel.isMouseOver((int)position.x, (int)(position.y + offsetY), (int)size.width, (int)size.width, (double)mouseX, (double)mouseY)) {
                    this.gui.getModularUIGui().setHoverTooltip(tooltip.getFancyTooltip(), class_1799.field_8037, null, tooltip.getFancyComponent());
                    return;
                }
                offsetY += size.getWidth() + 2;
            }
        }
    }

    public List<IFancyTooltip> getTooltips() {
        return this.tooltips;
    }
}

