/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.editor;

import com.gregtechceu.gtceu.api.gui.editor.UIMainPanel;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.editor.data.UIProject;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.tool.WidgetToolBox;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.TabButton;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2960;

@LDLRegister(name="rtui", group="editor.gtceu")
public class RecipeTypeUIProject
extends UIProject {
    @Nullable
    protected GTRecipeType recipeType;

    private RecipeTypeUIProject() {
        this(null, null);
    }

    public RecipeTypeUIProject(Resources resources, WidgetGroup root) {
        super(resources, root);
    }

    public RecipeTypeUIProject(class_2487 tag) {
        super(tag);
    }

    public RecipeTypeUIProject newEmptyProject() {
        return new RecipeTypeUIProject(Resources.defaultResource(), new WidgetGroup(30, 30, 200, 200));
    }

    public UIProject loadProject(File file) {
        try {
            class_2487 tag = class_2507.method_10633((File)file);
            if (tag != null) {
                return new RecipeTypeUIProject(tag);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public class_2487 serializeNBT() {
        class_2487 tag = super.serializeNBT();
        if (this.recipeType != null) {
            tag.method_10582("recipe_type", this.recipeType.registryName.toString());
        }
        return tag;
    }

    public void deserializeNBT(class_2487 tag) {
        super.deserializeNBT(tag);
        if (tag.method_10545("recipe_type")) {
            this.recipeType = (GTRecipeType)GTRegistries.RECIPE_TYPES.get(new class_2960(tag.method_10558("recipe_type")));
        }
    }

    public void onLoad(Editor editor) {
        editor.getResourcePanel().loadResource(this.getResources(), false);
        editor.getTabPages().addTab(new TabButton(50, 16, 60, 14).setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GREEN.rectTexture().setBottomRadius(10.0f).transform(0.0f, 0.4f), new TextTexture("Main")}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_RED.rectTexture().setBottomRadius(10.0f).transform(0.0f, 0.4f), new TextTexture("Main")})), (WidgetGroup)new UIMainPanel(editor, this.root, this.recipeType == null ? null : this.recipeType.registryName.method_42094()));
        for (WidgetToolBox.Default tab : WidgetToolBox.Default.TABS) {
            editor.getToolPanel().addNewToolBox("ldlib.gui.editor.group." + tab.groupName, tab.icon, (WidgetGroup)tab.createToolBox());
        }
    }

    public void attachMenu(Editor editor, String name, TreeBuilder.Menu menu) {
        if (name.equals("file")) {
            if (this.recipeType == null) {
                menu.remove("ldlib.gui.editor.menu.save");
            } else {
                menu.remove("ldlib.gui.editor.menu.save");
                menu.leaf((IGuiTexture)Icons.SAVE, "ldlib.gui.editor.menu.save", () -> {
                    File path = new File(LDLib.location, "assets/%s/ui/recipe_type".formatted(this.recipeType.registryName.method_12836()));
                    path.mkdirs();
                    this.saveProject(new File(path, this.recipeType.registryName.method_12832() + "." + this.getRegisterUI().name()));
                    this.recipeType.reloadCustomUI();
                });
            }
        } else if (name.equals("template_tab")) {
            LinkedHashMap<String, List> categories = new LinkedHashMap<String, List>();
            for (GTRecipeType recipeType : GTRegistries.RECIPE_TYPES) {
                categories.computeIfAbsent(recipeType.group, group -> new ArrayList()).add(recipeType);
            }
            categories.forEach((groupName, recipeTypes) -> menu.branch(groupName, m -> {
                for (GTRecipeType recipeType : recipeTypes) {
                    ItemStackTexture icon = recipeType.getIconSupplier() != null ? new ItemStackTexture(new class_1799[]{recipeType.getIconSupplier().get()}) : new ItemStackTexture(new class_1792[]{class_1802.field_8077});
                    m.leaf((IGuiTexture)icon, recipeType.registryName.method_42094(), () -> {
                        this.root.clearAllWidgets();
                        if (recipeType.hasCustomUI()) {
                            class_2487 nbt = recipeType.getCustomUI();
                            IConfigurableWidget.deserializeNBT((IConfigurableWidget)this.root, (class_2487)nbt.method_10562("root"), (Resources)Resources.fromNBT((class_2487)nbt.method_10562("resources")), (boolean)false);
                        } else {
                            WidgetGroup widget = recipeType.createEditableUITemplate(false, false).createDefault();
                            this.root.setSize(widget.getSize());
                            for (Widget children : widget.widgets) {
                                this.root.addWidget(children);
                            }
                        }
                        this.setRecipeType(recipeType);
                    });
                }
            }));
        }
    }

    @Nullable
    public GTRecipeType getRecipeType() {
        return this.recipeType;
    }

    public void setRecipeType(@Nullable GTRecipeType recipeType) {
        this.recipeType = recipeType;
    }
}

