/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.ores;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.IWorldGenLayer;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.BedrockOreVeinSavedData;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedIndicators;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVein;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreIndicatorPlacer;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreVeinUtil;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_5281;
import net.minecraft.class_5444;
import net.minecraft.class_5819;
import net.minecraft.class_6328;
import net.minecraft.class_6677;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public class OreGenerator {
    public List<GeneratedVeinMetadata> generateMetadata(class_5281 level, class_2794 chunkGenerator, class_1923 chunkPos) {
        return this.createConfigs(level, chunkGenerator, chunkPos).stream().map(OreGenerator::logVeinGeneration).map(entry -> entry.data).toList();
    }

    public List<GeneratedIndicators> generateIndicators(class_5281 level, List<GeneratedVeinMetadata> metadata, class_1923 chunkPos) {
        return metadata.stream().map(data -> new VeinConfiguration((GeneratedVeinMetadata)data, (class_5819)new class_6677(level.method_8412() ^ chunkPos.method_8324()))).map(config -> this.generateIndicators((VeinConfiguration)config, level, chunkPos)).toList();
    }

    private GeneratedIndicators generateIndicators(VeinConfiguration config, class_5281 level, class_1923 chunkPos) {
        GTOreDefinition definition = config.data.definition();
        Map<class_1923, List<OreIndicatorPlacer>> generatedIndicators = definition.indicatorGenerators().stream().flatMap(gen -> gen.generate(level, config.newRandom(), config.data).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, entry -> List.of((OreIndicatorPlacer)entry.getValue()), (a, b) -> Stream.of(a, b).flatMap(Collection::stream).toList()));
        return new GeneratedIndicators(chunkPos, generatedIndicators);
    }

    public List<GeneratedVein> generateOres(class_5281 level, List<GeneratedVeinMetadata> metadata, class_1923 chunkPos) {
        return metadata.stream().map(data -> new VeinConfiguration((GeneratedVeinMetadata)data, (class_5819)new class_6677(level.method_8412() ^ chunkPos.method_8324()))).flatMap(config -> this.generateOres((VeinConfiguration)config, level, chunkPos).stream()).toList();
    }

    private Optional<GeneratedVein> generateOres(VeinConfiguration config, class_5281 level, class_1923 chunkPos) {
        GTOreDefinition definition = config.data.definition();
        Map<class_2338, OreBlockPlacer> generatedVeins = definition.veinGenerator().generate(level, config.newRandom(), definition, config.data.center());
        if (generatedVeins.isEmpty()) {
            OreGenerator.logEmptyVein(config);
            return Optional.empty();
        }
        OreGenerator.generateBedrockOreVein(config, level);
        return Optional.of(new GeneratedVein(chunkPos, definition.layer(), generatedVeins));
    }

    private static void generateBedrockOreVein(VeinConfiguration config, class_5281 level) {
        if (ConfigHolder.INSTANCE.machines.doBedrockOres) {
            BedrockOreVeinSavedData.getOrCreate(level.method_8410()).createVein(new class_1923(config.data.center()), config.data.definition());
        }
    }

    private List<VeinConfiguration> createConfigs(class_5281 level, class_2794 generator, class_1923 chunkPos) {
        class_6677 random = new class_6677(level.method_8412() ^ chunkPos.method_8324());
        return OreVeinUtil.getVeinCenter(chunkPos, (class_5819)random).stream().flatMap(veinCenter -> this.getEntries(level, (class_2338)veinCenter, random).map(entry -> {
            class_2960 id = (class_2960)GTRegistries.ORE_VEINS.getKey((GTOreDefinition)entry);
            if (entry == null) {
                return null;
            }
            class_2338 origin = OreGenerator.computeVeinOrigin(level, generator, (class_5819)random, veinCenter, entry).orElseThrow(() -> new IllegalStateException("Cannot determine y coordinate for the vein at " + veinCenter));
            return new VeinConfiguration(new GeneratedVeinMetadata(id, chunkPos, origin, (GTOreDefinition)entry), (class_5819)random);
        })).toList();
    }

    private Stream<GTOreDefinition> getEntries(class_5281 level, class_2338 veinCenter, class_6677 random) {
        return WorldGeneratorUtils.WORLD_GEN_LAYERS.values().stream().filter(layer -> layer.isApplicableForLevel(level.method_8410().method_27983().method_29177())).map(layer -> this.getEntry(level, (class_6880<class_1959>)level.method_23753(veinCenter), (class_5819)random, (IWorldGenLayer)layer)).filter(Objects::nonNull);
    }

    @Nullable
    private GTOreDefinition getEntry(class_5281 level, class_6880<class_1959> biome, class_5819 random, IWorldGenLayer layer) {
        List<Map.Entry> veins = WorldGeneratorUtils.getCachedBiomeVeins(level.method_8410(), biome, random).stream().filter(vein -> ((GTOreDefinition)vein.getValue()).layer().equals(layer)).toList();
        int randomEntryIndex = GTUtil.getRandomItem(random, veins, veins.size());
        return randomEntryIndex == -1 ? null : (GTOreDefinition)veins.get(randomEntryIndex).getValue();
    }

    @NotNull
    private static Optional<class_2338> computeVeinOrigin(class_5281 level, class_2794 generator, class_5819 random, class_2338 veinCenter, GTOreDefinition entry) {
        int layerSeed = WorldGeneratorUtils.getWorldGenLayerKey(entry.layer()).map(String::hashCode).orElse(0);
        class_6677 layeredRandom = new class_6677(random.method_43055() ^ (long)layerSeed);
        return entry.range().method_14452(new class_5444(level, generator, Optional.empty()), (class_5819)layeredRandom, veinCenter).findFirst();
    }

    private static VeinConfiguration logVeinGeneration(VeinConfiguration config) {
        if (ConfigHolder.INSTANCE.dev.debugWorldgen) {
            GTCEu.LOGGER.debug("Generating vein " + config.data.id() + " at " + config.data.center());
        }
        return config;
    }

    private static void logEmptyVein(VeinConfiguration config) {
        if (ConfigHolder.INSTANCE.dev.debugWorldgen) {
            GTCEu.LOGGER.debug("No blocks generated for vein " + config.data.id() + " at " + config.data.center());
        }
    }

    private record VeinConfiguration(GeneratedVeinMetadata data, class_5819 random) {
        public class_5819 newRandom() {
            return new class_6677(this.random.method_43055());
        }
    }
}

