/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.ores;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedIndicators;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVein;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreVeinUtil;
import com.gregtechceu.gtceu.config.ConfigHolder;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1923;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_5281;
import net.minecraft.class_6328;
import org.apache.commons.lang3.mutable.MutableInt;

@class_6328
@ParametersAreNonnullByDefault
public class OreGenCache {
    private final OreGenerator oreGenerator = new OreGenerator();
    private final int oreGenerationCacheSize;
    private final int oreIndicatorCacheSize;
    private final int veinMetadataCacheSize;
    private final Cache<class_1923, List<GeneratedVeinMetadata>> veinMetadataByOrigin;
    private final Cache<class_1923, List<GeneratedVein>> generatedVeinsByOrigin;
    private final Cache<class_1923, List<GeneratedIndicators>> indicatorsByOrigin;

    public OreGenCache() {
        this.oreGenerationCacheSize = ConfigHolder.INSTANCE != null ? ConfigHolder.INSTANCE.worldgen.oreVeins.oreGenerationChunkCacheSize : 512;
        this.oreIndicatorCacheSize = ConfigHolder.INSTANCE != null ? ConfigHolder.INSTANCE.worldgen.oreVeins.oreIndicatorChunkCacheSize : 512;
        this.veinMetadataCacheSize = Math.max(this.oreGenerationCacheSize, this.oreIndicatorCacheSize);
        this.veinMetadataByOrigin = CacheBuilder.newBuilder().maximumSize((long)this.veinMetadataCacheSize).softValues().build();
        this.generatedVeinsByOrigin = CacheBuilder.newBuilder().maximumSize((long)this.oreGenerationCacheSize).softValues().build();
        this.indicatorsByOrigin = CacheBuilder.newBuilder().maximumSize((long)this.oreIndicatorCacheSize).softValues().build();
    }

    private List<GeneratedVeinMetadata> getOrCreateVeinMetadata(class_5281 level, class_2794 generator, class_1923 chunkPos) {
        try {
            return (List)this.veinMetadataByOrigin.get((Object)chunkPos, () -> this.oreGenerator.generateMetadata(level, generator, chunkPos));
        }
        catch (ExecutionException e) {
            GTCEu.LOGGER.error("Cannot create vein position in chunk " + chunkPos, (Throwable)e);
            return List.of();
        }
    }

    public List<GeneratedVein> consumeChunkVeins(class_5281 level, class_2794 generator, class_2791 chunk) {
        return this.getSurroundingChunks(chunk.method_12004(), OreVeinUtil.getMaxVeinSearchDistance()).flatMap(chunkPos -> {
            try {
                return ((List)this.generatedVeinsByOrigin.get(chunkPos, () -> this.oreGenerator.generateOres(level, this.getOrCreateVeinMetadata(level, generator, (class_1923)chunkPos), (class_1923)chunkPos))).stream();
            }
            catch (ExecutionException e) {
                GTCEu.LOGGER.error("Cannot create vein in chunk " + chunkPos, (Throwable)e);
                return Stream.empty();
            }
        }).filter(Objects::nonNull).toList();
    }

    public List<GeneratedIndicators> consumeChunkIndicators(class_5281 level, class_2794 generator, class_2791 chunk) {
        return this.getSurroundingChunks(chunk.method_12004(), OreVeinUtil.getMaxIndicatorSearchDistance()).flatMap(chunkPos -> {
            try {
                return ((List)this.indicatorsByOrigin.get(chunkPos, () -> this.oreGenerator.generateIndicators(level, this.getOrCreateVeinMetadata(level, generator, (class_1923)chunkPos), (class_1923)chunkPos))).stream();
            }
            catch (ExecutionException e) {
                GTCEu.LOGGER.error("Cannot create vein in chunk " + chunkPos, (Throwable)e);
                return Stream.empty();
            }
        }).filter(Objects::nonNull).toList();
    }

    private Stream<class_1923> getSurroundingChunks(class_1923 center, int searchDistance) {
        int minX = center.field_9181 - searchDistance;
        int minZ = center.field_9180 - searchDistance;
        int maxX = center.field_9181 + searchDistance;
        int maxZ = center.field_9180 + searchDistance;
        MutableInt x = new MutableInt(minX - 1);
        MutableInt z = new MutableInt(minZ);
        return Stream.generate(() -> {
            if (x.incrementAndGet() <= maxX) {
                return new class_1923(x.getValue().intValue(), z.getValue().intValue());
            }
            if (z.incrementAndGet() <= maxZ) {
                x.setValue(minX);
                return new class_1923(x.getValue().intValue(), z.getValue().intValue());
            }
            return null;
        }).takeWhile(Objects::nonNull);
    }
}

