/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator.veins;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreVeinUtil;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2826;
import net.minecraft.class_3124;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3798;
import net.minecraft.class_3825;
import net.minecraft.class_4076;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5867;
import net.minecraft.class_6677;
import net.minecraft.class_7923;
import org.apache.commons.lang3.mutable.MutableInt;

public class StandardVeinGenerator
extends VeinGenerator {
    public static final Codec<StandardVeinGenerator> CODEC_SEPARATE = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("block").forGetter(ext -> (class_2248)ext.block.get()), (App)class_7923.field_41175.method_39673().fieldOf("deep_block").forGetter(ext -> (class_2248)ext.deepBlock.get()), (App)class_7923.field_41175.method_39673().fieldOf("nether_block").forGetter(ext -> (class_2248)ext.netherBlock.get())).apply((Applicative)instance, StandardVeinGenerator::new));
    public static final Codec<StandardVeinGenerator> CODEC_LIST = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)class_3124.class_5876.field_29067.listOf(), GTRegistries.MATERIALS.codec()).fieldOf("targets").forGetter(ext -> ext.blocks)).apply((Applicative)instance, StandardVeinGenerator::new));
    public static final Codec<StandardVeinGenerator> CODEC = Codec.either(CODEC_SEPARATE, CODEC_LIST).xmap(either -> (StandardVeinGenerator)either.map(Function.identity(), Function.identity()), Either::left);
    public NonNullSupplier<? extends class_2248> block;
    public NonNullSupplier<? extends class_2248> deepBlock;
    public NonNullSupplier<? extends class_2248> netherBlock;
    public Either<List<class_3124.class_5876>, Material> blocks;

    public StandardVeinGenerator(GTOreDefinition entry) {
        super(entry);
    }

    public StandardVeinGenerator(class_2248 block, class_2248 deepBlock, class_2248 netherBlock) {
        this.block = NonNullSupplier.of(() -> block);
        this.deepBlock = NonNullSupplier.of(() -> deepBlock);
        this.netherBlock = NonNullSupplier.of(() -> netherBlock);
    }

    public StandardVeinGenerator(Either<List<class_3124.class_5876>, Material> blocks) {
        this.blocks = blocks;
    }

    public StandardVeinGenerator withBlock(NonNullSupplier<? extends class_2248> block) {
        this.block = block;
        this.deepBlock = block;
        return this;
    }

    public StandardVeinGenerator withNetherBlock(NonNullSupplier<? extends class_2248> block) {
        this.netherBlock = block;
        return this;
    }

    public StandardVeinGenerator withMaterial(Material material) {
        this.blocks = Either.right((Object)material);
        return this;
    }

    @Override
    public List<Map.Entry<Either<class_2680, Material>, Integer>> getAllEntries() {
        if (this.blocks != null) {
            return (List)this.blocks.map(blockStates -> blockStates.stream().map(state -> Either.left((Object)state.field_29069)).map(entry -> Map.entry(entry, 1)).collect(Collectors.toList()), material -> List.of(Map.entry(Either.right((Object)material), 1)));
        }
        return List.of(Map.entry(Either.left((Object)((class_2248)this.block.get()).method_9564()), 1), Map.entry(Either.left((Object)((class_2248)this.deepBlock.get()).method_9564()), 1), Map.entry(Either.left((Object)((class_2248)this.netherBlock.get()).method_9564()), 1));
    }

    @Override
    public VeinGenerator build() {
        if (this.blocks != null) {
            return this;
        }
        ArrayList<class_3124.class_5876> targetStates = new ArrayList<class_3124.class_5876>();
        if (this.block != null) {
            targetStates.add(class_3124.method_33994((class_3825)new class_3798(class_3481.field_28992), (class_2680)((class_2248)this.block.get()).method_9564()));
        }
        if (this.deepBlock != null) {
            targetStates.add(class_3124.method_33994((class_3825)new class_3798(class_3481.field_28993), (class_2680)((class_2248)this.deepBlock.get()).method_9564()));
        }
        if (this.netherBlock != null) {
            targetStates.add(class_3124.method_33994((class_3825)new class_3798(class_3481.field_38833), (class_2680)((class_2248)this.netherBlock.get()).method_9564()));
        }
        this.blocks = Either.left(targetStates);
        return this;
    }

    @Override
    public VeinGenerator copy() {
        return new StandardVeinGenerator(this.blocks);
    }

    @Override
    public Codec<? extends VeinGenerator> codec() {
        return CODEC;
    }

    @Override
    public Map<class_2338, OreBlockPlacer> generate(class_5281 level, class_5819 random, GTOreDefinition entry, class_2338 origin) {
        Object2ObjectOpenHashMap generatedBlocks = new Object2ObjectOpenHashMap();
        float f = random.method_43057() * (float)Math.PI;
        float f1 = (float)entry.clusterSize() / 8.0f;
        int i = class_3532.method_15386((float)(((float)entry.clusterSize() / 16.0f * 2.0f + 1.0f) / 2.0f));
        double minX = (double)origin.method_10263() + Math.sin(f) * (double)f1;
        double maxX = (double)origin.method_10263() - Math.sin(f) * (double)f1;
        double minZ = (double)origin.method_10260() + Math.cos(f) * (double)f1;
        double maxZ = (double)origin.method_10260() - Math.cos(f) * (double)f1;
        double minY = origin.method_10264() + random.method_43048(3) - 2;
        double maxY = origin.method_10264() + random.method_43048(3) - 2;
        int x = origin.method_10263() - class_3532.method_15386((float)f1) - i;
        int y = origin.method_10264() - 2 - i;
        int z = origin.method_10260() - class_3532.method_15386((float)f1) - i;
        int width = 2 * (class_3532.method_15386((float)f1) + i);
        int height = 2 * (2 + i);
        for (int heightmapX = x; heightmapX <= x + width; ++heightmapX) {
            for (int heightmapZ = z; heightmapZ <= z + width; ++heightmapZ) {
                this.doPlaceNormal((Map<class_2338, OreBlockPlacer>)generatedBlocks, random, entry, origin, this.blocks, minX, maxX, minZ, maxZ, minY, maxY, x, y, z, width, height);
                if (generatedBlocks.isEmpty()) continue;
                return generatedBlocks;
            }
        }
        return generatedBlocks;
    }

    protected void doPlaceNormal(Map<class_2338, OreBlockPlacer> generatedBlocks, class_5819 random, GTOreDefinition entry, class_2338 origin, Either<List<class_3124.class_5876>, Material> targets, double pMinX, double pMaxX, double pMinZ, double pMaxZ, double pMinY, double pMaxY, int pX, int pY, int pZ, int pWidth, int pHeight) {
        double randomShapeOffset;
        int centerOffset;
        MutableInt placedAmount = new MutableInt(1);
        BitSet placedBlocks = new BitSet(pWidth * pHeight * pWidth);
        class_2338.class_2339 posCursor = new class_2338.class_2339();
        int size = entry.clusterSize();
        float density = entry.density();
        double[] shape = new double[size * 4];
        for (centerOffset = 0; centerOffset < size; ++centerOffset) {
            float centerOffsetFraction = (float)centerOffset / (float)size;
            double x = class_3532.method_16436((double)centerOffsetFraction, (double)pMinX, (double)pMaxX);
            double y = class_3532.method_16436((double)centerOffsetFraction, (double)pMinY, (double)pMaxY);
            double z = class_3532.method_16436((double)centerOffsetFraction, (double)pMinZ, (double)pMaxZ);
            double randomOffsetModifier = random.method_43058() * (double)size / 16.0;
            randomShapeOffset = ((double)(class_3532.method_15374((float)((float)Math.PI * centerOffsetFraction)) + 1.0f) * randomOffsetModifier + 1.0) / 2.0;
            int shapeIdxOffset = centerOffset * 4;
            shape[shapeIdxOffset] = x;
            shape[shapeIdxOffset + 1] = y;
            shape[shapeIdxOffset + 2] = z;
            shape[shapeIdxOffset + 3] = randomShapeOffset;
        }
        for (centerOffset = 0; centerOffset < size - 1; ++centerOffset) {
            int shapeIdxOffset1 = centerOffset * 4;
            if (shape[shapeIdxOffset1 + 3] <= 0.0) continue;
            for (int i4 = centerOffset + 1; i4 < size; ++i4) {
                double z;
                double y;
                double x;
                int shapeIdxOffset2 = i4 * 4;
                if (shape[shapeIdxOffset2 + 3] <= 0.0 || !((randomShapeOffset = shape[shapeIdxOffset1 + 3] - shape[shapeIdxOffset2 + 3]) * randomShapeOffset > (x = shape[shapeIdxOffset1] - shape[shapeIdxOffset2]) * x + (y = shape[shapeIdxOffset1 + 1] - shape[shapeIdxOffset2 + 1]) * y + (z = shape[shapeIdxOffset1 + 2] - shape[shapeIdxOffset2 + 2]) * z)) continue;
                if (randomShapeOffset > 0.0) {
                    shape[shapeIdxOffset2 + 3] = -1.0;
                    continue;
                }
                shape[shapeIdxOffset1 + 3] = -1.0;
            }
        }
        for (centerOffset = 0; centerOffset < size; ++centerOffset) {
            int shapeIdxOffset = centerOffset * 4;
            StandardVeinGenerator.generateShape(generatedBlocks, random, entry, origin, targets, pX, pY, pZ, pWidth, pHeight, shape, shapeIdxOffset, placedBlocks, posCursor, density, placedAmount);
        }
    }

    private static void generateShape(Map<class_2338, OreBlockPlacer> generatedBlocks, class_5819 random, GTOreDefinition entry, class_2338 origin, Either<List<class_3124.class_5876>, Material> targets, int pX, int pY, int pZ, int pWidth, int pHeight, double[] shape, int shapeIdxOffset, BitSet placedBlocks, class_2338.class_2339 posCursor, float density, MutableInt placedAmount) {
        double randomShapeOffset = shape[shapeIdxOffset + 3];
        if (randomShapeOffset < 0.0) {
            return;
        }
        double x = shape[shapeIdxOffset];
        double y = shape[shapeIdxOffset + 1];
        double z = shape[shapeIdxOffset + 2];
        int minX = Math.max(class_3532.method_15357((double)(x - randomShapeOffset)), pX);
        int minY = Math.max(class_3532.method_15357((double)(y - randomShapeOffset)), pY);
        int minZ = Math.max(class_3532.method_15357((double)(z - randomShapeOffset)), pZ);
        int maxX = Math.max(class_3532.method_15357((double)(x + randomShapeOffset)), minX);
        int maxY = Math.max(class_3532.method_15357((double)(y + randomShapeOffset)), minY);
        int maxZ = Math.max(class_3532.method_15357((double)(z + randomShapeOffset)), minZ);
        for (int posX = minX; posX <= maxX; ++posX) {
            double radX = ((double)posX + 0.5 - x) / randomShapeOffset;
            if (!(radX * radX < 1.0)) continue;
            posCursor.method_33097(posX);
            for (int posY = minY; posY <= maxY; ++posY) {
                double radY = ((double)posY + 0.5 - y) / randomShapeOffset;
                if (!(radX * radX + radY * radY < 1.0)) continue;
                posCursor.method_33098(posY);
                for (int posZ = minZ; posZ <= maxZ; ++posZ) {
                    double radZ = ((double)posZ + 0.5 - z) / randomShapeOffset;
                    if (!(radX * radX + radY * radY + radZ * radZ < 1.0)) continue;
                    posCursor.method_33099(posZ);
                    int isPlaced = posX - pX + (posY - pY) * pWidth + (posZ - pZ) * pWidth * pHeight;
                    if (placedBlocks.get(isPlaced)) continue;
                    placedBlocks.set(isPlaced);
                    class_2338 pos = posCursor.method_10062();
                    long randomSeed = random.method_43055();
                    generatedBlocks.put(pos, (access, section) -> StandardVeinGenerator.placeBlock(access, randomSeed, entry, targets, pos, density, placedAmount));
                }
            }
        }
    }

    private static void placeBlock(class_5867 access, long randomSeed, GTOreDefinition entry, Either<List<class_3124.class_5876>, Material> targets, class_2338 pos, float density, MutableInt placedAmount) {
        class_6677 random = new class_6677(randomSeed);
        class_2338.class_2339 posCursor = pos.method_25503();
        class_2826 levelchunksection = access.method_33944((class_2338)posCursor);
        if (levelchunksection == null) {
            return;
        }
        int sectionX = class_4076.method_18684((int)pos.method_10263());
        int sectionY = class_4076.method_18684((int)pos.method_10264());
        int sectionZ = class_4076.method_18684((int)pos.method_10260());
        class_2680 blockstate = levelchunksection.method_12254(sectionX, sectionY, sectionZ);
        if (!(random.method_43057() <= density)) {
            return;
        }
        targets.ifLeft(arg_0 -> StandardVeinGenerator.lambda$placeBlock$15(blockstate, access, (class_5819)random, entry, posCursor, levelchunksection, sectionX, sectionY, sectionZ, placedAmount, arg_0)).ifRight(arg_0 -> StandardVeinGenerator.lambda$placeBlock$16(blockstate, access, (class_5819)random, entry, posCursor, levelchunksection, sectionX, sectionY, sectionZ, placedAmount, arg_0));
    }

    private static /* synthetic */ void lambda$placeBlock$16(class_2680 blockstate, class_5867 access, class_5819 random, GTOreDefinition entry, class_2338.class_2339 posCursor, class_2826 levelchunksection, int sectionX, int sectionY, int sectionZ, MutableInt placedAmount, Material material) {
        if (!OreVeinUtil.canPlaceOre(blockstate, arg_0 -> ((class_5867)access).method_33946(arg_0), random, entry, posCursor)) {
            return;
        }
        class_2680 currentState = access.method_33946((class_2338)posCursor);
        Optional<TagPrefix> prefix = ChemicalHelper.getOrePrefix(currentState);
        if (prefix.isEmpty()) {
            return;
        }
        class_2248 toPlace = ChemicalHelper.getBlock(prefix.get(), material);
        if (toPlace == null || toPlace.method_9564().method_26215()) {
            return;
        }
        levelchunksection.method_12256(sectionX, sectionY, sectionZ, toPlace.method_9564(), false);
        placedAmount.increment();
    }

    private static /* synthetic */ void lambda$placeBlock$15(class_2680 blockstate, class_5867 access, class_5819 random, GTOreDefinition entry, class_2338.class_2339 posCursor, class_2826 levelchunksection, int sectionX, int sectionY, int sectionZ, MutableInt placedAmount, List blockStates) {
        for (class_3124.class_5876 targetState : blockStates) {
            if (!OreVeinUtil.canPlaceOre(blockstate, arg_0 -> ((class_5867)access).method_33946(arg_0), random, entry, targetState, posCursor)) continue;
            levelchunksection.method_12256(sectionX, sectionY, sectionZ, targetState.field_29069, false);
            placedAmount.increment();
            break;
        }
    }
}

