/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator.indicators;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.generator.IndicatorGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreIndicatorPlacer;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.block.SurfaceRockBlock;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_3542;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5862;
import net.minecraft.class_5863;
import net.minecraft.class_5867;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6328;
import org.apache.commons.lang3.function.TriFunction;

@class_6328
@ParametersAreNonnullByDefault
public class SurfaceIndicatorGenerator
extends IndicatorGenerator {
    public static final Codec<SurfaceIndicatorGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)class_2680.field_24734, GTRegistries.MATERIALS.codec()).fieldOf("block").forGetter(ext -> ext.block), (App)class_6017.method_35004((int)1, (int)32).fieldOf("radius").forGetter(ext -> ext.radius), (App)class_5863.method_33916((float)0.0f, (float)1.0f).fieldOf("density").forGetter(ext -> ext.density), (App)class_3542.method_28140(IndicatorPlacement::values).fieldOf("placement").forGetter(ext -> ext.placement)).apply((Applicative)instance, SurfaceIndicatorGenerator::new));
    private Either<class_2680, Material> block = Either.left((Object)class_2246.field_10124.method_9564());
    private class_6017 radius = class_6016.method_34998((int)5);
    private class_5863 density = class_5862.method_33908((float)0.2f);
    private IndicatorPlacement placement = IndicatorPlacement.SURFACE;

    public SurfaceIndicatorGenerator(GTOreDefinition entry) {
        super(entry);
    }

    public SurfaceIndicatorGenerator(Either<class_2680, Material> block, class_6017 radius, class_5863 density, IndicatorPlacement placement) {
        this.block = block;
        this.radius = radius;
        this.density = density;
        this.placement = placement;
        block.ifRight(SurfaceIndicatorGenerator::validateSurfaceRockMaterial);
    }

    public SurfaceIndicatorGenerator surfaceRock(Material material) {
        SurfaceIndicatorGenerator.validateSurfaceRockMaterial(material);
        this.block = Either.right((Object)material);
        return this;
    }

    public SurfaceIndicatorGenerator block(class_2248 block) {
        return this.state(block.method_9564());
    }

    public SurfaceIndicatorGenerator state(class_2680 state) {
        this.block = Either.left((Object)state);
        return this;
    }

    public SurfaceIndicatorGenerator radius(int radius) {
        return this.radius((class_6017)class_6016.method_34998((int)radius));
    }

    public SurfaceIndicatorGenerator radius(class_6017 provider) {
        this.radius = provider;
        return this;
    }

    public SurfaceIndicatorGenerator density(float density) {
        return this.density((class_5863)class_5862.method_33908((float)density));
    }

    public SurfaceIndicatorGenerator density(class_5863 provider) {
        this.density = provider;
        return this;
    }

    public SurfaceIndicatorGenerator placement(IndicatorPlacement placement) {
        this.placement = placement;
        return this;
    }

    private static void validateSurfaceRockMaterial(Material material) {
        if (GTBlocks.SURFACE_ROCK_BLOCKS.get(material) == null) {
            throw new IllegalArgumentException("No surface rock registered for material " + material.getName());
        }
    }

    @Override
    public Map<class_1923, OreIndicatorPlacer> generate(class_5281 level, class_5819 random, GeneratedVeinMetadata metadata) {
        class_2680 blockState = this.placement.stateTransformer.apply(this.block);
        int radius = this.radius.method_35008(random);
        float density = this.density.method_33920(random);
        class_2338 center = metadata.center();
        Stream<class_2338> positionStream = class_2338.method_17962((int)(center.method_10263() - radius), (int)center.method_10264(), (int)(center.method_10260() - radius), (int)(center.method_10263() + radius), (int)center.method_10264(), (int)(center.method_10260() + radius)).map(class_2338::method_10062);
        List<class_2338> positions = positionStream.filter(pos -> pos.equals((Object)center) || random.method_43057() <= density).filter(pos -> Math.sqrt(pos.method_10262((class_2382)center)) <= (double)radius).toList();
        return WorldGeneratorUtils.groupByChunks(positions).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.createPlacer(level, (List)entry.getValue(), blockState)));
    }

    private OreIndicatorPlacer createPlacer(class_5281 level, List<class_2338> positionsWithoutY, class_2680 blockState) {
        return access -> {
            List<class_2338> positions = positionsWithoutY.stream().map(pos -> (class_2338)this.placement.resolver.apply((Object)level, (Object)access, pos)).filter(pos -> !level.method_31606(pos)).toList();
            for (class_2338 pos2 : positions) {
                int sectionZ;
                int sectionY;
                int sectionX;
                class_2826 section = Objects.requireNonNull(access.method_33944(pos2));
                if (!section.method_12254(sectionX = class_4076.method_18684((int)pos2.method_10263()), sectionY = class_4076.method_18684((int)pos2.method_10264()), sectionZ = class_4076.method_18684((int)pos2.method_10260())).method_26215()) {
                    return;
                }
                if (!blockState.method_26184((class_4538)level, pos2)) {
                    return;
                }
                section.method_12256(sectionX, sectionY, sectionZ, blockState, false);
            }
        };
    }

    @Override
    public int getSearchRadiusModifier(int veinRadius) {
        return Math.max(0, this.radius.method_35011() - veinRadius);
    }

    @Override
    public Codec<? extends IndicatorGenerator> codec() {
        return CODEC;
    }

    public static enum IndicatorPlacement implements class_3542
    {
        SURFACE((TriFunction<class_5281, class_5867, class_2338, class_2338>)((TriFunction)(level, access, pos) -> pos.method_33096(level.method_8624(class_2902.class_2903.field_13195, pos.method_10263(), pos.method_10260()))), block -> IndicatorPlacement.getBlockState((Either<class_2680, Material>)block, class_2350.field_11033)),
        ABOVE((TriFunction<class_5281, class_5867, class_2338, class_2338>)((TriFunction)(level, access, initialPos) -> WorldGeneratorUtils.findBlockPos(initialPos, pos -> access.method_33946(pos).method_26215() && access.method_33946(pos.method_10074()).method_26206((class_1922)level, pos.method_10074(), class_2350.field_11036), pos -> pos.method_10104(class_2350.field_11036, 1), level.method_31600() - initialPos.method_10264()).orElse((class_2338)initialPos)), block -> IndicatorPlacement.getBlockState((Either<class_2680, Material>)block, class_2350.field_11033)),
        BELOW((TriFunction<class_5281, class_5867, class_2338, class_2338>)((TriFunction)(level, access, initialPos) -> WorldGeneratorUtils.findBlockPos(initialPos, pos -> access.method_33946(pos).method_26215() && access.method_33946(pos.method_10084()).method_26206((class_1922)level, pos.method_10084(), class_2350.field_11033), pos -> pos.method_10104(class_2350.field_11033, 1), initialPos.method_10264() - level.method_31607()).orElse((class_2338)initialPos)), block -> IndicatorPlacement.getBlockState((Either<class_2680, Material>)block, class_2350.field_11036));

        public final TriFunction<class_5281, class_5867, class_2338, class_2338> resolver;
        public final Function<Either<class_2680, Material>, class_2680> stateTransformer;

        private static class_2680 getBlockState(Either<class_2680, Material> block, class_2350 direction) {
            return (class_2680)block.map(state -> state, material -> ((SurfaceRockBlock)((Object)((Object)GTBlocks.SURFACE_ROCK_BLOCKS.get(material).get()))).getStateForDirection(direction));
        }

        public String method_15434() {
            return this.name().toLowerCase();
        }

        @Nullable
        public static IndicatorPlacement getByName(String name) {
            return IndicatorPlacement.valueOf(name.toUpperCase());
        }

        private IndicatorPlacement(TriFunction<class_5281, class_5867, class_2338, class_2338> resolver, Function<Either<class_2680, Material>, class_2680> stateTransformer) {
            this.resolver = resolver;
            this.stateTransformer = stateTransformer;
        }
    }
}

