/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.bedrockore;

import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class OreVeinWorldEntry {
    @Nullable
    private GTOreDefinition vein;
    private int oreYield;
    private int operationsRemaining;

    public OreVeinWorldEntry(@Nullable GTOreDefinition vein, int oreYield, int operationsRemaining) {
        this.vein = vein;
        this.oreYield = oreYield;
        this.operationsRemaining = operationsRemaining;
    }

    private OreVeinWorldEntry() {
    }

    public GTOreDefinition getDefinition() {
        return this.vein;
    }

    public void setOperationsRemaining(int amount) {
        this.operationsRemaining = amount;
    }

    public void decreaseOperations(int amount) {
        this.operationsRemaining = ConfigHolder.INSTANCE.worldgen.oreVeins.infiniteBedrockOresFluids ? this.operationsRemaining : Math.max(0, this.operationsRemaining - amount);
    }

    public class_2487 writeToNBT() {
        class_2487 tag = new class_2487();
        tag.method_10569("oreYield", this.oreYield);
        tag.method_10569("operationsRemaining", this.operationsRemaining);
        if (this.vein != null) {
            tag.method_10582("vein", ((class_2960)GTRegistries.ORE_VEINS.getKey(this.vein)).toString());
        }
        return tag;
    }

    @Nonnull
    public static OreVeinWorldEntry readFromNBT(@Nonnull class_2487 tag) {
        OreVeinWorldEntry info = new OreVeinWorldEntry();
        info.oreYield = tag.method_10550("oreYield");
        info.operationsRemaining = tag.method_10550("operationsRemaining");
        if (tag.method_10545("vein")) {
            info.vein = (GTOreDefinition)GTRegistries.ORE_VEINS.get(new class_2960(tag.method_10558("vein")));
        }
        return info;
    }

    @Nullable
    public GTOreDefinition getVein() {
        return this.vein;
    }

    public int getOreYield() {
        return this.oreYield;
    }

    public int getOperationsRemaining() {
        return this.operationsRemaining;
    }
}

