/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.tag;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import java.util.function.BiFunction;
import net.minecraft.class_1792;
import net.minecraft.class_6862;

public class TagType {
    private final String tagPath;
    private boolean isParentTag = false;
    private BiFunction<TagPrefix, Material, class_6862<class_1792>> formatter;

    private TagType(String tagPath) {
        this.tagPath = tagPath;
    }

    public static TagType withDefaultFormatter(String tagPath) {
        TagType type = new TagType(tagPath);
        type.formatter = (prefix, mat) -> TagUtil.createItemTag(type.tagPath.formatted(mat.getName()));
        return type;
    }

    public static TagType withPrefixFormatter(String tagPath) {
        TagType type = new TagType(tagPath);
        type.formatter = (prefix, mat) -> TagUtil.createItemTag(type.tagPath.formatted(FormattingUtil.toLowerCaseUnderscore(prefix.name), mat.getName()));
        return type;
    }

    public static TagType withPrefixOnlyFormatter(String tagPath) {
        TagType type = new TagType(tagPath);
        type.formatter = (prefix, mat) -> TagUtil.createItemTag(type.tagPath.formatted(FormattingUtil.toLowerCaseUnderscore(prefix.name)));
        type.isParentTag = true;
        return type;
    }

    public static TagType withNoFormatter(String tagPath) {
        TagType type = new TagType(tagPath);
        type.formatter = (prefix, material) -> TagUtil.createItemTag(type.tagPath);
        type.isParentTag = true;
        return type;
    }

    public static TagType withCustomFormatter(String tagPath, BiFunction<TagPrefix, Material, class_6862<class_1792>> formatter) {
        TagType type = new TagType(tagPath);
        type.formatter = formatter;
        return type;
    }

    public class_6862<class_1792> getTag(TagPrefix prefix, Material material) {
        return this.formatter.apply(prefix, material);
    }

    public boolean isParentTag() {
        return this.isParentTag;
    }
}

