/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability.fabric;

import com.gregtechceu.gtceu.api.capability.IPlatformEnergyStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import team.reborn.energy.api.EnergyStorage;

public class GTEnergyHelperImpl {
    public static IPlatformEnergyStorage toPlatformEnergyStorage(final EnergyStorage handler) {
        return new IPlatformEnergyStorage(){

            @Override
            public boolean supportsInsertion() {
                return handler.supportsInsertion();
            }

            @Override
            public long insert(long maxAmount, boolean simulate) {
                if (maxAmount == 0L) {
                    return 0L;
                }
                long inserted = 0L;
                try (Transaction transaction = Transaction.openNested((TransactionContext)Transaction.getCurrentUnsafe());){
                    inserted = handler.insert(maxAmount, (TransactionContext)transaction);
                    if (simulate) {
                        transaction.abort();
                    } else {
                        transaction.commit();
                    }
                }
                return inserted;
            }

            @Override
            public boolean supportsExtraction() {
                return handler.supportsExtraction();
            }

            @Override
            public long extract(long maxAmount, boolean simulate) {
                if (maxAmount == 0L) {
                    return 0L;
                }
                long extracted = 0L;
                try (Transaction transaction = Transaction.openNested((TransactionContext)Transaction.getCurrentUnsafe());){
                    extracted = handler.extract(maxAmount, (TransactionContext)transaction);
                    if (simulate) {
                        transaction.abort();
                    } else {
                        transaction.commit();
                    }
                }
                return extracted;
            }

            @Override
            public long getAmount() {
                return handler.getAmount();
            }

            @Override
            public long getCapacity() {
                return handler.getCapacity();
            }
        };
    }

    public static EnergyStorage toEnergyStorage(final IPlatformEnergyStorage energyStorage) {
        return new EnergyStorage(){

            public boolean supportsInsertion() {
                return energyStorage.supportsInsertion();
            }

            public long insert(long maxAmount, TransactionContext transaction) {
                return energyStorage.insert(maxAmount, false);
            }

            public boolean supportsExtraction() {
                return energyStorage.supportsExtraction();
            }

            public long extract(long maxAmount, TransactionContext transaction) {
                return energyStorage.extract(maxAmount, false);
            }

            public long getAmount() {
                return energyStorage.getAmount();
            }

            public long getCapacity() {
                return energyStorage.getCapacity();
            }
        };
    }
}

