/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.util.biome.GeneratorUtil;
import biomesoplenty.worldgen.feature.configurations.TaigaTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public class UmbranTreeFeature
extends BOPTreeFeature<TaigaTreeConfiguration> {
    public UmbranTreeFeature(Codec<TaigaTreeConfiguration> codec) {
        super(codec);
    }

    public boolean checkSpace(class_1936 world, class_2338 pos, int baseHeight, int height, TaigaTreeConfiguration config) {
        for (int y = 0; y <= height; ++y) {
            int trunkWidth = config.trunkWidth * (height - y) / height + 1;
            int trunkStart = class_3532.method_15384((double)(0.25 - (double)trunkWidth / 2.0));
            int trunkEnd = class_3532.method_15357((double)(0.25 + (double)trunkWidth / 2.0));
            int start = y <= baseHeight ? trunkStart : trunkStart - 1;
            int end = y <= baseHeight ? trunkEnd : trunkEnd + 1;
            for (int x = start; x <= end; ++x) {
                for (int z = start; z <= end; ++z) {
                    class_2338 pos1 = pos.method_10069(x, y, z);
                    if (pos1.method_10264() < 255 && this.canReplace(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeafLayer(class_1936 world, class_5819 rand, class_2338 pos, int leavesRadius, int trunkStart, int trunkEnd, class_4647.class_8179 leaves, TaigaTreeConfiguration config) {
        int start = trunkStart - leavesRadius;
        int end = trunkEnd + leavesRadius;
        for (int x = start; x <= end; ++x) {
            for (int z = start; z <= end; ++z) {
                int distFromTrunk;
                if (leavesRadius > 0 && (x == start || x == end) && (z == start || z == end) || (distFromTrunk = (x < 0 ? trunkStart - x : x - trunkEnd) + (z < 0 ? trunkStart - z : z - trunkEnd)) >= 4 && (distFromTrunk != 4 || rand.method_43048(2) != 0)) continue;
                this.placeLeaves(world, pos.method_10069(x, 0, z), leaves, config);
                if (x != start && x != end && z != start && z != end || rand.method_43048(3) == 0) continue;
                this.placeLeaves(world, pos.method_10069(x, -1, z), leaves, config);
            }
        }
        if (rand.method_43048(6) != 0 && leavesRadius > 1) {
            this.placeLeaves(world, pos.method_10069(-1, 1, 0), leaves, config);
            this.placeLeaves(world, pos.method_10069(1, 1, 0), leaves, config);
            this.placeLeaves(world, pos.method_10069(0, 1, -1), leaves, config);
            this.placeLeaves(world, pos.method_10069(0, 1, 1), leaves, config);
        }
    }

    public void generateBranch(class_1936 world, class_5819 rand, class_2338 pos, class_2350 direction, int length, BiConsumer<class_2338, class_2680> logs, class_4647.class_8179 leaves, TaigaTreeConfiguration config) {
        class_2350.class_2351 axis = direction.method_10166();
        class_2350 sideways = direction.method_10170();
        boolean slant = true;
        int slantOffset = 0;
        for (int i = 1; i <= length; ++i) {
            class_2338 pos1 = pos.method_10079(direction, i - (int)Math.floor(slantOffset)).method_10087((int)Math.floor(slantOffset));
            int r = i == 1 || i == length ? 1 : 2;
            for (int j = -r; j <= r; ++j) {
                if (i >= length && rand.method_43048(2) != 0) continue;
                this.placeLeaves(world, pos1.method_10079(sideways, j), leaves, config);
            }
            if (length - i > 2) {
                this.placeLeaves(world, pos1.method_10084(), leaves, config);
                this.placeLeaves(world, pos1.method_10084().method_10079(sideways, -1), leaves, config);
                this.placeLeaves(world, pos1.method_10084().method_10079(sideways, 1), leaves, config);
            }
            if (!slant || i <= 2) continue;
            ++slantOffset;
        }
    }

    protected boolean method_12775(class_5281 world, class_5819 random, class_2338 startPos, BiConsumer<class_2338, class_2680> roots, BiConsumer<class_2338, class_2680> logs, class_4647.class_8179 leaves, class_4643 configBase) {
        int trunkEnd;
        int trunkStart;
        int trunkWidth;
        boolean topLeaves;
        int baseHeight;
        TaigaTreeConfiguration config = (TaigaTreeConfiguration)configBase;
        while (startPos.method_10264() >= world.method_31607() + 1 && world.method_22347(startPos) || world.method_8320(startPos).method_26164(class_3481.field_15503)) {
            startPos = startPos.method_10074();
        }
        int height = GeneratorUtil.nextIntBetween(random, config.minHeight, config.maxHeight);
        int leavesHeight = height - (baseHeight = GeneratorUtil.nextIntBetween(random, height / 5, height / 3));
        if (leavesHeight < 3) {
            return false;
        }
        if (!this.checkSpace((class_1936)world, startPos.method_10084(), baseHeight, height, config)) {
            return false;
        }
        class_2338 pos = startPos.method_10086(height);
        boolean bl = height <= 20 ? true : (topLeaves = random.method_43048(3) == 0);
        if (topLeaves) {
            this.placeLeaves((class_1936)world, pos, leaves, config);
        }
        pos.method_10074();
        for (int i = 0; i < leavesHeight; ++i) {
            trunkWidth = config.trunkWidth * i / height + 1;
            trunkStart = class_3532.method_15384((double)(0.25 - (double)trunkWidth / 2.0));
            trunkEnd = class_3532.method_15357((double)(0.25 + (double)trunkWidth / 2.0));
            int radius = Math.min(Math.min((i + 2) / 3, 3 + (leavesHeight - i)), 6);
            if (radius == 0) {
                if (topLeaves) {
                    this.placeLeaves((class_1936)world, pos, leaves, config);
                } else {
                    this.placeLog((class_1936)world, pos, logs, config);
                }
            } else if (radius < 4) {
                if (i % 3 == 0) {
                    this.generateLeafLayer((class_1936)world, random, pos, radius, trunkStart, trunkEnd, leaves, config);
                } else if (topLeaves) {
                    this.placeLeaves((class_1936)world, pos, leaves, config);
                } else {
                    this.placeLog((class_1936)world, pos, logs, config);
                }
            } else if (i % 3 == 0) {
                this.generateBranch((class_1936)world, random, pos.method_10069(trunkStart, 0, trunkStart), class_2350.field_11043, radius, logs, leaves, config);
                this.generateBranch((class_1936)world, random, pos.method_10069(trunkEnd, 0, trunkStart), class_2350.field_11034, radius, logs, leaves, config);
                this.generateBranch((class_1936)world, random, pos.method_10069(trunkEnd, 0, trunkEnd), class_2350.field_11035, radius, logs, leaves, config);
                this.generateBranch((class_1936)world, random, pos.method_10069(trunkStart, 0, trunkEnd), class_2350.field_11039, radius, logs, leaves, config);
            }
            pos = pos.method_10074();
        }
        for (int y = 0; y < height - 1; ++y) {
            trunkWidth = config.trunkWidth * (height - y) / height + 1;
            trunkStart = class_3532.method_15384((double)(0.25 - (double)trunkWidth / 2.0));
            trunkEnd = class_3532.method_15357((double)(0.25 + (double)trunkWidth / 2.0));
            if (trunkWidth < 1 || trunkWidth > config.trunkWidth) {
                trunkStart = 0;
                trunkEnd = 0;
            }
            for (int x = trunkStart; x <= trunkEnd; ++x) {
                for (int z = trunkStart; z <= trunkEnd; ++z) {
                    if (y == 1) {
                        world.method_8652(startPos.method_10069(x, y - 1, z), class_2246.field_10566.method_9564(), 3);
                    }
                    this.placeLog((class_1936)world, startPos.method_10069(x, y, z), logs, config);
                }
            }
        }
        return true;
    }
}

