/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.brnbrd.delightful.common.loot.DelightfulLootModifiers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class SmeltLootModifier
extends LootModifier {
    public static final Codec<SmeltLootModifier> CODEC = RecordCodecBuilder.create(inst -> SmeltLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, SmeltLootModifier::new));

    public SmeltLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        return (ObjectArrayList)generatedLoot.stream().map(stack -> {
            ItemStack smelted = context.m_78952_().m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), (Level)context.m_78952_()).map(recipe -> recipe.m_8043_(context.m_78952_().m_9598_())).filter(itemStack -> !itemStack.m_41619_()).map(itemStack -> ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)(stack.m_41613_() * itemStack.m_41613_()))).orElse((ItemStack)stack);
            if (smelted == stack) {
                return stack;
            }
            ExperienceOrb.m_147082_((ServerLevel)context.m_78952_(), (Vec3)((Vec3)context.m_165124_(LootContextParams.f_81460_)), (int)(context.m_230907_().m_188503_(3) + 1));
            return smelted;
        }).collect(ObjectArrayList.toList());
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)DelightfulLootModifiers.SMELT.get();
    }
}

